/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.java;

import de.statspez.pleditor.generator.codegen.analysis.CrossReferenceBuilder;
import de.statspez.pleditor.generator.codegen.java.ClassificationCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.CodegenContext;
import de.statspez.pleditor.generator.codegen.java.LiteralCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.MappingsCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.MaterialCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.PlausiElementCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.PlausiFehlerFactoryGenerator;
import de.statspez.pleditor.generator.codegen.java.PlausiFehlerIdsGenerator;
import de.statspez.pleditor.generator.codegen.java.ProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.Settings;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.java.ThemenbereichCodeGenerator;
import de.statspez.pleditor.generator.codegen.support.CodegenUtil;
import de.statspez.pleditor.generator.codegen.support.LiteralManager;
import de.statspez.pleditor.generator.codegen.support.Scope;
import de.statspez.pleditor.generator.codegen.support.ScopeImpl;
import de.statspez.pleditor.generator.common.ElementMessageContext;
import de.statspez.pleditor.generator.meta.MetaCustomAblauf;
import de.statspez.pleditor.generator.meta.MetaCustomInitwert;
import de.statspez.pleditor.generator.meta.MetaCustomMerkmal;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaPLAblauf;
import de.statspez.pleditor.generator.meta.generated.MetaPLInitwert;
import de.statspez.pleditor.generator.meta.generated.MetaPLMaterial;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;

public class PlausiCodeGenerator
extends PlausiElementCodeGenerator {
    public static final int MAX_NESTED_TB = 1000;
    private CodegenContext context = null;
    private LiteralManager literalManager = null;

    public synchronized void generate(CodegenContext aContext) {
        this.context = aContext;
        this.literalManager = new LiteralManager(true, this.context.getMaxElementsInSegment(0), new LiteralManager.SegmentPrefixGiver(){

            @Override
            public String getNextSegmentPrefix() {
                return String.valueOf(PlausiCodeGenerator.this.context.getNextPlausiSegmentClassName()) + ".";
            }
        });
        this.setErrorContext(this.context.getMessageContext());
        CrossReferenceBuilder crefBuilder = new CrossReferenceBuilder();
        crefBuilder.buildCrossReference(this.context.getPlausi(), this.context.getPlausiScope(), this.context.getTopicScopes());
        this.context.getPlausi().accept(this);
        this.checkForErrors(this.context.isIgnoreWarnings());
    }

    @Override
    public void visitPlausibilisierung(MetaPlausibilisierung plausi) {
        String plausiFilename = String.valueOf(this.context.getPlausiClassName()) + ".java";
        Writer writer = this.context.createWriter(plausiFilename);
        this.setOutput(writer);
        try {
            this.out.print("package ");
            this.out.print(this.context.getPlausiPackage());
            this.out.print(";");
            this.indentNewLine();
            this.indentNewLine();
            this.out.print("import ");
            this.out.print("de.statspez.pleditor.generator.runtime.");
            this.out.print("*;");
            this.indentNewLine();
            this.out.print("import ");
            this.out.print("de.statspez.pleditor.generator.runtime.plausi.");
            this.out.print("*;");
            this.indentNewLine();
            this.defineClass(this.context.getPlausiClassName(), "public", "BasePlausi");
            this.indentNewLine();
            this.out.print("public double getPlausiSystemVersion() { return 3.2; }");
            this.indentNewLine();
            String genDateStr = "";
            Date genDate = ((MetaCustomPlausibilisierung)plausi).getGenDate();
            if (genDate != null) {
                SimpleDateFormat time_formatter = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.GERMANY);
                genDateStr = time_formatter.format(genDate);
            }
            this.out.print("public String getPlausiVersionString() { return \"" + genDateStr + "\"; }");
            this.indentNewLine();
            this.processPlausiElements(plausi);
            LiteralCodeGenerator litGen = new LiteralCodeGenerator();
            litGen.setOutput(this.out);
            litGen.setIndentLevel(this.indentLevel());
            litGen.setErrorContext(this.context.getMessageContext());
            litGen.generate(this.context, this.literalManager);
            MetaThemenbereich rootTb = ((MetaCustomPlausibilisierung)plausi).rootThemenbereich();
            this.indentNewLine();
            this.out.print("public ");
            this.out.print(this.getTbClass(rootTb));
            this.out.print(" ");
            this.out.print("themenbereich");
            this.out.print(";");
            MetaPLMaterial[] usedMaterials = CodegenUtil.getUsedMaterials(plausi);
            if (usedMaterials != null && usedMaterials.length > 0) {
                int i = 0;
                while (i < usedMaterials.length) {
                    this.indentNewLine();
                    this.out.print("public ");
                    this.out.print("Material");
                    this.out.print(this.getTbClass(usedMaterials[i].getThemenbereich()));
                    this.out.print(" ");
                    this.out.print("__material_");
                    this.out.print(StringHelper.getEscapedName(usedMaterials[i].getName()));
                    this.out.print(";");
                    ++i;
                }
            }
            this.indentNewLine();
            this.createPlausiConstructor(plausi);
            this.indentNewLine();
            this.createPlausiInitMethod(plausi);
            this.indentNewLine();
            this.createAblaufInvocationMethod(plausi);
            this.indentNewLine();
            this.createPlausiFehlerFactoryMethod();
            this.indentNewLine();
            this.createPlausiFehlerIdsMethod();
            this.endClassDefinition();
        }
        finally {
            this.context.destroyWriter(plausiFilename, writer);
        }
    }

    @Override
    public void visitMerkmal(MetaMerkmal aMerkmal) {
        MetaCustomMerkmal merkmal = (MetaCustomMerkmal)aMerkmal;
        if (merkmal.referencedByErhebung()) {
            ProgramCodeGenerator prgGen = new ProgramCodeGenerator();
            prgGen.setOutput(this.out);
            prgGen.setIndentLevel(this.indentLevel());
            prgGen.setLiteralManager(this.literalManager);
            prgGen.setErrorContext(new ElementMessageContext(5, merkmal.getId(), merkmal.getName()));
            this.context.putContextInfo("PROGRAM_CHECKS_FIELD_KEY", Boolean.TRUE);
            prgGen.generate(this.context, merkmal.getMetaSpezifikation(), new ScopeImpl(this.context.getPlausiScope()), false, true);
            this.context.putContextInfo("PROGRAM_CHECKS_FIELD_KEY", null);
            this.indentNewLine();
            this.createFehlerMethod(this.context, this.context.getPlausiScope(), this.literalManager, merkmal.getMetaSpezifikation().name(), merkmal.getName(), this.context.getTextResource().getFehlertextKurzProgram(merkmal), this.context.getTextResource().getFehlertextLangProgram(merkmal), this.context.getTextResource().getKorrekturhinweisProgram(merkmal), "Merkmalpruefung", null, null, null, (short)1);
        }
    }

    @Override
    public void visitThemenbereich(MetaThemenbereich tb) {
        ThemenbereichCodeGenerator tbGen = new ThemenbereichCodeGenerator();
        tbGen.setOutput(this.out);
        tbGen.setIndentLevel(this.indentLevel());
        tbGen.setLiteralManager(this.literalManager);
        tbGen.setErrorContext(new ElementMessageContext(6, tb.getId(), tb.getName()));
        tbGen.generate(this.context, tb, (Scope)this.context.getTopicScopes().get(tb.getName()));
        if (CodegenUtil.referencedByUsedMaterial(this.context.getPlausi(), tb)) {
            this.indentNewLine();
            MaterialCodeGenerator matGen = new MaterialCodeGenerator();
            matGen.setOutput(this.out);
            matGen.setIndentLevel(this.indentLevel());
            matGen.setErrorContext(new ElementMessageContext(7, tb.getId(), tb.getName()));
            matGen.generate(this.context, tb);
        }
    }

    private void createPlausiConstructor(MetaPlausibilisierung aPlausi) {
        MetaCustomPlausibilisierung plausi = (MetaCustomPlausibilisierung)aPlausi;
        this.defineMethod("public", "", this.context.getPlausiClassName(), "");
        this.indentNewLine();
        this.out.print("plausiDescriptor()");
        this.out.print(".setName(\"");
        this.out.print(plausi.getPLName());
        this.out.print("\");");
        this.indentNewLine();
        this.declareAblaufRuntimeInfos(plausi);
        this.declareStandardAblauf(plausi);
        this.indentNewLine();
        this.declareClassifications();
        this.indentNewLine();
        this.declareMappings();
        this.indentNewLine();
        this.declareMaterialAttributes(plausi);
        this.indentNewLine();
        this.out.print("themenbereich");
        this.out.print(" = new ");
        this.out.print(this.getTbClass(plausi.rootThemenbereich()));
        this.out.print("(null, new ");
        this.out.print("FeldDeskriptor");
        this.out.print("(plausiMappings(), ");
        this.out.print("\"__root_tb__\", ");
        this.out.print("null, RuntimeSettings.RT_TYPE_CUSTOM), ");
        this.out.print("null);");
        this.endMethodDefinition();
    }

    private void createPlausiInitMethod(MetaPlausibilisierung plausi) {
        this.defineMethod("public", "void", "init", "PlausiRuntimeContext context");
        this.endMethodDefinition();
    }

    private void declareAblaufRuntimeInfos(MetaPlausibilisierung plausi) {
        Iterator it = ((MetaCustomPlausibilisierung)plausi).rootThemenbereich().getAblaeufe();
        while (it.hasNext()) {
            MetaCustomAblauf ablauf = (MetaCustomAblauf)it.next();
            this.indentNewLine();
            this.out.print("plausiDescriptor()");
            this.out.print(".addFlow(new ");
            this.out.print("PlausiDescriptor.FlowInfo");
            this.out.print("(\"");
            this.out.print(ablauf.getName());
            this.out.print("\"");
            this.out.print(", new Class[] {");
            Iterator initwerteIt = ablauf.getThemenbereich().getInitialisierungswerte();
            while (initwerteIt.hasNext()) {
                MetaPLInitwert anInitwert = (MetaPLInitwert)initwerteIt.next();
                this.out.print(Settings.NATIVE_TYPES[anInitwert.getTyp()]);
                this.out.print(".class");
                if (!initwerteIt.hasNext()) continue;
                this.out.print(", ");
            }
            this.out.print("}");
            this.out.print("));");
        }
    }

    private void declareStandardAblauf(MetaPlausibilisierung plausi) {
        MetaPLAblauf stdAblauf = ((MetaCustomPlausibilisierung)plausi).standardAblauf();
        if (stdAblauf != null) {
            this.indentNewLine();
            this.out.print("plausiDescriptor()");
            this.out.print(".setStandardFlow(");
            this.out.print("plausiDescriptor()");
            this.out.print(".flow(\"");
            this.out.print(StringHelper.getEscapedName(stdAblauf.getName()));
            this.out.print("\"));");
        } else {
            this.warning(plausi, "es konnte kein Standard-Ablauf ermittelt werden");
        }
    }

    private void declareClassifications() {
        ClassificationCodeGenerator codeGen = new ClassificationCodeGenerator();
        codeGen.setOutput(this.out);
        codeGen.setIndentLevel(this.indentLevel());
        codeGen.setErrorContext(this.context.getMessageContext());
        codeGen.generate(this.context);
    }

    private void declareMappings() {
        MappingsCodeGenerator codeGen = new MappingsCodeGenerator();
        codeGen.setOutput(this.out);
        codeGen.setIndentLevel(this.indentLevel());
        codeGen.setErrorContext(this.context.getMessageContext());
        codeGen.generate(this.context);
    }

    private void declareMaterialAttributes(MetaPlausibilisierung plausi) {
        MaterialCodeGenerator codeGen = new MaterialCodeGenerator();
        codeGen.setOutput(this.out);
        codeGen.setIndentLevel(this.indentLevel());
        codeGen.setErrorContext(this.context.getMessageContext());
        codeGen.generate(plausi);
    }

    private void createAblaufInvocationMethod(MetaPlausibilisierung plausi) {
        assert (plausi != null);
        this.defineMethod("protected", "void", "doAblauf", "PlausiDescriptor.FlowInfo ablaufInfo, PlausiRuntimeContext context, Object[] initWerte");
        MetaThemenbereich rootTb = ((MetaCustomPlausibilisierung)plausi).rootThemenbereich();
        Iterator it = rootTb.getAblaeufe();
        boolean firstIf = true;
        while (it.hasNext()) {
            MetaPLAblauf ablauf = (MetaPLAblauf)it.next();
            this.indentNewLine();
            if (!firstIf) {
                this.out.print("else ");
            } else {
                firstIf = false;
            }
            this.out.print("if (ablaufInfo.name.equals(\"");
            this.out.print(ablauf.getName());
            this.out.print("\"))");
            this.openBlock();
            if (rootTb.sizeOfInitialisierungswerte() > 0) {
                MetaPLInitwert initwert;
                this.indentNewLine();
                this.out.print("ValueFactory");
                this.out.print(" vf = ");
                this.out.print("ValueFactory.instance()");
                this.out.print(";");
                int i = 0;
                while (i < rootTb.sizeOfInitialisierungswerte()) {
                    initwert = (MetaCustomInitwert)rootTb.getFromInitialisierungswerte(i);
                    String initwertName = StringHelper.getEscapedName(initwert.getName());
                    this.indentNewLine();
                    if (initwert.getListe()) {
                        int[] dimensions = ((MetaCustomInitwert)initwert).dimensions();
                        this.out.print("LocalArray ");
                        this.out.print(initwertName);
                        this.out.print(" = new LocalArray(");
                        this.createArrayDimensions(dimensions);
                        this.out.print(");");
                        StringBuffer template = new StringBuffer();
                        template.append("((Variable)");
                        template.append(initwertName);
                        template.append(".getElement(context, @@indexarray)).set(context, vf.valueFor(((");
                        template.append(Settings.NATIVE_TYPES[initwert.getTyp()]);
                        int j = 0;
                        while (j < dimensions.length) {
                            template.append("[]");
                            ++j;
                        }
                        template.append(")initWerte[");
                        template.append(Integer.toString(i));
                        template.append("])@@index));");
                        this.iterateArray(template.toString(), dimensions);
                    } else {
                        this.out.print("Value ");
                        this.out.print(initwertName);
                        this.out.print(" = ");
                        this.out.print("vf.valueFor((");
                        this.out.print(Settings.NATIVE_TYPES[initwert.getTyp()]);
                        this.out.print(")initWerte[");
                        this.out.print(Integer.toString(i));
                        this.out.print("]);");
                    }
                    ++i;
                }
                this.indentNewLine();
                this.out.print("themenbereich");
                this.out.print(".");
                this.out.print("setInitValues");
                this.out.print("(context");
                i = 0;
                while (i < rootTb.sizeOfInitialisierungswerte()) {
                    initwert = rootTb.getFromInitialisierungswerte(i);
                    this.out.print(", ");
                    this.out.print(StringHelper.getEscapedName(initwert.getName()));
                    ++i;
                }
                this.out.print(");");
            }
            this.indentNewLine();
            this.out.print("themenbereich");
            this.out.print(".");
            this.out.print("prg_");
            this.out.print(StringHelper.getEscapedName(ablauf.getName()));
            this.out.print("(context);");
            this.closeBlock();
        }
        this.endMethodDefinition();
    }

    private void createPlausiFehlerFactoryMethod() {
        PlausiFehlerFactoryGenerator codeGen = new PlausiFehlerFactoryGenerator();
        codeGen.setOutput(this.out);
        codeGen.setIndentLevel(this.indentLevel());
        codeGen.setErrorContext(this.context.getMessageContext());
        codeGen.generate(this.context);
    }

    private void createPlausiFehlerIdsMethod() {
        PlausiFehlerIdsGenerator codeGen = new PlausiFehlerIdsGenerator();
        codeGen.setOutput(this.out);
        codeGen.setIndentLevel(this.indentLevel());
        codeGen.setErrorContext(this.context.getMessageContext());
        codeGen.generate(this.context);
    }

    private void processPlausiElements(MetaPlausibilisierung plausi) {
        Iterator it = plausi.getMerkmale();
        while (it.hasNext()) {
            MetaMerkmal aMerkmal = (MetaMerkmal)it.next();
            aMerkmal.accept(this);
            this.indentNewLine();
        }
        it = plausi.getThemenbereiche();
        while (it.hasNext()) {
            MetaThemenbereich aTb = (MetaThemenbereich)it.next();
            aTb.accept(this);
            this.indentNewLine();
        }
    }
}

