/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.java;

import de.statspez.pleditor.generator.codegen.java.CodegenContext;
import de.statspez.pleditor.generator.codegen.java.ExternalProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.GetArrayRefStrategy;
import de.statspez.pleditor.generator.codegen.java.GetIteratorValueStrategy;
import de.statspez.pleditor.generator.codegen.java.GetMerkmalFromAccess;
import de.statspez.pleditor.generator.codegen.java.GetValueStrategy;
import de.statspez.pleditor.generator.codegen.java.JavaCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.SetValueStrategy;
import de.statspez.pleditor.generator.codegen.java.Settings;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.java.TranslateToMethodStrategy;
import de.statspez.pleditor.generator.codegen.pl.HierarchicalCodeConverter;
import de.statspez.pleditor.generator.codegen.support.CodegenException;
import de.statspez.pleditor.generator.codegen.support.ForEachCheckIterator;
import de.statspez.pleditor.generator.codegen.support.GenericSymbolDescriptor;
import de.statspez.pleditor.generator.codegen.support.GenericSymbolDescriptorFactory;
import de.statspez.pleditor.generator.codegen.support.LiteralManager;
import de.statspez.pleditor.generator.codegen.support.Scope;
import de.statspez.pleditor.generator.codegen.support.ScopeImpl;
import de.statspez.pleditor.generator.codegen.support.SymbolDescriptor;
import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.InternalFunctions;
import de.statspez.pleditor.generator.meta.MetaAblaufStatement;
import de.statspez.pleditor.generator.meta.MetaArrayAccess;
import de.statspez.pleditor.generator.meta.MetaBoolean;
import de.statspez.pleditor.generator.meta.MetaBooleanOperator;
import de.statspez.pleditor.generator.meta.MetaBreakStatement;
import de.statspez.pleditor.generator.meta.MetaCallStatement;
import de.statspez.pleditor.generator.meta.MetaCheckFeldStatement;
import de.statspez.pleditor.generator.meta.MetaClassificationReference;
import de.statspez.pleditor.generator.meta.MetaConditionalStatement;
import de.statspez.pleditor.generator.meta.MetaDate;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaElementVisitor;
import de.statspez.pleditor.generator.meta.MetaErrorStatement;
import de.statspez.pleditor.generator.meta.MetaFactor;
import de.statspez.pleditor.generator.meta.MetaFieldAccess;
import de.statspez.pleditor.generator.meta.MetaForEachCheck;
import de.statspez.pleditor.generator.meta.MetaForEachLoop;
import de.statspez.pleditor.generator.meta.MetaForEachStatement;
import de.statspez.pleditor.generator.meta.MetaForNextLoop;
import de.statspez.pleditor.generator.meta.MetaFunctionCall;
import de.statspez.pleditor.generator.meta.MetaIdentifier;
import de.statspez.pleditor.generator.meta.MetaInterval;
import de.statspez.pleditor.generator.meta.MetaLiteralAccess;
import de.statspez.pleditor.generator.meta.MetaMaterialAccess;
import de.statspez.pleditor.generator.meta.MetaMathOperator;
import de.statspez.pleditor.generator.meta.MetaMultiAssignment;
import de.statspez.pleditor.generator.meta.MetaNumber;
import de.statspez.pleditor.generator.meta.MetaPrintStatement;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.MetaProgramParameter;
import de.statspez.pleditor.generator.meta.MetaPruefeStatement;
import de.statspez.pleditor.generator.meta.MetaRangeSeries;
import de.statspez.pleditor.generator.meta.MetaReturnStatement;
import de.statspez.pleditor.generator.meta.MetaSequence;
import de.statspez.pleditor.generator.meta.MetaSignOperator;
import de.statspez.pleditor.generator.meta.MetaSingleAssignment;
import de.statspez.pleditor.generator.meta.MetaSingleValueRange;
import de.statspez.pleditor.generator.meta.MetaSizeOfOperator;
import de.statspez.pleditor.generator.meta.MetaStatementSequence;
import de.statspez.pleditor.generator.meta.MetaString;
import de.statspez.pleditor.generator.meta.MetaStructureAccess;
import de.statspez.pleditor.generator.meta.MetaTestingOperator;
import de.statspez.pleditor.generator.meta.MetaTypeCheck;
import de.statspez.pleditor.generator.meta.MetaUnaryBoolOperator;
import de.statspez.pleditor.generator.meta.MetaValueAccess;
import de.statspez.pleditor.generator.meta.MetaVarDeclaration;
import de.statspez.pleditor.generator.meta.MetaWhileLoop;
import de.statspez.pleditor.generator.parser.Helper;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Stack;

public class ProgramCodeGenerator
extends JavaCodeGenerator {
    public static final String INVOKE_AS_LONG_METHOD = ".asLong()";
    public static final String INVOKE_AS_DOUBLE_METHOD = ".asDouble()";
    public static final String INVOKE_AS_BOOLEAN_METHOD = ".asBoolean()";
    public static final String INVOKE_AS_STRING_METHOD = ".asString()";
    public static final String SHORT_INVOKE_VALUE_FOR = "vf.valueFor(";
    public static final String OPERATOR_LIB_PLUS = "OperatorLib.plus(context, ";
    public static final String OPERATOR_LIB_MINUS = "OperatorLib.minus(context, ";
    public static final String OPERATOR_LIB_MULT = "OperatorLib.mult(context, ";
    public static final String OPERATOR_LIB_DIV = "OperatorLib.div(context, ";
    public static final String OPERATOR_LIB_CONTAINS = "OperatorLib.contains(context, ";
    public static final String OPERATOR_LIB_EQ = "OperatorLib.eq(context, ";
    public static final String OPERATOR_LIB_NE = "OperatorLib.ne(context, ";
    public static final String OPERATOR_LIB_GT = "OperatorLib.gt(context, ";
    public static final String OPERATOR_LIB_GE = "OperatorLib.ge(context, ";
    public static final String OPERATOR_LIB_LT = "OperatorLib.lt(context, ";
    public static final String OPERATOR_LIB_LE = "OperatorLib.le(context, ";
    public static final String OPERATOR_LIB_AND = "OperatorLib.and(context, ";
    public static final String OPERATOR_LIB_OR = "OperatorLib.or(context, ";
    public static final String OPERATOR_LIB_NOT = "OperatorLib.not(context, ";
    public static final String PLAUSI_VAR = "plausi";
    public static final String TB_VAR = "tb";
    public static final String PRG_SEG_METHOD = "programSegment";
    public static final String RANGE_SEG_METHOD = "rangeSegment";
    public static final String PROGRAM_CHECKS_FIELD_KEY = "PROGRAM_CHECKS_FIELD_KEY";
    public static final String TOPIC_CLASS_NAME_KEY = "TOPIC_CLASS_NAME_KEY";
    private final SetValueStrategy SET_STRATEGY;
    private final GetValueStrategy GET_NOVALUE_STRATEGY;
    private final GetValueStrategy GET_NODEREF_STRATEGY;
    private final GetArrayRefStrategy GET_ARRAY_REF_STRATEGY;
    private final TranslateToMethodStrategy TRANSLATE_TO_METHOD_STRATEGY;
    private final MetaElementVisitor STRUCTURE_ACCESS_HELPER = new StructureAccessHelper();
    private static long uniqueIdCounter = 0L;
    private Stack scopeStack = new Stack();
    private Scope scope = null;
    private LiteralManager literalManager = new LiteralManager();
    private Stack namespace = new Stack();
    private Stack namespaces = new Stack();
    private int loopCount = 0;
    private Stack structureHelpStack = new Stack();
    private MetaProgram program = null;
    private boolean programReturnsValue = false;
    private boolean generateWithTryAndCatchBlock = false;
    private Short errorWeight = null;
    private MetaElementVisitor valueAccessStrategy;
    private boolean willGetLengthOfDimension = false;
    private boolean withinStructureAccess = false;
    private boolean structureFirstAccess = true;
    private boolean ignoreFirstFieldNamespace = false;
    private boolean withinSetValueAccess = false;
    private CodegenContext context;
    private int numOfStatements;
    private Stack segments;
    private PrintWriter originalWriter;
    private int originalIndentLevel;
    private int numOfRanges;

    public ProgramCodeGenerator() {
        this.TRANSLATE_TO_METHOD_STRATEGY = new TranslateToMethodStrategy(this);
        this.GET_ARRAY_REF_STRATEGY = new GetArrayRefStrategy(this);
        this.GET_NOVALUE_STRATEGY = new GetValueStrategy("", this);
        this.GET_NODEREF_STRATEGY = new GetValueStrategy(this);
        this.SET_STRATEGY = new SetValueStrategy(this);
        this.setValueAccess(this.GET_NOVALUE_STRATEGY);
    }

    public void generate(CodegenContext aContext, MetaProgram aProgram, Scope superScope, boolean returnsValue, boolean generateWithTryAndCatchBlock) {
        this.generate(aContext, aProgram, superScope, returnsValue, generateWithTryAndCatchBlock, null);
    }

    public void generate(CodegenContext aContext, MetaProgram aProgram, Scope superScope, boolean returnsValue, boolean generateWithTryAndCatchBlock, Short errorWeight) {
        this.context = aContext;
        this.numOfStatements = 0;
        this.segments = new Stack();
        this.numOfRanges = 0;
        if (aProgram.containsHierarchicalFunction()) {
            HierarchicalCodeConverter converter = new HierarchicalCodeConverter();
            this.program = Helper.metaStructureFor(converter.generate(aProgram));
            this.program.setName(aProgram.name());
            this.program.setContextInfos(aProgram.contextInfos());
        } else {
            this.program = aProgram;
        }
        this.scope = superScope;
        this.programReturnsValue = returnsValue;
        this.generateWithTryAndCatchBlock = generateWithTryAndCatchBlock;
        this.errorWeight = errorWeight;
        this.program.accept(this);
        this.checkForErrors();
    }

    public void generate(CodegenContext aContext, MetaProgram aProgram, Scope superScope, boolean returnsValue) {
        this.generate(aContext, aProgram, superScope, returnsValue, false, null);
    }

    public void setLiteralManager(LiteralManager aManager) {
        this.literalManager = aManager;
        this.GET_NOVALUE_STRATEGY.setLiteralManager(aManager);
        this.GET_NODEREF_STRATEGY.setLiteralManager(aManager);
    }

    @Override
    public void visitProgram(MetaProgram aProgram) {
        String programName = StringHelper.getEscapedName(aProgram.name());
        this.indentNewLine();
        this.out.print("public ");
        if (this.programReturnsValue || this.generateWithTryAndCatchBlock) {
            this.out.print("Value ");
        } else {
            this.out.print("void ");
        }
        this.out.print("prg_");
        this.out.print(programName);
        this.out.print("(");
        this.out.print("PlausiRuntimeContext");
        this.out.print(" context");
        int i = 0;
        while (i < aProgram.numberOfParameters()) {
            MetaProgramParameter aParam = aProgram.parameterAt(i);
            if (!aParam.isList()) {
                this.out.print(", ");
                if (!aParam.byReference()) {
                    this.out.print("Value param_");
                    this.out.print(StringHelper.getEscapedName(aParam.name().value()));
                } else {
                    this.out.print("Variable aFeld");
                }
            } else {
                this.out.print(", Array param_");
                this.out.print(StringHelper.getEscapedName(aParam.name().value()));
            }
            ++i;
        }
        this.out.print(")");
        this.startBlock();
        this.preGenerate();
        if (this.errorWeight != null) {
            this.indentNewLine();
            this.out.print("if (");
            this.out.print(this.errorWeight);
            this.out.print(" >= context.getPlausiKontext().getFehlerGewichtSchranke())");
            this.openBlock();
        }
        this.startNewSection(aProgram.contextInfos());
        this.indentNewLine();
        this.out.print("try");
        this.openBlock();
        if (this.programChecksField()) {
            this.indentNewLine();
            this.out.print("context.getLogger().trace(\"Pruefe Feld \" + ((FeatureVariable)aFeld).hierarchyAsString());");
            this.indentNewLine();
            this.out.print("context.setCurrentField((FeatureVariable)aFeld);");
            this.indentNewLine();
            this.out.print("Variable feld = new MerkmalCheckFeatureVariable((FeatureVariable)aFeld);");
        }
        i = 0;
        while (i < aProgram.numberOfParameters()) {
            aProgram.parameterAt(i).accept(this);
            ++i;
        }
        if (aProgram.isExternal()) {
            ExternalProgramCodeGenerator externalProgramGenerator = new ExternalProgramCodeGenerator();
            externalProgramGenerator.setOutput(this.out);
            externalProgramGenerator.setIndentLevel(this.indentLevel());
            externalProgramGenerator.setLiteralManager(this.literalManager);
            aProgram.accept(externalProgramGenerator);
        } else {
            this.originalWriter = this.out;
            this.originalIndentLevel = this.indentLevel();
            Iterator it = aProgram.statements().statements();
            while (it.hasNext()) {
                this.startNewSegmentIfNecessary(false);
                ((MetaElement)it.next()).accept(this);
            }
            while (!this.segments.empty()) {
                this.closeCurrentSegment();
            }
            this.out = this.originalWriter;
            this.setIndentLevel(this.originalIndentLevel);
        }
        if (!this.programReturnsValue && this.generateWithTryAndCatchBlock) {
            this.indentNewLine();
            this.out.print("return vf.valueFor(false);");
        }
        this.closeBlock();
        if (this.programReturnsValue || this.generateWithTryAndCatchBlock) {
            this.indentNewLine();
            this.out.print("catch (ReturnStatementException e)");
            this.openBlock();
            this.indentNewLine();
            this.out.print("return e.getReturnValue();");
            this.closeBlock();
        }
        if (this.generateWithTryAndCatchBlock) {
            this.indentNewLine();
            this.out.print("catch (Exception e)");
            this.openBlock();
            this.indentNewLine();
            this.out.print("context.getLogger().error(\"Fehler waehrend Ausfuehrung: ");
            this.out.print(programName);
            this.out.print("\", e);");
            this.indentNewLine();
            this.out.print("context.getLogger().trace(\"Fehler angeschrieben (wg. Exception): ");
            this.out.print(programName);
            this.out.print("\");");
            this.indentNewLine();
            this.out.print("this.");
            this.out.print("fehler_");
            this.out.print(programName);
            this.out.print("(context, ");
            this.out.print(0);
            this.out.print(", e);");
            this.indentNewLine();
            this.out.print("return vf.valueFor(true);");
            this.closeBlock();
        }
        this.indentNewLine();
        this.out.print("finally");
        this.openBlock();
        if (this.programChecksField()) {
            this.indentNewLine();
            this.out.print("context.setCurrentField(null);");
        }
        this.leaveCurrentSection();
        this.closeBlock();
        if (this.errorWeight != null) {
            this.closeBlock();
            this.indentNewLine();
            this.out.print("else");
            this.openBlock();
            this.indentNewLine();
            this.out.print("context.getLogger().trace(\"Pruefung wg. Fehlergewichtsschranke ausgelassen: " + programName + "\");");
            this.indentNewLine();
            this.out.print("return vf.valueFor(false);");
            this.closeBlock();
        }
        this.endBlock();
    }

    @Override
    public void visitProgramParameter(MetaProgramParameter aParam) {
        String paramName = StringHelper.getEscapedName(aParam.name().value());
        if (!aParam.byReference()) {
            this.indentNewLine();
            if (aParam.isList()) {
                this.out.print("LocalArray ");
            } else {
                this.out.print("LocalVariable ");
            }
            this.out.print(paramName);
            this.out.print(" = new ");
            if (aParam.isList()) {
                this.out.print("LocalArray(new int[]{");
                int[] dimensions = aParam.dimensions();
                int i = 0;
                while (i < dimensions.length) {
                    this.out.print(dimensions[i]);
                    if (i < dimensions.length - 1) {
                        this.out.print(", ");
                    }
                    ++i;
                }
                this.out.print("});");
                this.indentNewLine();
                this.out.print("SupportLib.copyArray(param_");
                this.out.print(paramName);
                this.out.print(", ");
                this.out.print(paramName);
                this.out.print(", context);");
                this.indentNewLine();
                this.out.print("context.defineArray(\"");
                this.out.print(paramName);
                this.out.print("\", ");
                this.out.print(paramName);
                this.out.print(");");
            } else {
                this.out.print("LocalVariable(param_");
                this.out.print(paramName);
                this.out.print(");");
                this.indentNewLine();
                this.out.print("context.defineVariable(\"");
                this.out.print(paramName);
                this.out.print("\", ");
                this.out.print(paramName);
                this.out.print(");");
            }
        }
        SymbolDescriptor sd = new GenericSymbolDescriptorFactory().createSymbolDescriptor(aParam);
        this.scope.define(aParam.name(), this.namespace(), sd);
    }

    @Override
    public void visitStatementSequence(MetaStatementSequence aSequence) {
        int currentNumOfSegments = this.segments.size();
        Iterator it = aSequence.statements();
        while (it.hasNext()) {
            this.startNewSegmentIfNecessary(true);
            ((MetaElement)it.next()).accept(this);
        }
        while (this.segments.size() > currentNumOfSegments) {
            this.closeCurrentSegment();
        }
    }

    @Override
    public void visitVarDeclaration(MetaVarDeclaration aDecl) {
        Iterator it = aDecl.identifiers();
        while (it.hasNext()) {
            this.declareLocalVariable((MetaIdentifier)it.next());
        }
    }

    @Override
    public void visitSingleAssignment(MetaSingleAssignment anAssignment) {
        this.indentNewLine();
        this.withinSetValueAccess = true;
        this.setValueAccess(this.SET_STRATEGY);
        anAssignment.leftValue().accept(this);
        this.withinSetValueAccess = false;
        this.setValueAccess(this.GET_NOVALUE_STRATEGY);
        anAssignment.rightValue().accept(this);
        if (anAssignment.rightValue().value() instanceof MetaFactor && ((MetaFactor)anAssignment.rightValue().value()).adaptedObject() instanceof MetaMaterialAccess) {
            this.out.print(".firstValue()");
        }
        this.out.print("))");
        this.out.print(";");
    }

    @Override
    public void visitMultiAssignment(MetaMultiAssignment anAssignment) {
        this.indentNewLine();
        this.startBlock();
        this.indentNewLine();
        String iteratorVar = "__multiassignment_iterator" + Long.toString(uniqueIdCounter++);
        this.out.print("PlausiRuntimeIterator");
        this.out.print(" ");
        this.out.print(iteratorVar);
        this.out.print(" = SupportLib.iteratorFor(");
        this.setValueAccess(this.GET_NOVALUE_STRATEGY);
        anAssignment.rightValue().accept(this);
        this.out.print(", context);");
        int i = 0;
        while (i < anAssignment.numberOfLeftValues()) {
            this.indentNewLine();
            this.out.print("if (");
            this.out.print(iteratorVar);
            this.out.print(".hasNext())");
            this.openBlock();
            this.indentNewLine();
            this.setValueAccess(this.SET_STRATEGY);
            anAssignment.leftValueAt(i).accept(this);
            this.out.print("(Value)");
            this.out.print(iteratorVar);
            this.out.print(".next()");
            this.out.print("));");
            this.closeBlock();
            ++i;
        }
        this.endBlock();
    }

    @Override
    public void visitPrintStatement(MetaPrintStatement aStatement) {
        this.indentNewLine();
        if (aStatement.leftValue() != null) {
            Iterator iter = aStatement.toPrint();
            while (iter.hasNext()) {
                this.setValueAccess(this.SET_STRATEGY);
                aStatement.leftValue().accept(this);
                this.out.print("FunctionLib.KONKATENIEREN(context, ");
                this.setValueAccess(this.GET_NOVALUE_STRATEGY);
                aStatement.leftValue().accept(this);
                this.out.print(", ");
                ((MetaElement)iter.next()).accept(this);
                this.out.print("));");
                if (!iter.hasNext()) continue;
                this.indentNewLine();
            }
        } else {
            if (this.withinSegment()) {
                this.printPlausiClassAccess();
            }
            this.out.print("context.println(");
            this.printPrintStatementText(aStatement);
            this.out.print(");");
        }
    }

    @Override
    public void visitConditionalStatement(MetaConditionalStatement aStatement) {
        this.indentNewLine();
        this.generateForEachChecks(aStatement.condition());
        this.out.print("if(");
        this.setValueAccess(this.GET_NOVALUE_STRATEGY);
        aStatement.condition().accept(this);
        this.out.print(INVOKE_AS_BOOLEAN_METHOD);
        this.out.print(")");
        this.startBlock();
        aStatement.ifTrue().accept(this);
        this.endBlock();
        if (aStatement.ifFalse().numberOfStatements() > 0) {
            this.indentNewLine();
            this.out.print("else");
            this.startBlock();
            aStatement.ifFalse().accept(this);
            this.endBlock();
        }
    }

    @Override
    public void visitForNextLoop(MetaForNextLoop aStatement) {
        aStatement.startAssignment().accept(this);
        this.openTryBlockForLoop();
        this.indentNewLine();
        this.out.print("while (true)");
        this.indentNewLine();
        this.out.print("{");
        this.increaseIndentLevel();
        this.indentNewLine();
        this.out.print("if (");
        this.setValueAccess(this.GET_NOVALUE_STRATEGY);
        aStatement.endCondition().accept(this);
        this.out.print(INVOKE_AS_BOOLEAN_METHOD);
        this.out.print(") { break; }");
        this.indentNewLine();
        this.enterLoopBody();
        aStatement.loopBody().accept(this);
        this.indentNewLine();
        this.setValueAccess(this.SET_STRATEGY);
        aStatement.startAssignment().leftValue().accept(this);
        this.out.print(OPERATOR_LIB_PLUS);
        this.setValueAccess(this.GET_NOVALUE_STRATEGY);
        aStatement.startAssignment().leftValue().accept(this);
        this.out.print(", ");
        this.setValueAccess(this.GET_NOVALUE_STRATEGY);
        aStatement.stepExpression().accept(this);
        this.out.print(")));");
        this.leaveLoopBody();
        this.decreaseIndentLevel();
        this.indentNewLine();
        this.out.print("}");
        this.closeTryBlockForLoop();
    }

    @Override
    public void visitForEachLoop(MetaForEachLoop aStatement) {
        this.indentNewLine();
        this.startBlock();
        this.indentNewLine();
        String iterator_var = this.declareIteratorVariable(aStatement);
        this.openTryBlockForLoop();
        this.indentNewLine();
        this.out.print("while(");
        this.out.print(iterator_var);
        this.out.print(".hasNext())");
        this.startBlock();
        this.createPerIterationStatements(aStatement, iterator_var);
        this.enterLoopBody();
        aStatement.loopBody().accept(this);
        this.leaveLoopBody();
        this.endBlock();
        this.closeTryBlockForLoop();
        this.endBlock();
    }

    @Override
    public void visitWhileLoop(MetaWhileLoop aStatement) {
        this.openTryBlockForLoop();
        this.indentNewLine();
        this.out.print("while(");
        this.setValueAccess(this.GET_NOVALUE_STRATEGY);
        aStatement.condition().accept(this);
        this.out.print(INVOKE_AS_BOOLEAN_METHOD);
        this.out.print(")");
        this.startBlock();
        this.enterLoopBody();
        aStatement.loopBody().accept(this);
        this.leaveLoopBody();
        this.endBlock();
        this.closeTryBlockForLoop();
    }

    @Override
    public void visitBreakStatement(MetaBreakStatement aStatement) {
        if (!this.inLoop()) {
            this.error(aStatement, "nicht ausserhalb von Schleifen erlaubt");
        } else {
            this.indentNewLine();
            if (this.withinSegment()) {
                this.out.print("throw new BreakStatementException()");
            } else {
                this.out.print("break");
            }
            this.out.print(";");
        }
    }

    @Override
    public void visitPruefeStatement(MetaPruefeStatement aStatement) {
        this.createMethodCall(aStatement, aStatement.isStandalone());
    }

    @Override
    public void visitAblaufStatement(MetaAblaufStatement aStatement) {
        if (aStatement.numberOfParameters() > 0) {
            this.indentNewLine();
            this.TRANSLATE_TO_METHOD_STRATEGY.setForcedMethodName("setInitValues");
            if (aStatement.function().adaptedObject() instanceof MetaIdentifier) {
                if (this.withinSegment()) {
                    this.printTopicAccess();
                }
                aStatement.function().accept(this.TRANSLATE_TO_METHOD_STRATEGY);
            } else {
                this.setValueAccess(this.TRANSLATE_TO_METHOD_STRATEGY);
                aStatement.function().accept(this);
            }
            this.TRANSLATE_TO_METHOD_STRATEGY.setForcedMethodName(null);
            SymbolDescriptor ablaufDesc = this.TRANSLATE_TO_METHOD_STRATEGY.lastFunctionDescriptor();
            if (ablaufDesc == null) {
                this.error(aStatement, "Das verwendete Element (" + aStatement.function() + ") ist nicht definiert.");
                return;
            }
            if (ablaufDesc.numberOfFunctionParameters() != aStatement.numberOfParameters()) {
                this.error(aStatement, "falsche Anzahl von Parametern (" + ablaufDesc.numberOfFunctionParameters() + " erwartet, " + aStatement.numberOfParameters() + " bekommen)");
            }
            this.out.print("(context");
            int i = 0;
            while (i < aStatement.numberOfParameters()) {
                this.out.print(", ");
                if (ablaufDesc.functionParameterAt(i).isArray()) {
                    this.setValueAccess(this.GET_ARRAY_REF_STRATEGY);
                    aStatement.parameterAt(i).accept(this);
                } else {
                    this.out.print(SHORT_INVOKE_VALUE_FOR);
                    this.setValueAccess(this.GET_NOVALUE_STRATEGY);
                    aStatement.parameterAt(i).accept(this);
                    this.out.print(")");
                }
                ++i;
            }
            this.out.print(");");
        }
        this.createMethodCall(aStatement, true);
    }

    @Override
    public void visitCheckFeldStatement(MetaCheckFeldStatement aStatement) {
        GetMerkmalFromAccess merkmalGetter = new GetMerkmalFromAccess(this);
        aStatement.field().accept(merkmalGetter);
        SymbolDescriptor merkmalDesc = merkmalGetter.merkmal();
        if (merkmalDesc != null) {
            if (merkmalDesc.isArray()) {
                if (!aStatement.isStandalone()) {
                    this.error(aStatement, "Merkmalspr\u00fcfung der Listenfelder darf nur im Standalone-Modus aufgerufen werden.");
                } else {
                    this.openBlock();
                    this.indentNewLine();
                    this.out.print("ArrayIterator feldIt = SupportLib.forceArrayIteratorFor(");
                    this.setValueAccess(this.GET_NODEREF_STRATEGY);
                    aStatement.field().accept(this);
                    this.out.print(", context);");
                    this.indentNewLine();
                    this.out.print("while(feldIt.hasNext())");
                    this.openBlock();
                    this.indentNewLine();
                    if (this.withinSegment()) {
                        this.out.print(PLAUSI_VAR);
                        this.out.print(".");
                    }
                    this.out.print("prg_");
                    this.out.print("Merkmal_");
                    this.out.print(StringHelper.getEscapedName(merkmalDesc.getMerkmal()));
                    this.out.print("(context, (FeatureVariable)feldIt.nextVariable());");
                    this.indentNewLine();
                    this.closeBlock();
                    this.closeBlock();
                }
            } else {
                if (aStatement.isStandalone()) {
                    this.indentNewLine();
                }
                if (this.withinSegment()) {
                    this.out.print(PLAUSI_VAR);
                    this.out.print(".");
                }
                this.out.print("prg_");
                this.out.print("Merkmal_");
                this.out.print(StringHelper.getEscapedName(merkmalDesc.getMerkmal()));
                this.out.print("(context, ");
                this.setValueAccess(this.GET_NODEREF_STRATEGY);
                aStatement.field().accept(this);
                this.out.print(")");
                if (aStatement.isStandalone()) {
                    this.out.print(";");
                }
            }
        }
    }

    @Override
    public void visitFunctionCall(MetaFunctionCall aStatement) {
        if (aStatement.isStandalone()) {
            this.indentNewLine();
        }
        SymbolDescriptor functionDesc = null;
        if (InternalFunctions.instance().identifiesInternalFunction(aStatement.function())) {
            MetaIdentifier functionId = (MetaIdentifier)aStatement.function().adaptedObject();
            functionDesc = this.scope.symbolDescriptor(functionId, this.namespace());
            this.out.print("FunctionLib.");
            this.out.print(functionId.value());
        } else {
            if (aStatement.function().adaptedObject() instanceof MetaIdentifier) {
                if (this.withinSegment() && !this.withinStructureAccess()) {
                    this.printTopicAccess();
                }
                aStatement.function().accept(this.TRANSLATE_TO_METHOD_STRATEGY);
            } else {
                this.setValueAccess(this.TRANSLATE_TO_METHOD_STRATEGY);
                aStatement.function().accept(this);
            }
            functionDesc = this.TRANSLATE_TO_METHOD_STRATEGY.lastFunctionDescriptor();
        }
        if (functionDesc == null) {
            this.error(aStatement, "Das verwendete Element (" + aStatement.function() + ") ist nicht definiert.");
            return;
        }
        if (functionDesc.numberOfFunctionParameters() != aStatement.numberOfParameters()) {
            this.error(aStatement, "falsche Anzahl von Parametern (" + functionDesc.numberOfFunctionParameters() + " erwartet, " + aStatement.numberOfParameters() + " bekommen)");
        }
        this.out.print("(context");
        int i = 0;
        while (i < aStatement.numberOfParameters()) {
            this.out.print(", ");
            if (!functionDesc.functionParameterAt(i).isArray()) {
                this.out.print(SHORT_INVOKE_VALUE_FOR);
                this.setValueAccess(this.GET_NOVALUE_STRATEGY);
                aStatement.parameterAt(i).accept(this);
                this.out.print(")");
            } else {
                this.setValueAccess(this.GET_ARRAY_REF_STRATEGY);
                aStatement.parameterAt(i).accept(this);
            }
            ++i;
        }
        this.out.print(")");
        if (aStatement.isStandalone()) {
            this.out.print(";");
        }
    }

    @Override
    public void visitErrorStatement(MetaErrorStatement aStatement) {
        this.indentNewLine();
        if (this.withinSegment()) {
            this.out.print(PLAUSI_VAR);
            this.out.print(".");
        }
        this.out.print("context.getLogger().trace(\"Fehler angeschrieben: " + this.program.name() + "\");");
        this.indentNewLine();
        if (this.withinSegment()) {
            if (this.programChecksField()) {
                this.out.print(PLAUSI_VAR);
            } else {
                this.out.print(TB_VAR);
            }
            this.out.print(".");
        }
        this.out.print("fehler_");
        this.out.print(StringHelper.getEscapedName(this.program.name()));
        this.out.print("(context, ");
        this.out.print(aStatement.errorNumber());
        this.out.print(", null);");
        this.indentNewLine();
        if (this.withinSegment()) {
            this.out.print("throw new ReturnStatementException(");
        } else {
            this.out.print("return ");
        }
        this.out.print("vf.valueFor(true)");
        if (this.withinSegment()) {
            this.out.print(")");
        }
        this.out.print(";");
    }

    @Override
    public void visitReturnStatement(MetaReturnStatement aStatement) {
        this.indentNewLine();
        boolean returnStatementSupported = this.returnStatementSupported();
        if (returnStatementSupported) {
            this.out.print("return ");
        } else {
            this.out.print("throw new ReturnStatementException(");
        }
        this.setValueAccess(this.GET_NOVALUE_STRATEGY);
        aStatement.returnValue().accept(this);
        if (!returnStatementSupported) {
            this.out.print(")");
        }
        this.out.print(";");
    }

    @Override
    public void visitFieldAccess(MetaFieldAccess anAccess) {
        if (!this.withinStructureAccess()) {
            this.printAccessPrefix(anAccess.accessedField());
        }
        anAccess.accept(this.valueAccessStrategy);
    }

    @Override
    public void visitArrayAccess(MetaArrayAccess anAccess) {
        if (!this.hvScope().isDefined(anAccess.accessedArray(), this.namespace())) {
            this.error(anAccess, String.valueOf(anAccess.accessedArray().toString()) + " ist nicht in diesem Gueltigkeitsbereich definiert");
            return;
        }
        SymbolDescriptor sd = this.hvScope().symbolDescriptor(anAccess.accessedArray(), this.namespace());
        if (!this.willGetLengthOfDimension && !this.withinStructureAccess()) {
            this.out.print("(");
            this.castArrayAccess(anAccess, null);
        }
        if (!this.withinStructureAccess()) {
            this.printAccessPrefix(anAccess.accessedArray());
        }
        String name = StringHelper.getEscapedName(anAccess.accessedArray().value());
        if (this.withinSegment()) {
            if (sd.isLokaleVariable() || sd.isParameter()) {
                this.out.print("context.getArray(\"");
                this.out.print(name);
                this.out.print("\")");
            } else {
                if (!this.withinStructureAccess()) {
                    this.printTopicAccess();
                }
                this.out.print(name);
            }
        } else {
            this.out.print(name);
        }
        this.out.print(".");
        if (this.willGetLengthOfDimension) {
            this.out.print("getLengthOfDimension");
        } else {
            this.out.print("getElement");
        }
        this.out.print("(context, new int[]{");
        MetaElementVisitor oldAccessStrategy = this.valueAccessStrategy;
        this.setValueAccess(this.GET_NOVALUE_STRATEGY);
        boolean currentWithinStructureAccess = this.withinStructureAccess;
        this.withinStructureAccess = false;
        boolean currentWithinSetValueAccess = this.withinSetValueAccess;
        this.withinSetValueAccess = false;
        Stack currentStructureHelpStack = this.structureHelpStack;
        this.structureHelpStack = new Stack();
        int i = 0;
        while (i < anAccess.numberOfIndices()) {
            this.startNewNamespace();
            this.out.print("(int)(");
            anAccess.indexAt(i).accept(this);
            this.out.print(INVOKE_AS_LONG_METHOD);
            this.out.print(" - 1)");
            if (i < anAccess.numberOfIndices() - 1) {
                this.out.print(", ");
            }
            this.leaveThisNamespace();
            ++i;
        }
        this.withinStructureAccess = currentWithinStructureAccess;
        this.withinSetValueAccess = currentWithinSetValueAccess;
        this.structureHelpStack = currentStructureHelpStack;
        this.out.print("})");
        if (!this.willGetLengthOfDimension) {
            this.out.print(")");
        } else {
            this.willGetLengthOfDimension = false;
        }
        this.setValueAccess(oldAccessStrategy);
        anAccess.accept(this.valueAccessStrategy);
    }

    @Override
    public void visitClassificationReference(MetaClassificationReference anAccess) {
        anAccess.accept(this.valueAccessStrategy);
    }

    @Override
    public void visitLiteralAccess(MetaLiteralAccess anAccess) {
        anAccess.accept(this.valueAccessStrategy);
    }

    @Override
    public void visitStructureAccess(MetaStructureAccess anAccess) {
        boolean currentWithinStructureAccess = this.withinStructureAccess;
        this.withinStructureAccess = true;
        if (anAccess.structureAccess() instanceof MetaStructureAccess) {
            if (!(!(anAccess.selectedElement() instanceof MetaArrayAccess) || this.structureFirstAccess && this.willGetLengthOfDimension)) {
                MetaArrayAccess arrayAccess = (MetaArrayAccess)anAccess.selectedElement();
                this.out.print("(");
                this.castArrayAccess(arrayAccess, anAccess.structureAccess());
            }
            this.structureFirstAccess = false;
            this.structureHelpStack.push(anAccess.selectedElement());
            anAccess.structureAccess().accept(this);
        } else {
            MetaArrayAccess arrayAccess;
            if (!(!(anAccess.selectedElement() instanceof MetaArrayAccess) || this.structureFirstAccess && this.willGetLengthOfDimension)) {
                arrayAccess = (MetaArrayAccess)anAccess.selectedElement();
                this.out.print("(");
                this.castArrayAccess(arrayAccess, anAccess.structureAccess());
            }
            if (anAccess.structureAccess() instanceof MetaArrayAccess) {
                arrayAccess = (MetaArrayAccess)anAccess.structureAccess();
                this.out.print("(");
                this.castArrayAccess(arrayAccess, null);
            }
            this.structureFirstAccess = true;
            this.structureHelpStack.push(anAccess.selectedElement());
            this.structureHelpStack.push(anAccess.structureAccess());
            MetaElementVisitor oldAccessStrategy = this.valueAccessStrategy;
            this.setValueAccess(this.STRUCTURE_ACCESS_HELPER);
            boolean tmpWillGetLengthOfDimenion = this.willGetLengthOfDimension;
            this.willGetLengthOfDimension = false;
            MetaElement firstElement = (MetaElement)this.structureHelpStack.peek();
            if (firstElement instanceof MetaArrayAccess) {
                this.printAccessPrefix(((MetaArrayAccess)firstElement).accessedArray());
            } else {
                this.printAccessPrefix(((MetaFieldAccess)firstElement).accessedField());
            }
            if (this.withinSegment()) {
                this.printTopicAccess();
            }
            int namespaceCount = this.ignoreFirstFieldNamespace ? -1 : 0;
            while (this.structureHelpStack.size() > 1) {
                ++namespaceCount;
                ((MetaElement)this.structureHelpStack.pop()).accept(this);
            }
            this.setValueAccess(oldAccessStrategy);
            this.willGetLengthOfDimension = tmpWillGetLengthOfDimenion;
            ((MetaElement)this.structureHelpStack.pop()).accept(this);
            int i = 0;
            while (i < namespaceCount) {
                this.leaveSubNamespace();
                ++i;
            }
        }
        this.withinStructureAccess = currentWithinStructureAccess;
    }

    @Override
    public void visitMaterialAccess(MetaMaterialAccess anAccess) {
        if (!this.scope.isDefined(anAccess.material(), this.namespace())) {
            this.error(anAccess, "kein Material mit dem Namen '" + anAccess.material().value() + "' in diesem Gueltigkeitsbereich definiert");
            return;
        }
        String materialAttribut = null;
        materialAttribut = this.scope.symbolDescriptor(anAccess.material(), this.namespace()).isReference() ? "__material_ref_" + anAccess.material().value() : "__material_" + anAccess.material().value();
        String materialAttributName = StringHelper.getEscapedName(materialAttribut);
        this.out.print("new Material(");
        if (this.withinSegment()) {
            this.printTopicAccess();
        }
        this.out.print(materialAttributName);
        MetaElementVisitor currentValueAccess = this.valueAccessStrategy;
        this.out.print(", new ");
        this.out.print("FeldDeskriptorInterface");
        this.out.print("[] {");
        this.enterSubNamespace(anAccess.material().value());
        int i = 0;
        while (i < anAccess.numberOfSelectedFields()) {
            this.setValueAccess(this.GET_NODEREF_STRATEGY);
            this.ignoreFirstFieldNamespace = true;
            this.visitMaterialStructureAccess(materialAttribut, anAccess.selectedFieldAt(i));
            if (i < anAccess.numberOfSelectedFields() - 1) {
                this.out.print(", ");
            }
            ++i;
        }
        this.leaveSubNamespace();
        this.out.print("}");
        this.out.print(", new SatzFilter.FilterBedingung[] {");
        Iterator it = anAccess.selectionConditions();
        while (it.hasNext()) {
            MetaTestingOperator condition = (MetaTestingOperator)it.next();
            this.out.print("new SatzFilter.FilterBedingung(");
            this.setValueAccess(this.GET_NODEREF_STRATEGY);
            this.enterSubNamespace(anAccess.material().value());
            this.ignoreFirstFieldNamespace = true;
            this.visitMaterialStructureAccess(materialAttribut, (MetaValueAccess)condition.firstOperand().adaptedObject());
            this.leaveSubNamespace();
            this.out.print(", ");
            this.out.print(Integer.toString(this.toSatzFilterOperator(condition)));
            this.out.print(", ");
            this.setValueAccess(this.GET_NOVALUE_STRATEGY);
            condition.secondOperand().accept(this);
            this.out.print(")");
            if (!it.hasNext()) continue;
            this.out.print(", ");
        }
        this.out.print("}");
        this.out.print(", context)");
        this.setValueAccess(currentValueAccess);
    }

    @Override
    public void visitBoolean(MetaBoolean aBoolean) {
        this.error(aBoolean, "unerwarteter bool-Wert");
    }

    @Override
    public void visitNumber(MetaNumber aNumber) {
        this.error(aNumber, "unerwarteter numerischer Wert");
    }

    @Override
    public void visitString(MetaString aString) {
        this.error(aString, "unerwartete Zeichenkette");
    }

    @Override
    public void visitDate(MetaDate aDate) {
        this.out.print("new DateValue(");
        this.setValueAccess(this.GET_NOVALUE_STRATEGY);
        aDate.specification().accept(this);
        this.out.print(INVOKE_AS_STRING_METHOD);
        this.out.print(", \"");
        if (aDate.format() != null) {
            this.out.print(StringHelper.getEscapedStringValue(aDate.format()));
        } else {
            this.out.print("TT.MM.JJJJ");
        }
        this.out.print("\"");
        this.out.print(")");
    }

    @Override
    public void visitRangeSeries(MetaRangeSeries aRangeSeries) {
        int previousNumOfRanges;
        if (this.segments.isEmpty()) {
            previousNumOfRanges = this.numOfRanges;
            this.numOfRanges = 0;
        } else {
            previousNumOfRanges = ((SegmentInfo)this.segments.peek()).numOfRanges;
            ((SegmentInfo)this.segments.peek()).numOfRanges = 0;
        }
        this.out.print("new RangeSeries(new Range[] {");
        int numOfSegments = this.segments.size();
        Iterator it = aRangeSeries.ranges();
        while (it.hasNext()) {
            this.startNewRangeSegmentIfNecessary();
            ((MetaElement)it.next()).accept(this);
            if (!it.hasNext()) continue;
            this.out.print(", ");
        }
        while (this.segments.size() > numOfSegments) {
            this.closeCurrentRangeSegment();
        }
        this.out.print("})");
        if (this.segments.isEmpty()) {
            this.numOfRanges = previousNumOfRanges;
        } else {
            ((SegmentInfo)this.segments.peek()).numOfRanges = previousNumOfRanges;
        }
    }

    @Override
    public void visitSingleValueRange(MetaSingleValueRange aRange) {
        this.out.print("new SingleValueRange(");
        aRange.value().accept(this);
        this.out.print(")");
    }

    @Override
    public void visitInterval(MetaInterval aRange) {
        this.out.print("new IntervalRange(");
        aRange.first().accept(this);
        this.out.print(", ");
        aRange.last().accept(this);
        this.out.print(", ");
        this.out.print(this.getRuntimeIntervalType(aRange.type()));
        this.out.print(")");
    }

    @Override
    public void visitSequence(MetaSequence aRange) {
        this.out.print("new SequenceRange(");
        aRange.first().accept(this);
        this.out.print(", ");
        aRange.second().accept(this);
        this.out.print(", ");
        aRange.last().accept(this);
        this.out.print(")");
    }

    @Override
    public void visitBooleanOperator(MetaBooleanOperator anOperator) {
        this.out.print(SHORT_INVOKE_VALUE_FOR);
        anOperator.firstOperand().accept(this);
        this.out.print(INVOKE_AS_BOOLEAN_METHOD);
        switch (anOperator.type()) {
            case 1: {
                this.out.print(" && ");
                break;
            }
            case 2: {
                this.out.print(" || ");
                break;
            }
            default: {
                this.error(anOperator, "unbekannter Operator " + anOperator.toString());
            }
        }
        anOperator.secondOperand().accept(this);
        this.out.print(INVOKE_AS_BOOLEAN_METHOD);
        this.out.print(")");
    }

    @Override
    public void visitUnaryBoolOperator(MetaUnaryBoolOperator anOperator) {
        switch (anOperator.type()) {
            case 1: {
                this.out.print(OPERATOR_LIB_NOT);
                break;
            }
            default: {
                this.error(anOperator, "unbekannter Operator " + anOperator.toString());
            }
        }
        this.setValueAccess(this.GET_NOVALUE_STRATEGY);
        anOperator.operand().accept(this);
        this.out.print(")");
    }

    @Override
    public void visitTestingOperator(MetaTestingOperator anOperator) {
        MetaFactor leftOperand = null;
        MetaFactor rightOperand = null;
        if (anOperator.type() == 7) {
            leftOperand = anOperator.secondOperand();
            rightOperand = anOperator.firstOperand();
        } else {
            leftOperand = anOperator.firstOperand();
            rightOperand = anOperator.secondOperand();
        }
        switch (anOperator.type()) {
            case 1: {
                this.out.print(OPERATOR_LIB_EQ);
                break;
            }
            case 6: {
                this.out.print(OPERATOR_LIB_GE);
                break;
            }
            case 3: {
                this.out.print(OPERATOR_LIB_GT);
                break;
            }
            case 5: {
                this.out.print(OPERATOR_LIB_LE);
                break;
            }
            case 2: {
                this.out.print(OPERATOR_LIB_LT);
                break;
            }
            case 4: {
                this.out.print(OPERATOR_LIB_NE);
                break;
            }
            case 7: {
                this.out.print(OPERATOR_LIB_CONTAINS);
                break;
            }
            default: {
                this.error(anOperator, "unbekannter Operator " + anOperator.toString());
            }
        }
        this.setValueAccess(this.GET_NOVALUE_STRATEGY);
        ((MetaElement)leftOperand).accept(this);
        this.out.print(", ");
        this.setValueAccess(this.GET_NOVALUE_STRATEGY);
        ((MetaElement)rightOperand).accept(this);
        this.out.print(")");
    }

    @Override
    public void visitTypeCheck(MetaTypeCheck typeCheck) {
        this.out.print(SHORT_INVOKE_VALUE_FOR);
        this.out.print("SupportLib.checkType(");
        this.setValueAccess(this.GET_NOVALUE_STRATEGY);
        typeCheck.value().accept(this);
        this.out.print(", ");
        this.out.print(Settings.rtTypeForILType(typeCheck.type()));
        if (typeCheck.maske() != null) {
            this.out.print(", \"");
            this.out.print(StringHelper.getEscapedStringValue(typeCheck.maske().value()));
            this.out.print("\"");
        }
        this.out.print(", context)");
        this.out.print(")");
    }

    @Override
    public void visitSizeOfOperator(MetaSizeOfOperator anOperator) {
        this.willGetLengthOfDimension = true;
        this.out.print(SHORT_INVOKE_VALUE_FOR);
        this.setValueAccess(this.GET_ARRAY_REF_STRATEGY);
        anOperator.operand().accept(this);
        if (this.willGetLengthOfDimension) {
            this.out.print(".getLengthOfDimension(context, null)");
            this.willGetLengthOfDimension = false;
        }
        this.out.print(")");
    }

    @Override
    public void visitForEachCheck(MetaForEachCheck aCheck) {
        this.out.print(StringHelper.getEscapedName(aCheck.resultVar().value()));
    }

    @Override
    public void visitMathOperator(MetaMathOperator anOperator) {
        switch (anOperator.type()) {
            case 3: {
                this.out.print(OPERATOR_LIB_DIV);
                break;
            }
            case 2: {
                this.out.print(OPERATOR_LIB_MINUS);
                break;
            }
            case 4: {
                this.out.print(OPERATOR_LIB_MULT);
                break;
            }
            case 1: {
                this.out.print(OPERATOR_LIB_PLUS);
                break;
            }
            default: {
                this.error(anOperator, "unbekannter Operator " + anOperator.toString());
            }
        }
        this.setValueAccess(this.GET_NOVALUE_STRATEGY);
        anOperator.firstOperand().accept(this);
        this.out.print(", ");
        this.setValueAccess(this.GET_NOVALUE_STRATEGY);
        anOperator.secondOperand().accept(this);
        this.out.print(")");
    }

    @Override
    public void visitSignOperator(MetaSignOperator anOperator) {
        if (anOperator.type() == 2) {
            this.out.print(OPERATOR_LIB_MULT);
        }
        this.setValueAccess(this.GET_NOVALUE_STRATEGY);
        anOperator.operand().accept(this);
        if (anOperator.type() == 2) {
            this.out.print(", ");
            this.out.print(SHORT_INVOKE_VALUE_FOR);
            this.out.print("-1))");
        }
    }

    @Override
    public void visitIdentifier(MetaIdentifier anIdentifier) {
        this.out.print(StringHelper.getEscapedName(anIdentifier.value()));
    }

    @Override
    public Scope hvScope() {
        return this.scope;
    }

    @Override
    public String hvNamespace() {
        return this.namespace();
    }

    protected void printPrintStatementText(MetaPrintStatement aStatement) {
        Iterator it = aStatement.toPrint();
        boolean first = true;
        while (it.hasNext()) {
            if (!first) {
                this.out.print(" + ");
            } else {
                first = false;
            }
            this.setValueAccess(this.GET_NOVALUE_STRATEGY);
            ((MetaElement)it.next()).accept(this);
            this.out.print(INVOKE_AS_STRING_METHOD);
        }
    }

    protected boolean programChecksField() {
        Boolean b = (Boolean)this.context.getContextInfo(PROGRAM_CHECKS_FIELD_KEY);
        if (b == null) {
            b = Boolean.FALSE;
        }
        return b;
    }

    protected void printAccessPrefix(MetaIdentifier accessedElement) {
    }

    protected boolean withinSegment() {
        return !this.segments.empty();
    }

    protected boolean returnStatementSupported() {
        boolean returnStatementSupported;
        if (this.programReturnsValue) {
            returnStatementSupported = true;
            if (this.withinSegment()) {
                int i = this.segments.size() - 1;
                while (i >= 0) {
                    if (((SegmentInfo)this.segments.get((int)i)).outsource) {
                        returnStatementSupported = false;
                        break;
                    }
                    --i;
                }
            }
        } else {
            returnStatementSupported = false;
        }
        return returnStatementSupported;
    }

    protected String getPlausiClassName() {
        return this.context.getPlausiClassName();
    }

    protected String getTopicClassName() {
        return (String)this.context.getContextInfo(TOPIC_CLASS_NAME_KEY);
    }

    protected String getPlausiClassVarName() {
        return PLAUSI_VAR;
    }

    protected String getNextSegmentClassName() {
        return this.context.getNextPlausiSegmentClassName();
    }

    protected void printTopicAccess() {
        this.out.print(TB_VAR);
        this.out.print(".");
    }

    protected void printPlausiClassAccess() {
        this.out.print(this.context.getPlausiClassName());
        this.out.print(".");
    }

    protected void preGenerate() {
        this.indentNewLine();
        this.out.print("ValueFactory");
        this.out.print(" vf = ");
        this.out.print("ValueFactory.instance()");
        this.out.print(";");
    }

    protected boolean withinStructureAccess() {
        return this.withinStructureAccess;
    }

    protected boolean withinSetValueAccess() {
        return this.withinSetValueAccess;
    }

    protected SymbolDescriptor checkIfExistsAndArray(MetaIdentifier anId) {
        if (!this.hvScope().isDefined(anId, this.namespace())) {
            this.error(anId, String.valueOf(anId.toString()) + " ist nicht in diesem Gueltigkeitsbereich definiert " + "(Scope:" + this.namespace() + ")");
            return null;
        }
        SymbolDescriptor sd = this.hvScope().symbolDescriptor(anId, this.namespace());
        if (!sd.isArray()) {
            this.error(anId, String.valueOf(anId.toString()) + " ist keine Liste");
        }
        return sd;
    }

    private void createMethodCall(MetaCallStatement call, boolean isStandalone) {
        if (isStandalone) {
            this.indentNewLine();
        }
        if (this.withinSegment() && !(call.function().adaptedObject() instanceof MetaStructureAccess)) {
            this.printTopicAccess();
        }
        if (call.function().adaptedObject() instanceof MetaIdentifier) {
            call.function().accept(this.TRANSLATE_TO_METHOD_STRATEGY);
        } else {
            this.setValueAccess(this.TRANSLATE_TO_METHOD_STRATEGY);
            call.function().accept(this);
        }
        this.out.print("(context)");
        if (isStandalone) {
            this.out.print(";");
        }
    }

    private int toSatzFilterOperator(MetaTestingOperator op) {
        int sfOp = 0;
        switch (op.type()) {
            case 1: {
                sfOp = 1;
                break;
            }
            case 6: {
                sfOp = 6;
                break;
            }
            case 3: {
                sfOp = 3;
                break;
            }
            case 5: {
                sfOp = 5;
                break;
            }
            case 2: {
                sfOp = 2;
                break;
            }
            case 4: {
                sfOp = 4;
                break;
            }
            default: {
                this.error(op, "der Operator " + op.toString() + " ist hier nicht erlaubt");
            }
        }
        return sfOp;
    }

    protected void declareLocalVariable(MetaIdentifier id) {
        String name = StringHelper.getEscapedName(id.value());
        this.indentNewLine();
        this.out.print("Variable ");
        this.out.print(name);
        this.out.print(" = new LocalVariable()");
        this.out.print(";");
        this.indentNewLine();
        this.out.print("context.defineVariable(\"");
        this.out.print(name);
        this.out.print("\", ");
        this.out.print(name);
        this.out.print(");");
        try {
            GenericSymbolDescriptor sd = new GenericSymbolDescriptor();
            sd.setHasGenericType(true);
            sd.setIsLokaleVariable(true);
            this.scope.define(id, this.namespace(), sd);
        }
        catch (IllegalArgumentException exc) {
            this.error(id, exc.getMessage());
        }
    }

    private String declareIteratorVariable(MetaForEachStatement aStatement) {
        String iterator_var = "__loop_iterator" + Long.toString(uniqueIdCounter++);
        this.out.print("PlausiRuntimeIterator");
        this.out.print(" ");
        this.out.print(iterator_var);
        this.out.print(" = ");
        this.out.print("SupportLib.iteratorFor(");
        GetIteratorValueStrategy s = new GetIteratorValueStrategy(this);
        ((GetValueStrategy)s).setLiteralManager(this.literalManager);
        this.setValueAccess(s);
        aStatement.value().accept(this);
        this.out.print(", context);");
        if (aStatement.restrictions().size() > 0) {
            this.indentNewLine();
            this.out.print(iterator_var);
            this.out.print(".setRestrictions(");
            this.out.print("new ");
            this.out.print("PlausiRuntimeIterator");
            this.out.print("[] {");
            Iterator it = aStatement.restrictions().iterator();
            while (it.hasNext()) {
                MetaElement aRestriction = (MetaElement)it.next();
                if (aRestriction != null) {
                    this.setValueAccess(this.GET_NODEREF_STRATEGY);
                    this.out.print("SupportLib.iteratorFor(");
                    aRestriction.accept(this);
                    this.out.print(", context)");
                } else {
                    this.out.print("null");
                }
                if (!it.hasNext()) continue;
                this.out.print(", ");
            }
            this.out.print("});");
        }
        return iterator_var;
    }

    private void createPerIterationStatements(MetaForEachStatement aStatement, String iteratorVar) {
        int i = 0;
        while (i < aStatement.numberOfVariables()) {
            if (!this.scope.isDefined(aStatement.variableAt(i), this.namespace())) {
                this.declareLocalVariable(aStatement.variableAt(i));
            }
            this.indentNewLine();
            this.out.print(StringHelper.getEscapedName(aStatement.variableAt(i).value()));
            this.out.print(".set(context, (Value)");
            this.out.print(iteratorVar);
            this.out.print(".next());");
            ++i;
        }
    }

    private void generateForEachChecks(MetaElement anElement) {
        final ProgramCodeGenerator prgCodeGen = this;
        ForEachCheckIterator it = new ForEachCheckIterator(anElement);
        it.eachCheck(new ForEachCheckIterator.CodeBlock(){

            @Override
            public void doForCheck(MetaForEachCheck aCheck) {
                String resultVarName = StringHelper.getEscapedName(aCheck.resultVar().value());
                ProgramCodeGenerator.this.indentNewLine();
                ProgramCodeGenerator.this.out.print("Value " + resultVarName + " = BooleanValue.TRUE;");
                ProgramCodeGenerator.this.startBlock();
                ProgramCodeGenerator.this.indentNewLine();
                String iteratorVar = ProgramCodeGenerator.this.declareIteratorVariable(aCheck);
                ProgramCodeGenerator.this.indentNewLine();
                ProgramCodeGenerator.this.out.print("while (" + iteratorVar + ".hasNext())");
                ProgramCodeGenerator.this.startBlock();
                ProgramCodeGenerator.this.indentNewLine();
                ProgramCodeGenerator.this.createPerIterationStatements(aCheck, iteratorVar);
                ProgramCodeGenerator.this.indentNewLine();
                ProgramCodeGenerator.this.out.print(String.valueOf(resultVarName) + " = ");
                ProgramCodeGenerator.this.setValueAccess(ProgramCodeGenerator.this.GET_NOVALUE_STRATEGY);
                aCheck.condition().accept(prgCodeGen);
                ProgramCodeGenerator.this.out.print(";");
                ProgramCodeGenerator.this.indentNewLine();
                ProgramCodeGenerator.this.out.print("if (");
                ProgramCodeGenerator.this.out.print(ProgramCodeGenerator.OPERATOR_LIB_NOT);
                ProgramCodeGenerator.this.out.print(resultVarName);
                ProgramCodeGenerator.this.out.print(")");
                ProgramCodeGenerator.this.out.print(ProgramCodeGenerator.INVOKE_AS_BOOLEAN_METHOD);
                ProgramCodeGenerator.this.out.print(")");
                ProgramCodeGenerator.this.startBlock();
                ProgramCodeGenerator.this.indentNewLine();
                ProgramCodeGenerator.this.out.print("break;");
                ProgramCodeGenerator.this.endBlock();
                ProgramCodeGenerator.this.endBlock();
                ProgramCodeGenerator.this.endBlock();
                ProgramCodeGenerator.this.indentNewLine();
            }
        });
    }

    protected void startBlock() {
        ScopeImpl blockScope = new ScopeImpl(this.scope);
        this.scopeStack.push(this.scope);
        this.scope = blockScope;
        this.openBlock();
    }

    protected void endBlock() {
        this.scope = (Scope)this.scopeStack.pop();
        this.closeBlock();
    }

    private void setValueAccess(MetaElementVisitor strategy) {
        this.valueAccessStrategy = strategy;
    }

    private void enterSubNamespace(String namespace) {
        this.namespace.push(namespace);
    }

    private String leaveSubNamespace() {
        return (String)this.namespace.pop();
    }

    private void startNewNamespace() {
        this.namespaces.push(this.namespace);
        this.namespace = new Stack();
    }

    private void leaveThisNamespace() {
        this.namespace = (Stack)this.namespaces.pop();
    }

    private String namespace() {
        StringBuffer ns = new StringBuffer("Kontext");
        Iterator it = this.namespace.iterator();
        while (it.hasNext()) {
            ns.append(".");
            ns.append((String)it.next());
        }
        return ns.toString();
    }

    private boolean inLoop() {
        return this.loopCount > 0;
    }

    private void enterLoopBody() {
        ++this.loopCount;
    }

    private void leaveLoopBody() {
        --this.loopCount;
        if (this.loopCount < 0) {
            throw new CodegenException("Fataler Fehler: Inkonsitenz, Schleifen-Tiefe kleiner 0");
        }
    }

    private void visitMaterialStructureAccess(String materialAttribut, MetaElement materialField) {
        MetaStructureAccess msa = null;
        MetaFieldAccess mfa = new MetaFieldAccess(new MetaIdentifier(materialAttribut));
        if (materialField instanceof MetaFieldAccess) {
            msa = new MetaStructureAccess(mfa, (MetaFieldAccess)materialField);
        } else if (materialField instanceof MetaArrayAccess) {
            msa = new MetaStructureAccess(mfa, (MetaArrayAccess)materialField);
        } else if (materialField instanceof MetaStructureAccess) {
            MetaStructureAccess strAccess = (MetaStructureAccess)materialField;
            Stack<MetaValueAccess> structure = new Stack<MetaValueAccess>();
            structure.push(strAccess.selectedElement());
            while (strAccess.structureAccess() instanceof MetaStructureAccess) {
                strAccess = (MetaStructureAccess)strAccess.structureAccess();
                structure.push(strAccess.selectedElement());
            }
            structure.push(strAccess.structureAccess());
            msa = new MetaStructureAccess(mfa, (MetaValueAccess)structure.pop());
            while (!structure.isEmpty()) {
                msa = new MetaStructureAccess(msa, (MetaValueAccess)structure.pop());
            }
        }
        if (msa != null) {
            msa.accept(this);
        }
    }

    protected void castArrayAccess(MetaArrayAccess arrayAccess, MetaValueAccess structureAccess) {
        Stack<MetaValueAccess> structures = new Stack<MetaValueAccess>();
        if (structureAccess != null) {
            while (structureAccess instanceof MetaStructureAccess) {
                structures.push(((MetaStructureAccess)structureAccess).selectedElement());
                structureAccess = ((MetaStructureAccess)structureAccess).structureAccess();
            }
            if (!this.ignoreFirstFieldNamespace) {
                structures.push(structureAccess);
            }
        }
        int namespaceCount = 0;
        while (!structures.isEmpty()) {
            MetaValueAccess valueAccess = (MetaValueAccess)structures.pop();
            if (valueAccess instanceof MetaArrayAccess) {
                this.enterSubNamespace(((MetaArrayAccess)valueAccess).accessedArray().value());
            } else if (valueAccess instanceof MetaFieldAccess) {
                this.enterSubNamespace(((MetaFieldAccess)valueAccess).accessedField().value());
            }
            ++namespaceCount;
        }
        SymbolDescriptor symbolDescriptor = this.hvScope().symbolDescriptor(arrayAccess.accessedArray(), this.namespace());
        int i = 0;
        while (i < namespaceCount) {
            this.leaveSubNamespace();
            ++i;
        }
        this.out.print("(");
        if (arrayAccess.numberOfIndices() < symbolDescriptor.dimensions()) {
            this.out.print("Array");
        } else if (symbolDescriptor.isTbField()) {
            if (symbolDescriptor.fieldReferencesTb()) {
                if (this.withinSegment()) {
                    this.printPlausiClassAccess();
                }
                if (this.ignoreFirstFieldNamespace) {
                    this.out.print("Material");
                }
                this.out.print(StringHelper.getEscapedName(String.valueOf(this.getTopicClassPrefix()) + symbolDescriptor.getMerkmal()));
            } else if (this.ignoreFirstFieldNamespace) {
                this.out.print("MaterialVariable");
            } else {
                this.out.print("FeatureVariable");
            }
        } else {
            this.out.print("Variable");
        }
        this.out.print(")");
    }

    protected String getTopicClassPrefix() {
        return "TB_";
    }

    private void openTryBlockForLoop() {
        this.indentNewLine();
        this.out.print("try");
        this.openBlock();
    }

    private void closeTryBlockForLoop() {
        this.closeBlock();
        this.indentNewLine();
        this.out.print("catch (BreakStatementException e)");
        this.openBlock();
        this.closeBlock();
    }

    private void startNewSegmentIfNecessary(boolean outsource) {
        int currentNumOfStatements = this.segments.isEmpty() ? this.numOfStatements : ((SegmentInfo)this.segments.peek()).numOfStatements;
        if (currentNumOfStatements >= this.context.getMaxElementsInSegment(6)) {
            String className = this.getNextSegmentClassName();
            String topicClassName = this.getTopicClassName();
            this.indentNewLine();
            if (this.returnStatementSupported() && !outsource) {
                this.out.print("return ");
            }
            this.out.print(className);
            this.out.print(".");
            this.out.print(PRG_SEG_METHOD);
            this.out.print("(context, ");
            if (this.withinSegment()) {
                this.out.print(this.getPlausiClassVarName());
            } else {
                this.out.print(this.getPlausiClassName());
                this.out.print(".this");
            }
            if (topicClassName != null && topicClassName.length() > 0) {
                this.out.print(", ");
                if (this.withinSegment()) {
                    this.out.print(TB_VAR);
                } else {
                    this.out.print("this");
                }
            }
            this.out.print(");");
            String filename = String.valueOf(className) + ".java";
            Writer writer = this.context.createWriter(filename);
            this.segments.push(new SegmentInfo(filename, writer, outsource, this.out, this.indentLevel()));
            this.setOutput(writer);
            this.setIndentLevel(0);
            this.out.print("package ");
            this.out.print(this.context.getPlausiPackage());
            this.out.print(";");
            this.indentNewLine();
            this.indentNewLine();
            this.out.print("import ");
            this.out.print("de.statspez.pleditor.generator.runtime.");
            this.out.print("*;");
            this.indentNewLine();
            this.indentNewLine();
            this.out.print("public class ");
            this.out.print(className);
            this.openBlock();
            this.indentNewLine();
            this.out.print("public static ");
            if (this.returnStatementSupported() && !outsource) {
                this.out.print("Value ");
            } else {
                this.out.print("void ");
            }
            this.out.print(PRG_SEG_METHOD);
            this.out.print("(");
            this.out.print("PlausiRuntimeContext");
            this.out.print(" context, ");
            this.out.print(this.getPlausiClassName());
            this.out.print(" ");
            this.out.print(this.getPlausiClassVarName());
            if (topicClassName != null && topicClassName.length() > 0) {
                this.out.print(", ");
                this.out.print(this.getPlausiClassName());
                this.out.print(".");
                this.out.print(topicClassName);
                this.out.print(" ");
                this.out.print(TB_VAR);
            }
            this.out.print(")");
            this.openBlock();
            this.preGenerate();
        }
        if (this.segments.isEmpty()) {
            ++this.numOfStatements;
        } else {
            ++((SegmentInfo)this.segments.peek()).numOfStatements;
        }
    }

    private void startNewRangeSegmentIfNecessary() {
        int currentNumOfRanges = this.segments.isEmpty() ? this.numOfRanges : ((SegmentInfo)this.segments.peek()).numOfRanges;
        if (currentNumOfRanges >= this.context.getMaxElementsInSegment(7)) {
            String className = this.getNextSegmentClassName();
            String topicClassName = this.getTopicClassName();
            this.out.print(className);
            this.out.print(".");
            this.out.print(RANGE_SEG_METHOD);
            this.out.print("(context, ");
            if (this.withinSegment()) {
                this.out.print(this.getPlausiClassVarName());
            } else {
                this.out.print(this.getPlausiClassName());
                this.out.print(".this");
            }
            if (topicClassName != null && topicClassName.length() > 0) {
                this.out.print(", ");
                if (this.withinSegment()) {
                    this.out.print(TB_VAR);
                } else {
                    this.out.print("this");
                }
            }
            this.out.print(")");
            String filename = String.valueOf(className) + ".java";
            Writer writer = this.context.createWriter(filename);
            this.segments.push(new SegmentInfo(filename, writer, false, this.out, this.indentLevel()));
            this.setOutput(writer);
            this.setIndentLevel(0);
            this.out.print("package ");
            this.out.print(this.context.getPlausiPackage());
            this.out.print(";");
            this.indentNewLine();
            this.indentNewLine();
            this.out.print("import ");
            this.out.print("de.statspez.pleditor.generator.runtime.");
            this.out.print("*;");
            this.indentNewLine();
            this.indentNewLine();
            this.out.print("public class ");
            this.out.print(className);
            this.openBlock();
            this.indentNewLine();
            this.out.print("public static Range ");
            this.out.print(RANGE_SEG_METHOD);
            this.out.print("(");
            this.out.print("PlausiRuntimeContext");
            this.out.print(" context, ");
            this.out.print(this.getPlausiClassName());
            this.out.print(" ");
            this.out.print(this.getPlausiClassVarName());
            if (topicClassName != null && topicClassName.length() > 0) {
                this.out.print(", ");
                this.out.print(this.getPlausiClassName());
                this.out.print(".");
                this.out.print(topicClassName);
                this.out.print(" ");
                this.out.print(TB_VAR);
            }
            this.out.print(")");
            this.openBlock();
            this.preGenerate();
            this.indentNewLine();
            this.out.print("return new RangeSeries(new Range[]{");
        }
        if (this.segments.isEmpty()) {
            ++this.numOfRanges;
        } else {
            ++((SegmentInfo)this.segments.peek()).numOfRanges;
        }
    }

    private void closeCurrentSegment() {
        this.closeBlock();
        this.closeBlock();
        this.out.flush();
        SegmentInfo segment = (SegmentInfo)this.segments.pop();
        this.context.destroyWriter(segment.filename, segment.writer);
        this.out = segment.previousOut;
        this.setIndentLevel(segment.previousIndentLevel);
    }

    private void closeCurrentRangeSegment() {
        this.out.print("});");
        this.closeCurrentSegment();
    }

    protected int getRuntimeIntervalType(int metaType) {
        switch (metaType) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return 4;
    }

    private class SegmentInfo {
        public String filename;
        public Writer writer;
        public boolean outsource;
        public PrintWriter previousOut;
        public int numOfStatements;
        public int numOfRanges;
        private int previousIndentLevel;

        public SegmentInfo(String filename, Writer writer, boolean outsource, PrintWriter previousOut, int previousIndentLevel) {
            this.filename = filename;
            this.writer = writer;
            this.outsource = outsource;
            this.previousOut = previousOut;
            this.previousIndentLevel = previousIndentLevel;
            this.numOfStatements = 0;
            this.numOfRanges = 0;
        }
    }

    private class StructureAccessHelper
    extends AbstractElementVisitor {
        private StructureAccessHelper() {
        }

        @Override
        public void visitFieldAccess(MetaFieldAccess anAccess) {
            ProgramCodeGenerator.this.out.print(StringHelper.getEscapedName(anAccess.accessedField().value()));
            ProgramCodeGenerator.this.out.print(".");
            if (!ProgramCodeGenerator.this.ignoreFirstFieldNamespace) {
                ProgramCodeGenerator.this.enterSubNamespace(anAccess.accessedField().value());
            } else {
                ProgramCodeGenerator.this.ignoreFirstFieldNamespace = false;
            }
        }

        @Override
        public void visitArrayAccess(MetaArrayAccess anAccess) {
            ProgramCodeGenerator.this.enterSubNamespace(anAccess.accessedArray().value());
            ProgramCodeGenerator.this.out.print(".");
        }

        @Override
        public void visitLiteralAccess(MetaLiteralAccess anAccess) {
            ProgramCodeGenerator.this.error(anAccess, "Literale koennen nicht Elemente einer Struktur sein.");
        }

        public void visitStructureAcccess(MetaStructureAccess anAccess) {
            throw new CodegenException("Fataler Fehler: Inkonsitenz, Struktur innerhalb einer Struktur?");
        }
    }
}

