/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.js;

import de.statspez.pleditor.generator.codegen.analysis.CrossReferenceBuilder;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.js.CodegenContext;
import de.statspez.pleditor.generator.codegen.js.JavaScriptCodeGenerator;
import de.statspez.pleditor.generator.codegen.js.SymbolDescriptorResolver;
import de.statspez.pleditor.generator.codegen.pl.HierarchicalCodeConverter;
import de.statspez.pleditor.generator.codegen.support.GenericSymbolDescriptor;
import de.statspez.pleditor.generator.codegen.support.NamespaceHelper;
import de.statspez.pleditor.generator.codegen.support.Scope;
import de.statspez.pleditor.generator.codegen.support.ScopeImpl;
import de.statspez.pleditor.generator.codegen.support.SymbolDescriptor;
import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.InternalFunctions;
import de.statspez.pleditor.generator.meta.MetaAblaufStatement;
import de.statspez.pleditor.generator.meta.MetaArrayAccess;
import de.statspez.pleditor.generator.meta.MetaBooleanOperator;
import de.statspez.pleditor.generator.meta.MetaBreakStatement;
import de.statspez.pleditor.generator.meta.MetaCheckFeldStatement;
import de.statspez.pleditor.generator.meta.MetaClassificationReference;
import de.statspez.pleditor.generator.meta.MetaConditionalStatement;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaErrorStatement;
import de.statspez.pleditor.generator.meta.MetaFieldAccess;
import de.statspez.pleditor.generator.meta.MetaForEachLoop;
import de.statspez.pleditor.generator.meta.MetaForNextLoop;
import de.statspez.pleditor.generator.meta.MetaFunctionCall;
import de.statspez.pleditor.generator.meta.MetaIdentifier;
import de.statspez.pleditor.generator.meta.MetaLiteralAccess;
import de.statspez.pleditor.generator.meta.MetaMaterialAccess;
import de.statspez.pleditor.generator.meta.MetaMathOperator;
import de.statspez.pleditor.generator.meta.MetaMultiAssignment;
import de.statspez.pleditor.generator.meta.MetaPrintStatement;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.MetaProgramParameter;
import de.statspez.pleditor.generator.meta.MetaPruefeStatement;
import de.statspez.pleditor.generator.meta.MetaReturnStatement;
import de.statspez.pleditor.generator.meta.MetaSignOperator;
import de.statspez.pleditor.generator.meta.MetaSingleAssignment;
import de.statspez.pleditor.generator.meta.MetaSizeOfOperator;
import de.statspez.pleditor.generator.meta.MetaStatementSequence;
import de.statspez.pleditor.generator.meta.MetaStructureAccess;
import de.statspez.pleditor.generator.meta.MetaTestingOperator;
import de.statspez.pleditor.generator.meta.MetaTypeCheck;
import de.statspez.pleditor.generator.meta.MetaUnaryBoolOperator;
import de.statspez.pleditor.generator.meta.MetaValueAccess;
import de.statspez.pleditor.generator.meta.MetaVarDeclaration;
import de.statspez.pleditor.generator.meta.MetaWhileLoop;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.parser.Helper;
import java.util.Iterator;

public class ProgramCodeGenerator
extends JavaScriptCodeGenerator {
    public static final String PROGRAM_NAMESPACE_KEY = "programNamespaceKey";
    public static final String PROGRAM_PERFORMS_PLAUSI_KEY = "programPerformsPlausiKey";
    public static final String PROGRAM_CHECKS_FIELD_KEY = "programChecksFieldKey";
    private Scope scope;
    private NamespaceHelper namespaceHelper;
    private boolean getValueAccess;
    private boolean withinStructureAccess;
    private String programName;

    public synchronized void generate(CodegenContext context, MetaProgram program, Scope scope) {
        this.setCodegenContext(context);
        this.scope = new ScopeImpl(scope);
        this.namespaceHelper = new NamespaceHelper();
        this.getValueAccess = true;
        this.withinStructureAccess = false;
        if (program.containsHierarchicalFunction()) {
            HierarchicalCodeConverter converter = new HierarchicalCodeConverter();
            MetaProgram programConverted = Helper.metaStructureFor(converter.generate(program));
            programConverted.setName(program.name());
            programConverted.setContextInfos(program.contextInfos());
            new CrossReferenceBuilder().buildCrossReference(programConverted, scope, context.getTopicScopes());
            program = programConverted;
        }
        program.accept(this);
        this.out.flush();
        this.checkForErrors();
    }

    @Override
    public Scope hvScope() {
        return this.scope;
    }

    @Override
    public String hvNamespace() {
        return this.namespaceHelper.namespace();
    }

    @Override
    public void visitProgram(MetaProgram aProgram) {
        this.programName = StringHelper.getEscapedName(aProgram.name());
        this.indentNewLine();
        this.print("function ");
        this.print("prg_");
        if (!this.hasProgramNamespace()) {
            this.printContextAsPrefix();
        }
        this.print(this.programName);
        this.print("(");
        if (this.isProgramChecksField()) {
            this.print("field");
        } else {
            if (this.hasContext() && !this.hasProgramNamespace()) {
                this.print("ns");
                if (aProgram.numberOfParameters() > 0) {
                    this.print(", ");
                }
            }
            Iterator it = aProgram.parameters();
            while (it.hasNext()) {
                ((MetaElement)it.next()).accept(this);
                if (!it.hasNext()) continue;
                this.print(", ");
            }
        }
        this.print(")");
        this.openBlock();
        if (this.hasProgramNamespace()) {
            this.indentNewLine();
            this.print("var ns = \"");
            this.print(this.getProgramNamespace());
            this.print("\";");
        }
        if (this.isProgramPerformsPlausi()) {
            this.indentNewLine();
            this.print("var ");
            this.print("errmsg");
            this.print(" = new Array();");
            this.indentNewLine();
            this.print("referencedFields = new Array();");
        }
        aProgram.statements().accept(this);
        if (this.isProgramPerformsPlausi()) {
            this.indentNewLine();
            this.print("referencedFields = null;");
            this.indentNewLine();
            this.print("return ");
            this.print("errmsg");
            this.print(";");
        }
        this.closeBlock();
    }

    @Override
    public void visitProgramParameter(MetaProgramParameter aParameter) {
        this.defineLocalVariable(aParameter.name());
        aParameter.name().accept(this);
    }

    @Override
    public void visitStatementSequence(MetaStatementSequence aSequence) {
        this.visitElements(aSequence.statements());
    }

    @Override
    public void visitReturnStatement(MetaReturnStatement aStatement) {
        this.indentNewLine();
        this.print("return ");
        aStatement.returnValue().accept(this);
        this.print(";");
    }

    @Override
    public void visitVarDeclaration(MetaVarDeclaration aDeclaration) {
        Iterator it = aDeclaration.identifiers();
        while (it.hasNext()) {
            this.declareLocalVariable((MetaIdentifier)it.next());
        }
    }

    @Override
    public void visitSingleAssignment(MetaSingleAssignment anAssignment) {
        boolean localVariable = this.isLocalVariable(anAssignment.leftValue());
        this.indentNewLine();
        this.getValueAccess = false;
        if (!localVariable) {
            this.printValueAccessFunctionName(anAssignment.leftValue());
            this.print("(");
        }
        anAssignment.leftValue().accept(this);
        this.getValueAccess = true;
        if (localVariable) {
            this.print(" = ");
        } else {
            this.print(", ");
        }
        anAssignment.rightValue().accept(this);
        if (!localVariable) {
            this.printValueAccessFunctionAdditionalParameter(anAssignment.leftValue());
            this.print(")");
        }
        this.print(";");
    }

    @Override
    public void visitMultiAssignment(MetaMultiAssignment anAssignment) {
    }

    @Override
    public void visitWhileLoop(MetaWhileLoop aStatement) {
        this.indentNewLine();
        this.print("while (");
        aStatement.condition().accept(this);
        this.print(")");
        this.openBlock();
        aStatement.loopBody().accept(this);
        this.closeBlock();
    }

    @Override
    public void visitForNextLoop(MetaForNextLoop aStatement) {
        aStatement.startAssignment().accept(this);
        this.indentNewLine();
        this.print("while (true)");
        this.openBlock();
        this.indentNewLine();
        this.print("if (");
        aStatement.endCondition().accept(this);
        this.print(")");
        this.openBlock();
        this.indentNewLine();
        this.print("break;");
        this.closeBlock();
        aStatement.loopBody().accept(this);
        boolean localVariable = this.isLocalVariable(aStatement.startAssignment().leftValue());
        this.indentNewLine();
        if (!localVariable) {
            this.printValueAccessFunctionName(aStatement.startAssignment().leftValue());
            this.print("(");
        }
        this.getValueAccess = false;
        aStatement.startAssignment().leftValue().accept(this);
        if (localVariable) {
            this.print(" = ");
        } else {
            this.print(", ");
        }
        this.getValueAccess = true;
        aStatement.startAssignment().leftValue().accept(this);
        this.print(" + 1");
        if (!localVariable) {
            this.print(")");
        }
        this.print(";");
        this.closeBlock();
    }

    @Override
    public void visitForEachLoop(MetaForEachLoop aStatement) {
    }

    @Override
    public void visitConditionalStatement(MetaConditionalStatement aStatement) {
        this.indentNewLine();
        this.print("if (");
        aStatement.condition().accept(this);
        this.print(")");
        this.openBlock();
        aStatement.ifTrue().accept(this);
        this.closeBlock();
        if (aStatement.ifFalse().numberOfStatements() > 0) {
            this.indentNewLine();
            this.print("else");
            this.openBlock();
            aStatement.ifFalse().accept(this);
            this.closeBlock();
        }
    }

    @Override
    public void visitBreakStatement(MetaBreakStatement aStatement) {
        this.indentNewLine();
        this.print("break;");
    }

    @Override
    public void visitFunctionCall(MetaFunctionCall aStatement) {
        SymbolDescriptorResolver symbolDescriptorResolver = new SymbolDescriptorResolver(this);
        aStatement.function().accept(symbolDescriptorResolver);
        SymbolDescriptor function = symbolDescriptorResolver.getSymbolDescriptor();
        if (function != null) {
            if (function.isFunction()) {
                boolean internal;
                if (aStatement.isStandalone()) {
                    this.indentNewLine();
                }
                if (!(internal = InternalFunctions.instance().identifiesInternalFunction(aStatement.function()))) {
                    this.print("prg_");
                    if (symbolDescriptorResolver.getParentTopic() != null) {
                        this.print(StringHelper.getEscapedName(this.context.getContextNameFor(symbolDescriptorResolver.getParentTopic())));
                        this.print("_");
                    } else {
                        this.printContextAsPrefix();
                    }
                }
                symbolDescriptorResolver.getIdentifier().accept(this);
                if (function.numberOfFunctionParameters() != aStatement.numberOfParameters()) {
                    this.error(aStatement, "Falsche Anzahl von Parametern (" + function.numberOfFunctionParameters() + " erwartet, " + aStatement.numberOfParameters() + " bekommen)");
                }
                this.print("(");
                boolean hasParameter = false;
                if (!internal) {
                    if (symbolDescriptorResolver.getStructuredAccess() != null) {
                        this.getValueAccess = false;
                        symbolDescriptorResolver.getStructuredAccess().accept(this);
                        this.getValueAccess = true;
                        hasParameter = true;
                    } else if (this.hasContext()) {
                        this.print("ns");
                        hasParameter = true;
                    }
                }
                Iterator iter = aStatement.parameters();
                while (iter.hasNext()) {
                    if (hasParameter) {
                        this.print(", ");
                    }
                    ((MetaElement)iter.next()).accept(this);
                    hasParameter = true;
                }
                this.print(")");
                if (aStatement.isStandalone()) {
                    this.print(";");
                }
            } else {
                this.error(aStatement, "Das verwendete Element (" + aStatement.function() + ") ist keine Funktion.");
            }
        } else {
            this.error(aStatement, "Das verwendete Element (" + aStatement.function() + ") ist nicht definiert.");
        }
    }

    @Override
    public void visitAblaufStatement(MetaAblaufStatement aStatement) {
        SymbolDescriptorResolver symbolDescriptorResolver = new SymbolDescriptorResolver(this);
        aStatement.function().accept(symbolDescriptorResolver);
        SymbolDescriptor flow = symbolDescriptorResolver.getSymbolDescriptor();
        if (flow != null) {
            if (flow.isAblauf()) {
                this.indentNewLine();
                this.print("errmsg");
                this.print(" = ");
                this.print("errmsg");
                this.print(".concat(");
                this.print("prg_");
                if (symbolDescriptorResolver.getParentTopic() != null) {
                    this.print(StringHelper.getEscapedName(this.context.getContextNameFor(symbolDescriptorResolver.getParentTopic())));
                    this.print("_");
                } else {
                    this.printContextAsPrefix();
                }
                symbolDescriptorResolver.getIdentifier().accept(this);
                if (flow.numberOfFunctionParameters() != aStatement.numberOfParameters()) {
                    this.error(aStatement, "Falsche Anzahl von Parametern (" + flow.numberOfFunctionParameters() + " erwartet, " + aStatement.numberOfParameters() + " bekommen)");
                }
                this.print("(");
                boolean hasParameter = false;
                if (symbolDescriptorResolver.getStructuredAccess() != null) {
                    this.getValueAccess = false;
                    symbolDescriptorResolver.getStructuredAccess().accept(this);
                    this.getValueAccess = true;
                    hasParameter = true;
                } else if (this.hasContext()) {
                    this.print("ns");
                    hasParameter = true;
                }
                Iterator iter = aStatement.parameters();
                while (iter.hasNext()) {
                    if (hasParameter) {
                        this.print(", ");
                    }
                    ((MetaElement)iter.next()).accept(this);
                    hasParameter = true;
                }
                this.print("));");
            } else {
                this.error(aStatement, "Das verwendete Element (" + aStatement.function() + ") ist kein Ablauf.");
            }
        } else {
            this.error(aStatement, "Das verwendete Element (" + aStatement.function() + ") ist nicht definiert.");
        }
    }

    @Override
    public void visitPruefeStatement(MetaPruefeStatement aStatement) {
        SymbolDescriptorResolver symbolDescriptorResolver = new SymbolDescriptorResolver(this);
        aStatement.function().accept(symbolDescriptorResolver);
        SymbolDescriptor check = symbolDescriptorResolver.getSymbolDescriptor();
        if (check != null) {
            if (check.isPruefung()) {
                if (aStatement.isStandalone()) {
                    this.indentNewLine();
                } else {
                    this.print("errmsg");
                    this.print(".length < (");
                }
                this.print("errmsg");
                this.print(" = ");
                this.print("errmsg");
                this.print(".concat(");
                this.print("prg_");
                if (symbolDescriptorResolver.getParentTopic() != null) {
                    this.print(StringHelper.getEscapedName(this.context.getContextNameFor(symbolDescriptorResolver.getParentTopic())));
                    this.print("_");
                } else {
                    this.printContextAsPrefix();
                }
                symbolDescriptorResolver.getIdentifier().accept(this);
                this.print("(");
                if (this.hasContext()) {
                    this.print("ns");
                }
                if (symbolDescriptorResolver.getStructuredAccess() != null) {
                    if (this.hasContext()) {
                        this.print(" + ");
                    }
                    this.getValueAccess = false;
                    symbolDescriptorResolver.getStructuredAccess().accept(this);
                    this.getValueAccess = true;
                }
                this.print("))");
                if (aStatement.isStandalone()) {
                    this.print(";");
                } else {
                    this.print(").length");
                }
            } else {
                this.error(aStatement, "Das verwendete Element (" + aStatement.function() + ") ist keine Pruefung.");
            }
        } else {
            this.error(aStatement, "Das verwendete Element (" + aStatement.function() + ") ist nicht definiert.");
        }
    }

    @Override
    public void visitCheckFeldStatement(MetaCheckFeldStatement aStatement) {
        SymbolDescriptorResolver symbolDescriptorResolver = new SymbolDescriptorResolver(this);
        aStatement.field().accept(symbolDescriptorResolver);
        SymbolDescriptor merkmalDesc = symbolDescriptorResolver.getSymbolDescriptor();
        if (merkmalDesc != null) {
            if (merkmalDesc.isArray()) {
                if (!aStatement.isStandalone()) {
                    this.error(aStatement, "Merkmalspr\u00fcfung der Listenfelder darf nur im Standalone-Modus aufgerufen werden.");
                }
            } else {
                if (aStatement.isStandalone()) {
                    this.indentNewLine();
                } else {
                    this.print("errmsg");
                    this.print(".length < (");
                }
                this.print("errmsg");
                this.print(" = ");
                this.print("errmsg");
                this.print(".concat(");
                this.print("prg_");
                this.print("Merkmal_");
                this.print(StringHelper.getEscapedName(merkmalDesc.getMerkmal()));
                this.print("(");
                this.getValueAccess = false;
                aStatement.field().accept(this);
                this.getValueAccess = true;
                this.print("))");
                if (aStatement.isStandalone()) {
                    this.print(";");
                } else {
                    this.print(").length");
                }
            }
        }
    }

    @Override
    public void visitErrorStatement(MetaErrorStatement aStatement) {
        this.indentNewLine();
        this.print("errmsg");
        this.print("[0] = ");
        this.print("err_");
        this.printContextAsPrefix();
        this.print(this.programName);
        this.print("(");
        if (this.isProgramChecksField()) {
            this.print("field, ");
            this.print(aStatement.errorNumber());
        } else if (this.hasContext()) {
            this.print("ns");
        }
        this.print(");");
        this.indentNewLine();
        this.print("return ");
        this.print("errmsg");
        this.print(";");
    }

    @Override
    public void visitPrintStatement(MetaPrintStatement aStatement) {
        boolean localVariable = false;
        this.indentNewLine();
        if (aStatement.leftValue() != null) {
            localVariable = this.isLocalVariable(aStatement.leftValue());
            this.getValueAccess = false;
            if (!localVariable) {
                this.printValueAccessFunctionName(aStatement.leftValue());
                this.print("(");
            }
            aStatement.leftValue().accept(this);
            this.getValueAccess = true;
            if (localVariable) {
                this.print(" = ");
            } else {
                this.print(", ");
            }
        } else {
            this.print("trace(");
        }
        Iterator iter = aStatement.toPrint();
        while (iter.hasNext()) {
            ((MetaElement)iter.next()).accept(this);
            if (!iter.hasNext()) continue;
            this.print(" + ");
        }
        if (aStatement.leftValue() != null) {
            if (!localVariable) {
                this.printValueAccessFunctionAdditionalParameter(aStatement.leftValue());
                this.print(")");
            }
        } else {
            this.print(")");
        }
        this.print(";");
    }

    @Override
    public void visitTestingOperator(MetaTestingOperator anOperator) {
        switch (anOperator.type()) {
            case 1: {
                this.print("eq");
                break;
            }
            case 4: {
                this.print("ne");
                break;
            }
            case 7: {
                this.print("contains");
                if (!(anOperator.secondOperand().adaptedObject() instanceof MetaClassificationReference)) break;
                this.print("Classification");
                break;
            }
            case 3: {
                this.print("gt");
                break;
            }
            case 6: {
                this.print("ge");
                break;
            }
            case 2: {
                this.print("lt");
                break;
            }
            case 5: {
                this.print("le");
            }
        }
        this.print("(");
        anOperator.firstOperand().accept(this);
        this.print(", ");
        anOperator.secondOperand().accept(this);
        this.print(")");
    }

    @Override
    public void visitUnaryBoolOperator(MetaUnaryBoolOperator anOperator) {
        this.print("not(");
        anOperator.operand().accept(this);
        this.print(")");
    }

    @Override
    public void visitBooleanOperator(MetaBooleanOperator anOperator) {
        this.print("(");
        anOperator.firstOperand().accept(this);
        switch (anOperator.type()) {
            case 1: {
                this.print(" && ");
                break;
            }
            case 2: {
                this.print(" || ");
            }
        }
        anOperator.secondOperand().accept(this);
        this.print(")");
    }

    @Override
    public void visitMathOperator(MetaMathOperator anOperator) {
        switch (anOperator.type()) {
            case 3: {
                this.print("div");
                break;
            }
            case 2: {
                this.print("minus");
                break;
            }
            case 4: {
                this.print("mult");
                break;
            }
            case 1: {
                this.print("plus");
            }
        }
        this.print("(");
        anOperator.firstOperand().accept(this);
        this.print(", ");
        anOperator.secondOperand().accept(this);
        this.print(")");
    }

    @Override
    public void visitSignOperator(MetaSignOperator anOperator) {
        if (anOperator.operand().adaptedObject() instanceof MetaLiteralAccess) {
            this.print("-");
            anOperator.operand().accept(this);
        } else {
            if (anOperator.type() == 2) {
                this.print("mult(");
            }
            anOperator.operand().accept(this);
            if (anOperator.type() == 2) {
                this.print(", -1)");
            }
        }
    }

    @Override
    public void visitSizeOfOperator(MetaSizeOfOperator anOperator) {
        this.print("getSizeOf(");
        this.getValueAccess = false;
        anOperator.operand().accept(this);
        this.getValueAccess = true;
        this.print(")");
    }

    @Override
    public void visitTypeCheck(MetaTypeCheck anOperator) {
        boolean hasMask = anOperator.maske() != null;
        switch (anOperator.type()) {
            case 5: {
                this.print("isValueInteger");
                break;
            }
            case 1: {
                this.print("isValueReal");
                break;
            }
            case 3: 
            case 4: {
                this.print("isValueDate");
                break;
            }
            case 2: {
                this.print("isValueString");
                hasMask = false;
                break;
            }
            case 6: {
                this.print("isValueString");
                hasMask = false;
                break;
            }
            case 7: {
                this.print("isValueString");
                hasMask = false;
            }
        }
        if (hasMask) {
            this.print("Mask");
        }
        this.print("(");
        anOperator.value().accept(this);
        if (hasMask) {
            this.print(", ");
            anOperator.maske().accept(this);
        }
        this.print(")");
    }

    @Override
    public void visitMaterialAccess(MetaMaterialAccess anAccess) {
        this.print("null");
    }

    @Override
    public void visitFieldAccess(MetaFieldAccess aFieldAccess) {
        if (this.isProgramChecksField()) {
            this.printValueAccessFunctionName(aFieldAccess);
            this.print("(field)");
        } else {
            boolean localVariable = this.isLocalVariable(aFieldAccess);
            if (!localVariable && !this.withinStructureAccess) {
                if (this.getValueAccess) {
                    this.printValueAccessFunctionName(aFieldAccess);
                    this.print("(");
                }
                if (this.hasContext()) {
                    this.print("ns");
                    this.print(" + ");
                }
                this.print("\"");
                if (this.hasContext()) {
                    this.print(".");
                }
            }
            aFieldAccess.accessedField().accept(this);
            if (!localVariable && !this.withinStructureAccess) {
                this.print("\"");
                if (this.getValueAccess) {
                    this.printValueAccessFunctionAdditionalParameter(aFieldAccess);
                    this.print(")");
                }
            }
        }
    }

    @Override
    public void visitArrayAccess(MetaArrayAccess anArrayAccess) {
        boolean localVariable = this.isLocalVariable(anArrayAccess);
        if (!localVariable && !this.withinStructureAccess) {
            if (this.getValueAccess) {
                this.printValueAccessFunctionName(anArrayAccess);
                this.print("(");
            }
            if (this.hasContext()) {
                this.print("ns");
                this.print(" + ");
            }
            this.print("\"");
            if (this.hasContext()) {
                this.print(".");
            }
        }
        anArrayAccess.accessedArray().accept(this);
        this.namespaceHelper.startNewNamespace();
        this.print("\" + getIndicesAsString(");
        if (anArrayAccess.numberOfIndices() > 1) {
            this.print("new Array(");
        }
        Iterator it = anArrayAccess.indices();
        while (it.hasNext()) {
            ((MetaElement)it.next()).accept(this);
            this.print(" - 1");
            if (!it.hasNext()) continue;
            this.print(", ");
        }
        if (anArrayAccess.numberOfIndices() > 1) {
            this.print(")");
        }
        this.print(") + \"");
        this.namespaceHelper.leaveThisNamespace();
        if (!localVariable && !this.withinStructureAccess) {
            this.print("\"");
            if (this.getValueAccess) {
                this.printValueAccessFunctionAdditionalParameter(anArrayAccess);
                this.print(")");
            }
        }
    }

    @Override
    public void visitStructureAccess(MetaStructureAccess aStructureAccess) {
        boolean wasWithinStructureAccess = this.withinStructureAccess;
        if (!wasWithinStructureAccess) {
            if (this.getValueAccess) {
                this.printValueAccessFunctionName(aStructureAccess);
                this.print("(");
            }
            if (this.hasContext()) {
                this.print("ns");
                this.print(" + ");
            }
            this.print("\"");
            if (this.hasContext()) {
                this.print(".");
            }
        }
        this.withinStructureAccess = true;
        aStructureAccess.structureAccess().accept(new AbstractElementVisitor(){

            @Override
            public void visitFieldAccess(MetaFieldAccess aFieldAccess) {
                aFieldAccess.accept(ProgramCodeGenerator.this);
                ProgramCodeGenerator.this.namespaceHelper.enterSubNamespace(aFieldAccess.accessedField().value());
                ProgramCodeGenerator.this.print(".");
            }

            @Override
            public void visitArrayAccess(MetaArrayAccess anArrayAccess) {
                anArrayAccess.accept(ProgramCodeGenerator.this);
                ProgramCodeGenerator.this.namespaceHelper.enterSubNamespace(anArrayAccess.accessedArray().value());
                ProgramCodeGenerator.this.print(".");
            }

            @Override
            public void visitStructureAccess(MetaStructureAccess aStructureAccess) {
                aStructureAccess.structureAccess().accept(this);
                aStructureAccess.selectedElement().accept(this);
            }
        });
        aStructureAccess.selectedElement().accept(this);
        aStructureAccess.structureAccess().accept(new AbstractElementVisitor(){

            @Override
            public void visitFieldAccess(MetaFieldAccess aFieldAccess) {
                ProgramCodeGenerator.this.namespaceHelper.leaveSubNamespace();
            }

            @Override
            public void visitArrayAccess(MetaArrayAccess anArrayAccess) {
                ProgramCodeGenerator.this.namespaceHelper.leaveSubNamespace();
            }

            @Override
            public void visitStructureAccess(MetaStructureAccess aStructureAccess) {
                aStructureAccess.structureAccess().accept(this);
                aStructureAccess.selectedElement().accept(this);
            }
        });
        this.withinStructureAccess = wasWithinStructureAccess;
        if (!wasWithinStructureAccess) {
            this.print("\"");
            if (this.getValueAccess) {
                this.printValueAccessFunctionAdditionalParameter(aStructureAccess);
                this.print(")");
            }
        }
    }

    @Override
    public void visitIdentifier(MetaIdentifier anIdentifier) {
        this.print(StringHelper.getEscapedName(anIdentifier.value()));
    }

    @Override
    public void visitClassificationReference(MetaClassificationReference aReference) {
        this.print("cls_");
        Iterator iter = aReference.levels();
        while (iter.hasNext()) {
            ((MetaElement)iter.next()).accept(this);
            if (!iter.hasNext()) continue;
            this.print("_");
        }
    }

    protected boolean isProgramPerformsPlausi() {
        Boolean programPerformsPlausi = (Boolean)this.context.getContextInfo(PROGRAM_PERFORMS_PLAUSI_KEY);
        boolean result = programPerformsPlausi != null ? programPerformsPlausi : false;
        return result;
    }

    protected boolean isProgramChecksField() {
        Boolean programChecksField = (Boolean)this.context.getContextInfo(PROGRAM_CHECKS_FIELD_KEY);
        boolean result = programChecksField != null ? programChecksField : false;
        return result;
    }

    protected boolean hasProgramNamespace() {
        String programNamespace = (String)this.context.getContextInfo(PROGRAM_NAMESPACE_KEY);
        return programNamespace != null && programNamespace.length() > 0;
    }

    protected String getProgramNamespace() {
        return (String)this.context.getContextInfo(PROGRAM_NAMESPACE_KEY);
    }

    protected void declareLocalVariable(MetaIdentifier identifier) {
        String name = StringHelper.getEscapedName(identifier.value());
        this.indentNewLine();
        this.print("var ");
        this.print(name);
        this.print(";");
        this.defineLocalVariable(identifier);
    }

    protected void defineLocalVariable(MetaIdentifier identifier) {
        try {
            GenericSymbolDescriptor sd = new GenericSymbolDescriptor();
            sd.setHasGenericType(true);
            sd.setIsLokaleVariable(true);
            this.hvScope().define(identifier, this.hvNamespace(), sd);
        }
        catch (IllegalArgumentException exc) {
            this.error(identifier, exc.getMessage());
        }
    }

    protected boolean isLocalVariable(MetaValueAccess access) {
        SymbolDescriptor sd;
        boolean localVariable = false;
        MetaIdentifier identifier = access instanceof MetaFieldAccess ? ((MetaFieldAccess)access).accessedField() : (access instanceof MetaArrayAccess ? ((MetaArrayAccess)access).accessedArray() : null);
        if (identifier != null && (sd = this.hvScope().symbolDescriptor(identifier, this.hvNamespace())) != null) {
            localVariable = sd.isLokaleVariable();
        }
        return localVariable;
    }

    protected void printValueAccessFunctionName(MetaValueAccess access) {
        block11: {
            block13: {
                SymbolDescriptorResolver resolver;
                block12: {
                    block10: {
                        if (!this.isProgramChecksField()) break block10;
                        this.print("getValueString");
                        break block11;
                    }
                    resolver = new SymbolDescriptorResolver(this);
                    access.accept(resolver);
                    SymbolDescriptor symbolDescriptor = resolver.getSymbolDescriptor();
                    if (!symbolDescriptor.isHilfsvariable() && !symbolDescriptor.isInitwert()) break block12;
                    if (this.getValueAccess) {
                        this.print("getVarValue");
                    } else {
                        this.print("setVarValue");
                    }
                    break block11;
                }
                if (this.getValueAccess) {
                    this.print("getValue");
                } else {
                    this.print("setValue");
                }
                MetaTBFeld referencedField = (MetaTBFeld)resolver.getReferredElement();
                if (referencedField == null) break block13;
                MetaMerkmal merkmal = (MetaMerkmal)referencedField.getKlasse();
                switch (merkmal.getTyp()) {
                    case 5: {
                        this.print("Integer");
                        break;
                    }
                    case 1: {
                        this.print("Real");
                        break;
                    }
                    case 3: {
                        this.print("Date");
                        if (merkmal.getMaske() != null && merkmal.getMaske().length() > 0) {
                            this.print("Mask");
                            break;
                        }
                        break block11;
                    }
                    default: {
                        this.print("String");
                        break;
                    }
                }
                break block11;
            }
            this.error(access, "Referenziertes Element konnte nicht ermittelt werden.");
        }
    }

    protected void printValueAccessFunctionAdditionalParameter(MetaValueAccess access) {
        if (!this.isProgramChecksField()) {
            SymbolDescriptorResolver resolver = new SymbolDescriptorResolver(this);
            access.accept(resolver);
            SymbolDescriptor symbolDescriptor = resolver.getSymbolDescriptor();
            if (!symbolDescriptor.isHilfsvariable() && !symbolDescriptor.isInitwert()) {
                MetaTBFeld referencedField = (MetaTBFeld)resolver.getReferredElement();
                if (referencedField != null) {
                    MetaMerkmal merkmal = (MetaMerkmal)referencedField.getKlasse();
                    if (merkmal.getTyp() == 3 && merkmal.getMaske() != null && merkmal.getMaske().length() > 0) {
                        this.print(", \"");
                        this.print(StringHelper.getEscapedStringValue(merkmal.getMaske()));
                        this.print("\"");
                    }
                } else {
                    this.error(access, "Referenziertes Element konnte nicht ermittelt werden.");
                }
            }
        }
    }
}

