/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.compare;

import de.statspez.pleditor.generator.codegen.support.Traverser;
import de.statspez.pleditor.generator.compare.Comparator;
import de.statspez.pleditor.generator.meta.MetaCustomMerkmal;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.pleditor.generator.meta.generated.MetaPLAuspraegung;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.generator.runtime.FeldDeskriptor;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorExt;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import de.statspez.pleditor.generator.runtime.InvalidValue;
import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.ValueFactory;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import java.util.ArrayList;
import java.util.List;

public class ComparedNode {
    private Comparator comparator;
    private SatzInterface satz1;
    private SatzInterface satz2;
    private String value1;
    private String value2;
    private String value1Display;
    private String value2Display;
    private boolean changed;
    private ComparedNode parent;
    private List children;
    private MetaElement element;
    private FeldDeskriptorImpl feldDeskriptor;
    private boolean virtual;

    public ComparedNode(ComparedNode parent, MetaElement element, FeldDeskriptorImpl feldDeskriptor, boolean virtual, SatzInterface satz1, SatzInterface satz2, Comparator comparator) {
        this.parent = parent;
        this.children = new ArrayList();
        this.element = element;
        this.feldDeskriptor = feldDeskriptor;
        this.virtual = virtual;
        this.satz1 = satz1;
        this.satz2 = satz2;
        this.comparator = comparator;
        this.value1 = null;
        this.value2 = null;
        this.value1Display = null;
        this.value2Display = null;
        this.changed = false;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
    }

    public ComparedNode getParent() {
        return this.parent;
    }

    public List getChildren() {
        return this.children;
    }

    public void setChildren(List children) {
        this.children = children;
    }

    public int getChildCount() {
        int childCount = 0;
        childCount = this.children.size();
        return childCount;
    }

    public ComparedNode getChild(int index) {
        return (ComparedNode)this.children.get(index);
    }

    public void addChild(ComparedNode child) {
        this.children.add(child);
    }

    public void removeChild(ComparedNode child) {
        this.children.remove(child);
    }

    public boolean hasChild(ComparedNode child) {
        return this.children.contains(child);
    }

    public boolean isRemoved() {
        return this.getParent() != null && !this.getParent().hasChild(this);
    }

    public MetaElement getElement() {
        return this.element;
    }

    public FeldDeskriptorImpl getFeldDeskriptor() {
        return this.feldDeskriptor;
    }

    public void setFeldDeskriptor(FeldDeskriptorImpl descriptor) {
        this.feldDeskriptor = descriptor;
    }

    public MetaCustomMerkmal getFeature() {
        MetaCustomMerkmal feature = this.element instanceof MetaTBFeld && ((MetaTBFeld)this.element).getKlasse() instanceof MetaCustomMerkmal ? (MetaCustomMerkmal)((MetaTBFeld)this.element).getKlasse() : null;
        return feature;
    }

    public MetaAuspraegungsgruppe getClassifications() {
        MetaCustomMerkmal feature = this.getFeature();
        MetaAuspraegungsgruppe classifications = feature != null ? feature.getKlasseWertebereich() : null;
        return classifications;
    }

    public void readValues() {
        this.readValue1();
        this.readValue2();
    }

    public String getValue1() {
        return this.value1Display;
    }

    public String getValue2() {
        return this.value2Display;
    }

    public boolean hasDifferentValues() {
        boolean result;
        if (this.element instanceof MetaThemenbereich) {
            result = false;
        } else if (this.getParent().hasSatz1() != this.getParent().hasSatz2()) {
            result = false;
        } else {
            boolean hasSatz1 = this.hasSatz1();
            boolean hasSatz2 = this.hasSatz2();
            MetaTBFeld field = (MetaTBFeld)this.element;
            if (field.getKlasse() instanceof MetaThemenbereich) {
                result = hasSatz1 ^ hasSatz2;
            } else if (hasSatz1 && hasSatz2) {
                boolean hasValue1 = this.hasValue1();
                boolean hasValue2 = this.hasValue2();
                result = hasValue1 && hasValue2 ? !this.value1.equals(this.value2) : hasValue1 ^ hasValue2;
            } else {
                result = false;
            }
        }
        return result;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public boolean hasSatz1() {
        boolean result;
        if (this.element instanceof MetaThemenbereich) {
            result = true;
        } else {
            MetaTBFeld field = (MetaTBFeld)this.element;
            if (field.getKlasse() instanceof MetaThemenbereich) {
                if (this.getFeldDeskriptor().getIndizes() != null) {
                    int[] basisIndizes = this.getBasisIndizes(this.getFeldDeskriptor().getIndizes());
                    result = this.getParent().hasSatz1() && this.getFeldDeskriptor().getLaenge(this.satz1, basisIndizes) > this.getFeldDeskriptor().getIndizes()[0];
                } else {
                    result = this.getParent().hasSatz1();
                }
            } else {
                result = this.getParent().hasSatz1();
            }
        }
        return result;
    }

    public boolean hasSatz2() {
        boolean result;
        if (this.element instanceof MetaThemenbereich) {
            result = true;
        } else {
            MetaTBFeld field = (MetaTBFeld)this.element;
            if (field.getKlasse() instanceof MetaThemenbereich) {
                if (this.getFeldDeskriptor().getIndizes() != null) {
                    int[] basisIndizes = this.getBasisIndizes(this.getFeldDeskriptor().getIndizes());
                    result = this.getParent().hasSatz2() && this.getFeldDeskriptor().getLaenge(this.satz2, basisIndizes) > this.getFeldDeskriptor().getIndizes()[0];
                } else {
                    result = this.getParent().hasSatz2();
                }
            } else {
                result = this.getParent().hasSatz2();
            }
        }
        return result;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public boolean hasValue1() {
        return this.value1 != null && this.value1.length() > 0;
    }

    public boolean hasValue2() {
        return this.value2 != null && this.value2.length() > 0;
    }

    public String toString() {
        String text;
        if (this.element instanceof MetaThemenbereich) {
            text = ((MetaThemenbereich)this.element).getName();
        } else {
            StringBuffer buffer = new StringBuffer();
            MetaTBFeld field = (MetaTBFeld)this.element;
            if (field.getBezeichnung() != null && field.getBezeichnung().length() > 0) {
                buffer.append(field.getBezeichnung());
            } else {
                buffer.append(field.getName());
            }
            if (this.feldDeskriptor.getIndizes() != null && this.feldDeskriptor.getIndizes().length > 0) {
                buffer.append(' ');
                int i = 0;
                while (i < this.feldDeskriptor.getIndizes().length) {
                    buffer.append('[');
                    buffer.append(this.feldDeskriptor.getIndizes()[i] + 1);
                    buffer.append(']');
                    ++i;
                }
            }
            text = buffer.toString();
        }
        return text;
    }

    public ComparedNode[] getPath() {
        return this.getPathToRoot(this, 0);
    }

    protected ComparedNode[] getPathToRoot(ComparedNode aNode, int depth) {
        ComparedNode[] retNodes;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new ComparedNode[depth];
        } else {
            retNodes = this.getPathToRoot(aNode.getParent(), ++depth);
            retNodes[retNodes.length - depth] = aNode;
        }
        return retNodes;
    }

    public String getClassificationText(MetaAuspraegungsgruppe classifications, final String code) {
        final StringBuffer result = new StringBuffer();
        Traverser traverser = new Traverser(){

            @Override
            public void visitPLAuspraegung(MetaPLAuspraegung classification) {
                if (classification.sizeOfAuspraegungen() > 0) {
                    this.visitElements(classification.getAuspraegungen());
                } else if (classification.getFachschluessel().equals(code)) {
                    result.append(classification.getKurztext());
                    throw new BreakException();
                }
            }
        };
        try {
            classifications.accept(traverser);
        }
        catch (BreakException breakException) {
            // empty catch block
        }
        return result.toString();
    }

    public void changeValue1() {
        this.doChangeValue1(true);
    }

    public void changeValue2() {
        this.doChangeValue2(true);
    }

    public ComparedNode copyValue1() throws NoSuchFieldException {
        return this.copyValue(true);
    }

    public ComparedNode copyValue2() throws NoSuchFieldException {
        return this.copyValue(false);
    }

    private void copyNode(ComparedNode quelle, ComparedNode parentNode, boolean copyInSatz1) throws NoSuchFieldException {
        boolean hasSatz = copyInSatz1 ? quelle.hasSatz2() : quelle.hasSatz1();
        if (hasSatz) {
            int[] indizes_orig = quelle.getFeldDeskriptor().getIndizes();
            int[] indizes_copy = null;
            if (indizes_orig != null && indizes_orig.length > 0) {
                indizes_copy = new int[indizes_orig.length];
                System.arraycopy(indizes_orig, 0, indizes_copy, 0, indizes_orig.length);
            }
            FeldDeskriptorImpl parentFeldDeskriptor = parentNode.isVirtual() ? parentNode.getRealParent().getFeldDeskriptor() : parentNode.getFeldDeskriptor();
            FeldDeskriptorImpl feldDeskriptorNeu = this.comparator.createFeldDeskriptor(quelle.getFeldDeskriptor().getFeldNameTB(), indizes_copy, parentFeldDeskriptor);
            ComparedNode copy = new ComparedNode(parentNode, quelle.getElement(), feldDeskriptorNeu, quelle.isVirtual(), this.satz1, this.satz2, this.comparator);
            if (quelle.getElement() instanceof MetaTBFeld) {
                if (((MetaTBFeld)quelle.getElement()).getKlasse() instanceof MetaCustomMerkmal && quelle.getChildCount() == 0) {
                    if (copyInSatz1) {
                        Value value = quelle.getFeldDeskriptor().getValueFrom(this.satz2);
                        copy.getFeldDeskriptor().setValueWith(this.satz1, value);
                        copy.readValue1();
                    } else {
                        Value value = quelle.getFeldDeskriptor().getValueFrom(this.satz1);
                        copy.getFeldDeskriptor().setValueWith(this.satz2, value);
                        copy.readValue2();
                    }
                } else if (quelle.getChildCount() > 0) {
                    int i = 0;
                    while (i < quelle.getChildCount()) {
                        ComparedNode quelleChild = quelle.getChild(i);
                        this.copyNode(quelleChild, copy, copyInSatz1);
                        ++i;
                    }
                }
            }
        }
    }

    public ComparedNode getRealParent() {
        ComparedNode realParent = this.getParent().isVirtual() ? this.getParent().getRealParent() : this.getParent();
        return realParent;
    }

    public void removeFromParent() {
        if (this.getParent() != null) {
            ComparedNode parent = this.getParent();
            int[] indices = new int[parent.getChildCount()];
            if (this.getFeldDeskriptor().getIndizes() != null) {
                int i = 0;
                while (i < parent.getChildCount()) {
                    int[] in = parent.getChild(i).getFeldDeskriptor().getIndizes();
                    if (in != null) {
                        int l = parent.getChild(i).getFeldDeskriptor().getIndizes().length;
                        int j = 0;
                        while (j < l) {
                            indices[i] = parent.getChild(i).getFeldDeskriptor().getIndizes()[j] + 1;
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            parent.removeChild(this);
            if (this.getFeldDeskriptor().getIndizes() != null) {
                int[] newIndices = new int[1];
                int i = 0;
                while (i < parent.getChildCount()) {
                    newIndices[0] = indices[i] - 1;
                    parent.getChild(i).getFeldDeskriptor().setIndizes(newIndices);
                    ++i;
                }
            }
        }
    }

    public SatzInterface getSatz1() {
        return this.satz1;
    }

    public SatzInterface getSatz2() {
        return this.satz2;
    }

    public boolean isNDimensional() {
        boolean result = false;
        if (this.getFeldDeskriptor() != null) {
            int[] indizes = null;
            FeldDeskriptor feldDeskriptor = this.getFeldDeskriptor().getFeldDeskriptor();
            if (feldDeskriptor != null && feldDeskriptor instanceof FeldDeskriptorExt) {
                indizes = ((FeldDeskriptorExt)feldDeskriptor).getDimension();
            }
            if (indizes != null && indizes.length > 0 && indizes[indizes.length - 1] < 0) {
                result = true;
            }
        }
        return result;
    }

    private int[] getBasisIndizes(int[] indizes) {
        int[] basisIndizes = null;
        if (indizes != null && indizes.length > 1) {
            basisIndizes = new int[indizes.length - 1];
            System.arraycopy(indizes, 0, basisIndizes, 0, indizes.length - 1);
        }
        return basisIndizes;
    }

    private int getLaenge(SatzInterface satz) {
        int laenge = 0;
        if (this.getFeldDeskriptor().getIndizes() != null && this.getParent().hasSatz1()) {
            int[] basisIndizes = this.getBasisIndizes(this.getFeldDeskriptor().getIndizes());
            laenge = this.getFeldDeskriptor().getLaenge(satz, basisIndizes);
        }
        return laenge;
    }

    private void readValue1() {
        if (this.hasSatz1()) {
            this.value1Display = this.value1 = this.getFeldDeskriptor().getValueFrom(this.satz1, true).asString();
            MetaAuspraegungsgruppe classifications = this.getClassifications();
            if (classifications != null) {
                this.value1Display = this.getClassificationText(classifications, this.value1);
            }
        }
    }

    private void readValue2() {
        if (this.hasSatz2()) {
            this.value2Display = this.value2 = this.getFeldDeskriptor().getValueFrom(this.satz2, true).asString();
            MetaAuspraegungsgruppe classifications = this.getClassifications();
            if (classifications != null) {
                this.value2Display = this.getClassificationText(classifications, this.value2);
            }
        }
    }

    private ComparedNode copyValue(boolean copyInSatz1) throws NoSuchFieldException {
        int[] indezes_orig = this.getFeldDeskriptor().getIndizes();
        int[] indezes_copy = new int[indezes_orig.length];
        System.arraycopy(indezes_orig, 0, indezes_copy, 0, indezes_orig.length - 1);
        int size1 = this.getLaenge(this.satz1);
        int size2 = this.getLaenge(this.satz2);
        indezes_copy[indezes_orig.length - 1] = size1 > size2 ? size1 : size2;
        FeldDeskriptorImpl currentFeldDeskriptor = this.comparator.createFeldDeskriptor(this.getFeldDeskriptor().getFeldNameTB(), indezes_copy, (FeldDeskriptorImpl)this.getFeldDeskriptor().getVorgaenger());
        ComparedNode copy = new ComparedNode(this.getParent(), this.element, currentFeldDeskriptor, this.isVirtual(), this.satz1, this.satz2, this.comparator);
        copy.setChanged(true);
        if (this.getChildCount() > 0) {
            int i = 0;
            while (i < this.getChildCount()) {
                ComparedNode child = this.getChild(i);
                this.copyNode(child, copy, copyInSatz1);
                ++i;
            }
        }
        return copy;
    }

    private void doChangeValue1(boolean markAsChanged) {
        if (this.getElement() instanceof MetaThemenbereich) {
            int i = this.getChildCount();
            while (i > 0) {
                this.getChild(i - 1).doChangeValue1(markAsChanged);
                --i;
            }
        } else if (this.isVirtual()) {
            int i = this.getChildCount();
            while (i > 0) {
                this.getChild(i - 1).doChangeValue1(markAsChanged);
                --i;
            }
            if (this.getChildCount() == 0) {
                this.removeFromParent();
            }
        } else if (((MetaTBFeld)this.getElement()).getKlasse() instanceof MetaThemenbereich) {
            if (this.hasSatz2()) {
                boolean hasSatz1 = this.hasSatz1();
                int i = this.getChildCount();
                while (i > 0) {
                    this.getChild(i - 1).doChangeValue1(markAsChanged && hasSatz1);
                    --i;
                }
                if (markAsChanged && !hasSatz1) {
                    this.setChanged(true);
                }
            } else if (this.hasSatz1()) {
                this.getFeldDeskriptor().setValueWith(this.satz1, InvalidValue.instance());
                this.removeFromParent();
                if (markAsChanged) {
                    this.setChanged(true);
                }
            }
        } else {
            if (this.hasSatz2()) {
                if (!this.hasSatz1() || this.hasDifferentValues()) {
                    this.getFeldDeskriptor().setValueWith(this.satz1, ValueFactory.instance().valueFor(this.value2));
                    if (markAsChanged) {
                        this.setChanged(true);
                    }
                }
            } else if (this.hasSatz1()) {
                this.getFeldDeskriptor().setValueWith(this.satz1, InvalidValue.instance());
                if (markAsChanged) {
                    this.setChanged(true);
                }
            }
            this.readValue1();
        }
    }

    private void doChangeValue2(boolean markAsChanged) {
        if (this.getElement() instanceof MetaThemenbereich) {
            int i = this.getChildCount();
            while (i > 0) {
                this.getChild(i - 1).doChangeValue2(markAsChanged);
                --i;
            }
        } else if (this.isVirtual()) {
            int i = this.getChildCount();
            while (i > 0) {
                this.getChild(i - 1).doChangeValue2(markAsChanged);
                --i;
            }
            if (this.getChildCount() == 0) {
                this.removeFromParent();
            }
        } else if (((MetaTBFeld)this.getElement()).getKlasse() instanceof MetaThemenbereich) {
            if (this.hasSatz1()) {
                boolean hasSatz2 = this.hasSatz2();
                int i = this.getChildCount();
                while (i > 0) {
                    this.getChild(i - 1).doChangeValue2(markAsChanged && hasSatz2);
                    --i;
                }
                if (markAsChanged && !hasSatz2) {
                    this.setChanged(true);
                }
            } else if (this.hasSatz2()) {
                this.getFeldDeskriptor().setValueWith(this.satz2, InvalidValue.instance());
                this.removeFromParent();
                if (markAsChanged) {
                    this.setChanged(true);
                }
            }
        } else {
            if (this.hasSatz1()) {
                this.getFeldDeskriptor().setValueWith(this.satz2, ValueFactory.instance().valueFor(this.value1));
                if (markAsChanged) {
                    this.setChanged(true);
                }
            } else if (this.hasSatz2()) {
                this.getFeldDeskriptor().setValueWith(this.satz2, InvalidValue.instance());
                if (markAsChanged) {
                    this.setChanged(true);
                }
            }
            this.readValue2();
        }
    }

    private class BreakException
    extends RuntimeException {
        private BreakException() {
        }
    }
}

