/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.compare2.ui;

import de.statspez.pleditor.generator.compare2.ComparedNode;
import de.statspez.pleditor.generator.compare2.ui.AbstractTreeTableModel;
import de.statspez.pleditor.generator.compare2.ui.ComboBoxValue;
import de.statspez.pleditor.generator.compare2.ui.TreeTableModel;

public class CETreeTableModel
extends AbstractTreeTableModel {
    private ComparedNode rootNode;

    public CETreeTableModel(ComparedNode node) {
        super(node);
        this.rootNode = node;
    }

    @Override
    public int getColumnCount() {
        return 2 + this.rootNode.getVergleichssaetze().size();
    }

    @Override
    public Class getColumnClass(int column) {
        if (column == 0) {
            return TreeTableModel.class;
        }
        return String.class;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Feld";
            }
            case 1: {
                return "Wert neu";
            }
            case 2: {
                return "Wert alt";
            }
        }
        return "default";
    }

    @Override
    public Object getValueAt(Object nodeObject, int column) {
        Object result;
        ComparedNode node = (ComparedNode)nodeObject;
        switch (column) {
            case 0: {
                result = this;
                break;
            }
            case 1: {
                result = node.getDisplayvalueOfHauptsatz();
                break;
            }
            default: {
                result = node.getDisplayvalueOfVergleichssatz(column - 1);
            }
        }
        return result;
    }

    @Override
    public void setValueAt(Object aValue, Object nodeObject, int column) {
        if (column != 1) {
            return;
        }
        ComparedNode node = (ComparedNode)nodeObject;
        if (aValue instanceof String) {
            node.setHauptsatzValue(aValue, true);
        } else {
            ComboBoxValue comboBoxValue = (ComboBoxValue)aValue;
            node.setHauptsatzValue(comboBoxValue.getValue(), true);
        }
        this.fireTreeNodesChanged(this, node.getPath(), new int[]{node.getParent().getChildren().indexOf(node)}, new Object[]{node});
    }

    @Override
    public Object getChild(Object parent, int index) {
        ComparedNode parentNode = (ComparedNode)parent;
        return parentNode.getChild(index);
    }

    @Override
    public int getChildCount(Object parent) {
        ComparedNode parentNode = (ComparedNode)parent;
        return parentNode.getChildCount();
    }

    public void nodeChanged(ComparedNode node) {
        if (node.getParent() != null) {
            ComparedNode parent = node.getParent();
            this.fireTreeStructureChanged(this, parent.getPath(), null, null);
        } else {
            this.fireTreeStructureChanged(this, node.getPath(), null, null);
        }
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        if (node instanceof ComparedNode) {
            ComparedNode cNode = (ComparedNode)node;
            if (cNode.isVirtual() || cNode.isRemoved() || !cNode.isLeaf()) {
                return false;
            }
            if (!cNode.hasHauptsatz() && !cNode.isErsterFreierCompareNode()) {
                return false;
            }
            return column == 1;
        }
        return false;
    }
}

