/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.compare2.ui;

import de.statspez.pleditor.generator.compare2.ComparedNode;
import de.statspez.pleditor.generator.compare2.ui.CompareEditor;
import de.statspez.pleditor.generator.compare2.ui.TreeTable;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class TableColorRenderer
extends DefaultTableCellRenderer
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    private CompareEditor compareEditor;

    public TableColorRenderer(CompareEditor compareEditor) {
        this.compareEditor = compareEditor;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        ComparedNode node = (ComparedNode)((TreeTable)table).getTree().getPathForRow(row).getLastPathComponent();
        this.setForeground(Color.BLACK);
        if (isSelected && column == 1 || hasFocus) {
            this.setForeground(Color.WHITE);
            this.setBackground(table.getSelectionBackground());
        } else if (node != null) {
            if (node.isChanged()) {
                this.setBackground(this.compareEditor.getColorForChanges());
            } else if (column > 1 && !node.hasSatzByVergleichssatzNr(column - 1) || column == 1 && !node.hasHauptsatz()) {
                this.setBackground(this.compareEditor.getColorForPlaceholder());
            } else if (node.hasDifferentValues()) {
                this.setBackground(this.compareEditor.getColorForDifferences());
            } else {
                this.setBackground(table.getBackground());
            }
        }
        return comp;
    }
}

