/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.interpreter;

import de.statspez.pleditor.generator.runtime.FeldDeskriptorExt;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import de.statspez.pleditor.generator.runtime.NumberValue;
import de.statspez.pleditor.generator.runtime.plausi.FeldDeskriptorInterface;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import de.statspez.pleditor.generator.runtime.plausi.WertNichtTypgerechtException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SimpleDataset
implements SatzInterface {
    public static final String DEFAULT_NAME_SEPARATOR = ".";
    public static final String DEFAULT_INDICES_PREFIX = "#";
    public static final String DEFAULT_INDICES_SUFFIX = "";
    public static final String DEFAULT_NUMBER_OF_SUFFIX = "#anzahl";
    public static final String DEFAULT_DECIMAL_POINT = ",";
    public static final String DEFAULT_THOUSEND_POINT = ".";
    private Map values;
    private String nameSeparator;
    private String indicesPrefix;
    private String indicesSuffix;
    private String numberOfSuffix;
    private String decimalPoint;
    private String thousandPoint;
    private Set plVariables;

    public SimpleDataset(Map values) {
        this.values = values;
        this.nameSeparator = ".";
        this.indicesPrefix = DEFAULT_INDICES_PREFIX;
        this.indicesSuffix = DEFAULT_INDICES_SUFFIX;
        this.numberOfSuffix = DEFAULT_NUMBER_OF_SUFFIX;
        this.decimalPoint = DEFAULT_DECIMAL_POINT;
        this.thousandPoint = ".";
        this.plVariables = new HashSet();
    }

    public String getNameSeparator() {
        return this.nameSeparator;
    }

    public void setNameSeparator(String nameSeparator) {
        this.nameSeparator = nameSeparator;
    }

    public String getIndicesPrefix() {
        return this.indicesPrefix;
    }

    public void setIndicesPrefix(String indicesPrefix) {
        this.indicesPrefix = indicesPrefix;
    }

    public String getIndicesSuffix() {
        return this.indicesSuffix;
    }

    public void setIndicesSuffix(String indicesSuffix) {
        this.indicesSuffix = indicesSuffix;
    }

    public String getNumberOfSuffix() {
        return this.numberOfSuffix;
    }

    public void setNumberOfSuffix(String numberOfSuffix) {
        this.numberOfSuffix = numberOfSuffix;
    }

    public String getDecimalPoint() {
        return this.decimalPoint;
    }

    public void setDecimalPoint(String decimalPoint) {
        if (decimalPoint == null || decimalPoint.length() == 0) {
            throw new IllegalArgumentException("Dezimaltrenner muss angegeben werden.");
        }
        this.decimalPoint = decimalPoint;
    }

    public String getThousandPoint() {
        return this.thousandPoint;
    }

    public void setThousandPoint(String thousendPoint) {
        this.thousandPoint = thousendPoint;
    }

    public Set getPlVariables() {
        return this.plVariables;
    }

    private String createKey(FeldDeskriptorInterface feldDeskriptor) {
        FeldDeskriptorExt feldDeskriptorExt;
        FeldDeskriptorImpl feldDeskriptorImpl;
        StringBuffer key = new StringBuffer();
        FeldDeskriptorInterface field = feldDeskriptor;
        while (field != null) {
            if (field.getIndizes() != null) {
                int i = 0;
                while (i < field.getIndizes().length) {
                    key.insert(0, this.getIndicesSuffix());
                    key.insert(0, field.getIndizes()[i]);
                    key.insert(0, this.getIndicesPrefix());
                    ++i;
                }
            }
            key.insert(0, field.getFeldNameTB());
            if (field.getVorgaenger() != null) {
                key.insert(0, this.getNameSeparator());
            }
            field = field.getVorgaenger();
        }
        if (feldDeskriptor instanceof FeldDeskriptorImpl && (feldDeskriptorImpl = (FeldDeskriptorImpl)feldDeskriptor).getFeldDeskriptor() instanceof FeldDeskriptorExt && (feldDeskriptorExt = (FeldDeskriptorExt)feldDeskriptorImpl.getFeldDeskriptor()).getFeldBezeichnung() != null && feldDeskriptorExt.getFeldBezeichnung().equals("###PL-VARIABLE###")) {
            this.plVariables.add(key.toString());
        }
        return key.toString();
    }

    private String getThousandPointEscaped() {
        String thousandPointEscaped = this.getThousandPoint() == null ? null : (this.getThousandPoint().equals(".") ? "\\." : this.getThousandPoint());
        return thousandPointEscaped;
    }

    @Override
    public int getLaenge(FeldDeskriptorInterface feldDeskriptor, int[] indizes) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        int laenge;
        StringBuffer key = new StringBuffer(this.createKey(feldDeskriptor));
        if (indizes != null) {
            int i = 0;
            while (i < indizes.length) {
                key.append(this.getIndicesPrefix());
                key.append(indizes[i]);
                ++i;
            }
        }
        key.append(this.numberOfSuffix);
        Object objectValue = this.values.get(key.toString());
        if (objectValue == null) {
            laenge = 0;
        } else if (objectValue instanceof Integer) {
            laenge = (Integer)objectValue;
        } else if (objectValue instanceof String) {
            try {
                laenge = Integer.parseInt((String)objectValue);
            }
            catch (Exception e) {
                laenge = 0;
            }
        } else {
            laenge = 0;
        }
        return laenge;
    }

    @Override
    public boolean hatWert(FeldDeskriptorInterface feldDeskriptor) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        return this.values.get(this.createKey(feldDeskriptor)) != null;
    }

    @Override
    public String getString(FeldDeskriptorInterface feldDeskriptor) throws NoSuchFieldException, ArrayIndexOutOfBoundsException, WertNichtTypgerechtException {
        String value;
        String key = this.createKey(feldDeskriptor);
        Object objectValue = this.values.get(key);
        if (objectValue == null) {
            value = DEFAULT_INDICES_SUFFIX;
        } else if (objectValue instanceof String) {
            value = (String)objectValue;
        } else {
            throw new WertNichtTypgerechtException(key);
        }
        return value;
    }

    @Override
    public void setString(FeldDeskriptorInterface feldDeskriptor, String neuerWert) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        this.values.put(this.createKey(feldDeskriptor), neuerWert);
    }

    @Override
    public long getLong(FeldDeskriptorInterface feldDeskriptor) throws NoSuchFieldException, ArrayIndexOutOfBoundsException, WertNichtTypgerechtException {
        long value;
        String key = this.createKey(feldDeskriptor);
        Object objectValue = this.values.get(key);
        if (objectValue == null) {
            value = 0L;
        } else if (objectValue instanceof Long) {
            value = (Long)objectValue;
        } else if (objectValue instanceof String) {
            try {
                String stringValue = (String)objectValue;
                NumberValue numberValue = new NumberValue(stringValue);
                if (stringValue.indexOf(44) >= 0) {
                    throw new WertNichtTypgerechtException(key);
                }
                value = numberValue.asLong();
            }
            catch (Exception e) {
                throw new WertNichtTypgerechtException(key);
            }
        } else {
            throw new WertNichtTypgerechtException(key);
        }
        return value;
    }

    @Override
    public void setLong(FeldDeskriptorInterface feldDeskriptor, long neuerWert) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        this.values.put(this.createKey(feldDeskriptor), new Long(neuerWert));
    }

    @Override
    public double getDouble(FeldDeskriptorInterface feldDeskriptor) throws NoSuchFieldException, ArrayIndexOutOfBoundsException, WertNichtTypgerechtException {
        double value;
        String key = this.createKey(feldDeskriptor);
        Object objectValue = this.values.get(key);
        if (objectValue == null) {
            value = 0.0;
        } else if (objectValue instanceof Double) {
            value = (Double)objectValue;
        } else if (objectValue instanceof String) {
            try {
                String stringValue = (String)objectValue;
                NumberValue numberValue = new NumberValue(stringValue);
                value = numberValue.asDouble();
            }
            catch (Exception e) {
                throw new WertNichtTypgerechtException(key);
            }
        } else {
            throw new WertNichtTypgerechtException(key);
        }
        return value;
    }

    @Override
    public void setDouble(FeldDeskriptorInterface feldDeskriptor, double neuerWert) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        this.values.put(this.createKey(feldDeskriptor), new Double(neuerWert));
    }

    @Override
    public boolean getBool(FeldDeskriptorInterface feldDeskriptor) throws NoSuchFieldException, ArrayIndexOutOfBoundsException, WertNichtTypgerechtException {
        boolean value;
        String key = this.createKey(feldDeskriptor);
        Object objectValue = this.values.get(key);
        if (objectValue == null) {
            value = false;
        } else if (objectValue instanceof Boolean) {
            value = (Boolean)objectValue;
        } else if (objectValue instanceof String) {
            try {
                value = new Boolean((String)objectValue);
            }
            catch (Exception e) {
                throw new WertNichtTypgerechtException(key);
            }
        } else {
            throw new WertNichtTypgerechtException(key);
        }
        return value;
    }

    @Override
    public void setBool(FeldDeskriptorInterface feldDeskriptor, boolean neuerWert) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        this.values.put(this.createKey(feldDeskriptor), new Boolean(neuerWert));
    }

    @Override
    public void setLeerWert(FeldDeskriptorInterface feldDeskriptor) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        this.values.remove(this.createKey(feldDeskriptor));
    }

    @Override
    public SatzInterface getSubSatz(FeldDeskriptorInterface satzFeldDeskriptor) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        return this;
    }
}

