/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.interpreter;

import de.statspez.pleditor.generator.codegen.support.ClassificationRegKeyBuilder;
import de.statspez.pleditor.generator.interpreter.FieldDescriptorFactory;
import de.statspez.pleditor.generator.interpreter.GenericMaterialDescriptor;
import de.statspez.pleditor.generator.interpreter.IdentifierResolver;
import de.statspez.pleditor.generator.interpreter.InterpreterContext;
import de.statspez.pleditor.generator.interpreter.ProgramInterpreter;
import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.InternalFunctions;
import de.statspez.pleditor.generator.meta.MetaArrayAccess;
import de.statspez.pleditor.generator.meta.MetaBoolean;
import de.statspez.pleditor.generator.meta.MetaBooleanOperator;
import de.statspez.pleditor.generator.meta.MetaCheckFeldStatement;
import de.statspez.pleditor.generator.meta.MetaClassificationReference;
import de.statspez.pleditor.generator.meta.MetaDate;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaFieldAccess;
import de.statspez.pleditor.generator.meta.MetaForEachCheck;
import de.statspez.pleditor.generator.meta.MetaFunctionCall;
import de.statspez.pleditor.generator.meta.MetaIdentifier;
import de.statspez.pleditor.generator.meta.MetaInterval;
import de.statspez.pleditor.generator.meta.MetaLiteralAccess;
import de.statspez.pleditor.generator.meta.MetaMaterialAccess;
import de.statspez.pleditor.generator.meta.MetaMathOperator;
import de.statspez.pleditor.generator.meta.MetaNoValue;
import de.statspez.pleditor.generator.meta.MetaNumber;
import de.statspez.pleditor.generator.meta.MetaPruefeStatement;
import de.statspez.pleditor.generator.meta.MetaRangeSeries;
import de.statspez.pleditor.generator.meta.MetaSelfAccess;
import de.statspez.pleditor.generator.meta.MetaSequence;
import de.statspez.pleditor.generator.meta.MetaSignOperator;
import de.statspez.pleditor.generator.meta.MetaSingleValueRange;
import de.statspez.pleditor.generator.meta.MetaSizeOfOperator;
import de.statspez.pleditor.generator.meta.MetaString;
import de.statspez.pleditor.generator.meta.MetaStructureAccess;
import de.statspez.pleditor.generator.meta.MetaTestingOperator;
import de.statspez.pleditor.generator.meta.MetaTypeCheck;
import de.statspez.pleditor.generator.meta.MetaUnaryBoolOperator;
import de.statspez.pleditor.generator.runtime.BooleanValue;
import de.statspez.pleditor.generator.runtime.DateValue;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorExt;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import de.statspez.pleditor.generator.runtime.FunctionLib;
import de.statspez.pleditor.generator.runtime.IntervalRange;
import de.statspez.pleditor.generator.runtime.InvalidValue;
import de.statspez.pleditor.generator.runtime.Material;
import de.statspez.pleditor.generator.runtime.NilValue;
import de.statspez.pleditor.generator.runtime.OperatorLib;
import de.statspez.pleditor.generator.runtime.PlausiRuntimeIterator;
import de.statspez.pleditor.generator.runtime.Range;
import de.statspez.pleditor.generator.runtime.RangeSeries;
import de.statspez.pleditor.generator.runtime.SequenceRange;
import de.statspez.pleditor.generator.runtime.SingleValueRange;
import de.statspez.pleditor.generator.runtime.SupportLib;
import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.plausi.FeldDeskriptorInterface;
import de.statspez.pleditor.generator.runtime.plausi.SatzFilter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Vector;

public class ValueResolver
extends AbstractElementVisitor {
    private InterpreterContext context;
    private ValueResolver privateSubResolver;
    private ProgramInterpreter privateSubProgramInterpreter;
    private IdentifierResolver identifierResolver;
    private Value value;

    public ValueResolver(InterpreterContext context) {
        this.context = context;
        this.privateSubResolver = null;
        this.privateSubProgramInterpreter = null;
        this.identifierResolver = new IdentifierResolver(context);
        this.value = null;
    }

    public Value resolve(MetaElement element) {
        this.value = NilValue.instance();
        element.accept(this);
        return this.value;
    }

    private ValueResolver subResolver() {
        if (this.privateSubResolver == null) {
            this.privateSubResolver = new ValueResolver(this.context);
        }
        return this.privateSubResolver;
    }

    private ProgramInterpreter subInterpreter() {
        if (this.privateSubProgramInterpreter == null) {
            this.privateSubProgramInterpreter = new ProgramInterpreter();
        }
        return this.privateSubProgramInterpreter;
    }

    private void resolveFromIdentifier(MetaElement element) {
        this.identifierResolver.resolve(element);
        this.value = this.identifierResolver.isVariable() ? this.context.getVariableValue(this.identifierResolver.getName(), this.identifierResolver.getIndices()) : this.identifierResolver.getFieldDescriptor().getValueFrom(this.context.getSatz());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visitFunctionCall(MetaFunctionCall aStatement) {
        if (InternalFunctions.instance().identifiesInternalFunction(aStatement.function())) {
            MetaIdentifier functionId = (MetaIdentifier)aStatement.function().adaptedObject();
            String functionName = functionId.value();
            Method internalFunction = null;
            Method[] internalFunctions = FunctionLib.class.getDeclaredMethods();
            if (internalFunctions.length > 0) {
                int i = 0;
                while (i < internalFunctions.length) {
                    if (internalFunctions[i].getName().equals(functionName)) {
                        internalFunction = internalFunctions[i];
                        break;
                    }
                    ++i;
                }
            }
            if (internalFunction == null) throw new RuntimeException("Die Funktion " + functionName + " wird nicht unterst\u00fctzt.");
            if (!Value.class.isAssignableFrom(internalFunction.getReturnType())) {
                throw new RuntimeException("Die Funktion " + functionName + " wird nicht unterst\u00fctzt.");
            }
            Class<?>[] parameterTypes = internalFunction.getParameterTypes();
            if (parameterTypes.length - 1 != aStatement.numberOfParameters()) throw new RuntimeException("Die Funktion " + functionName + " erwartet " + (parameterTypes.length - 1) + " Parameter.");
            Object[] parameters = new Object[parameterTypes.length];
            parameters[0] = this.context;
            int i = 0;
            while (i < aStatement.numberOfParameters()) {
                if (!Value.class.isAssignableFrom(parameterTypes[i + 1])) {
                    throw new RuntimeException("Die Funktion " + functionName + " wird nicht unterst\u00fctzt.");
                }
                parameters[i + 1] = this.subResolver().resolve(aStatement.parameterAt(i));
                ++i;
            }
            try {
                this.value = (Value)internalFunction.invoke(null, parameters);
                return;
            }
            catch (InvocationTargetException e) {
                if (!(e.getTargetException() instanceof RuntimeException)) throw new RuntimeException(e.getTargetException());
                throw (RuntimeException)e.getTargetException();
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.value = this.subInterpreter().execute(aStatement, this.context);
        }
    }

    @Override
    public void visitCheckFeldStatement(MetaCheckFeldStatement statement) {
        this.value = this.subInterpreter().execute(statement, this.context);
    }

    @Override
    public void visitPruefeStatement(MetaPruefeStatement statement) {
        this.value = this.subInterpreter().execute(statement, this.context);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void visitForEachCheck(MetaForEachCheck aStatement) {
        this.context.enterBlock();
        try {
            block9: {
                PlausiRuntimeIterator values;
                Iterator iter;
                block8: {
                    iter = aStatement.variables();
                    while (iter != null && iter.hasNext()) {
                        MetaIdentifier variable = (MetaIdentifier)iter.next();
                        this.context.declareVariable(variable.value());
                    }
                    values = SupportLib.iteratorFor(this.subResolver().resolve(aStatement.value()), this.context);
                    this.value = BooleanValue.TRUE;
                    if (!true) break block8;
                    if (values == null) return;
                    if (!values.hasNext()) break block9;
                }
                do {
                    iter = aStatement.variables();
                    while (iter != null && iter.hasNext()) {
                        MetaIdentifier variable = (MetaIdentifier)iter.next();
                        this.context.setVariableValue(variable.value(), (Value)values.next());
                    }
                    if (!this.subResolver().resolve(aStatement.condition()).asBoolean()) {
                        this.value = BooleanValue.FALSE;
                        return;
                    }
                    if (values == null) return;
                } while (values.hasNext());
            }
            return;
        }
        finally {
            this.context.leaveScope();
        }
    }

    @Override
    public void visitTypeCheck(MetaTypeCheck anOperator) {
        int type;
        String maske = null;
        if (anOperator.maske() != null) {
            maske = anOperator.maske().value();
        }
        switch (anOperator.type()) {
            case 5: {
                type = 0;
                break;
            }
            case 1: {
                type = 2;
                break;
            }
            case 7: {
                type = 4;
                break;
            }
            case 6: {
                type = 8;
                break;
            }
            case 2: {
                type = 3;
                break;
            }
            case 3: {
                type = 5;
                break;
            }
            case 4: {
                type = 6;
                break;
            }
            default: {
                throw new RuntimeException("Die Typpr\u00fcfung " + anOperator.type() + " wird nicht unterst\u00fctzt.");
            }
        }
        this.value = this.context.valueFactory().valueFor(SupportLib.checkType(this.subResolver().resolve(anOperator.value()), type, maske, this.context));
    }

    @Override
    public void visitTestingOperator(MetaTestingOperator anOperator) {
        switch (anOperator.type()) {
            case 1: {
                this.value = this.context.valueFactory().valueFor(OperatorLib.eq(this.context, this.subResolver().resolve(anOperator.firstOperand()), this.subResolver().resolve(anOperator.secondOperand())));
                break;
            }
            case 4: {
                this.value = this.context.valueFactory().valueFor(OperatorLib.ne(this.context, this.subResolver().resolve(anOperator.firstOperand()), this.subResolver().resolve(anOperator.secondOperand())));
                break;
            }
            case 3: {
                this.value = this.context.valueFactory().valueFor(OperatorLib.gt(this.context, this.subResolver().resolve(anOperator.firstOperand()), this.subResolver().resolve(anOperator.secondOperand())));
                break;
            }
            case 6: {
                this.value = this.context.valueFactory().valueFor(OperatorLib.ge(this.context, this.subResolver().resolve(anOperator.firstOperand()), this.subResolver().resolve(anOperator.secondOperand())));
                break;
            }
            case 2: {
                this.value = this.context.valueFactory().valueFor(OperatorLib.lt(this.context, this.subResolver().resolve(anOperator.firstOperand()), this.subResolver().resolve(anOperator.secondOperand())));
                break;
            }
            case 5: {
                this.value = this.context.valueFactory().valueFor(OperatorLib.le(this.context, this.subResolver().resolve(anOperator.firstOperand()), this.subResolver().resolve(anOperator.secondOperand())));
                break;
            }
            case 7: {
                this.value = this.context.valueFactory().valueFor(OperatorLib.contains(this.context, this.subResolver().resolve(anOperator.secondOperand()), this.subResolver().resolve(anOperator.firstOperand())));
                break;
            }
            default: {
                throw new RuntimeException("Der Vergleichsoperator " + anOperator.type() + " wird nicht unterst\u00fctzt.");
            }
        }
    }

    @Override
    public void visitBooleanOperator(MetaBooleanOperator anOperator) {
        switch (anOperator.type()) {
            case 1: {
                this.value = this.context.valueFactory().valueFor(this.subResolver().resolve(anOperator.firstOperand()).asBoolean() && this.subResolver().resolve(anOperator.secondOperand()).asBoolean());
                break;
            }
            case 2: {
                this.value = this.context.valueFactory().valueFor(this.subResolver().resolve(anOperator.firstOperand()).asBoolean() || this.subResolver().resolve(anOperator.secondOperand()).asBoolean());
                break;
            }
            default: {
                throw new RuntimeException("Der boolsche Operator " + anOperator.type() + " wird nicht unterst\u00fctzt.");
            }
        }
    }

    @Override
    public void visitUnaryBoolOperator(MetaUnaryBoolOperator anOperator) {
        this.value = this.context.valueFactory().valueFor(OperatorLib.not(this.context, this.subResolver().resolve(anOperator.operand())));
    }

    @Override
    public void visitMathOperator(MetaMathOperator anOperator) {
        switch (anOperator.type()) {
            case 1: {
                this.value = OperatorLib.plus(this.context, this.subResolver().resolve(anOperator.firstOperand()), this.subResolver().resolve(anOperator.secondOperand()));
                break;
            }
            case 2: {
                this.value = OperatorLib.minus(this.context, this.subResolver().resolve(anOperator.firstOperand()), this.subResolver().resolve(anOperator.secondOperand()));
                break;
            }
            case 4: {
                this.value = OperatorLib.mult(this.context, this.subResolver().resolve(anOperator.firstOperand()), this.subResolver().resolve(anOperator.secondOperand()));
                break;
            }
            case 3: {
                this.value = OperatorLib.div(this.context, this.subResolver().resolve(anOperator.firstOperand()), this.subResolver().resolve(anOperator.secondOperand()));
                break;
            }
            default: {
                throw new RuntimeException("Der mathematische Operator " + anOperator.type() + " wird nicht unterst\u00fctzt.");
            }
        }
    }

    @Override
    public void visitSignOperator(MetaSignOperator anOperator) {
        switch (anOperator.type()) {
            case 2: {
                this.value = OperatorLib.mult(this.context, this.subResolver().resolve(anOperator.operand()), this.context.valueFactory().valueFor(-1.0));
                break;
            }
            case 1: {
                this.value = this.subResolver().resolve(anOperator.operand());
                break;
            }
            default: {
                throw new RuntimeException("Das Vorzeichen " + anOperator.type() + " wird nicht unterst\u00fctzt.");
            }
        }
    }

    @Override
    public void visitSizeOfOperator(MetaSizeOfOperator anOperator) {
        this.identifierResolver.resolve(anOperator.operand());
        if (this.identifierResolver.isVariable()) {
            this.value = this.context.valueFactory().valueFor(1.0);
        } else if (this.identifierResolver.getFieldDescriptor().getFeldDeskriptor() instanceof FeldDeskriptorExt) {
            int dimension = this.identifierResolver.getIndices() != null && this.identifierResolver.getIndices().length > 0 ? this.identifierResolver.getIndices().length : 0;
            FeldDeskriptorExt feldDeskriptorExt = (FeldDeskriptorExt)this.identifierResolver.getFieldDescriptor().getFeldDeskriptor();
            this.value = feldDeskriptorExt.getDimension() != null && feldDeskriptorExt.getDimension().length > dimension ? (feldDeskriptorExt.getDimension()[dimension] > 0 ? this.context.valueFactory().valueFor(feldDeskriptorExt.getDimension()[dimension]) : this.context.valueFactory().valueFor(this.identifierResolver.getFieldDescriptor().getLaenge(this.context.getSatz(), this.identifierResolver.getIndices()))) : this.context.valueFactory().valueFor(1.0);
        } else {
            this.value = this.context.valueFactory().valueFor(this.identifierResolver.getFieldDescriptor().getLaenge(this.context.getSatz(), this.identifierResolver.getIndices()));
        }
    }

    @Override
    public void visitSelfAccess(MetaSelfAccess aSelfAccess) {
        FeldDeskriptorImpl feldDeskr = this.context.getCurrentField();
        this.value = feldDeskr == null ? this.context.getVariableValue("feld") : feldDeskr.getValueFrom(this.context.getSatz());
    }

    @Override
    public void visitStructureAccess(MetaStructureAccess aStructureAccess) {
        this.resolveFromIdentifier(aStructureAccess);
    }

    @Override
    public void visitArrayAccess(MetaArrayAccess anArrayAccess) {
        this.resolveFromIdentifier(anArrayAccess);
    }

    @Override
    public void visitFieldAccess(MetaFieldAccess aFieldAccess) {
        this.resolveFromIdentifier(aFieldAccess);
    }

    @Override
    public void visitMaterialAccess(MetaMaterialAccess aMaterialAccess) {
        GenericMaterialDescriptor material = new GenericMaterialDescriptor();
        material.setMaterialName(aMaterialAccess.material().value());
        int numOfFields = aMaterialAccess.numberOfSelectedFields();
        FeldDeskriptorInterface[] fields = new FeldDeskriptorInterface[numOfFields];
        FieldDescriptorFactory fieldDescriptorFactory = this.context.getMaterialFieldDescriptorFactory(aMaterialAccess.material().value());
        int i = 0;
        while (i < numOfFields) {
            this.identifierResolver.resolve(aMaterialAccess.selectedFieldAt(i), false, fieldDescriptorFactory);
            fields[i] = this.identifierResolver.getFieldDescriptor();
            if (fields[i] == null) {
                throw new RuntimeException("Feld " + this.identifierResolver.getName() + " ist im Material " + aMaterialAccess.material().value() + " nicht definiert.");
            }
            ++i;
        }
        int numOfConditions = aMaterialAccess.numberOfSelectionConditions();
        SatzFilter.FilterBedingung[] conditions = new SatzFilter.FilterBedingung[numOfConditions];
        if (numOfConditions > 0) {
            int i2 = 0;
            while (i2 < numOfConditions) {
                MetaTestingOperator testingOperator = aMaterialAccess.selectionConditionAt(i2);
                this.identifierResolver.resolve(testingOperator.firstOperand(), false, fieldDescriptorFactory);
                FeldDeskriptorImpl field = this.identifierResolver.getFieldDescriptor();
                if (field == null) {
                    throw new RuntimeException("Feld " + this.identifierResolver.getName() + " ist im Material " + aMaterialAccess.material().value() + " nicht definiert.");
                }
                conditions[i2] = new SatzFilter.FilterBedingung(field, testingOperator.type(), this.subResolver().resolve(testingOperator.secondOperand()));
                ++i2;
            }
        }
        this.value = new Material(material, fields, conditions, this.context);
    }

    @Override
    public void visitRangeSeries(MetaRangeSeries aRangeSeries) {
        Vector<Value> ranges = new Vector<Value>();
        Iterator iter = aRangeSeries.ranges();
        while (iter != null && iter.hasNext()) {
            ranges.add(this.subResolver().resolve((MetaElement)iter.next()));
        }
        this.value = new RangeSeries(ranges.toArray(new Range[0]));
    }

    @Override
    public void visitSingleValueRange(MetaSingleValueRange aRange) {
        this.value = new SingleValueRange(this.subResolver().resolve(aRange.value()));
    }

    @Override
    public void visitSequence(MetaSequence aSequence) {
        this.value = new SequenceRange(this.subResolver().resolve(aSequence.first()), this.subResolver().resolve(aSequence.second()), this.subResolver().resolve(aSequence.last()));
    }

    @Override
    public void visitInterval(MetaInterval anInterval) {
        this.value = new IntervalRange(this.subResolver().resolve(anInterval.first()), this.subResolver().resolve(anInterval.last()), anInterval.type());
    }

    @Override
    public void visitClassificationReference(MetaClassificationReference aReference) {
        ClassificationRegKeyBuilder keyBuilder = new ClassificationRegKeyBuilder();
        aReference.accept(keyBuilder);
        String regKey = keyBuilder.regKey();
        this.value = aReference.referenceByCode() ? this.context.getClassificationFactory().getClassificationByCode(regKey) : this.context.getClassificationFactory().getClassificationByValue(regKey);
    }

    @Override
    public void visitLiteralAccess(MetaLiteralAccess aLiteralAccess) {
        aLiteralAccess.accessedLiteral().accept(this);
    }

    @Override
    public void visitNumber(MetaNumber aNumber) {
        this.value = this.context.valueFactory().valueFor(aNumber.value());
    }

    @Override
    public void visitBoolean(MetaBoolean aBoolean) {
        this.value = this.context.valueFactory().valueFor(aBoolean.value());
    }

    @Override
    public void visitString(MetaString aString) {
        this.value = this.context.valueFactory().valueFor(aString.value());
    }

    @Override
    public void visitDate(MetaDate aDate) {
        String format = aDate.format();
        if (format == null || format.length() == 0) {
            format = "TT.MM.JJJJ";
        }
        this.value = new DateValue(this.subResolver().resolve(aDate.specification()).asString(), format);
    }

    @Override
    public void visitNoValue(MetaNoValue noValue) {
        this.value = InvalidValue.instance();
    }
}

