/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.common.AbstractMessage;
import de.statspez.pleditor.generator.meta.MetaCustomRawSet;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaDsbObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaRawField;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.ParserChain;
import de.statspez.pleditor.generator.parser.RawFieldGroupParser;
import de.statspez.pleditor.generator.parser.RawFieldParser;
import de.statspez.pleditor.generator.parser.Resolver;
import de.statspez.pleditor.generator.parser.SubParser;
import de.statspez.pleditor.generator.parser.SuperParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class RawSetParser
extends SubParser
implements SuperParser {
    private MetaCustomRawSet sa = null;
    private ParserChain parserChain = new ParserChain();
    private RawFieldGroupParser grParser;
    private RawFieldParser feldParser = null;

    public RawSetParser(SuperParser sParser, Resolver resolver) {
        super(sParser, resolver);
        this.grParser = new RawFieldGroupParser(this, resolver);
        this.grParser.disallow();
        this.parserChain.addParser(this.grParser);
        this.feldParser = new RawFieldParser(this, resolver);
        this.feldParser.disallow();
        this.parserChain.addParser(this.feldParser);
    }

    @Override
    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("http://www.werum.de/pl-editor".equalsIgnoreCase(namespaceURI) && "rawSet".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    @Override
    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("rawSet".equalsIgnoreCase(localName)) {
            this.enable();
            this.sa = new MetaCustomRawSet();
            this.handleAttributes(namespaceURI, localName, qName, atts);
            this.grParser.allow();
            this.feldParser.allow();
            this.notifyObjectStarted();
        } else if (!this.parserChain.startElement(namespaceURI, localName, qName, atts) && !this.canHandleTag(namespaceURI, localName)) {
            throw ILParseException.unknownTagException(localName);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("rawSet".equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else if (!this.parserChain.endElement(namespaceURI, localName, qName) && !this.handleTag(namespaceURI, localName, qName)) {
            throw ILParseException.unkownClosingTagException(localName);
        }
    }

    @Override
    public MetaElement object() {
        return this.sa;
    }

    @Override
    public void notifyObjectStarted(SubParser aParser) {
        if (aParser == this.feldParser) {
            this.grParser.disallow();
        } else if (aParser == this.grParser) {
            this.feldParser.disallow();
        }
    }

    @Override
    public void notifyObjectAvailable(SubParser aParser) {
        if (aParser == this.feldParser) {
            this.sa.addToListOfRawField((MetaRawField)aParser.object());
            this.grParser.allow();
        } else if (aParser == this.grParser) {
            this.sa.addToListOfRawField((MetaRawField)aParser.object());
            this.feldParser.allow();
        }
    }

    @Override
    public StringBuffer charData() {
        return this.superParser().charData();
    }

    @Override
    public String parentElement() {
        return this.superParser().parentElement();
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("rawSet".equalsIgnoreCase(localName)) {
            String name = atts.getValue("name");
            if (name == null) {
                throw new ILParseException("Fuer das RawSet ist kein Name definiert!");
            }
            this.sa.setName(name.trim());
            String id = atts.getValue("id");
            if (id != null && id.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                this.sa.setId(id.trim());
            } else {
                this.sa.setId(name);
            }
            String source = atts.getValue("source");
            if (source != null) {
                this.sa.setDSBName(source.trim());
            }
        }
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) {
        boolean handled = false;
        String chars = this.superParser().charData().toString().trim();
        return handled;
    }

    private void setDsbOfSubParsers(MetaDsbObjekt _dsb) {
    }

    private boolean canHandleTag(String namespaceURI, String tag) {
        return "http://www.werum.de/pl-editor".equalsIgnoreCase(namespaceURI) && "rawSet".equalsIgnoreCase(tag);
    }

    @Override
    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }
}

