/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime.test;

import de.statspez.pleditor.generator.interpreter.InterpreterContext;
import de.statspez.pleditor.generator.interpreter.PlausiClassificationFactory;
import de.statspez.pleditor.generator.interpreter.PlausiProgramFactory;
import de.statspez.pleditor.generator.interpreter.ProgramDescriptor;
import de.statspez.pleditor.generator.interpreter.ProgramInterpreter;
import de.statspez.pleditor.generator.interpreter.SimpleDataset;
import de.statspez.pleditor.generator.interpreter.TBFieldDescriptorFactory;
import de.statspez.pleditor.generator.meta.MetaCustomAblauf;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.pleditor.generator.parser.Helper;
import de.statspez.pleditor.generator.runtime.plausi.PlausiFehler;
import de.statspez.pleditor.generator.runtime.plausi.PlausiInterface;
import de.statspez.pleditor.generator.runtime.plausi.PlausiKontext;
import de.statspez.pleditor.generator.runtime.test.FieldValues;
import de.statspez.pleditor.generator.runtime.test.MaterialValues;
import de.statspez.pleditor.generator.runtime.test.PlausiTestCase;
import de.statspez.pleditor.generator.runtime.test.PlausiTestCaseResult;
import de.statspez.pleditor.generator.runtime.test.PlausiTestResult;
import de.statspez.pleditor.generator.runtime.test.TestFailure;
import de.statspez.pleditor.generator.runtime.test.TestMaterialAccess;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FlowTestCase
extends PlausiTestCase {
    private String flow = null;
    private int errorLevel = 1;
    private FieldValues initValues = new FieldValues();
    private List inputValues = new ArrayList();
    private List outputValues = new ArrayList();
    private Map materialValues = new HashMap();
    private boolean checkOutputValues;

    public String getFlow() {
        return this.flow;
    }

    public void setFlow(String flow) {
        this.flow = flow;
    }

    public int getErrorLevel() {
        return this.errorLevel;
    }

    public void setErrorLevel(int errorLevel) {
        this.errorLevel = errorLevel;
    }

    public FieldValues getInitValue() {
        return this.initValues;
    }

    public void addInputValues(FieldValues inputValues) {
        this.inputValues.add(inputValues);
    }

    public Iterator getInputValues() {
        return this.inputValues.iterator();
    }

    public HashMap getInputValuesAsMap() {
        return this.convertListToMap(this.inputValues);
    }

    public void addOutputValues(FieldValues outputValues) {
        this.outputValues.add(outputValues);
    }

    public Iterator getOutputValues() {
        return this.outputValues.iterator();
    }

    public HashMap getOutputValuesAsMap() {
        return this.convertListToMap(this.outputValues);
    }

    public void addMaterialValues(MaterialValues materialValues) {
        this.materialValues.put(materialValues.getMaterialName(), materialValues);
    }

    public Map getMaterialValues() {
        return this.materialValues;
    }

    private HashMap convertListToMap(List list) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (FieldValues fieldValues : list) {
            Iterator fieldKeyIterator = fieldValues.getFields();
            while (fieldKeyIterator.hasNext()) {
                String fieldKey = (String)fieldKeyIterator.next();
                result.put(fieldKey, fieldValues.getValue(fieldKey));
            }
        }
        return result;
    }

    public boolean isCheckOutputValues() {
        return this.checkOutputValues;
    }

    public void setCheckOutputValues(boolean checkOutputValues) {
        this.checkOutputValues = checkOutputValues;
    }

    @Override
    public void execute(PlausiInterface plausi, PlausiTestResult result) {
        PlausiTestCaseResult testCaseResult = new PlausiTestCaseResult(this);
        try {
            try {
                PlausiKontext context = new PlausiKontext();
                HashMap<String, String> values = new HashMap<String, String>();
                context.setPlausiAblauf(this.getFlow());
                context.setFehlerGewichtSchranke(this.getErrorLevel());
                context.setReferenzDateien(new TestMaterialAccess(this.getMaterialValues()));
                Iterator iter = this.getInputValues();
                while (iter.hasNext()) {
                    FieldValues fieldValues = (FieldValues)iter.next();
                    Iterator fields = fieldValues.getFields();
                    while (fields.hasNext()) {
                        String field = (String)fields.next();
                        String fieldValue = fieldValues.getValue(field);
                        if (fieldValue == null || fieldValue.length() <= 0) continue;
                        values.put(field, fieldValue);
                    }
                }
                FieldValues initValues = this.getInitValue();
                if (initValues.getValuesCount() > 0) {
                    Object[] initValuesArray = new Object[initValues.getValuesCount()];
                    Iterator fields = initValues.getFields();
                    int i = 0;
                    while (fields.hasNext()) {
                        String field = (String)fields.next();
                        initValuesArray[i++] = initValues.getValue(field);
                    }
                    context.setInitWerte(initValuesArray);
                }
                SimpleDataset dataset = new SimpleDataset(values);
                dataset.setIndicesPrefix("[");
                dataset.setIndicesSuffix("]");
                plausi.gesamtPlausi(dataset, context);
                PlausiFehler[] errors = new PlausiFehler[context.getAnzahlFehler()];
                int i = 0;
                while (i < context.getAnzahlFehler()) {
                    errors[i] = context.getFehler(i);
                    ++i;
                }
                testCaseResult.handlePlausiResult(errors);
                if (this.isCheckOutputValues()) {
                    this.checkOutputValues(values, null, testCaseResult);
                }
            }
            catch (Exception ex) {
                testCaseResult.addFailure(new TestFailure(this.getName(), 5, ex));
                result.addTestCaseResult(testCaseResult);
            }
        }
        finally {
            result.addTestCaseResult(testCaseResult);
        }
    }

    @Override
    public void interprete(MetaCustomPlausibilisierung plausi, PlausiTestResult result) {
        PlausiTestCaseResult testCaseResult = new PlausiTestCaseResult(this);
        try {
            try {
                MetaStatspezObjekt metaObject = this.getMetaObject(plausi);
                MetaProgram metaProgram = Helper.metaStructureFor(this.getElementMessage(metaObject), this.getProgramCode(metaObject));
                InterpreterContext context = new InterpreterContext();
                context.setClassificationFactory(new PlausiClassificationFactory(plausi));
                MetaCustomAblauf metaAblauf = (MetaCustomAblauf)metaObject;
                TBFieldDescriptorFactory fieldDescriptorFactory = new TBFieldDescriptorFactory(metaAblauf.getThemenbereich());
                context.setFieldDescriptorFactory(fieldDescriptorFactory);
                context.setProgramFactory(new PlausiProgramFactory(metaAblauf.getThemenbereich(), fieldDescriptorFactory));
                PlausiKontext myPLContext = new PlausiKontext();
                myPLContext.setReferenzDateien(new TestMaterialAccess(this.getMaterialValues()));
                context.setPlausiKontext(myPLContext);
                HashMap<String, String> values = new HashMap<String, String>();
                Iterator fieldValuesIterator = this.getInputValues();
                while (fieldValuesIterator.hasNext()) {
                    FieldValues fieldValues = (FieldValues)fieldValuesIterator.next();
                    Iterator fieldIterator = fieldValues.getFields();
                    while (fieldIterator.hasNext()) {
                        String field = (String)fieldIterator.next();
                        String fieldValue = fieldValues.getValue(field);
                        if (fieldValue == null || fieldValue.length() <= 0) continue;
                        values.put(field, fieldValue);
                    }
                }
                SimpleDataset dataset = new SimpleDataset(values);
                dataset.setIndicesPrefix("[");
                dataset.setIndicesSuffix("]");
                context.setSatz(dataset);
                ProgramDescriptor programDescriptor = new ProgramDescriptor(metaProgram, null, metaObject);
                ProgramInterpreter programInterpreter = new ProgramInterpreter();
                programInterpreter.execute(programDescriptor, null, context);
                testCaseResult.handlePlausiResult(context.getPlausiErrors());
                if (this.isCheckOutputValues()) {
                    this.checkOutputValues(values, dataset.getPlVariables(), testCaseResult);
                }
            }
            catch (Exception ex) {
                testCaseResult.addFailure(new TestFailure(this.getName(), 5, ex));
                result.addTestCaseResult(testCaseResult);
            }
        }
        finally {
            result.addTestCaseResult(testCaseResult);
        }
    }

    private void checkOutputValues(Map outputMap, Set plVariables, PlausiTestCaseResult testCaseResult) {
        HashMap expectedOutputMap = this.getOutputValuesAsMap();
        for (String key : expectedOutputMap.keySet()) {
            String value = (String)outputMap.get(key);
            String expectedValue = (String)expectedOutputMap.get(key);
            if (value != null) {
                outputMap.remove(key);
                if (value.equals(expectedValue)) continue;
                testCaseResult.addFailure(new TestFailure(this.getName(), 7, key, 10, expectedValue, value));
                continue;
            }
            testCaseResult.addFailure(new TestFailure(this.getName(), 6, key));
        }
        for (String key : outputMap.keySet()) {
            if (plVariables != null && plVariables.contains(key)) continue;
            testCaseResult.addFailure(new TestFailure(this.getName(), 5, key));
        }
    }
}

