/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime.test;

import de.statspez.pleditor.generator.runtime.test.ExpectedPlausiError;
import de.statspez.pleditor.generator.runtime.test.FieldTestCase;
import de.statspez.pleditor.generator.runtime.test.FieldValues;
import de.statspez.pleditor.generator.runtime.test.FlowTestCase;
import de.statspez.pleditor.generator.runtime.test.MappingTestCase;
import de.statspez.pleditor.generator.runtime.test.MaterialValues;
import de.statspez.pleditor.generator.runtime.test.PlausiTestCase;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PlausiTest {
    private String name = null;
    private String plausiFileName = null;
    private List testCases = new ArrayList();
    private List fieldValues = new ArrayList();

    public PlausiTest() {
    }

    public PlausiTest(String fileName) throws Exception {
        this(new File(fileName));
    }

    public PlausiTest(File file) throws Exception {
        this();
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        parser.parse(file, (DefaultHandler)new XmlParser());
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setPlausiFileName(String plausiFileName) {
        this.plausiFileName = plausiFileName;
    }

    public String getPlausiFileName() {
        return this.plausiFileName;
    }

    public void addTestCase(PlausiTestCase testCase) {
        this.testCases.add(testCase);
    }

    public int getTestCasesCount() {
        return this.testCases.size();
    }

    public Iterator getTestCases() {
        return this.testCases.iterator();
    }

    public PlausiTestCase getTestCase(String name) {
        Iterator iter = this.getTestCases();
        while (iter.hasNext()) {
            PlausiTestCase testCase = (PlausiTestCase)iter.next();
            if (!testCase.getName().equals(name)) continue;
            return testCase;
        }
        return null;
    }

    public void addFieldValues(FieldValues fieldValues) {
        this.fieldValues.add(fieldValues);
    }

    public FieldValues getFieldValues(String id) {
        for (FieldValues fieldValues : this.fieldValues) {
            if (!fieldValues.getId().equals(id)) continue;
            return fieldValues;
        }
        return null;
    }

    public boolean containsRawMappingTestCase() {
        Iterator iter = this.getTestCases();
        while (iter.hasNext()) {
            PlausiTestCase testCase = (PlausiTestCase)iter.next();
            if (!(testCase instanceof MappingTestCase)) continue;
            switch (((MappingTestCase)testCase).getDirection()) {
                case 1: 
                case 2: {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean containsDsbMappingTestCase() {
        Iterator iter = this.getTestCases();
        while (iter.hasNext()) {
            PlausiTestCase testCase = (PlausiTestCase)iter.next();
            if (!(testCase instanceof MappingTestCase)) continue;
            switch (((MappingTestCase)testCase).getDirection()) {
                case 3: 
                case 4: {
                    return true;
                }
            }
        }
        return false;
    }

    private class XmlParser
    extends DefaultHandler {
        private PlausiTestCase currentTestCase = null;
        private FieldValues currentFieldValues = null;
        private String currentField = null;
        private MaterialValues currentMaterialValues = null;
        private ExpectedPlausiError currentError = null;
        private String currentPath = "";
        private StringBuffer buffer = new StringBuffer();

        private XmlParser() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            this.buffer.delete(0, this.buffer.length());
            if (name.equalsIgnoreCase("PlausiTest")) {
                this.assertParent("");
                PlausiTest.this.setName(attributes.getValue("name"));
                PlausiTest.this.setPlausiFileName(attributes.getValue("plausi"));
            } else if (name.equalsIgnoreCase("fieldTest")) {
                this.assertParent("PlausiTest");
                FieldTestCase testCase = new FieldTestCase();
                testCase.setName(attributes.getValue("name"));
                PlausiTest.this.addTestCase(testCase);
                this.currentTestCase = testCase;
            } else if (name.equalsIgnoreCase("flowTest")) {
                this.assertParent("PlausiTest");
                FlowTestCase testCase = new FlowTestCase();
                testCase.setName(attributes.getValue("name"));
                testCase.setCheckOutputValues(Boolean.valueOf(attributes.getValue("check-output-values")));
                PlausiTest.this.addTestCase(testCase);
                this.currentTestCase = testCase;
            } else if (name.equalsIgnoreCase("mappingTest")) {
                this.assertParent("PlausiTest");
                MappingTestCase testCase = new MappingTestCase();
                testCase.setName(attributes.getValue("name"));
                testCase.setDirection(attributes.getValue("direction"));
                testCase.setTestDeprecatedMapping(Boolean.valueOf(attributes.getValue("test-deprecated-mapping")));
                PlausiTest.this.addTestCase(testCase);
                this.currentTestCase = testCase;
            } else if (name.equalsIgnoreCase("values")) {
                this.assertParent("PlausiTest material");
                String file = attributes.getValue("file");
                if (file != null) {
                    try {
                        FieldValues fieldValues = new FieldValues(file);
                        if (this.withinParent("material")) {
                            fieldValues.setId(attributes.getValue("id"));
                            this.currentMaterialValues.addFieldValues(fieldValues);
                        }
                        fieldValues.setId(attributes.getValue("id"));
                        PlausiTest.this.addFieldValues(fieldValues);
                    }
                    catch (IOException e) {
                        throw new SAXException(e);
                    }
                } else {
                    String ref = attributes.getValue("ref");
                    if (ref != null) {
                        this.assertParent("material");
                        FieldValues fieldValues = PlausiTest.this.getFieldValues(ref);
                        if (fieldValues == null) {
                            throw new SAXException("Werte <" + ref + "> nicht definiert.");
                        }
                        this.currentMaterialValues.addFieldValues(fieldValues);
                    } else {
                        this.currentFieldValues = new FieldValues();
                        if (this.withinParent("material")) {
                            this.currentFieldValues.setId(attributes.getValue("id"));
                            this.currentMaterialValues.addFieldValues(this.currentFieldValues);
                        } else {
                            this.currentFieldValues.setId(attributes.getValue("id"));
                            PlausiTest.this.addFieldValues(this.currentFieldValues);
                        }
                    }
                }
            } else if (name.equalsIgnoreCase("inputValues")) {
                this.assertParent("mappingTest flowTest");
                this.currentFieldValues = new FieldValues();
                if (this.withinParent("mappingTest")) {
                    ((MappingTestCase)this.currentTestCase).addInputValue(this.currentFieldValues);
                } else if (this.withinParent("flowTest")) {
                    ((FlowTestCase)this.currentTestCase).addInputValues(this.currentFieldValues);
                }
            } else if (name.equalsIgnoreCase("outputValues")) {
                this.assertParent("mappingTest flowTest");
                this.currentFieldValues = new FieldValues();
                if (this.withinParent("mappingTest")) {
                    ((MappingTestCase)this.currentTestCase).addOutputValue(this.currentFieldValues);
                } else if (this.withinParent("flowTest")) {
                    ((FlowTestCase)this.currentTestCase).addOutputValues(this.currentFieldValues);
                }
            } else if (name.equalsIgnoreCase("initValues")) {
                this.assertParent("flowTest");
            } else if (name.equalsIgnoreCase("field")) {
                this.assertParent("values fieldTest initValues inputValues outputValues");
                if (this.withinParent("values initValues inputValues outputValues")) {
                    this.currentField = attributes.getValue("name");
                } else {
                    ((FieldTestCase)this.currentTestCase).setField(attributes.getValue("name"));
                }
            } else if (name.equalsIgnoreCase("expectedError")) {
                this.assertParent("fieldTest flowTest");
                this.currentError = new ExpectedPlausiError();
                this.currentError.setId(attributes.getValue("id"));
                this.currentError.setCheckRuntimeException(Boolean.valueOf(attributes.getValue("check-runtime-exception")));
                this.currentError.setCheckReferenceField(Boolean.valueOf(attributes.getValue("check-ref-field")));
                this.currentError.setCheckUsedFields(Boolean.valueOf(attributes.getValue("check-used-fields")));
                this.currentTestCase.addExpectedError(this.currentError);
            } else if (name.equalsIgnoreCase("material")) {
                this.assertParent("flowTest");
                this.currentMaterialValues = new MaterialValues();
                this.currentMaterialValues.setMaterialName(attributes.getValue("name"));
                ((FlowTestCase)this.currentTestCase).addMaterialValues(this.currentMaterialValues);
            } else if (name.equalsIgnoreCase("refField")) {
                this.assertParent("expectedError");
                this.currentError.setReferenceField(attributes.getValue("name"));
                if (!this.currentError.getCheckReferenceField()) {
                    this.currentError.setCheckReferenceField(true);
                }
            } else if (name.equalsIgnoreCase("usedField")) {
                this.assertParent("expectedError");
                this.currentError.addUsedField(attributes.getValue("name"));
                if (!this.currentError.getCheckUsedFields()) {
                    this.currentError.setCheckUsedFields(true);
                }
            } else if (name.equalsIgnoreCase("runtimeException")) {
                this.assertParent("expectedError");
                this.currentError.setRuntimeExceptionClass(attributes.getValue("class"));
                if (!this.currentError.getCheckRuntimeException()) {
                    this.currentError.setCheckRuntimeException(true);
                }
            }
            this.currentPath = String.valueOf(this.currentPath) + "/" + name;
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            this.currentPath = this.currentPath.substring(0, this.currentPath.lastIndexOf(47));
            if (name.equalsIgnoreCase("fieldTest") || name.equalsIgnoreCase("flowTest") || name.equalsIgnoreCase("mappingTest")) {
                this.currentTestCase = null;
            } else if (name.equalsIgnoreCase("flow")) {
                this.assertParent("flowTest");
                ((FlowTestCase)this.currentTestCase).setFlow(this.buffer.toString());
            } else if (name.equalsIgnoreCase("errorLevel")) {
                this.assertParent("flowTest");
                ((FlowTestCase)this.currentTestCase).setErrorLevel(Integer.parseInt(this.buffer.toString()));
            } else if (name.equalsIgnoreCase("values")) {
                this.currentFieldValues = null;
            } else if (name.equalsIgnoreCase("field")) {
                if (this.withinParent("values inputValues outputValues")) {
                    this.currentFieldValues.setValue(this.currentField, this.buffer.toString());
                } else if (this.withinParent("initValues")) {
                    ((FlowTestCase)this.currentTestCase).getInitValue().setValue(this.currentField, this.buffer.toString());
                } else {
                    ((FieldTestCase)this.currentTestCase).setValue(this.buffer.toString());
                }
                this.currentField = null;
            } else if (name.equalsIgnoreCase("expectedError")) {
                this.currentError = null;
            } else if (name.equalsIgnoreCase("runtimeException")) {
                this.assertParent("expectedError");
                this.currentError.setRuntimeExceptionMessage(this.buffer.toString());
            } else if (name.equalsIgnoreCase("textShort")) {
                this.assertParent("expectedError");
                this.currentError.setTextShort(this.buffer.toString());
            } else if (name.equalsIgnoreCase("textLong")) {
                this.assertParent("expectedError");
                this.currentError.setTextLong(this.buffer.toString());
            } else if (name.equalsIgnoreCase("correctionAdvice")) {
                this.assertParent("expectedError");
                this.currentError.setCorrectionAdvice(this.buffer.toString());
            } else if (name.equalsIgnoreCase("material")) {
                this.currentMaterialValues = null;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.buffer.append(ch, start, length);
        }

        private void assertParent(String parentPath) throws SAXException {
            if (!this.withinParent(parentPath)) {
                throw new SAXException("Falsches Format");
            }
        }

        private boolean withinParent(String parentPath) {
            boolean result = parentPath.indexOf(32) > 0 ? this.withinParent(parentPath.substring(0, parentPath.indexOf(32))) || this.withinParent(parentPath.substring(parentPath.indexOf(32) + 1)) : (parentPath.equals("") || parentPath.startsWith("/") ? this.currentPath.equalsIgnoreCase(parentPath) : this.currentPath.endsWith("/" + parentPath));
            return result;
        }
    }
}

