/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime.test;

import de.statspez.pleditor.generator.common.ElementMessageContext;
import de.statspez.pleditor.generator.meta.MetaCustomAblauf;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaCustomMerkmal;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaCustomPruefung;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaPLAblauf;
import de.statspez.pleditor.generator.meta.generated.MetaPLFunktion;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.generator.runtime.plausi.PlausiInterface;
import de.statspez.pleditor.generator.runtime.test.ExpectedPlausiError;
import de.statspez.pleditor.generator.runtime.test.FieldTestCase;
import de.statspez.pleditor.generator.runtime.test.FlowTestCase;
import de.statspez.pleditor.generator.runtime.test.PlausiTestResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class PlausiTestCase {
    private String name = null;
    private List expectedErrors = new ArrayList();

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addExpectedError(ExpectedPlausiError error) {
        this.expectedErrors.add(error);
    }

    public Iterator getExpectedErrors() {
        return this.expectedErrors.iterator();
    }

    public int getExpectedErrorSize() {
        return this.expectedErrors.size();
    }

    public ExpectedPlausiError getExpectedErrorById(String id) {
        Iterator iter = this.getExpectedErrors();
        while (iter.hasNext()) {
            ExpectedPlausiError error = (ExpectedPlausiError)iter.next();
            if (!error.getId().equals(id)) continue;
            return error;
        }
        return null;
    }

    public abstract void interprete(MetaCustomPlausibilisierung var1, PlausiTestResult var2);

    public abstract void execute(PlausiInterface var1, PlausiTestResult var2);

    protected MetaStatspezObjekt getMetaObject(MetaCustomPlausibilisierung plausi) {
        if (this instanceof FieldTestCase) {
            return this.getMerkmal(plausi.rootThemenbereich(), ((FieldTestCase)this).getField());
        }
        if (this instanceof FlowTestCase) {
            String compareString = ((FlowTestCase)this).getFlow();
            Iterator ablaufIterator = plausi.rootThemenbereich().getAblaeufe();
            while (ablaufIterator.hasNext()) {
                MetaCustomAblauf metaAblauf = (MetaCustomAblauf)ablaufIterator.next();
                if (!metaAblauf.getName().equals(compareString)) continue;
                return metaAblauf;
            }
        }
        return null;
    }

    protected MetaMerkmal getMerkmal(MetaThemenbereich topic, String field) {
        String structure;
        MetaMerkmal result = null;
        int indexOfDot = field.indexOf(46);
        if (indexOfDot >= 0) {
            structure = field.substring(0, indexOfDot);
            field = field.substring(indexOfDot + 1);
            int indexOfBrace = structure.indexOf(91);
            if (indexOfBrace >= 0) {
                structure = structure.substring(0, indexOfBrace);
            }
        } else {
            structure = null;
        }
        Iterator fields = topic.getFelder();
        while (fields.hasNext()) {
            MetaTBFeld currentField = (MetaTBFeld)fields.next();
            if (structure != null) {
                if (!currentField.getName().equals(structure)) continue;
                result = this.getMerkmal((MetaThemenbereich)currentField.getKlasse(), field);
                break;
            }
            if (!currentField.getName().equals(field)) continue;
            result = (MetaMerkmal)currentField.getKlasse();
            break;
        }
        return result;
    }

    protected ElementMessageContext getElementMessage(MetaStatspezObjekt metaStatspezObjekt) {
        ElementMessageContext elementMessage = null;
        if (metaStatspezObjekt != null) {
            String name = metaStatspezObjekt.getName();
            String id = metaStatspezObjekt.getId();
            int typ = 0;
            if (metaStatspezObjekt instanceof MetaCustomMerkmal) {
                typ = 5;
            } else if (metaStatspezObjekt instanceof MetaCustomFunktion) {
                int functionType = ((MetaCustomFunktion)metaStatspezObjekt).getFunctionType();
                if (functionType == 1) {
                    typ = 3;
                }
                if (functionType == 0) {
                    typ = 4;
                }
            }
            if (metaStatspezObjekt instanceof MetaCustomAblauf) {
                typ = 2;
            }
            if (metaStatspezObjekt instanceof MetaCustomPruefung) {
                typ = 1;
            }
            elementMessage = new ElementMessageContext(typ, id, name);
        }
        return elementMessage;
    }

    protected String getProgramCode(MetaStatspezObjekt metaStatspezObjekt) {
        String code = metaStatspezObjekt instanceof MetaCustomMerkmal ? ((MetaCustomMerkmal)metaStatspezObjekt).getPLSpezifikation() : (metaStatspezObjekt instanceof MetaPLFunktion ? ((MetaPLFunktion)metaStatspezObjekt).getAnweisungen() : (metaStatspezObjekt instanceof MetaCustomPruefung ? ((MetaCustomPruefung)metaStatspezObjekt).getPLSpezifikation() : (metaStatspezObjekt instanceof MetaPLAblauf ? ((MetaPLAblauf)metaStatspezObjekt).getSpezifikation() : null)));
        return code;
    }
}

