/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.ui.editor;

import de.statspez.pleditor.generator.codeassist.ui.CodeAssistantWindow;
import de.statspez.pleditor.generator.codeassist.ui.ScopeProvider;
import de.statspez.pleditor.generator.codegen.pl.PrettyPrinter;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.parser.Helper;
import de.statspez.pleditor.generator.parser.speclanguage.ui.PLSyntaxTextAreaUI;
import de.statspez.pleditor.ui.editor.CodePositionTraverser;
import de.statspez.pleditor.ui.editor.EditableDocument;
import de.statspez.pleditor.ui.editor.JScrollPaneAdjuster;
import de.statspez.pleditor.ui.editor.LineNumberJList;
import de.statspez.pleditor.ui.editor.PLCodeEditorConfig;
import de.statspez.pleditor.ui.editor.Ruler;
import de.statspez.pleditor.ui.editor.StatusbarListener;
import de.statspez.pleditor.ui.editor.marker.Marker;
import de.statspez.pleditor.ui.editor.marker.MarkerHandler;
import de.statspez.pleditor.ui.search.SearchDialog;
import de.statspez.pleditor.ui.settings.EditorSetting;
import de.statspez.pleditor.ui.settings.SettingsProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;

public class PLCodeEditor
extends JPanel {
    private static final long serialVersionUID = -6371558408720902459L;
    private static final String PLCODEEDITOR_TEXTEDITOR_UICLASSID = "PLCodeEditorTextEditorUIClassID";
    private final JTextArea textPane = new JTextArea(){

        @Override
        public String getUIClassID() {
            return PLCodeEditor.PLCODEEDITOR_TEXTEDITOR_UICLASSID;
        }
    };
    StatusBar statusBar = new StatusBar();
    EditableDocument editableDocument = new EditableDocument();
    private final boolean enableToolBar;
    private final boolean enableStatusBar;
    private final boolean enableSettingsAction;
    private final boolean enablePrettyPrinterAction;
    private AbstractAction searchAction;
    private AbstractAction settingsAction;
    private AbstractAction markAction;
    private AbstractAction expandWindow;
    private JDialog fullScreen;
    private JToolBar toolBar;
    private ScopeProvider scopeProvider;
    private final boolean expandable;
    private AbstractAction prettyPrinterAction;
    private JDialog parentDialog;
    private boolean expanded = false;
    private PLCodeEditor refEditor;
    private String fullScreenTitle;
    private boolean formated = false;
    private LineNumberJList rHeader;
    private JLabel title;
    private ArrayList statusbarListeners;
    private MarkerHandler markerHandler;
    private final int defaultBlinkRate;
    private int editorType;

    static {
        UIManager.put(PLCODEEDITOR_TEXTEDITOR_UICLASSID, PLSyntaxTextAreaUI.class.getName());
    }

    public PLCodeEditor() {
        this(new PLCodeEditorConfig());
    }

    public PLCodeEditor(PLCodeEditorConfig config) {
        this(config, false);
    }

    private PLCodeEditor(PLCodeEditorConfig config, boolean expanded) {
        this.enableToolBar = config.isEnableToolBar();
        this.enableStatusBar = config.isEnableStatusBar();
        this.enableSettingsAction = config.isEnableSettingsAction();
        this.enablePrettyPrinterAction = config.isEnablePrettyPrinterAction();
        this.expandable = config.isExpandable();
        this.expanded = expanded;
        this.title = new JLabel();
        if (config.getTitle() != null) {
            this.title.setText(config.getTitle());
            this.title.setToolTipText(config.getTooltip());
        }
        this.editorType = config.getEditorType();
        this.initWidgetLayout();
        this.defaultBlinkRate = this.textPane.getCaret().getBlinkRate();
        this.statusbarListeners = new ArrayList();
    }

    public void setScopeProvider(ScopeProvider scopeProvider) {
        if (this.scopeProvider != null) {
            throw new IllegalStateException("ScopeProvider wurde bereits gesetzt.");
        }
        this.scopeProvider = scopeProvider;
        new CodeAssistantWindow(this.textPane, scopeProvider);
    }

    private void initWidgetLayout() {
        this.setLayout(new BorderLayout());
        this.textPane.setDocument(this.editableDocument);
        this.loadColorProfile();
        this.initTitleAndToolBar();
        DefaultHighlighter highlighter = new DefaultHighlighter();
        this.textPane.setHighlighter(highlighter);
        this.textPane.setFont(new Font("Monospaced", 0, 11));
        JPanel noWrapPanel = new JPanel();
        noWrapPanel.setLayout(new BorderLayout());
        noWrapPanel.add(this.textPane);
        JScrollPane scp = new JScrollPane(noWrapPanel);
        Ruler ruler = new Ruler(this.textPane);
        scp.setColumnHeaderView(ruler);
        scp.getHorizontalScrollBar().setUnitIncrement(20);
        scp.getHorizontalScrollBar().setBlockIncrement(200);
        scp.getVerticalScrollBar().setUnitIncrement(20);
        scp.getVerticalScrollBar().setBlockIncrement(200);
        this.rHeader = new LineNumberJList(this.textPane);
        if (this.getMarkerHandler() != null) {
            this.rHeader.setMarkerHandler(this.getMarkerHandler());
        }
        scp.setRowHeaderView(this.rHeader);
        new JScrollPaneAdjuster(scp);
        this.add((Component)scp, "Center");
        if (this.enableStatusBar) {
            this.initStatusBar();
        }
        this.textPane.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                int mark = e.getMark();
                PLCodeEditor.this.statusBar.setCarretPosition(mark);
            }
        });
    }

    private void initTitleAndToolBar() {
        if (this.enableToolBar) {
            this.initToolBar();
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.title, "West");
        if (this.enableToolBar) {
            panel.add((Component)this.toolBar, "East");
        }
        this.add((Component)panel, "North");
    }

    private void initStatusBar() {
        int cursor = this.textPane.getCaretPosition();
        this.statusBar.setCarretPosition(cursor);
        this.add((Component)this.statusBar, "South");
    }

    private void initToolBar() {
        this.initActions();
        this.toolBar = new JToolBar("JToolBar");
        this.toolBar.setRollover(true);
        this.toolBar.setFloatable(false);
        this.prettyPrinterAction.setEnabled(this.enablePrettyPrinterAction);
        this.toolBar.add(this.prettyPrinterAction);
        if (this.enableSettingsAction) {
            this.toolBar.add(this.settingsAction);
        }
        this.toolBar.add(this.searchAction);
        this.toolBar.add(this.markAction);
        if (this.expandable) {
            if (!this.expanded) {
                this.toolBar.add(this.expandWindow);
            } else {
                JToggleButton minimize = new JToggleButton(new ImageIcon(PLCodeEditor.class.getResource("writeout_co.gif")), true);
                minimize.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PLCodeEditor.this.refEditor.setTextFrom(PLCodeEditor.this);
                        PLCodeEditor.this.parentDialog.setVisible(false);
                    }
                });
                this.toolBar.add(minimize);
            }
        }
    }

    private void initActions() {
        this.settingsAction = new AbstractAction("Farbprofil", new ImageIcon(PLCodeEditor.class.getResource("theme_category.gif"))){
            private static final long serialVersionUID = 4302564793589370844L;

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorSetting colorProfileSetting = new EditorSetting(PLCodeEditor.this);
                colorProfileSetting.setVisible(true);
                if (colorProfileSetting.isSettingChanged()) {
                    PLCodeEditor.this.loadColorProfile();
                }
            }
        };
        this.settingsAction.putValue("ShortDescription", "Farbprofil");
        this.prettyPrinterAction = new AbstractAction("Formatieren", new ImageIcon(PLCodeEditor.class.getResource("format.gif"))){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (PLCodeEditor.this.textPane.getText().trim().length() == 0) {
                        return;
                    }
                    String code = PLCodeEditor.this.textPane.getText();
                    PrettyPrinter prettyPrinter = new PrettyPrinter();
                    if (PLCodeEditor.this.editorType == PLCodeEditorConfig.CHECK_EDITOR) {
                        code = "RUECKGABE\n" + code;
                        prettyPrinter.setLineAfterReturnToken(true);
                    } else if (PLCodeEditor.this.editorType == 20) {
                        code = "WENN NICHT feld IN {" + code + "} DANN FEHLER ENDE";
                    }
                    MetaProgram program = Helper.metaStructureFor(code);
                    int caretPosition = PLCodeEditor.this.textPane.getCaretPosition();
                    int indentSpace = SettingsProvider.getInstance().getIndentSpaces();
                    StringBuffer buffer = new StringBuffer();
                    if (indentSpace < 0) {
                        indentSpace = 3;
                    }
                    int i = 0;
                    while (i < indentSpace) {
                        buffer.append(" ");
                        ++i;
                    }
                    prettyPrinter.setIndentSpace(buffer.toString());
                    code = prettyPrinter.generate(program, code);
                    if (PLCodeEditor.this.editorType == PLCodeEditorConfig.CHECK_EDITOR || PLCodeEditor.this.editorType == 30) {
                        code = code.substring("RUECKGABE\n".length(), code.length());
                    } else if (PLCodeEditor.this.editorType == 20) {
                        code = code.substring(20);
                        String tmp = "";
                        int i2 = 0;
                        while (i2 < code.length()) {
                            char charAt = code.charAt(i2);
                            if (charAt != '}') {
                                tmp = String.valueOf(tmp) + charAt;
                            } else {
                                i2 = code.length();
                            }
                            ++i2;
                        }
                        code = tmp.trim();
                    }
                    PLCodeEditor.this.textPane.setText(code);
                    PLCodeEditor.this.setFormated(true);
                    int newCaretPosition = PLCodeEditor.this.textPane.getCaretPosition();
                    if (newCaretPosition > caretPosition) {
                        PLCodeEditor.this.textPane.setCaretPosition(caretPosition);
                    }
                }
                catch (Throwable t) {
                    PLCodeEditor.this.setFormated(false);
                }
            }
        };
        this.prettyPrinterAction.putValue("ShortDescription", "Formatieren");
        this.searchAction = new AbstractAction("Suchen", new ImageIcon(PLCodeEditor.class.getResource("search.gif"))){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Window w = SwingUtilities.getWindowAncestor(PLCodeEditor.this);
                SearchDialog searchDialog = w instanceof JFrame ? new SearchDialog((JFrame)w, PLCodeEditor.this) : (w instanceof JDialog ? new SearchDialog((JDialog)w, PLCodeEditor.this) : new SearchDialog(PLCodeEditor.this));
                searchDialog.setVisible(true);
            }
        };
        this.searchAction.putValue("ShortDescription", "Suchen");
        if (this.expandable) {
            this.expandWindow = new AbstractAction("Fenstervergr\u00f6\u00dfern", new ImageIcon(PLCodeEditor.class.getResource("writeout_co.gif"))){
                private static final long serialVersionUID = -4469768533392266615L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    Window w = SwingUtilities.getWindowAncestor(PLCodeEditor.this);
                    if (w instanceof JFrame) {
                        PLCodeEditor.this.fullScreen = new JDialog((JFrame)w);
                    } else if (w instanceof JDialog) {
                        PLCodeEditor.this.fullScreen = new JDialog((JDialog)w);
                    } else {
                        PLCodeEditor.this.fullScreen = new JDialog();
                    }
                    PLCodeEditorConfig config = new PLCodeEditorConfig();
                    config.setEnableToolBar(PLCodeEditor.this.enableToolBar);
                    config.setEnableStatusBar(true);
                    config.setExpandable(PLCodeEditor.this.expandable);
                    final PLCodeEditor editor = new PLCodeEditor(config, true, null);
                    editor.setEditable(PLCodeEditor.this.isEditable());
                    editor.setParent(PLCodeEditor.this.fullScreen);
                    editor.setText(PLCodeEditor.this.textPane.getText());
                    editor.setReferenceEditor(PLCodeEditor.this);
                    PLCodeEditor.this.fullScreen.add(editor);
                    editor.setScopeProvider(PLCodeEditor.this.scopeProvider);
                    PLCodeEditor.this.fullScreen.addWindowListener(new WindowListener(){

                        @Override
                        public void windowOpened(WindowEvent e) {
                        }

                        @Override
                        public void windowIconified(WindowEvent e) {
                        }

                        @Override
                        public void windowDeiconified(WindowEvent e) {
                        }

                        @Override
                        public void windowDeactivated(WindowEvent e) {
                        }

                        @Override
                        public void windowClosing(WindowEvent e) {
                            PLCodeEditor.this.setTextFrom(editor);
                        }

                        @Override
                        public void windowClosed(WindowEvent e) {
                        }

                        @Override
                        public void windowActivated(WindowEvent e) {
                        }
                    });
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(PLCodeEditor.this.getGraphicsConfiguration());
                    int width = (int)(screenSize.getWidth() - (double)(screenInsets.left + screenInsets.right));
                    int height = (int)(screenSize.getHeight() - (double)(screenInsets.top + screenInsets.bottom));
                    PLCodeEditor.this.fullScreen.setSize(width, height);
                    PLCodeEditor.this.fullScreen.setTitle(PLCodeEditor.this.fullScreenTitle != null ? PLCodeEditor.this.fullScreenTitle : "");
                    PLCodeEditor.this.fullScreen.setModal(true);
                    PLCodeEditor.this.fullScreen.setVisible(true);
                }
            };
            this.expandWindow.putValue("ShortDescription", "Fenster vergr\u00f6\u00dfern");
            this.markAction = new AbstractAction("Block markieren", new ImageIcon(PLCodeEditor.class.getResource("segment.gif"))){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        String code = PLCodeEditor.this.getText();
                        MetaProgram metaStructureFor = Helper.metaStructureFor(code);
                        Caret caret = PLCodeEditor.this.textPane.getCaret();
                        int dot = caret.getDot();
                        MetaElement element = PLCodeEditor.this.getElementAtPos(metaStructureFor, dot);
                        if (element != null) {
                            int lineStartOffset = PLCodeEditor.this.getLineStartOffset(element.startLine());
                            int lineEndOffset = PLCodeEditor.this.getLineStartOffset(element.endLine());
                            PLCodeEditor.this.textPane.select(lineStartOffset + element.startColumn() - 1, lineEndOffset + element.endColumn());
                            PLCodeEditor.this.textPane.grabFocus();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            };
            this.markAction.putValue("ShortDescription", "Block markieren");
        }
    }

    protected MetaElement getElementAtPos(MetaProgram program, int position) throws BadLocationException {
        int lineOfOffset = this.textPane.getLineOfOffset(position);
        Element root = this.textPane.getDocument().getDefaultRootElement();
        int lineIndex = root.getElementIndex(position);
        Element lineElement = root.getElement(lineIndex);
        int lineStartOffset = lineElement.getStartOffset();
        int column = position - lineStartOffset;
        int line = lineIndex + 1;
        CodePositionTraverser traverser = new CodePositionTraverser(program, line, ++column);
        return traverser.getMetaElement();
    }

    protected void setReferenceEditor(PLCodeEditor refEditor) {
        this.refEditor = refEditor;
    }

    private void setParent(JDialog parent) {
        this.parentDialog = parent;
    }

    public String getText() {
        return this.textPane.getText();
    }

    public void setText(String text) {
        boolean wasWriteProtected = this.editableDocument.isWriteProtected();
        boolean wasInsertSpacesForTabs = this.editableDocument.isInsertSpacesForTabs();
        try {
            this.editableDocument.setWriteProtected(false);
            this.editableDocument.setInsertSpacesForTabs(false);
            this.textPane.setText(text);
            this.textPane.setCaretPosition(0);
        }
        finally {
            this.editableDocument.setWriteProtected(wasWriteProtected);
            this.editableDocument.setInsertSpacesForTabs(wasInsertSpacesForTabs);
        }
    }

    public void loadColorProfile() {
        this.textPane.setForeground(SettingsProvider.getInstance().getColor("text.color"));
        if (!this.editableDocument.isWriteProtected()) {
            this.textPane.setBackground(SettingsProvider.getInstance().getColor("background.color"));
        } else {
            this.textPane.setBackground(SettingsProvider.getInstance().getColor("disabledbackground.color"));
        }
        this.textPane.setCaretColor(SettingsProvider.getInstance().getColor("text.color"));
        PLSyntaxTextAreaUI areaUI = (PLSyntaxTextAreaUI)this.textPane.getUI();
        areaUI.setDefaultColor(SettingsProvider.getInstance().getColor("text.color"));
        areaUI.setCommentColor(SettingsProvider.getInstance().getColor("comment.color"));
        areaUI.setStringColor(SettingsProvider.getInstance().getColor("string.color"));
        areaUI.setKeywordColor(SettingsProvider.getInstance().getColor("keyword.color"));
        areaUI.setOperatorKeywordColor(SettingsProvider.getInstance().getColor("operator.keyword.color"));
        areaUI.setOperatorSymbolColor(SettingsProvider.getInstance().getColor("operator.symbol.color"));
        areaUI.setMiscSymbolColor(SettingsProvider.getInstance().getColor("misc.symbol.color"));
        areaUI.setNumberColor(SettingsProvider.getInstance().getColor("number.color"));
        this.textPane.repaint();
    }

    public void setNotification(String notification) {
        if (this.enableStatusBar && this.statusBar != null) {
            this.statusBar.setNotification(notification);
        }
        this.fireNotificationChange(notification);
    }

    public void openSearchDiaolog() {
        if (this.searchAction != null) {
            this.searchAction.actionPerformed(null);
        }
    }

    public void prettyCode() {
        if (this.prettyPrinterAction != null) {
            this.prettyPrinterAction.actionPerformed(null);
        }
    }

    public void expandWindow() {
        if (this.expandWindow != null) {
            this.expandWindow.actionPerformed(null);
        }
    }

    public void setFullScreenTitle(String fullScreenTitle) {
        this.fullScreenTitle = fullScreenTitle;
    }

    public void setCaretPosition(int lineOffset) {
        this.textPane.setCaretPosition(lineOffset);
    }

    public int getLineStartOffset(int lineToSelect) {
        int result = 0;
        if (this.textPane != null && this.textPane.getDocument() != null && this.textPane.getDocument().getDefaultRootElement() != null && lineToSelect - 1 >= 0 && this.textPane.getDocument().getDefaultRootElement().getElement(lineToSelect - 1) != null) {
            result = this.textPane.getDocument().getDefaultRootElement().getElement(lineToSelect - 1).getStartOffset();
        }
        return result;
    }

    public void addMarker(List marker) {
        int i = 0;
        while (i < marker.size()) {
            this.addMarker((Marker)marker.get(i), false);
            ++i;
        }
        this.repaint();
    }

    public void addMarker(Marker marker) {
        this.addMarker(marker, true);
    }

    private void addMarker(Marker marker, boolean repaint) {
        this.rHeader.addMarker(marker);
    }

    public void addDocumentListener(DocumentListener listener) {
        this.textPane.getDocument().addDocumentListener(listener);
    }

    public void setEditable(boolean editable) {
        this.editableDocument.setWriteProtected(!editable);
        if (editable) {
            this.textPane.getCaret().setBlinkRate(this.defaultBlinkRate);
        } else {
            this.textPane.getCaret().setBlinkRate(0);
        }
        if (this.textPane.hasFocus()) {
            this.textPane.getCaret().setVisible(true);
        } else {
            this.textPane.getCaret().setVisible(false);
        }
        if (editable) {
            this.textPane.setBackground(SettingsProvider.getInstance().getColor("background.color"));
        } else {
            this.textPane.setBackground(SettingsProvider.getInstance().getColor("disabledbackground.color"));
        }
        this.prettyPrinterAction.setEnabled(editable);
    }

    public boolean isEditable() {
        boolean result = false;
        if (this.textPane != null) {
            result = !this.editableDocument.isWriteProtected();
        }
        return result;
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
        this.textPane.getDocument().addUndoableEditListener(listener);
    }

    public JTextComponent getTextComponent() {
        return this.textPane;
    }

    public void addStatusbarListener(StatusbarListener listener) {
        if (listener != null) {
            this.statusbarListeners.add(listener);
        }
    }

    private void fireStatusChange(String status) {
        int i = 0;
        while (this.statusbarListeners != null && i < this.statusbarListeners.size()) {
            ((StatusbarListener)this.statusbarListeners.get(i)).statusChange(status);
            ++i;
        }
    }

    private void fireNotificationChange(String notification) {
        int i = 0;
        while (i < this.statusbarListeners.size()) {
            ((StatusbarListener)this.statusbarListeners.get(i)).notificationChange(notification);
            ++i;
        }
    }

    public void setTitle(String title) {
        if (title == null) {
            title = "";
        }
        this.title.setText(title);
    }

    public void setTitleEnabled(boolean enabled) {
        this.title.setEnabled(enabled);
    }

    private void setTextFrom(PLCodeEditor editor) {
        if (this.isEditable()) {
            if (!this.getText().equals(editor.getText())) {
                this.setText(editor.getText());
            }
            this.textPane.grabFocus();
            this.textPane.setCaretPosition(editor.getTextComponent().getCaretPosition());
        }
    }

    public void setCaretPositionFromLine(int line) {
        if (this.textPane != null) {
            this.textPane.setCaretPosition(this.getLineStartOffset(line));
        }
    }

    public void deactivateMarker(int line, Class clazz) {
    }

    public void removeMarker(int line, int type) {
        this.rHeader.removeMarker(line, type);
    }

    public void setMarkerHandler(MarkerHandler markerHandler) {
        this.markerHandler = markerHandler;
        this.rHeader.setMarkerHandler(markerHandler);
    }

    public MarkerHandler getMarkerHandler() {
        return this.markerHandler;
    }

    public void removeAllMarker(int type) {
        this.rHeader.removeAllMarker(type);
    }

    private void setFormated(boolean formated) {
        this.formated = formated;
    }

    public boolean isFormated() {
        return this.formated;
    }

    /* synthetic */ PLCodeEditor(PLCodeEditorConfig pLCodeEditorConfig, boolean bl, PLCodeEditor pLCodeEditor) {
        this(pLCodeEditorConfig, bl);
    }

    private class StatusBar
    extends JPanel {
        private static final long serialVersionUID = -7884786967247707333L;
        private JLabel textLabel;
        private JLabel notification;
        private int line;
        private int column;

        public StatusBar() {
            super(new GridBagLayout());
            this.line = 1;
            this.column = 0;
            GridBagConstraints gdc = new GridBagConstraints();
            gdc.insets.left = 10;
            gdc.insets.top = 5;
            gdc.insets.bottom = 5;
            this.textLabel = new JLabel();
            Font fontOrig = this.textLabel.getFont();
            this.textLabel.setFont(new Font("Courier New", fontOrig.getStyle(), 12));
            this.notification = new JLabel();
            fontOrig = this.notification.getFont();
            this.notification.setFont(new Font("Courier New", fontOrig.getStyle(), 12));
            Dimension dimension = new Dimension();
            dimension.height = 100;
            this.setSize(dimension);
            this.add((Component)this.textLabel, gdc);
            gdc.weightx = 2.0;
            gdc.fill = 2;
            this.add((Component)new JLabel(), gdc);
            gdc.fill = 0;
            gdc.weightx = 0.0;
            gdc.insets.right = 5;
            this.add((Component)this.notification, gdc);
        }

        public void setCarretPosition(int carretPosition) {
            this.calculatePosition(carretPosition);
            this.textLabel.setText("Zeile " + this.line + ", Spalte " + this.column);
            PLCodeEditor.this.fireStatusChange(this.textLabel.getText());
        }

        public void setNotification(String notificationText) {
            this.notification.setText(notificationText);
        }

        private void calculatePosition(int carretPosition) {
            Element root = PLCodeEditor.this.textPane.getDocument().getDefaultRootElement();
            int lineIndex = root.getElementIndex(carretPosition);
            Element lineElement = root.getElement(lineIndex);
            int lineStartOffset = lineElement.getStartOffset();
            int column = carretPosition - lineStartOffset;
            this.line = lineIndex + 1;
            this.column = column + 1;
        }
    }
}

