/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.ui.material;

import de.statspez.pleditor.generator.interpreter.SimpleDataset;
import de.statspez.pleditor.generator.meta.generated.MetaPLMaterial;
import de.statspez.pleditor.ui.material.CSVReaderProvider;
import de.statspez.pleditor.ui.material.DefaultCSVReaderProvider;
import de.statspez.pleditor.ui.material.MaterialEditorConfig;
import de.statspez.pleditor.ui.material.MaterialTableModel;
import de.statspez.pleditor.ui.material.ReferenzMaterialienInterface;
import de.statspez.pleditor.ui.structureditor.data.Node;
import de.statspez.pleditor.ui.structureditor.data.NodeBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class MaterialEditor
extends JPanel {
    List structure = new ArrayList();
    private JScrollPane pane;
    private JToolBar toolBar;
    private AddValueAction addAction;
    private RemoveValueAction removeAction;
    private JTable table;
    private ImportAction importAction;
    private static final long serialVersionUID = 4991012991840175649L;
    private final MaterialEditorConfig config;

    public MaterialEditor(MetaPLMaterial material, ReferenzMaterialienInterface satz) {
        this(new MaterialEditorConfig(material, satz));
    }

    public MaterialEditor(MaterialEditorConfig config) {
        this.config = config;
        MetaPLMaterial material = config.getMaterial();
        ReferenzMaterialienInterface satz = config.getSatz();
        Node node = new NodeBuilder().build(material.getThemenbereich(), new SimpleDataset(new HashMap()), false);
        this.extractLeaf(node);
        this.table = new JTable(new MaterialTableModel(this.structure, satz));
        this.table.setSelectionMode(0);
        GridBagConstraints gdc = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.toolBar.setAlignmentX(1.0f);
        JPanel toolPanel = new JPanel(new BorderLayout());
        toolPanel.add((Component)this.toolBar, "East");
        if (config.isAllowCSVImport()) {
            this.importAction = new ImportAction();
            this.toolBar.add(this.importAction);
        }
        this.addAction = new AddValueAction();
        this.toolBar.add(this.addAction);
        this.removeAction = new RemoveValueAction();
        this.toolBar.add(this.removeAction);
        gdc.fill = 2;
        gdc.weightx = 1.0;
        gdc.gridy = 0;
        gdc.gridx = 0;
        this.add((Component)toolPanel, gdc);
        gdc.fill = 1;
        gdc.anchor = 12;
        gdc.weightx = 1.0;
        ++gdc.gridy;
        gdc.weighty = 1.0;
        this.table.setAutoResizeMode(0);
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.getViewport().setBackground(this.table.getBackground());
        this.add((Component)scrollPane, gdc);
    }

    private void extractLeaf(Node node) {
        if (!node.hasChild()) {
            int[] indizes = node.getFeldDeskriptor().getIndizes();
            if (indizes == null || indizes.length == 0 || indizes[0] != -1) {
                this.structure.add(node.getFeldDeskriptor());
            } else {
                System.out.println("N - Dimensioniert");
            }
        } else {
            int i = 0;
            while (i < node.getChildCount()) {
                this.extractLeaf(node.getChild(i));
                ++i;
            }
        }
    }

    public JScrollPane getRoot() {
        return this.pane;
    }

    private class AddValueAction
    extends AbstractAction {
        private static final long serialVersionUID = 4935853279687695697L;
        HashMap map = new HashMap();

        public AddValueAction() {
            this.putValue("ShortDescription", "Wert hinzuf\u00fcgen");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/de/statspez/pleditor/ui/structureditor/add.gif")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MaterialTableModel model = (MaterialTableModel)MaterialEditor.this.table.getModel();
            model.addNewRow();
            MaterialEditor.this.table.updateUI();
        }
    }

    private class ImportAction
    extends AbstractAction {
        private static final long serialVersionUID = 1750637527483703265L;

        public ImportAction() {
            this.putValue("ShortDescription", "Datens\u00e4tze importieren");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/de/statspez/pleditor/ui/material/import.gif")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileFilter(new FileFilter(){

                @Override
                public String getDescription() {
                    return "CSV Datei";
                }

                @Override
                public boolean accept(File f) {
                    return f.getName().toLowerCase().endsWith(".csv") || f.isDirectory();
                }
            });
            chooser.setDialogTitle("Referenzmaterial Importieren");
            Container parent = MaterialEditor.this.getParent();
            while (parent != null && !(parent instanceof JFrame)) {
                parent = parent.getParent();
            }
            chooser.showDialog(parent, "Importieren");
            File csv = chooser.getSelectedFile();
            String seperation = ",";
            if (csv != null && csv.exists()) {
                Object fstream = null;
                Object inReader = null;
                try {
                    CSVReaderProvider provider = MaterialEditor.this.config.getCsvReaderProvider() != null ? MaterialEditor.this.config.getCsvReaderProvider() : new DefaultCSVReaderProvider();
                    List readCSVFile = provider.readCSVFile(csv);
                    int rowIndex = 0;
                    MaterialTableModel model = (MaterialTableModel)MaterialEditor.this.table.getModel();
                    while (model.getRowCount() > 0) {
                        model.removeRow(model.getRowCount() - 1);
                    }
                    int i = 0;
                    while (i < readCSVFile.size()) {
                        String[] werte = (String[])readCSVFile.get(i);
                        if (werte != null) {
                            model.addNewRow();
                            rowIndex = model.getRowCount() - 1;
                            int d = 0;
                            while (d < werte.length && d < MaterialEditor.this.structure.size()) {
                                model.setValueAt(werte[d], rowIndex, d);
                                ++d;
                            }
                        }
                        ++i;
                    }
                    MaterialEditor.this.table.updateUI();
                }
                catch (FileNotFoundException ex) {
                    JOptionPane.showMessageDialog(parent, "Datei wurde nicht gefunden", "Fehler beim \u00d6ffnen", 0);
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(parent, "Fehler beim Lesen der Datei", "Fehler beim \u00d6ffnen", 0);
                }
            }
        }
    }

    private class RemoveValueAction
    extends AbstractAction {
        private static final long serialVersionUID = 4935853279687695697L;
        HashMap map = new HashMap();

        public RemoveValueAction() {
            this.putValue("ShortDescription", "Wert entfernen");
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/de/statspez/pleditor/ui/structureditor/delete.gif")));
            MaterialEditor.this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (MaterialEditor.this.table.getSelectedRow() == -1) {
                        RemoveValueAction.this.setEnabled(false);
                    } else {
                        RemoveValueAction.this.setEnabled(true);
                    }
                }
            });
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MaterialEditor.this.table.getSelectedRow() != -1) {
                int row = MaterialEditor.this.table.getSelectedRow();
                MaterialTableModel model = (MaterialTableModel)MaterialEditor.this.table.getModel();
                model.removeRow(MaterialEditor.this.table.getSelectedRow());
                MaterialEditor.this.table.updateUI();
                if (MaterialEditor.this.table.getModel().getRowCount() >= row) {
                    --row;
                }
                if (MaterialEditor.this.table.getModel().getRowCount() == 0) {
                    this.setEnabled(false);
                } else {
                    MaterialEditor.this.table.getSelectionModel().setLeadSelectionIndex(row);
                }
            }
        }
    }
}

