/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.ui.search;

import de.statspez.pleditor.ui.editor.EditableDocument;
import de.statspez.pleditor.ui.editor.PLCodeEditor;
import de.statspez.pleditor.ui.search.SearchUtil;
import de.statspez.pleditor.ui.search.WordPosition;
import de.statspez.pleditor.ui.settings.SettingsProvider;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class SearchDialog
extends JDialog
implements WindowListener {
    private static final long serialVersionUID = 6704355118507944871L;
    private JTextField searchField;
    private JCheckBox fullWord;
    private JCheckBox caseSensitive;
    private String searchValue;
    private JTextField replaceField;
    private JButton cancle;
    private JButton replace;
    private JButton search;
    private JButton replaceAll;
    private Highlighter hilit;
    private Highlighter.HighlightPainter painter;
    private JTextComponent codeEditor;
    private PLCodeEditor plCodeEditor;
    private WordPosition replacePosition;
    private SearchUtil util = new SearchUtil();

    public SearchDialog(JDialog owner, PLCodeEditor plCodeEditor) {
        super(owner);
        this.init(plCodeEditor);
    }

    public SearchDialog(JFrame owner, PLCodeEditor plCodeEditor) {
        super(owner);
        this.init(plCodeEditor);
    }

    public SearchDialog(PLCodeEditor plCodeEditor) {
        this.init(plCodeEditor);
    }

    private void init(PLCodeEditor plCodeEditor) {
        this.addWindowListener(this);
        this.plCodeEditor = plCodeEditor;
        this.codeEditor = this.plCodeEditor.getTextComponent();
        this.util.setActualPos(this.codeEditor.getCaretPosition());
        this.hilit = new DefaultHighlighter();
        this.painter = new DefaultHighlighter.DefaultHighlightPainter(SettingsProvider.getInstance().getColor("selection.highligter"));
        this.codeEditor.setHighlighter(this.hilit);
        this.setTitle("Suchen und Ersetzen");
        this.setLayout(new GridBagLayout());
        GridBagConstraints gdc = new GridBagConstraints();
        gdc.anchor = 11;
        gdc.gridx = 1;
        gdc.fill = 1;
        gdc.weightx = 2.0;
        gdc.insets.left = 10;
        gdc.insets.right = 10;
        this.add((Component)this.initWidget(), gdc);
        gdc.weightx = 1.0;
        gdc.insets.left = 0;
        ++gdc.gridx;
        this.add(this.initButtons(), gdc);
        int width = 350;
        int height = 185;
        this.setSize(width, height);
        Point location = plCodeEditor.getLocationOnScreen();
        Dimension size = plCodeEditor.getSize();
        Point centerdWindow = new Point();
        centerdWindow.setLocation(location.getX() + size.getWidth() / 2.0 - (double)(width / 2), location.getY() + size.getHeight() / 2.0 - (double)(height / 2));
        this.setLocation(centerdWindow);
        this.setResizable(false);
        this.setModal(true);
    }

    @Override
    protected JRootPane createRootPane() {
        JRootPane pane = super.createRootPane();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        pane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchDialog.this.setVisible(false);
            }
        }, keyStroke, 2);
        return pane;
    }

    private void search() {
        this.replace.setEnabled(false);
        this.replaceAll.setEnabled(false);
        this.hilit.removeAllHighlights();
        WordPosition search = this.util.search(this.searchField.getText(), this.codeEditor.getText());
        if (search.isFound()) {
            this.replacePosition = search;
            try {
                this.hilit.addHighlight(search.getStart(), this.searchField.getText().length() + search.getStart(), this.painter);
                this.codeEditor.setCaretPosition(search.getStart() + this.searchField.getText().length());
                Document document = this.codeEditor.getDocument();
                if (document != null && document instanceof EditableDocument) {
                    EditableDocument editableDocument = (EditableDocument)document;
                    if (!editableDocument.isWriteProtected()) {
                        this.replace.setEnabled(true);
                        this.replaceAll.setEnabled(true);
                    }
                } else if (this.codeEditor.isEditable()) {
                    this.replace.setEnabled(true);
                    this.replaceAll.setEnabled(true);
                }
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
        }
    }

    private Component initButtons() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gdc = new GridBagConstraints();
        gdc.gridx = 1;
        gdc.insets.bottom = 10;
        ++gdc.gridy;
        gdc.anchor = 11;
        gdc.fill = 2;
        this.search = new JButton("Weitersuchen");
        this.replace = new JButton("Ersetzen");
        this.replaceAll = new JButton("Alle ersetzen");
        this.cancle = new JButton("Abbrechen");
        this.replace.setEnabled(false);
        this.replaceAll.setEnabled(false);
        this.search.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchDialog.this.search();
            }
        });
        this.replace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String newCodeText = SearchDialog.this.util.replace(SearchDialog.this.replacePosition, SearchDialog.this.searchField.getText(), SearchDialog.this.replaceField.getText(), SearchDialog.this.codeEditor.getText());
                SearchDialog.this.codeEditor.setText(newCodeText);
                SearchDialog.this.codeEditor.setCaretPosition(SearchDialog.this.util.getActualPos());
                SearchDialog.this.search();
                SearchDialog.this.replace.requestFocusInWindow();
            }
        });
        this.replaceAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String newCodeText = SearchDialog.this.codeEditor.getText();
                newCodeText = SearchDialog.this.util.replaceAll(SearchDialog.this.searchField.getText(), SearchDialog.this.replaceField.getText(), newCodeText);
                SearchDialog.this.codeEditor.setText(newCodeText);
                SearchDialog.this.search();
            }
        });
        this.cancle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchDialog.this.hilit.removeAllHighlights();
                SearchDialog.this.plCodeEditor.setNotification("");
                SearchDialog.this.setVisible(false);
            }
        });
        panel.add((Component)this.search, gdc);
        ++gdc.gridy;
        panel.add((Component)this.replace, gdc);
        ++gdc.gridy;
        panel.add((Component)this.replaceAll, gdc);
        ++gdc.gridy;
        panel.add((Component)this.cancle, gdc);
        return panel;
    }

    protected JPanel initWidget() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setSize(200, 100);
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel sucheName = new JLabel("Suchen nach:");
        this.searchField = new JTextField();
        this.searchField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (SearchDialog.this.replace != null) {
                    SearchDialog.this.replace.setEnabled(false);
                }
                if (SearchDialog.this.replaceAll != null) {
                    SearchDialog.this.replaceAll.setEnabled(false);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        if (this.searchValue != null) {
            this.searchField.setText(this.searchValue);
        }
        JLabel replaceLabel = new JLabel("Ersetzen durch:");
        this.replaceField = new JTextField();
        if (!this.codeEditor.isEditable()) {
            replaceLabel.setEnabled(false);
            this.replaceField.setEnabled(false);
        }
        this.fullWord = new JCheckBox("Nur ganzes Wort suchen");
        this.fullWord.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent paramChangeEvent) {
                SearchDialog.this.util.setFullWord(SearchDialog.this.fullWord.isSelected());
            }
        });
        this.util.setFullWord(this.fullWord.isSelected());
        this.caseSensitive = new JCheckBox("Gro\u00df-/Kleinschreibung beachten");
        this.caseSensitive.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent paramChangeEvent) {
                SearchDialog.this.util.setCaseSensitive(SearchDialog.this.caseSensitive.isSelected());
            }
        });
        this.util.setCaseSensitive(this.caseSensitive.isSelected());
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets.top = 5;
        gbc.anchor = 17;
        panel.add((Component)sucheName, gbc);
        ++gbc.gridy;
        panel.add((Component)replaceLabel, gbc);
        --gbc.gridy;
        gbc.anchor = 13;
        gbc.insets.left = 5;
        gbc.gridx = 1;
        gbc.weightx = 2.0;
        gbc.fill = 2;
        gbc.insets.left = 10;
        panel.add((Component)this.searchField, gbc);
        ++gbc.gridy;
        gbc.insets.top = 10;
        panel.add((Component)this.replaceField, gbc);
        ++gbc.gridy;
        gbc.insets.left = 0;
        gbc.insets.top = 10;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.insets.top = 10;
        gbc.gridwidth = 2;
        ++gbc.gridy;
        panel.add((Component)this.fullWord, gbc);
        gbc.insets.top = 0;
        ++gbc.gridy;
        panel.add((Component)this.caseSensitive, gbc);
        return panel;
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.hilit.removeAllHighlights();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

