/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.ui.settings;

import de.statspez.pleditor.ui.settings.CustomRectangleIcon;
import de.statspez.pleditor.ui.settings.SettingsProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class EditorSetting
extends JDialog
implements TableModel,
MouseListener {
    private static final long serialVersionUID = 8087414176266560906L;
    private boolean settingChanged = false;
    private JTable table;
    private Map colorMap;
    private String[] keyArrays;
    private Map humanReadableNames;
    private Map orignMap;
    private JButton okButton;
    private JButton cancelButton;
    private JButton restorebutton;
    private JButton editButton;
    private CustomRectangleIcon rectangle;

    public EditorSetting(JDialog owner) {
        super(owner);
        this.init(owner);
    }

    public EditorSetting(Component owner) {
        this.init(owner);
    }

    private void init(Component owner) {
        this.settingChanged = false;
        this.orignMap = SettingsProvider.getInstance().getColorMap();
        this.reloadColors();
        this.setModal(true);
        this.setResizable(false);
        this.initWidgetElements();
        this.pack();
        int width = this.getSize().width;
        int height = this.getSize().height;
        Point location = owner.getLocationOnScreen();
        Dimension size = owner.getSize();
        Point centerdWindow = new Point();
        centerdWindow.setLocation(location.getX() + size.getWidth() / 2.0 - (double)(width / 2), location.getY() + size.getHeight() / 2.0 - (double)(height / 2));
        this.setLocation(centerdWindow);
    }

    private void reloadColors() {
        this.keyArrays = this.orignMap.keySet().toArray(new String[0]);
        this.colorMap = new HashMap();
        int i = 0;
        while (i < this.keyArrays.length) {
            Color orignColor = (Color)this.orignMap.get(this.keyArrays[i]);
            Color c = new Color(orignColor.getRGB());
            this.colorMap.put(this.keyArrays[i], c);
            ++i;
        }
        this.humanReadableNames = SettingsProvider.getInstance().getHumanreadablenames();
    }

    private JButton getEditButton() {
        if (this.editButton == null) {
            this.rectangle = new CustomRectangleIcon();
            this.rectangle.setDimension(new Dimension(40, 10));
            this.editButton = new JButton(this.rectangle);
            this.editButton.setEnabled(false);
        }
        return this.editButton;
    }

    private CustomRectangleIcon getRectangle() {
        return this.rectangle;
    }

    private void initWidgetElements() {
        this.setTitle("Einstellung");
        this.setLayout(new GridBagLayout());
        GridBagConstraints gdc = new GridBagConstraints();
        gdc.insets.left = 10;
        gdc.insets.top = 10;
        gdc.anchor = 21;
        gdc.gridx = 1;
        gdc.gridy = 1;
        gdc.fill = 2;
        JLabel ueberschrift = new JLabel("Farbprofil");
        this.add((Component)ueberschrift, gdc);
        ++gdc.gridy;
        gdc.weightx = 1.0;
        gdc.weighty = 1.0;
        gdc.fill = 1;
        this.table = new JTable();
        this.table.setModel(this);
        this.table.addMouseListener(this);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row = EditorSetting.this.table.getSelectedRow();
                if (row > -1) {
                    Color color = (Color)EditorSetting.this.colorMap.get(EditorSetting.this.keyArrays[row]);
                    EditorSetting.this.getRectangle().setColor(color);
                    EditorSetting.this.getEditButton().setEnabled(true);
                    EditorSetting.this.getEditButton().repaint();
                }
            }
        });
        this.table.setTableHeader(null);
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.getViewport().setPreferredSize(this.table.getPreferredSize());
        this.add((Component)scrollPane, gdc);
        ++gdc.gridx;
        gdc.insets.right = 10;
        gdc.weightx = 0.0;
        gdc.weighty = 0.0;
        gdc.anchor = 11;
        gdc.fill = 0;
        JButton editButton = this.getEditButton();
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow = EditorSetting.this.table.getSelectedRow();
                if (selectedRow == -1) {
                    JOptionPane.showMessageDialog(EditorSetting.this, "Bitte w\u00e4hlen sie ein Eigenschaft die Sie bearbeiten m\u00f6chen", "Achtung", 1);
                } else {
                    Color color = (Color)EditorSetting.this.colorMap.get(EditorSetting.this.keyArrays[selectedRow]);
                    Color choosedColor = JColorChooser.showDialog(EditorSetting.this, "Farbeausw\u00e4hlen", color);
                    if (choosedColor != null) {
                        EditorSetting.this.colorMap.put(EditorSetting.this.keyArrays[selectedRow], choosedColor);
                        color = choosedColor;
                    }
                    EditorSetting.this.getRectangle().setColor(color);
                    EditorSetting.this.getEditButton().repaint();
                    EditorSetting.this.table.repaint();
                }
            }
        });
        this.add((Component)editButton, gdc);
        gdc.gridx = 1;
        ++gdc.gridy;
        JPanel formatPanel = new JPanel(new GridBagLayout());
        GridBagConstraints formatGdc = new GridBagConstraints();
        ++formatGdc.gridx;
        ++formatGdc.gridy;
        formatGdc.weightx = 2.0;
        formatGdc.fill = 2;
        JLabel format = new JLabel("Einr\u00fcckung");
        formatPanel.add((Component)format, formatGdc);
        final JTextField formatInput = new JTextField();
        formatInput.setText(String.valueOf(SettingsProvider.getInstance().getIndentSpaces()));
        ++formatGdc.gridx;
        formatGdc.weightx = 3.0;
        formatPanel.add((Component)formatInput, formatGdc);
        gdc.fill = 2;
        this.add((Component)formatPanel, gdc);
        JPanel buttons = new JPanel(new FlowLayout());
        this.okButton = new JButton("Anwenden");
        buttons.add(this.okButton);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = formatInput.getText();
                try {
                    int spaces = Integer.parseInt(text);
                    if (spaces < 0) {
                        throw new Exception();
                    }
                    SettingsProvider.getInstance().setIndentSpaces(spaces);
                }
                catch (Throwable t) {
                    JOptionPane.showMessageDialog(EditorSetting.this, "Die anzahl der Einr\u00fcckung muss eine Zahl und darf nicht kleiner 0 sein", "Fehler", 0);
                    return;
                }
                int i = 0;
                while (i < EditorSetting.this.keyArrays.length) {
                    Color orignColor = (Color)EditorSetting.this.colorMap.get(EditorSetting.this.keyArrays[i]);
                    EditorSetting.this.orignMap.put(EditorSetting.this.keyArrays[i], orignColor);
                    ++i;
                }
                EditorSetting.this.settingChanged = true;
                EditorSetting.this.setVisible(false);
            }
        });
        this.cancelButton = new JButton("Abbrechen");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorSetting.this.setVisible(false);
            }
        });
        buttons.add(this.cancelButton);
        gdc.gridx = 1;
        ++gdc.gridy;
        gdc.fill = 0;
        gdc.anchor = 13;
        gdc.insets.right = 0;
        this.add((Component)buttons, gdc);
        ++gdc.gridx;
        gdc.insets.right = 10;
        gdc.anchor = 17;
        this.restorebutton = new JButton("Zur\u00fccksetzen");
        this.restorebutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HashMap tmpOrignMap = new HashMap();
                int i = 0;
                while (i < EditorSetting.this.keyArrays.length) {
                    tmpOrignMap.put(EditorSetting.this.keyArrays[i], EditorSetting.this.orignMap.get(EditorSetting.this.keyArrays[i]));
                    ++i;
                }
                SettingsProvider.getInstance().resetSettings();
                EditorSetting.this.reloadColors();
                i = 0;
                while (i < EditorSetting.this.keyArrays.length) {
                    EditorSetting.this.orignMap.put(EditorSetting.this.keyArrays[i], tmpOrignMap.get(EditorSetting.this.keyArrays[i]));
                    ++i;
                }
                formatInput.setText(String.valueOf(SettingsProvider.getInstance().getIndentSpaces()));
                int selectedRow = EditorSetting.this.table.getSelectedRow();
                if (selectedRow > -1) {
                    Color color = (Color)EditorSetting.this.colorMap.get(EditorSetting.this.keyArrays[selectedRow]);
                    EditorSetting.this.getRectangle().setColor(color);
                    EditorSetting.this.getEditButton().repaint();
                }
                EditorSetting.this.table.repaint();
            }
        });
        this.add((Component)this.restorebutton, gdc);
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return "Kategorie";
    }

    @Override
    public int getRowCount() {
        return this.colorMap.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.humanReadableNames.get(this.keyArrays[rowIndex]);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        JTable table = (JTable)e.getSource();
        Point p = e.getPoint();
        int row = table.rowAtPoint(p);
        if (e.getClickCount() == 2) {
            Color color = (Color)this.colorMap.get(this.keyArrays[row]);
            Color choosedColor = JColorChooser.showDialog(this, "Farbeausw\u00e4hlen", color);
            if (choosedColor != null) {
                this.colorMap.put(this.keyArrays[row], choosedColor);
                color = choosedColor;
            }
            this.getRectangle().setColor(color);
            this.getEditButton().setEnabled(true);
            this.getEditButton().repaint();
            table.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public boolean isSettingChanged() {
        return this.settingChanged;
    }

    public Properties getSettingsProperties() {
        return SettingsProvider.getInstance().getSettingsProperties();
    }
}

