/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.ui.settings;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.UIManager;

public class SettingsProvider {
    private static final Color DEFAULT_TEXT_COLOR = Color.black;
    private static final Color DEFAULT_KEYWORD_COLOR = Color.blue;
    private static final Color DEFAULT_COMMENT_COLOR = Color.gray;
    private static final Color DEFAULT_NUMBER_COLOR = Color.orange.darker();
    private static final Color DEFAULT_STRING_COLOR = Color.green.darker();
    private static final Color DEFAULT_MISC_SYMBOL_COLOR = Color.red.darker();
    private static final Color DEFAULT_OPERATOR_SYMBOL_COLOR = Color.red.darker();
    private static final Color DEFAULT_OPERATOR_KEYWORD_COLOR = Color.red.darker();
    private static final Color DEFAULT_BACKGROUND_COLOR = Color.white;
    private static final Color DEFAULT_DISABLED_BACKGROUND_COLOR;
    private static final Color DEFAULT_SELECTION_HIGHLIGTER;
    private static final int DEFAULT_INDENT_SPACES = 4;
    public static final String TEXT_COLOR = "text.color";
    public static final String COMMENT_COLOR = "comment.color";
    public static final String NUMBER_COLOR = "number.color";
    public static final String STRING_COLOR = "string.color";
    public static final String MISC_SYMBOL_COLOR = "misc.symbol.color";
    public static final String OPERATOR_SYMBOL_COLOR = "operator.symbol.color";
    public static final String OPERATOR_KEYWORD_COLOR = "operator.keyword.color";
    public static final String KEYWORD_COLOR = "keyword.color";
    public static final String BACKGROUND_COLOR = "background.color";
    public static final String DISABLED_BACKGROUND_COLOR = "disabledbackground.color";
    public static final String SELECTION_HIGHLIGTER = "selection.highligter";
    public static final String INDENT_SPACES = "indent.spaces";
    public static int indentSpaces;
    private Map colorMap = new HashMap();
    private static final Map humanReadableNames;
    private static final SettingsProvider instance;
    private boolean defaultSettings = true;
    private String seperator = "-";
    private String standardPropertiesFileName = "settings.properties";

    static {
        Color tmp = UIManager.getColor("Panel.background");
        if (tmp == null) {
            tmp = Color.lightGray;
        }
        DEFAULT_DISABLED_BACKGROUND_COLOR = tmp;
        DEFAULT_SELECTION_HIGHLIGTER = Color.gray.brighter();
        indentSpaces = 4;
        humanReadableNames = new HashMap();
        instance = new SettingsProvider();
    }

    private SettingsProvider() {
        humanReadableNames.put(TEXT_COLOR, "Standardschrift");
        humanReadableNames.put(COMMENT_COLOR, "Kommentar");
        humanReadableNames.put(NUMBER_COLOR, "Zahlen");
        humanReadableNames.put(STRING_COLOR, "Zeichenkette");
        humanReadableNames.put(MISC_SYMBOL_COLOR, "Verschiede Zeichen");
        humanReadableNames.put(OPERATOR_KEYWORD_COLOR, "Operatorw\u00f6rter");
        humanReadableNames.put(OPERATOR_SYMBOL_COLOR, "Operatoren");
        humanReadableNames.put(KEYWORD_COLOR, "Schl\u00fcsselw\u00f6rter");
        humanReadableNames.put(BACKGROUND_COLOR, "Hintergrund");
        humanReadableNames.put(DISABLED_BACKGROUND_COLOR, "Schreibschutz-Hintergrund");
        humanReadableNames.put(SELECTION_HIGHLIGTER, "Markierung");
        this.resetSettings();
    }

    public void resetSettings() {
        this.setColor(TEXT_COLOR, DEFAULT_TEXT_COLOR);
        this.setColor(COMMENT_COLOR, DEFAULT_COMMENT_COLOR);
        this.setColor(NUMBER_COLOR, DEFAULT_NUMBER_COLOR);
        this.setColor(STRING_COLOR, DEFAULT_STRING_COLOR);
        this.setColor(MISC_SYMBOL_COLOR, DEFAULT_MISC_SYMBOL_COLOR);
        this.setColor(OPERATOR_SYMBOL_COLOR, DEFAULT_OPERATOR_SYMBOL_COLOR);
        this.setColor(OPERATOR_KEYWORD_COLOR, DEFAULT_OPERATOR_KEYWORD_COLOR);
        this.setColor(KEYWORD_COLOR, DEFAULT_KEYWORD_COLOR);
        this.setColor(BACKGROUND_COLOR, DEFAULT_BACKGROUND_COLOR);
        this.setColor(DISABLED_BACKGROUND_COLOR, DEFAULT_DISABLED_BACKGROUND_COLOR);
        this.setColor(SELECTION_HIGHLIGTER, DEFAULT_SELECTION_HIGHLIGTER);
        indentSpaces = 4;
        this.defaultSettings = true;
    }

    private void setColor(String colorKey, Color color) {
        if (this.colorMap.containsKey(colorKey)) {
            this.colorMap.remove(colorKey);
        }
        this.colorMap.put(colorKey, color);
    }

    public Color getColor(String colorKey) {
        if (this.colorMap.containsKey(colorKey)) {
            return (Color)this.colorMap.get(colorKey);
        }
        return new Color(0, 0, 0);
    }

    public void setSettings(Properties properties) {
        this.setValueFromProperties(properties, TEXT_COLOR);
        this.setValueFromProperties(properties, COMMENT_COLOR);
        this.setValueFromProperties(properties, NUMBER_COLOR);
        this.setValueFromProperties(properties, STRING_COLOR);
        this.setValueFromProperties(properties, MISC_SYMBOL_COLOR);
        this.setValueFromProperties(properties, OPERATOR_SYMBOL_COLOR);
        this.setValueFromProperties(properties, OPERATOR_KEYWORD_COLOR);
        this.setValueFromProperties(properties, KEYWORD_COLOR);
        this.setValueFromProperties(properties, BACKGROUND_COLOR);
        this.setValueFromProperties(properties, DISABLED_BACKGROUND_COLOR);
        this.setValueFromProperties(properties, SELECTION_HIGHLIGTER);
        String indentLevelString = (String)properties.get(INDENT_SPACES);
        if (indentLevelString != null) {
            indentSpaces = Integer.parseInt(indentLevelString);
        }
        this.defaultSettings = false;
    }

    public Properties getSettingsProperties() {
        Properties properties = new Properties();
        this.getValueForProperties(properties, TEXT_COLOR);
        this.getValueForProperties(properties, COMMENT_COLOR);
        this.getValueForProperties(properties, NUMBER_COLOR);
        this.getValueForProperties(properties, STRING_COLOR);
        this.getValueForProperties(properties, MISC_SYMBOL_COLOR);
        this.getValueForProperties(properties, BACKGROUND_COLOR);
        this.getValueForProperties(properties, DISABLED_BACKGROUND_COLOR);
        this.getValueForProperties(properties, OPERATOR_SYMBOL_COLOR);
        this.getValueForProperties(properties, OPERATOR_KEYWORD_COLOR);
        this.getValueForProperties(properties, KEYWORD_COLOR);
        this.getValueForProperties(properties, SELECTION_HIGHLIGTER);
        properties.put(INDENT_SPACES, String.valueOf(indentSpaces));
        return properties;
    }

    private void getValueForProperties(Properties properties, String propertyKey) {
        Color color = (Color)this.colorMap.get(propertyKey);
        properties.put(propertyKey, String.valueOf(color.getRed()) + "-" + color.getGreen() + "-" + color.getBlue());
    }

    private void setValueFromProperties(Properties properties, String colorKey) {
        if (properties.containsKey(colorKey)) {
            Color parsedColor = this.parseColor((String)properties.get(colorKey));
            this.setColor(colorKey, parsedColor);
        }
    }

    private Color parseColor(String colorString) {
        String[] colors = colorString.trim().split(this.seperator);
        Color result = null;
        if (colors.length == 3) {
            int red = Integer.parseInt(colors[0]);
            int green = Integer.parseInt(colors[1]);
            int blue = Integer.parseInt(colors[2]);
            result = new Color(red, green, blue);
        }
        if (result == null) {
            result = new Color(0, 0, 0);
        }
        return result;
    }

    public boolean isDefaultSettings() {
        return this.defaultSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SettingsProvider getInstance() {
        SettingsProvider settingsProvider = instance;
        synchronized (settingsProvider) {
            return instance;
        }
    }

    public void setSeperator(String seperator) {
        this.seperator = seperator;
    }

    public String getSeperator() {
        return this.seperator;
    }

    public Map getColorMap() {
        return this.colorMap;
    }

    public Map getHumanreadablenames() {
        return humanReadableNames;
    }

    public int getIndentSpaces() {
        return indentSpaces;
    }

    public void setIndentSpaces(int spaces) {
        indentSpaces = spaces;
    }
}

