/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.ui.structureditor.data;

import de.statspez.pleditor.generator.meta.MetaCustomInitwert;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaCustomVariable;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import de.statspez.pleditor.generator.runtime.InvalidValue;
import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.ValueFactory;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import java.util.ArrayList;
import java.util.List;

public class Node {
    private List children = new ArrayList();
    private final FeldDeskriptorImpl feldDeskriptor;
    private final SatzInterface satz;
    private MetaElement element;
    private final Node parent;
    private final boolean virtual;
    private final boolean localVar;

    public Node(Node parent, MetaElement element, FeldDeskriptorImpl fieldDecriptor, boolean virtual, SatzInterface satz) {
        this(parent, element, fieldDecriptor, virtual, satz, false);
    }

    public Node(Node parent, MetaElement element, FeldDeskriptorImpl fieldDecriptor, boolean virtual, SatzInterface satz, boolean lokal) {
        this.parent = parent;
        this.element = element;
        this.feldDeskriptor = fieldDecriptor;
        this.virtual = virtual;
        this.satz = satz;
        if (this.parent != null) {
            parent.addChild(this);
        }
        this.localVar = lokal;
    }

    public boolean hasChild() {
        return this.children.size() > 0;
    }

    public int indexOfChild(Node paramObject) {
        return this.children.indexOf(paramObject);
    }

    public void setValue(String value) {
        if (this.satz != null && this.getFeldDeskriptor() != null) {
            try {
                if (value != null && value.length() > 0) {
                    this.feldDeskriptor.setValueWith(this.satz, ValueFactory.instance().valueFor(value), true);
                } else {
                    this.feldDeskriptor.setValueWith(this.satz, InvalidValue.instance());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getValue() {
        Value value;
        String result = null;
        if (this.satz != null && this.feldDeskriptor != null && (value = this.feldDeskriptor.getValueFrom(this.satz, true)) != null && value.isValid()) {
            result = value.asString();
        }
        return result;
    }

    public void addChild(Node child) {
        this.children.add(child);
    }

    public void removeChild(Node child) {
        this.children.remove(child);
    }

    public Node getChild(int index) {
        return (Node)this.children.get(index);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public MetaElement getElement() {
        return this.element;
    }

    public void setElement(MetaElement element) {
        this.element = element;
    }

    public FeldDeskriptorImpl getFeldDeskriptor() {
        return this.feldDeskriptor;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public String toString() {
        String text;
        if (this.element instanceof MetaThemenbereich) {
            text = ((MetaThemenbereich)this.element).getName();
        } else if (this.element instanceof MetaCustomTBFeld) {
            StringBuffer buffer = new StringBuffer();
            MetaCustomTBFeld field = (MetaCustomTBFeld)this.element;
            buffer.append(field.getName());
            if (this.feldDeskriptor.getIndizes() != null && this.feldDeskriptor.getIndizes().length > 0) {
                buffer.append(' ');
                int i = 0;
                while (i < this.feldDeskriptor.getIndizes().length) {
                    buffer.append('[');
                    buffer.append(this.feldDeskriptor.getIndizes()[i] + 1);
                    buffer.append(']');
                    ++i;
                }
            } else if (field.dimensions() != null && field.dimensions().length == 1) {
                int i = field.dimensions()[0];
                if (i == -1) {
                    buffer.append("[N]");
                } else {
                    buffer.append("[");
                    buffer.append(i);
                    buffer.append("]");
                }
            }
            text = buffer.toString();
        } else if (this.element instanceof MetaCustomInitwert) {
            MetaCustomInitwert variable = (MetaCustomInitwert)this.element;
            text = variable.getName();
        } else {
            MetaCustomVariable variable = (MetaCustomVariable)this.element;
            text = variable.getName();
        }
        return text;
    }

    public boolean isLocalVar() {
        return this.localVar;
    }

    public boolean equals(Object obj) {
        return obj == this;
    }
}

