/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.ui.structureditor.data;

import de.statspez.pleditor.generator.interpreter.TBFieldDescriptorFactory;
import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaCustomInitwert;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaCustomVariable;
import de.statspez.pleditor.generator.meta.generated.MetaPLInitwert;
import de.statspez.pleditor.generator.meta.generated.MetaPLVariable;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.generator.runtime.FeatureVariable;
import de.statspez.pleditor.generator.runtime.FeldDeskriptor;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import de.statspez.pleditor.ui.structureditor.data.Node;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NodeBuilder
extends AbstractElementVisitor {
    private Node currentNode;
    private SatzInterface satz;
    private TBFieldDescriptorFactory fieldDescriptorFactory;
    private Map nodeMap;
    private boolean withPlVars;

    public synchronized Node build(MetaThemenbereich topic, SatzInterface satz) {
        return this.build(topic, satz, null, null, true);
    }

    public Node build(MetaThemenbereich topic, SatzInterface satz, boolean b) {
        return this.build(topic, satz, null, null, b);
    }

    public synchronized Node build(MetaThemenbereich topic, SatzInterface satz, List localvars, SatzInterface localsatz) {
        return this.build(topic, satz, localvars, localsatz, true);
    }

    public synchronized Node build(MetaThemenbereich topic, SatzInterface satz, List localvars, SatzInterface localsatz, boolean withPlVars) {
        this.withPlVars = withPlVars;
        Node node = null;
        this.nodeMap = new HashMap();
        if (topic != null) {
            this.fieldDescriptorFactory = new TBFieldDescriptorFactory(topic);
            this.currentNode = node = new Node(null, topic, null, false, this.satz);
            this.satz = satz;
            this.visitElements(topic.getFelder());
            this.visitElements(topic.getVariablen());
            this.visitElements(topic.getInitialisierungswerte());
        }
        if (node == null) {
            MetaThemenbereich metaThemenbereich = new MetaThemenbereich();
            FeldDeskriptor deskriptor = new FeldDeskriptor(null, "root", null, 7);
            FeatureVariable feldDeskriptor = new FeatureVariable(null, deskriptor, new int[0]);
            node = new Node(null, metaThemenbereich, feldDeskriptor, false, null);
        }
        if (localsatz != null && localvars != null) {
            int i = 0;
            while (i < localvars.size()) {
                FeldDeskriptorImpl desktriptor = (FeldDeskriptorImpl)localvars.get(i);
                MetaCustomTBFeld metaCustomTBFeld = new MetaCustomTBFeld();
                metaCustomTBFeld.setName(desktriptor.getFeldNameTB());
                new Node(node, metaCustomTBFeld, desktriptor, false, localsatz, true);
                ++i;
            }
        }
        return node;
    }

    public FeldDeskriptorImpl createFeldDeskriptor(String name, int[] indices, FeldDeskriptorImpl parent) throws NoSuchFieldException {
        return this.fieldDescriptorFactory.getFieldDecriptor(name, indices, parent);
    }

    @Override
    public void visitThemenbereich(MetaThemenbereich tb) {
        this.visitElements(tb.getFelder());
        this.visitElements(tb.getVariablen());
        this.visitElements(tb.getInitialisierungswerte());
    }

    @Override
    public void visitTBFeld(MetaTBFeld feld) {
        Node previousNode = this.currentNode;
        int[] dimensions = ((MetaCustomTBFeld)feld).dimensions();
        try {
            this.currentNode = new Node(previousNode, feld, this.fieldDescriptorFactory.getFieldDecriptor(feld.getName(), null, previousNode.getFeldDeskriptor()), dimensions != null && dimensions.length > 0, this.satz);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        if (dimensions != null && dimensions.length > 0) {
            this.handleDimension(previousNode.getFeldDeskriptor(), feld, dimensions, null);
        } else {
            feld.getKlasse().accept(this);
        }
        this.nodeMap.put(feld.getName(), this.currentNode);
        this.currentNode = previousNode;
    }

    @Override
    public void visitPLVariable(MetaPLVariable variable) {
        if (this.withPlVars) {
            int[] dimensions = ((MetaCustomVariable)variable).dimensions();
            try {
                new Node(this.currentNode, variable, this.fieldDescriptorFactory.getFieldDecriptor(variable.getName(), null, this.currentNode.getFeldDeskriptor()), dimensions != null && dimensions.length > 0, this.satz);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void visitPLInitwert(MetaPLInitwert initwert) {
        if (this.withPlVars) {
            int[] dimensions = ((MetaCustomInitwert)initwert).dimensions();
            try {
                new Node(this.currentNode, initwert, this.fieldDescriptorFactory.getFieldDecriptor(initwert.getName(), null, this.currentNode.getFeldDeskriptor()), dimensions != null && dimensions.length > 0, this.satz);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void handleDimension(FeldDeskriptorImpl parentFeldDeskriptor, MetaTBFeld feld, int[] dimensions, int[] indices) {
        try {
            int size;
            FeldDeskriptorImpl feldDeskriptor = this.fieldDescriptorFactory.getFieldDecriptor(feld.getName(), null, parentFeldDeskriptor);
            int numOfDimension = 0;
            if (indices != null) {
                numOfDimension = indices.length;
            }
            if ((size = dimensions[numOfDimension]) < 0) {
                size = feldDeskriptor.getLaenge(this.satz, indices);
            }
            Node previousNode = this.currentNode;
            int i = 0;
            while (i < size) {
                int[] currentIndices = new int[numOfDimension + 1];
                if (numOfDimension > 0) {
                    int j = 0;
                    while (j < indices.length) {
                        currentIndices[j] = indices[j];
                        ++j;
                    }
                }
                currentIndices[currentIndices.length - 1] = i;
                FeldDeskriptorImpl currentFeldDeskriptor = this.fieldDescriptorFactory.getFieldDecriptor(feld.getName(), currentIndices, parentFeldDeskriptor);
                this.currentNode = new Node(previousNode, feld, currentFeldDeskriptor, currentIndices.length < dimensions.length, this.satz);
                if (currentIndices.length == dimensions.length) {
                    feld.getKlasse().accept(this);
                } else {
                    this.handleDimension(parentFeldDeskriptor, feld, dimensions, currentIndices);
                }
                ++i;
            }
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

