/*
 * Folgende Funktionen muessen von der Laufzeitumgebung implementiert werden:
 *
 * getValue(field)
 * setValue(field, value)
 * getSizeOf(structure)
 * getIndicesAsString(indices)
 * trace(text)
 */

var varValues = new Array();
var referencedFields = null;
var maxReferencedFieldCount = 10;

function PlausiError()
{
	var type = 0;
	var infoType = 0;
  var id = "";
	var message = "";
	var description = "";
	var correctionAdvice = "";
	var field = "";
	var referencedFields = null;
	var fieldType = 0;
	var fieldMask = "";
	var fieldLength = 0;
	var fieldValueSpace = "";
}

function Sequence(f, s, l)
{
	this.first = f;
	this.second = s;
	this.last = l;
}

function Interval(startValue, endValue, operatorValue)
{
	this.first=startValue;
	this.last=endValue;
	this.operator=operatorValue;
} 

function normArray(x)
{
	var result=x;
	for (var i = 0; i < x.length; i++)
	{
		var value = x[i];
		if(value instanceof Sequence)
		{
			var args = new Array(i,1);
			var step = value.second - value.first;
			var counter = 0;
			
			var check = function(){return false};
			if(step<0) check = function(){return counter >= value.last;};
			if(step>0) check = function(){return counter <= value.last;};

			for(counter = value.first; check(); counter+=step)
			{
				args.push(counter);
			}
			x.splice.apply(x, args);
		}
		if(value instanceof Array)
		{
			var args = new Array(i, 1);
			args = args.concat(value);
			x.splice.apply(x, args);
		}
	}
	return result;
}

function getValueString(field)
{
	if (referencedFields != null && referencedFields.length < maxReferencedFieldCount && !contains(field, referencedFields))
	{
		referencedFields.push(field);
	}
	return getValue(field);
}

function getValueInteger(field)
{
	if (referencedFields != null && referencedFields.length < maxReferencedFieldCount && !contains(field, referencedFields))
	{
		referencedFields.push(field);
	}
	var value = getValue(field);
	if (!isValueNull(value))
	{
		value = ALS_GANZZAHL(value);
	}
	return value;
}

function getValueReal(field)
{
	if (referencedFields != null && referencedFields.length < maxReferencedFieldCount && !contains(field, referencedFields))
	{
		referencedFields.push(field);
	}
	var value = getValue(field);
	if (!isValueNull(value))
	{
		value = ALS_KOMMAZAHL(value);
	}
	return value;
}

function getValueDate(field)
{
	return getValueDateMask(field, null);
}

function getValueDateMask(field, mask)
{
	if (referencedFields != null && referencedFields.length < maxReferencedFieldCount && !contains(field, referencedFields))
	{
		referencedFields.push(field);
	}
	return getAsDateMask(getValue(field), mask);
}

function setValueString(field, value)
{
	setValue(field, ALS_ZEICHENKETTE(value));
}

function setValueInteger(field, value)
{
	setValue(field, ALS_ZEICHENKETTE(value));
}

function setValueReal(field, value)
{
	setValue(field, ALS_ZEICHENKETTE(value));
}

function setValueDate(field, value)
{
	setValueDateMask(field, value, null);
}

function setValueDateMask(field, value, mask)
{
	if (isValueNull(value))
	{
		setValue(field, "");
	}
	else if (isInstanceOfDate(value))
	{
		if (isValueNull(mask))
		{
			mask = "TT.MM.JJJJ";
		}

		var dateAsString = "";
		var i = 0;
		while (i < mask.length)
		{
			switch (mask.charAt(i))
			{
			case 'J':
				if (i < mask.length - 3 && mask.substr(i + 1, 3) == "JJJ")
				{
					dateAsString += value.getFullYear();
					i += 3;
				}
				else if (i < mask.length - 1 && mask.charAt(i + 1) == 'J')
				{
					var year = value.getFullYear();
					if (value.getFullYear() < 2000)
					{
						year -= 1900;
					}
					else
					{
						year -= 2000;
					}
					if (year < 10)
					{
						dateAsString += "0";
					}
					dateAsString += year;
					i++;
				}
				break;
			case 'M':
				if (i < mask.length - 1 && mask.charAt(i + 1) == 'M')
				{
					if (value.getMonth() < 9)
					{
						dateAsString += "0";
					}
					dateAsString += (value.getMonth() + 1);
					i++;
				}
				break;
			case 'T':
				if (i < mask.length - 1 && mask.charAt(i + 1) == 'T')
				{
					if (value.getDate() < 10)
					{
						dateAsString += "0";
					}
					dateAsString += value.getDate();
					i++;
				}
				break;
			case 'S':
				if (i < mask.length - 1 && mask.charAt(i + 1) == 'S')
				{
					if (value.getHours() < 10)
					{
						dateAsString += "0";
					}
					dateAsString += value.getHours();
					i++;
				}
				break;
			case 'm':
				if (i < mask.length - 1 && mask.charAt(i + 1) == 'm')
				{
					if (value.getMinutes() < 10)
					{
						dateAsString += "0";
					}
					dateAsString += value.getMinutes();
					i++;
				}
				break;
			case 's':
				if (i < mask.length - 1 && mask.charAt(i + 1) == 's')
				{
					if (value.getSeconds() < 10)
					{
						dateAsString += "0";
					}
					dateAsString += value.getSeconds();
					i++;
				}
				break;
			default:
				dateAsString += mask.charAt(i);
			}
			i++;
		}
		setValue(field, dateAsString);
	}
	else
	{
		setValue(field, ALS_ZEICHENKETTE(value));
	}
}

function getVarValue(field)
{
	return varValues[field];
}

function setVarValue(field, value)
{
	varValues[field] = value;
}

function isInstanceOfArray(object)
{
	return object.constructor.toString().indexOf("Array") > -1;
}

function isInstanceOfString(object)
{
	return object.constructor.toString().indexOf("String") > -1;
}

function isInstanceOfNumber(object)
{
	return object.constructor.toString().indexOf("Number") > -1;
}

function isInstanceOfDate(object)
{
	return object.constructor.toString().indexOf("Date") > -1;
}

function isValueNull(value)
{
	return value == null || (isInstanceOfString(value) && value == "");
}

function isValueInteger(value)
{
	return isValueIntegerMask(value, null);
}

function isValueIntegerMask(v,m){
 if(isValueNull(v)){
  return true;
 }
 v=ALS_ZEICHENKETTE(v);
 var vi=0;
 if (vi<v.length){
  var s=0;
  var max=20;
  var min=1;
  var f=new Array(-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1);
  var fi=0;
  if(!isValueNull(m)){
   var mi=0;
   var ii=-1;
   if(mi<m.length){
    if(m.charAt(mi)=='\\'){
     if(mi<m.length-1){
      if(m.charAt(mi+1)=='-'){
       s=2;
       mi+=2;
      }else if(m.charAt(mi+1)=='+'){
       s=3;
       mi+=2;
      }else{
       s=4;
      }
     }
    }else if(m.charAt(mi)=='-'){
     mi++;
    }else if(m.charAt(mi)=='+'){
     s=1;
     mi++;
    }else{
     s=4;
    }
    if(mi<m.length){
     if(m.charAt(mi)=='L' || m.charAt(mi)=='M' || m.charAt(mi)=='R'){
      mi++;
     }
    }
    while(mi<m.length){
     if(m.charAt(mi)=='#'){
      fi++;
     }else if(m.charCodeAt(mi)>=48 && m.charCodeAt(mi)<=57){
      if(ii<0){
       ii=fi;
      }
      if(m.charAt(mi)!='0' || (mi>0 && m.charAt(mi-1)=='\\')){
       f[fi]=m.charCodeAt(mi)-48;
       fi++;
      }
     }
     mi++;
    }
    max=fi;
    if(ii>=0){
     min=fi-ii;
    }
   }
  }
  if(v.charAt(vi)=='-'){
   if(s!=0 && s!=1 && s!=2){
    return false;
   }
   vi++;
  }else if(v.charAt(vi)=='+'){
   if(s!=0 && s!=1 && s!=3){
    return false;
   }
   vi++;
  }else if(s==2 || s==3 || s==1){
   return false;
  }
  var dc=0;
  while(vi<v.length){
   if(v.charCodeAt(vi)>=48 && v.charCodeAt(vi)<=57){
    if(dc==max){
     return false;
    }
    dc++;
   }else if(v.charAt(vi)=='.'){
    if(dc==0){
     return false;
    }
   }else{
    return false;
   }
   vi++;
  }
  if(dc<min){
   return false;
  }
  var gc=0;
  vi--;
  while(vi>=0 && v.charAt(vi)!='-' && v.charAt(vi)!='+'){
   if(v.charAt(vi)=='.'){
    if(gc!=3){
     return false;
    }
    gc=0;
   }else{
    fi--;
    if(fi>=0 && f[fi]>=0 && v.charCodeAt(vi)-48!=f[fi]){
     return false;
    }
    gc++;
   }
   vi--;
  }
 }
 return true;
}
function isValueReal(v){
 return isValueRealMask(v,null);
}
function isValueRealMask(v,m){
 if(isValueNull(v)){
  return true;
 }
 v=ALS_ZEICHENKETTE(v);
 var vi=0;
 if(vi<v.length){
  var s=0;
  var max=20;
  var min=1;
  var f=new Array(-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1);
  var fi=0;
  var maxf=20;
  var minf=0;
  var ff=new Array(-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1);
  var ffi=0;
  if(!isValueNull(m)){
   var mi=0;
   var ii=-1;
   if(mi<m.length){
    if(m.charAt(mi)=='\\'){
     if(mi<m.length-1){
      if(m.charAt(mi+1)=='-'){
       s=2;
       mi+=2;
      }else if(m.charAt(mi+1)=='+'){
       s=3;
       mi+=2;
      }else{
       s=4;
      }
     }
    }else if(m.charAt(mi)=='-'){
     mi++;
    }else if(m.charAt(mi)=='+'){
     s=1;
     mi++;
    }else{
     s=4;
    }
    if(mi<m.length){
     if(m.charAt(mi)=='L' || m.charAt(mi)=='M' || m.charAt(mi)=='R'){
      mi++;
     }
    }
    while(mi<m.length && m.charAt(mi)!='.'){
     if(m.charAt(mi)=='#'){
      fi++;
     }else if(m.charCodeAt(mi)>=48 && m.charCodeAt(mi)<=57){
      if(ii<0){
       ii=fi;
      }
      if(m.charAt(mi)!='0' || (mi>0 && m.charAt(mi-1)=='\\')){
       f[fi]=m.charCodeAt(mi)-48;
       fi++;
      }
     }
     mi++;
    }
    max=fi;
    if(ii>=0){
     min=fi-ii;
    }
    if(mi<m.length){
     ii=-1;
     mi++;
     while(mi<m.length){
      if(m.charAt(mi)=='#'){
       ffi++;
      }else if(m.charCodeAt(mi)>=48 && m.charAt(mi)<=57){
       if(ii<0){
        ii=ffi;
       }
       if(m.charAt(mi)!='0' || (mi>0 && m.charAt(mi-1)=='\\')){
        ff[ffi]=m.charCodeAt(mi)-48;
        ffi++;
       }
      }
      mi++;
     }
     maxf=ffi;
     if(ii>=0){
      minf=ii;
     }
    }
   }
  }
  if(v.charAt(vi)=='-'){
   if(s!=0 && s!=1 && s!=2){
    return false;
   }
   vi++;
  }else if(v.charAt(vi)=='+'){
   if(s!=0 && s!=1 && s!=3){
    return false;
   }
   vi++;
  }else if(s==2 || s==3 || s==1){
   return false;
  }
  var dc=0;
  var fc=0;
  var id=true;
  var ci=-1;
  while(vi<v.length){
   if(id){
    if(v.charCodeAt(vi)>=48 && v.charCodeAt(vi)<=57){
     if(dc==max){
      return false;
     }
     dc++;
    }else if(v.charAt(vi)=='.'){
     if(dc==0){
      return false;
     }
    }else if(v.charAt(vi)==','){
     if(vi==v.length-1){
      return false;
     }
     id=false;
     ci=vi;
    }else{
     return false;
    }
   }else{
    if(v.charCodeAt(vi)>=48 && v.charCodeAt(vi)<=57){
     if(fc==maxf){
      return false;
     }
     fc++;
    }else{
     return false;
    }
   }
   vi++;
  }
  var gc=0;
  vi--;
  while(vi>=0 && v.charAt(vi)!='-' && v.charAt(vi)!='+'){
   if(id){
    if(v.charAt(vi)=='.'){
     if(gc!=3){
      return false;
     }
     gc=0;
    }else{
     fi--;
     if(fi>=0 && f[fi]>=0 && v.charCodeAt(vi)-48!=f[fi]){
      return false;
     }
     gc++;
    }
   }else{
    if(v.charAt(vi)==','){
     id=true;
    }else{
     ffi--;
     if(ffi>=0 && ff[ffi]>=0 && v.charCodeAt(vi)-48!=ff[ffi]){
      return false;
     }
    }
   }
   vi--;
  }
  if(dc<min || fc<minf){
   return false;
  }
 }
 return true;
}

function getAsDate(value)
{
	return getAsDateMask(value, null);
}

function getAsDateMask(v,m){
 if(isValueNull(v)){
  return null;
 }
 if(isValueNull(m)){
  m="TT.MM.JJJJ";
 }
 var y=-1,mon=-1,dat=-1,h=-1,min=-1,s=-1;
 var vi=0;
 if(vi<v.length){
  var mi=0;
  var l=0;
  if(m.length>0){
   if(m.charAt(0)=='L' || m.charAt(0)=='R'){
    mi++;
   }else if(m.charAt(0)=='M'){
    var mc=0;
    for(var i=1; i<m.length && m.charAt(i)=='M'; i++){
     mc++;
    }
    if(mc%2==0){
     mi++;
    }
   }
  }
  for(var i=mi; i<m.length; i++){
   if(m.charAt(i)=='\\' && i<m.length-1){
    i++;
   }
   l++;
  }
  while(mi<m.length){
   if(vi==l){
    return null;
   }
   switch(m.charAt(mi)){
   case 'J':
    mi++;
    if(mi<m.length && m.charAt(mi)=='J'){
     y=0;
     var fy=false;
     if(mi<m.length-2 && m.charAt(mi+1)=='J' && m.charAt(mi+2)=='J'){
      fy=true;
      mi+=2;
     }
     if(fy){
      if(v.charCodeAt(vi)>=48 && v.charCodeAt(vi)<=57){
       y+=(v.charCodeAt(vi)-48) * 1000;
      }else{
       return null;
      }
      vi++;
      if(vi==v.length){
       return null;
      }
      if(v.charCodeAt(vi)>=48 && v.charCodeAt(vi)<=57){
       y+=(v.charCodeAt(vi)-48) * 100;
      }else{
       return null;
      }
      vi++;
      if(vi==v.length){
       return null;
      }
      if(v.charCodeAt(vi)>=48 && v.charCodeAt(vi)<=57){
       y+=(v.charCodeAt(vi)-48) * 10;
      }else{
       return null;
      }
      vi++;
      if(vi==v.length){
       return null;
      }
      if(v.charCodeAt(vi)>=48 && v.charCodeAt(vi)<=57){
       y+=(v.charCodeAt(vi)-48);
      }else{
       return null;
      }
     }else{
      if(v.charCodeAt(vi)>=48 && v.charCodeAt(vi)<=57){
       y+=(v.charCodeAt(vi)-48) * 10;
      }else{
       return null;
      }
      vi++;
      if(vi==v.length){
       return null;
      }
      if(v.charCodeAt(vi)>=48 && v.charCodeAt(vi)<=57){
       y+=v.charCodeAt(vi)-48;
      }else{
       return null;
      }
      if(y<50){
       y+=2000;
      }else{
       y+=1900;
      }
     }
     if(y<1900){
      return null;
     }
    }
    break;
   case 'M':
    mi++;
    if(mi<m.length && m.charAt(mi)=='M'){
     mon=0;
     if(v.charCodeAt(vi)>=48 && v.charCodeAt(vi)<=57){
      mon+=(v.charCodeAt(vi)-48)*10;
     }else{
      return null;
     }
     vi++;
     if(vi==v.length){
      return null;
     }
     if(v.charCodeAt(vi)>=48 && v.charCodeAt(vi)<=57){
      mon+=v.charCodeAt(vi)-49;
     }else{
      return null;
     }
     if(mon<0 || mon>11){
      return null;
     }
    }
    break;
   case 'T':
    mi++;
    if(mi<m.length && m.charAt(mi)=='T'){
     dat=0;
     if(v.charCodeAt(vi)>=48 && v.charCodeAt(vi)<=57){
      dat+=(v.charCodeAt(vi)-48)*10;
     }else{
      return null;
     }
     vi++;
     if(vi==v.length){
      return null;
     }
     if(v.charCodeAt(vi)>=48 && v.charCodeAt(vi)<=57){
      dat+=v.charCodeAt(vi)-48;
     }else{
      return null;
     }
     if(dat<1 || dat>31){
      return null;
     }
    }
    break;
   case 'S':
    mi++;
    if(mi<m.length && m.charAt(mi)=='S'){
     h=0;
     if(v.charCodeAt(vi)>=48 && v.charCodeAt(vi)<=57){
      h+=(v.charCodeAt(vi)-48)*10;
     }else{
      return null;
     }
     vi++;
     if(vi==v.length){
      return null;
     }
     if(v.charCodeAt(vi)>=48 && v.charCodeAt(vi)<=57){
      h+=v.charCodeAt(vi)-48;
     }else{
      return null;
     }
     if(h<0 || h>23){
      return null;
     }
    }
    break;
   case 'm':
    mi++;
    if(mi<m.length && m.charAt(mi)=='m'){
     min=0;
     if(v.charCodeAt(vi)>=48 && v.charCodeAt(vi)<=57){
      min+=(v.charCodeAt(vi)-48)*10;
     }else{
      return null;
     }
     vi++;
     if(vi==v.length){
      return null;
     }
     if(v.charCodeAt(vi)>=48 && v.charCodeAt(vi)<=57){
      min+=v.charCodeAt(vi)-48;
     }else{
      return null;
     }
     if(min<0 || min>59){
      return null;
     }
    }
    break;
   case 's':
    mi++;
    if(mi<m.length && m.charAt(mi)=='s'){
     s=0;
     if(v.charCodeAt(vi)>=48 && v.charCodeAt(vi)<=57){
      s+=(v.charCodeAt(vi)-48)*10;
     }else{
      return null;
     }
     vi++;
     if(vi==v.length){
      return null;
     }
     if(v.charCodeAt(vi)>=48 && v.charCodeAt(vi)<=57){
      s+=v.charCodeAt(vi)-48;
     }else{
      return null;
     }
     if(s<0 || s>59){
      return null;
     }
    }
    break;
   case '@':
    if(v.charAt(vi)!=' '){
     return null;
    }
    break;
   case '\\':
    if(mi<m.length-1){
     mi++;
    }
   default:
    if(v.charAt(vi)!=m.charAt(mi)){
     return null;
    }
   }
   mi++;
   vi++;
  }
  if(vi<v.length){
   return null;
  }
 }
 if(mon==1){
  if(dat>29){
   return null;
  }else if(dat==29){
   if(y%400!=0){
    if(y%100==0 || y%4!=0){
     return null;
    }
   }
  }
 }else if(mon==3 || mon==5 || mon==8 || mon==10){
  if(dat==31){
   return null;
  }
 }
 var d=new Date();
 d.setDate(1);
 if(y!=-1){
  d.setFullYear(y);
 }
 if(mon!=-1){
  d.setMonth(mon);
 }
 if(dat!=-1){
  d.setDate(dat);
 }
 if(h!=-1){
  d.setHours(h);
 }
 if(min!=-1){
  d.setMinutes(min);
 }
 if(s!=-1){
  d.setSeconds(s);
 }
 return d;
}

function isValueDate(value)
{
	return isValueDateMask(value, null);
}

function isValueDateMask(value, mask)
{
	if (isValueNull(value))
	{
		return true;
	}
	else if (isInstanceOfString(value))
	{
		return getAsDateMask(value, mask) != null;
	}
	return isInstanceOfDate(value);
}

function isValueString(value)
{
	return true;
}

function isValueStringMask(v,m){
 if(isValueNull(v) || isValueNull(m)){
  return true;
 }
 var vi=0;
 var mi=0;
 var min=0;
 if(m.charAt(mi)=='L' || m.charAt(mi) == 'M' || m.charAt(mi) == 'R'){
  mi++;
  if(mi<m.length){
   if(m.charAt(mi)!='\\' && m.charAt(mi)!='L' && m.charAt(mi)!='M' && m.charAt(mi)!='R' && m.charAt(mi)!='c' && m.charAt(mi)!='Z' && m.charAt(mi)!='z' && m.charAt(mi)!='.'){
    mi++;
   }
  }
 }
 var cc=0;
 while(mi<m.length){
  var e=false;
  if(m.charAt(mi)=='\\'){
   e=true;
   mi++;
  }
  if(mi<m.length){
   if(e){
    if(vi<v.length){
     if(v.charAt(vi)!=m.charAt(mi)){
      return false;
     }
     vi++;
    }
    cc++;
   }else{
    switch(m.charAt(mi)){
    case '.':
     min=cc;
     break;
    case '@':
     if(vi<v.length){
      if(v.charAt(vi)!=' '){
       return false;
      }
      vi++;
     }
     cc++;
     break;
    case 'c':
     vi++;
     cc++;
     break;
    case 'Z':
     if(vi<v.length){
      if(v.charAt(vi).toUpperCase()!=v.charAt(vi)){
       return false;
      }
      vi++;
     }
     cc++;
     break;
    case 'z':
     if(vi<v.length){
      if(v.charAt(vi).toLowerCase()!=v.charAt(vi)){
       return false;
      }
      vi++;
     }
     cc++;
     break;
    default:
     if(vi<v.length){
      if(v.charAt(vi)!=m.charAt(mi)){
       return false;
      }
      vi++;
     }
     cc++;
    }
   }
  }
  mi++;
 }
 if(vi<v.length){
  return false;
 }
 if(v.length<min){
  return false;
 }
 return true;
}
function contains(a,b){
 if(b && isInstanceOfArray(b)){
  for(var i=0; i<b.length; i++){
   if(b[i] instanceof Interval){
    var t=b[i].operator;
    if(t==1){
     if(gt(a,b[i].first) && lt(a,b[i].last)){
      return true;
     }
    }else if(t==2){
     if(gt(a,b[i].first) && le(a,b[i].last)){
      return true;
     }
    }else if(t==3){
     if(ge(a,b[i].first) && lt(a,b[i].last)){
      return true;
     }
    }else{
     if(ge(a,b[i].first) && le(a,b[i].last)){
      return true;
     }
    }
   }else if(eq(a,b[i])){
    return true;
   }
  }
 }
 return false;
}
function containsClassification(a,b){
 if(b && isInstanceOfArray(b)){
  for(var i=0; i<b.length; i++){
   if(a==b[i]){
    return true;
   }
  }
 }
 return false;
}
function compRound(a){
 var p=15-a.toFixed(0).toString().length;
 var n=a.toFixed(p>0?p:0).toString().replace(/\./g,",");
 var i=n.length;
 if(n.indexOf(",")>=0){
  while(i>0){
   if(n.charAt(i-1)=="0"){
    i--;
   }else if(n.charAt(i-1)==","){
    i--;
    break;
   }else{
    break;
   }
  }
 }
 return n.substring(0,i);
}
function plus(a,b){
 if(isValueNull(a)){
  return b;
 }
 if(isValueNull(b)){
  return a;
 }
 return compRound(ALS_KOMMAZAHL(a)+ALS_KOMMAZAHL(b));
}
function minus(a,b){
 if(isValueNull(b)){
  return a;
 }
 if(isValueNull(a)){
  return compRound(ALS_KOMMAZAHL(b) * (-1));
 }
 return compRound(ALS_KOMMAZAHL(a)-ALS_KOMMAZAHL(b));
}
function mult(a,b){
 if(isValueNull(a) || isValueNull(b)){
  return "0";
 }
 return compRound(ALS_KOMMAZAHL(a)*ALS_KOMMAZAHL(b));
}
function div(a,b){
 if(isValueNull(a)){
  return "0";
 }
 return compRound(ALS_KOMMAZAHL(a)/ALS_KOMMAZAHL(b));
}
function gt(a,b)
{
	if(b instanceof Array)
	{
		for(var i=0; i < b.length; i++)
		{
			if(!(ALS_KOMMAZAHL(a) > ALS_KOMMAZAHL(b[i])))
			{
				return false;
			}
		}
		return true;
	}
	return ALS_KOMMAZAHL(a) > ALS_KOMMAZAHL(b);
}
function ge(a,b)
{
	 if(b instanceof Array)
	 {
		 for(var i=0; i < b.length; i++)
		 {
			 if(!(ALS_KOMMAZAHL(a) >= ALS_KOMMAZAHL(b[i])))
			 {
				 return false;
			 }
		 }
		 return true;
	 }
	 return ALS_KOMMAZAHL(a) >= ALS_KOMMAZAHL(b);
}
function lt(a,b)
{
	if(b instanceof Array)
	{
		 for(var i=0; i < b.length; i++)
		 {
			 if(!(ALS_KOMMAZAHL(a) < ALS_KOMMAZAHL(b[i])))
			 {
				 return false;
			 }
		 }
		 return true;
	}
	return ALS_KOMMAZAHL(a) < ALS_KOMMAZAHL(b);
}
function le(a,b)
{
	if(b instanceof Array)
	{
		 for(var i=0; i < b.length; i++)
		 {
			 if(!(ALS_KOMMAZAHL(a) <= ALS_KOMMAZAHL(b[i])))
			 {
				 return false;
			 }
		 }
		 return true;
	}
	return ALS_KOMMAZAHL(a) <= ALS_KOMMAZAHL(b);
}
function eq(a,b)
{
	if((!isValueNull(a) && isValueNull(b)) || (isValueNull(a) && !isValueNull(b))){
		return false;
	}
	if(isValueReal(a) && isValueReal(b))
	{
		return ALS_KOMMAZAHL(a) == ALS_KOMMAZAHL(b);
	}
	if(b instanceof Array)
	{
		for(var i=0; i < b.length; i++)
		{
			if(ne(a,b[i]))
			{
				return false;
			}
		}
		return true;
	}
	
	return a==b;
}
function ne(a,b){
 return !eq(a,b);
}
function not(a){
 return !a;
}

function ALS_KOMMAZAHL(value)
{
	if (isValueNull(value) || !isValueReal(value))
	{
		return 0;
	}
	if (isInstanceOfString(value))
	{
		value = value.replace(/\./g, "");
		value = value.replace(/,/g, ".");
	}
	return Number(value);
}

function ALS_GANZZAHL(value)
{
	return ALS_KOMMAZAHL(value).toFixed(0);
}

function ALS_GANZZAHL_OHNE_RUNDUNG(value)
{
	var numberValue = ALS_KOMMAZAHL(value);
	var rounder = -0.5
	if (numberValue < 0)
	{
		rounder = 0.5
	}	
	return Number(numberValue + rounder).toFixed(0);
}

function ALS_ZEICHENKETTE(value)
{
	if (isValueNull(value))
	{
		return "";
	}
	if (isInstanceOfString(value))
	{
		return value;
	}
	if (isInstanceOfNumber(value))
	{
		return value.toString().replace(/\./g,",");
	}
	return value.toString();
}

function RUNDEN(value, precision)
{
	return ALS_KOMMAZAHL(value).toFixed(precision).toString().replace(/\./g, ",");
}

function MODULO(a, b)
{
	if (isValueNull(a))
	{
		return "0";
	}
	return ALS_KOMMAZAHL(a) % ALS_KOMMAZAHL(b);
}

function WERTLAENGE(value)
{
	if (!isValueNull(value))
	{
		return value.length;
	}
	return 0;
}

function KONKATENIEREN(a,b){
 if(isValueNull(a)){
  if(isValueNull(b)){
   return "";
  }else{
   return b;
  }
 }else{
  if(isValueNull(b)){
   return a;
  }else{
   return a+b;
  }
 }
}
function TEIL(a,s,l){
 if(isValueNull(a) || s>a.length){
  return "";
 }else{
  var start=s-1;
  if(start<0){
   start=0;
  }
  var end=start+l;
  if(l>0 && end<a.length){
   return a.substring(start,end);
  }
  return a.substring(start,a.length);
 }
}
function ERSETZEN(a,b,c){
 if(isValueNull(a)){
  return "";
 }else if(isValueNull(b)){
  return a;
 }else{
  var e="";
  for(var i=0; i<lengthOfString(a); i++){
   if(a.substr(i,b.length)==b){
    e+=c;
   }else{
    e+=a.charAt(i);
   }
  }
  return e;
 }
}
function ENDET_AUF(a,s){
 if(!isValueNull(a)){
  if(isValueNull(s)){
   return true;
  }else{
   if(a.length>s.length){
    return a.substr(a.length-s.length,s.length)==s;
   }
  }
 }
 return false;
}
function BEGINNT_MIT(a,p){
 if(!isValueNull(a)){
  if(isValueNull(p)){
   return true;
  }else{
   if(a.length>p.length){
    return a.substr(0,p.length)==p;
   }
  }
 }
 return false;
}

function GROSSBUCHSTABEN(a)
{
	if (!isValueNull(a))
	{
		return a.toUpperCase();
	}
	return "";
}

function KLEINBUCHSTABEN(a)
{
	if (!isValueNull(a))
	{
		return a.toLowerCase();
	}
	return "";
}

function NUMERISCH(a){
 var erg=true;
 if(!isValueNull(a)){
  for(var i=0; i<a.length; i++){
   if(a.charCodeAt(i)<48 || a.charCodeAt(i)>57){
    erg=false;
    break;
   }
  }
 }
 return erg;
}
function HAT_FORMAT(f,a){
 if(isValueNull(a)){
  return false;
 }
 var reg=new RegExp(f);
 return reg.test(a);
}
function JAHR(a){
 var d=new Date();
 if(!isValueNull(a) && !isNaN(a)){
  d=new Date(a);
 }
 return d.getFullYear();
}
function JAHR_ALS_ZEICHENKETTE(a){
 return ""+year(a);
}
function MONAT(a){
 var d=new Date();
 if(!isValueNull(a) && !isNaN(a)){
  d=new Date(a);
 }
 return d.getMonth()+1;
}
function MONAT_ALS_ZEICHENKETTE(a){
 var m=month(a);
 if(m<10){
  return "0"+m;
 }
 return ""+m;
}
function TAG(a){
 var d=new Date();
 if(!isValueNull(a) && !isNaN(a)){
  d=new Date(a);
 }
 return d.getDate();
}
function TAG_ALS_ZEICHENKETTE(a){
 var d=day(a);
 if(d<10){
  return "0"+d;
 }
 return ""+d;
}
function HEUTE(){
 var d=new Date();
 d.setHours(0);
 d.setMinutes(0);
 d.setSeconds(0);
 d.setMilliseconds(0);
 return d.getTime();
}
function ABSOLUTWERT(a)
{
	return compRound(Math.abs(ALS_KOMMAZAHL(a)));
}
function LOGARITHMUS(w,b)
{
	return compRound(Math.log(ALS_KOMMAZAHL(w)) / Math.log(ALS_KOMMAZAHL(b)));	
}
function NATUERLICHER_LOGARITHMUS(w)
{
	return compRound(Math.log(w));	
}
function ZUFALLSZAHL()
{
	return compRound(Math.random());
}
function MAXIMUM_AUS_REIHE(l)
{
	var max = null;
	if(l && isIntanceOfArray(l) && l.length > 0)
	{
		max = l[0];
		for(var i = 1; i < l.length; i++)
		{
			if (max<l[i]) max = l[i];
		}
	}
	return max;
}
function ZUFALLSZAHL_AUS_REIHE(l)
{
	var randomNumber = null;
	if(l && isIntanceOfArray(l) && l.length > 0)
	{
		randomNumber = l[Math.floor(Math.random() * l.length)];
	}
	return randomNumber;
}
function EXPONENT(value, exp)
{
	return compRound(Math.pow(ALS_KOMMAZAHL(value), ALS_KOMMAZAHL(exp)));
}

function NORMALVERTEILTE_ZUFALLSZAHL(mean, variance)
{
	// Generiere normalverteilte Zufallszahl nach der Polar-Methode
	var x1, x2, rad;
	do
	{
		x1 = 2 * Math.random() - 1;
		x2 = 2 * Math.random() - 1;
		rad = x1 * x1 + x2 * x2;
	}
	while(rad >= 1 || rad == 0);

	var c = Math.sqrt(-2 * Math.log(rad) / rad);
	var gaussian = x1 * c;
	
	var random = ALS_KOMMAZAHL(mean) + (gaussian * Math.abs(ALS_KOMMAZAHL(variance)));
	return compRound(random);
}