; Modul: ACC_TEST.ASM

; Version 1.00          BIA - Referat 5.2                    Datum: 15.09.2000

; Funktion:
; Test des Akkumulators mit einer wandernden 1. Der Hintergrund kann nicht 
; getestet werden, da man den Akku als Rechenregister fr eine 
; Hintergrundanalyse bentigt, so dass er letztendlich immer seinen Inhalt 
; verndert. Die hufige Benutzung des Akkumulators sorgt jedoch dafr, dass 
; Fehler auch anderweitig erkannt werden. 
; Sollte das Carry nach weniger als 7 Schritten gesetzt sein, ist der 
; Schleifenzhler noch nicht auf 0, so dass ein Akkufehler wahrscheinlich ist.
; Man knnte die Routine auch so ndern, dass der Initialwert von R1 07 ist. 
; Damit entfiele der zustzliche DEC R1 Befehl. Hier wird jedoch bewusst das 
; Carry nach 7 Durchlufen der Schleife mitgetestet, so dass man zum einen JC 
; testet, zum anderen eine dauernde 00 im Akku aufdeckt.

; Eingabeparameter: keine
; Ausgabeparameter: keine
; Vernderte Register: A, R1, PSW
; Vernderte Speicherbereiche: keine

; Fehleraussprung: keiner

; bergeordnete Module: CPU_TEST.ASM
; Untergeordnete Module: keine
; aufgerufen von: MAIN
; ruft auf: -

; Stacktiefe: 2 Bytes
; Verwendete Registerbank: aktuelle Bank
; ***************************************************************************
ACC_TEST:       CLR     C
		MOV     R1,#08                  ; R1 sei Schleifenzhler
		MOV     A,#01                   ; Testbyte: 0000$0001
ACC_1:          RLC     A                       ; wandernde 1 durch Carry-Flag
		JC      ACC_2                   ; Wenn 1 im Carry angekommen Springe zu ACC_2
		DJNZ    R1, ACC_1               ; Decrementiere Schleifenzhler
ACC_2:          DEC     R1                      ; Decrementiere Schleifenzhler nochmals
		CJNE    R1, #00h, ACC_ERR       ; hier geschieht der eigentliche Akkutest:
		SJMP    ACC_ENDE                ; Ende der Routine
ACC_ERR:        MOV     FEHLER,#FEHLER_ACC      ; Fehlerspeicher laden
		SJMP    ACC_ERR                 ; Endlosschleife
ACC_ENDE:       RET

