; Modul: ANL_TEST.ASM

; Version 1.00          BIA - Referat 5.2                    Datum: 15.09.2000

; Funktion:
; Die Unterprogramme testen den Verknpfungsbefehl ANL, indem AAh
; (10101010B) und 56h (01010110B) bitweise logisch UND verknpft
; werden und das berechnete Ergebnis mit dem erwarteten Ergebnis 
; von 02h (00000010B) verglichen wird.

; Eingabeparameter: keine
; Ausgabeparameter: keine
; Vernderte Register: siehe Einzelfunktionen
; Vernderte Speicherbereiche: keine, auer speziell fr diese Tests reservierte Speicherzellen

; Fehleraussprung: nach Funktion ERROR

; bergeordnete Module: LOGITEST.ASM
; Untergeordnete Module: keine
; aufgerufen von: ANL_TEST
; ruft auf: -

; Stacktiefe: 2 Bytes
; Verwendete Registerbank: aktuelle Bank
; ***************************************************************************



; ********************* ANL_TEST 1 ******************************************
; Funktion: Test von ANL A,R0
; Vernderte Register: A, R0, PSW
; *************************************************************************** 
ANL_TEST1:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     R0,#56h                 ; Testmuster 2 laden 
		ANL     A,R0                    ; Befehlstest 
		CJNE    A,#02h,ANL_err1         ; Vergleich mit Erwartungshaltung
		RET
ANL_err1:       LJMP    ERROR_ANL



; ********************* ANL_TEST 2 ******************************************
; Funktion: Test von ANL A,R1
; Vernderte Register: A, R1, PSW
; *************************************************************************** 
ANL_TEST2:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     R1,#56h                 ; Testmuster 2 laden 
		ANL     A,R1                    ; Befehlstest 
		CJNE    A,#02h,ANL_err2         ; Vergleich mit Erwartungshaltung
		RET
ANL_err2:       LJMP    ERROR_ANL               



; ********************* ANL_TEST 3 ******************************************
; Funktion: Test von ANL A,R2
; Vernderte Register: A, R2, PSW
; *************************************************************************** 
ANL_TEST3:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     R2,#56h                 ; Testmuster 2 laden 
		ANL     A,R2                    ; Befehlstest 
		CJNE    A,#02h,ANL_err3         ; Vergleich mit Erwartungshaltung
		RET
ANL_err3:       LJMP    ERROR_ANL                   



; ********************* ANL_TEST 4 ******************************************
; Funktion: Test von ANL A,R3
; Vernderte Register: A, R3, PSW
; *************************************************************************** 
ANL_TEST4:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     R3,#56h                 ; Testmuster 2 laden 
		ANL     A,R3                    ; Befehlstest 
		CJNE    A,#02h,ANL_err4         ; Vergleich mit Erwartungshaltung
		RET
ANL_err4:       LJMP    ERROR_ANL                   



; ********************* ANL_TEST 5 ******************************************
; Funktion: Test von ANL A,R4
; Vernderte Register: A, R4, PSW
; *************************************************************************** 
ANL_TEST5:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     R4,#56h                 ; Testmuster 2 laden 
		ANL     A,R4                    ; Befehlstest 
		CJNE    A,#02h,ANL_err5         ; Vergleich mit Erwartungshaltung
		RET
ANL_err5:       LJMP    ERROR_ANL                   



; ********************* ANL_TEST 6 ******************************************
; Funktion: Test von ANL A,R5
; Vernderte Register: A, R5, PSW
; *************************************************************************** 
ANL_TEST6:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     R5,#56h                 ; Testmuster 2 laden 
		ANL     A,R5                    ; Befehlstest 
		CJNE    A,#02h,ANL_err6         ; Vergleich mit Erwartungshaltung
		RET
ANL_err6:       LJMP    ERROR_ANL                   



; ********************* ANL_TEST 7 ******************************************
; Funktion: Test von ANL A,R6
; Vernderte Register: A, R6, PSW
; *************************************************************************** 
ANL_TEST7:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     R6,#56h                 ; Testmuster 2 laden 
		ANL     A,R6                    ; Befehlstest 
		CJNE    A,#02h,ANL_err7         ; Vergleich mit Erwartungshaltung
		RET
ANL_err7:       LJMP    ERROR_ANL                   



; ********************* ANL_TEST 8 ******************************************
; Funktion: Test von ANL A,R7
; Vernderte Register: A, R7, PSW
; *************************************************************************** 
ANL_TEST8:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     R7,#56h                 ; Testmuster 2 laden 
		ANL     A,R7                    ; Befehlstest 
		CJNE    A,#02h,ANL_err8         ; Vergleich mit Erwartungshaltung
		RET
ANL_err8:       LJMP    ERROR_ANL                   



; ********************* ANL_TEST 9 ******************************************
; Funktion: Test von ANL A,dir
; Vernderte Register: A, PSW
; *************************************************************************** 
ANL_TEST9:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     INTRAM10,#56h           ; Testmuster 2 laden
		ANL     A,INTRAM10              ; Befehlstest 
		CJNE    A,#02h,ANL_err9         ; Vergleich mit Erwartungshaltung
		RET
ANL_err9:       LJMP    ERROR_ANL                      



; ********************* ANL_TEST 10 *****************************************
; Funktion: Test von ANL A,@R0
; Vernderte Register: A, R0, PSW
; *************************************************************************** 
ANL_TEST10:     MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     INTRAM10,#56h           ; Testmuster 2 laden
		MOV     R0,#10h                 ; Adresse von INTRAM10 laden
		ANL     A,@R0                   ; Befehlstest 
		CJNE    A,#02h,ANL_err10        ; Vergleich mit Erwartungshaltung
		RET
ANL_err10:      LJMP    ERROR_ANL       



; ********************* ANL_TEST 11 *****************************************
; Funktion: Test von ANL A,@R1
; Vernderte Register: A, R1, PSW
; *************************************************************************** 
ANL_TEST11:     MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     INTRAM10,#56h           ; Testmuster 2 laden
		MOV     R1,#10h                 ; Adresse von INTRAM10 laden
		ANL     A,@R1                   ; Befehlstest 
		CJNE    A,#02h,ANL_err11        ; Vergleich mit Erwartungshaltung
		RET
ANL_err11:      LJMP    ERROR_ANL           



; ********************* ANL_TEST 12 *****************************************
; Funktion: Test von ANL A,#data
; Vernderte Register: A, PSW
; *************************************************************************** 
ANL_TEST12:     MOV     A,#0AAh                 ; Testmuster 1 laden
		ANL     A,#56h                  ; Befehlstest 
		CJNE    A,#02h,ANL_err12        ; Vergleich mit Erwartungshaltung
		RET
ANL_err12:      LJMP    ERROR_ANL           
     


; ********************* ANL_TEST 13 *****************************************
; Funktion: Test von ANL dir,A
; Vernderte Register: A, PSW
; *************************************************************************** 
ANL_TEST13:     MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     INTRAM10,#56h           ; Testmuster 2 laden
		ANL     INTRAM10,A              ; Befehlstest 
		MOV     A,INTRAM10              
		CJNE    A,#02h,ANL_err13        ; Vergleich mit Erwartungshaltung
		RET
ANL_err13:      LJMP    ERROR_ANL      



; ********************* ANL_TEST 14 *****************************************
; Funktion: Test von ANL dir,#data
; Vernderte Register: A, PSW
; *************************************************************************** 
ANL_TEST14:     MOV     INTRAM10,#0AAh          ; Testmuster 1 laden
		ANL     INTRAM10,#56h           ; Befehlstest
		MOV     A,INTRAM10              
		CJNE    A,#02h,ANL_err14        ; Vergleich mit Erwartungshaltung
		RET
ANL_err14:      LJMP    ERROR_ANL           



; ***************************************************************************
ERROR_ANL:      MOV     FEHLER,#FEHLER_ANL      ; Fehlerspeicher laden
		LJMP    ERROR
; ***************************************************************************

