; Modul: ARI_TEST.ASM

; Version 1.00          BIA - Referat 5.2                    Datum: 15.09.2000

; Funktion:
; Test von Arithmetikbefehlen: ADD, ADDC, SUBB, INC, DEC, MUL, DIV, DA 

; Eingabeparameter: keine
; Ausgabeparameter: keine
; Vernderte Register: siehe Einzelfunktionen
; Vernderte Speicherbereiche: keine, auer speziell fr diese Tests reservierte Speicherzellen

; Fehleraussprung: nach Funktion ERROR

; bergeordnete Module: LOGITEST.ASM
; Untergeordnete Module: keine

; Verwendete Registerbank: aktuelle Bank
; ***************************************************************************



; ********************* ADD_TEST 1 *****************************************
; Funktion: Test von ADD A,R0

; aufgerufen von: ADD_TEST
; ruft auf: -

; Vernderte Register: A, R0, PSW
; Stacktiefe: 2 Bytes
; **************************************************************************
ADD_TEST1:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     R0,#55h                 ; Testmuster 2 laden
		ADD     A,R0                    ; Befehlstest
		CJNE    A,#0FFh,ADD_err1        ; Vergleich mit Erwartungshaltung 
		RET
ADD_err1:       LJMP    ERROR_ARI



; ********************* ADD_TEST 2 *****************************************
; Funktion: Test von ADD A,R1

; aufgerufen von: ADD_TEST
; ruft auf: -

; Vernderte Register: A, R1, PSW
; Stacktiefe: 2 Bytes
; **************************************************************************
ADD_TEST2:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     R1,#55h                 ; Testmuster 2 laden 
		ADD     A,R1                    ; Befehlstest 
		CJNE    A,#0FFh,ADD_err2        ; Vergleich mit Erwartungshaltung 
		RET
ADD_err2:       LJMP    ERROR_ARI           



;********************* ADD_TEST 3 *****************************************
;Funktion: Test von ADD A,R2

; aufgerufen von: ADD_TEST
; ruft auf: -

; Vernderte Register: A, R2, PSW
; Stacktiefe: 2 Bytes
;**************************************************************************
ADD_TEST3:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     R2,#55h                 ; Testmuster 2 laden 
		ADD     A,R2                    ; Befehlstest 
		CJNE    A,#0FFh,ADD_err3        ; Vergleich mit Erwartungshaltung 
		RET
ADD_err3:       LJMP    ERROR_ARI                   



; ********************* ADD_TEST 4 *****************************************
; Funktion: Test von ADD A,R3

; aufgerufen von: ADD_TEST
; ruft auf: -

; Vernderte Register: A, R3, PSW
; Stacktiefe: 2 Bytes
; **************************************************************************
ADD_TEST4:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     R3,#55h                 ; Testmuster 2 laden 
		ADD     A,R3                    ; Befehlstest 
		CJNE    A,#0FFh,ADD_err4        ; Vergleich mit Erwartungshaltung 
		RET
ADD_err4:       LJMP    ERROR_ARI           



; ********************* ADD_TEST 5 *****************************************
; Funktion: Test von ADD A,R4

; aufgerufen von: ADD_TEST
; ruft auf: -

; Vernderte Register: A, R4, PSW
; Stacktiefe: 2 Bytes
; **************************************************************************
ADD_TEST5:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     R4,#55h                 ; Testmuster 2 laden 
		ADD     A,R4                    ; Befehlstest 
		CJNE    A,#0FFh,ADD_err5        ; Vergleich mit Erwartungshaltung 
		RET
ADD_err5:       LJMP    ERROR_ARI



; ********************* ADD_TEST 6 *****************************************
; Funktion: Test von ADD A,R5

; aufgerufen von: ADD_TEST
; ruft auf: -

; Vernderte Register: A, R5, PSW
; Stacktiefe: 2 Bytes
; **************************************************************************
ADD_TEST6:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     R5,#55h                 ; Testmuster 2 laden 
		ADD     A,R5                    ; Befehlstest 
		CJNE    A,#0FFh,ADD_err6        ; Vergleich mit Erwartungshaltung 
		RET
ADD_err6:       LJMP    ERROR_ARI           



;********************* ADD_TEST 7 *****************************************
;Funktion: Test von ADD A,R6

; aufgerufen von: ADD_TEST
; ruft auf: -

; Vernderte Register: A, R6, PSW
; Stacktiefe: 2 Bytes
;**************************************************************************
ADD_TEST7:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     R6,#55h                 ; Testmuster 2 laden 
		ADD     A,R6                    ; Befehlstest 
		CJNE    A,#0FFh,ADD_err7        ; Vergleich mit Erwartungshaltung 
		RET
ADD_err7:       LJMP    ERROR_ARI           



; ********************* ADD_TEST 8 *****************************************
; Funktion: Test von ADD A,R7

; aufgerufen von: ADD_TEST
; ruft auf: -

; Vernderte Register: A, R7, PSW
; Stacktiefe: 2 Bytes
; **************************************************************************
ADD_TEST8:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     R7,#55h                 ; Testmuster 2 laden 
		ADD     A,R7                    ; Befehlstest 
		CJNE    A,#0FFh,ADD_err8        ; Vergleich mit Erwartungshaltung 
		RET
ADD_err8:       LJMP    ERROR_ARI 



; ********************* ADD_TEST 9 *****************************************
; Funktion: Test von ADD A,dir

; aufgerufen von: ADD_TEST
; ruft auf: -

; Vernderte Register: A, PSW
; Stacktiefe: 2 Bytes
; **************************************************************************
ADD_TEST9:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     INTRAM10,#55h           ; Testmuster 2 laden
		ADD     A,INTRAM10              ; Befehlstest 
		CJNE    A,#0FFh,ADD_err9        ; Vergleich mit Erwartungshaltung 
		RET
ADD_err9:       LJMP    ERROR_ARI           



; ********************* ADD_TEST 10 ****************************************
; Funktion: Test von ADD A,@R0

; aufgerufen von: ADD_TEST
; ruft auf: -

; Vernderte Register: A, R0, PSW
; Stacktiefe: 2 Bytes
; **************************************************************************
ADD_TEST10:     MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     INTRAM10,#55h           ; Testmuster 2 laden
		MOV     R0,#10h                 ; Testmuster 3 laden
		ADD     A,@R0                   ; Befehlstest 
		CJNE    A,#0FFh,ADD_err10       ; Vergleich mit Erwartungshaltung 
		RET
ADD_err10:      LJMP    ERROR_ARI           



; ********************* ADD_TEST 11 ****************************************
; Funktion: Test von ADD A,R1

; aufgerufen von: ADD_TEST
; ruft auf: -

; Vernderte Register: A, R1, PSW
; Stacktiefe: 2 Bytes
; **************************************************************************
ADD_TEST11:     MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     INTRAM10,#55h           ; Testmuster 2 laden
		MOV     R1,#10h                 ; Testmuster 3 laden
		ADD     A,@R1                   ; Befehlstest
		CJNE    A,#0FFh,ADD_err11       ; Vergleich mit Erwartungshaltung 
		RET
ADD_err11:      LJMP    ERROR_ARI           



; ********************* ADD_TEST 12 ****************************************
; Funktion: Test von ADD A,data

; aufgerufen von: ADD_TEST
; ruft auf: -

; Vernderte Register: A, PSW
; Stacktiefe: 2 Bytes
; **************************************************************************
ADD_TEST12:     MOV     A,#0AAh                 ; Testmuster 1 laden
		ADD     A,#55h                  ; Befehlstest 
		CJNE    A,#0FFh,ADD_err12       ; Vergleich mit Erwartungshaltung 
		RET
ADD_err12:      LJMP    ERROR_ARI           




; ********************* ADDC_TEST 1  ****************************************
; Funktion: Test von ADDC A,R0

; aufgerufen von: ADDC_TEST
; ruft auf: -

; Vernderte Register: A, R0, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
ADDC_TEST1:     MOV     A,#0FFh                 ; Testmuster 1 laden
		MOV     R0,#01h                 ; Testmuster 2 laden 
		ADDC    A,R0                    ; Befehlstest 
		ADDC    A,R0                    ; Befehlstest       
		CJNE    A,#02h,ADDC_err1        ; Vergleich mit Erwartungshaltung 
		RET
ADDC_err1:      LJMP    ERROR_ARI           



; ********************* ADDC_TEST 2  ****************************************
; Funktion: Test von ADDC A,R1

; aufgerufen von: ADDC_TEST
; ruft auf: -

; Vernderte Register: A, R1, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
ADDC_TEST2:     MOV     A,#0FFh                 ; Testmuster 1 laden
		MOV     R1,#01h                 ; Testmuster 2 laden   
		ADDC    A,R1                    ; Befehlstest
		ADDC    A,R1                    ; Befehlstest
		CJNE    A,#02h,ADDC_err2        ; Vergleich mit Erwartungshaltung 
		RET
ADDC_err2:      LJMP    ERROR_ARI           



; ********************* ADDC_TEST 3  ****************************************
; Funktion: Test von ADDC A,R2

; aufgerufen von: ADDC_TEST
; ruft auf: -

; Vernderte Register: A, R2, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
ADDC_TEST3:     MOV     A,#0FFh                 ; Testmuster 1 laden
		MOV     R2,#01h                 ; Testmuster 2 laden 
		ADDC    A,R2                    ; Befehlstest 
		ADDC    A,R2                    ; Befehlstest               
		CJNE    A,#02H,ADDC_err3        ; Vergleich mit Erwartungshaltung 
		RET
ADDC_err3:      LJMP    ERROR_ARI           



; ********************* ADDC_TEST 4  ****************************************
; Funktion: Test von ADDC A,R3

; aufgerufen von: ADDC_TEST
; ruft auf: -

; Vernderte Register: A, R3, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
ADDC_TEST4:     MOV     A,#0FFh                 ; Testmuster 1 laden
		MOV     R3,#01h                 ; Testmuster 2 laden 
		ADDC    A,R3                    ; Befehlstest
		ADDC    A,R3                    ; Befehlstest       
		CJNE    A,#02h,ADDC_err4        ; Vergleich mit Erwartungshaltung
		RET
ADDC_err4:      LJMP    ERROR_ARI                   



; ********************* ADDC_TEST 5  ****************************************
; Funktion: Test von ADDC A,R4

; aufgerufen von: ADDC_TEST
; ruft auf: -

; Vernderte Register: A, R4, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************

ADDC_TEST5:     MOV     A,#0FFh                 ; Testmuster 1 laden
		MOV     R4,#01h                 ; Testmuster 2 laden 
		ADDC    A,R4                    ; Befehlstest       
		ADDC    A,R4                    ; Befehlstest       
		CJNE    A,#02h,ADDC_err5        ; Vergleich mit Erwartungshaltung 
		RET
ADDC_err5:      LJMP    ERROR_ARI   



; ********************* ADDC_TEST 6  ****************************************
; Funktion: Test von ADDC A,R5

; aufgerufen von: ADDC_TEST
; ruft auf: -

; Vernderte Register: A, R5, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
ADDC_TEST6:     MOV     A,#0FFh                 ; Testmuster 1 laden
		MOV     R5,#01h                 ; Testmuster 2 laden 
		ADDC    A,R5                    ; Befehlstest       
		ADDC    A,R5                    ; Befehlstest       
		CJNE    A,#02h,ADDC_err6        ; Vergleich mit Erwartungshaltung 
		RET
ADDC_err6:      LJMP    ERROR_ARI           



; ********************* ADDC_TEST 7  ****************************************
; Funktion: Test von ADDC A,R6

; aufgerufen von: ADDC_TEST
; ruft auf: -

; Vernderte Register: A, R6, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
ADDC_TEST7:     MOV     A,#0FFh                 ; Testmuster 1 laden
		MOV     R6,#01h                 ; Testmuster 2 laden 
		ADDC    A,R6                    ; Befehlstest       
		ADDC    A,R6                    ; Befehlstest       
		CJNE    A,#02h,ADDC_err7        ; Vergleich mit Erwartungshaltung 
		RET
ADDC_err7:      LJMP    ERROR_ARI           



; ********************* ADDC_TEST 8  ****************************************
; Funktion: Test von ADDC A,R7

; aufgerufen von: ADDC_TEST
; ruft auf: -

; Vernderte Register: A, R7, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
ADDC_TEST8:     MOV     A,#0FFh                 ; Testmuster 1 laden
		MOV     R7,#01h                 ; Testmuster 2 laden 
		ADDC    A,R7                    ; Befehlstest      
		ADDC    A,R7                    ; Befehlstest      
		CJNE    A,#02h,ADDC_err8        ; Vergleich mit Erwartungshaltung 
		RET
ADDC_err8:      LJMP    ERROR_ARI           



; ********************* ADDC_TEST 9  ****************************************
; Funktion: Test von ADDC A,dir

; aufgerufen von: ADDC_TEST
; ruft auf: -

; Vernderte Register: A, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
ADDC_TEST9:     MOV     A,#0FFh                 ; Testmuster 1 laden
		MOV     INTRAM10,#01h           ; Testmuster 2 laden
		ADDC    A,INTRAM10              ; Befehlstest 
		ADDC    A,INTRAM10              ; Befehlstest 
		CJNE    A,#02h,ADDC_err9        ; Vergleich mit Erwartungshaltung 
		RET
ADDC_err9:      LJMP    ERROR_ARI                   



; ********************* ADDC_TEST 10  ***************************************
; Funktion: Test von ADDC A,@R0

; aufgerufen von: ADDC_TEST
; ruft auf: -

; Vernderte Register: A, R0, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
ADDC_TEST10:    MOV     A,#0FFh                 ; Testmuster 1 laden
		MOV     INTRAM10,#01h           ; Testmuster 2 laden
		MOV     R0,#10h                 ; Testmuster 3 laden
		ADDC    A,@R0                   ; Befehlstest 
		ADDC    A,@R0                   ; Befehlstest 
		CJNE    A,#02h,ADDC_err10       ; Vergleich mit Erwartungshaltung 
		RET
ADDC_err10:     LJMP    ERROR_ARI           



; ********************* ADDC_TEST 11  ***************************************
; Funktion: Test von ADDC A,@R1

; aufgerufen von: ADDC_TEST
; ruft auf: -

; Vernderte Register: A, R1, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
ADDC_TEST11:    MOV     A,#0FFh                 ; Testmuster 1 laden
		MOV     INTRAM10,#01h           ; Testmuster 2 laden
		MOV     R1,#01h                 ; Testmuster 3 laden
		ADDC    A,@R1                   ; Befehlstest 
		ADDC    A,@R1                   ; Befehlstest 
		CJNE    A,#02h,ADDC_err11       ; Vergleich mit Erwartungshaltung 
		RET
ADDC_err11:     LJMP    ERROR_ARI           



; ********************* ADDC_TEST 12  ***************************************
; Funktion: Test von ADDC A,#data

; aufgerufen von: ADDC_TEST
; ruft auf: -

; Vernderte Register: A, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
ADDC_TEST12:    MOV     A,#0FFh                 ; Testmuster 1 laden
		ADDC    A,#01h                  ; Befehlstest
		ADDC    A,#01h                  ; Befehlstest
		CJNE    A,#02h,ADDC_err12       ; Vergleich mit Erwartungshaltung 
		RET
ADDC_err12:     LJMP    ERROR_ARI         



; ********************* SUBB_TEST 1 *****************************************
; Funktion: Test von SUBB A,R0

; aufgerufen von: SUBB_TEST
; ruft auf: -

; Vernderte Register: A, R0, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
SUBB_TEST1:     MOV     A,#55h                  ; Testmuster 1 laden
		MOV     R0,#0AAh                ; Testmuster 2 laden 
		SUBB    A,R0                    ; Befehlstest 
		SUBB    A,R0                    ; Befehlstest 
		CJNE    A,#00h,SUBB_err1        ; Vergleich mit Erwartungshaltung 
		RET
SUBB_err1:      LJMP    ERROR_ARI                  



; ********************* SUBB_TEST 2 *****************************************
; Funktion: Test von SUBB A,R1

; aufgerufen von: SUBB_TEST
; ruft auf: -

; Vernderte Register: A, R1, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
SUBB_TEST2:     MOV     A,#55h                  ; Testmuster 1 laden
		MOV     R1,#0AAh                ; Testmuster 2 laden     
		SUBB    A,R1                    ; Befehlstest 
		SUBB    A,R1                    ; Befehlstest 
		CJNE    A,#00h,SUBB_err2        ; Vergleich mit Erwartungshaltung 
		RET
SUBB_err2:      LJMP    ERROR_ARI          



; ********************* SUBB_TEST 3 *****************************************
; Funktion: Test von SUBB A,R2

; aufgerufen von: SUBB_TEST
; ruft auf: -

; Vernderte Register: A, R2, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
SUBB_TEST3:     MOV     A,#55h                  ; Testmuster 1 laden
		MOV     R2,#0AAh                ; Testmuster 2 laden 
		SUBB    A,R2                    ; Befehlstest
		SUBB    A,R2                    ; Befehlstest
		CJNE    A,#00h,SUBB_err3        ; Vergleich mit Erwartungshaltung
		RET
SUBB_err3:      LJMP    ERROR_ARI          



; ********************* SUBB_TEST 4 *****************************************
; Funktion: Test von SUBB A,R3

; aufgerufen von: SUBB_TEST
; ruft auf: -

; Vernderte Register: A, R3, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
SUBB_TEST4:     MOV     A,#55h                  ; Testmuster 1 laden
		MOV     R3,#0AAh                ; Testmuster 2 laden 
		SUBB    A,R3                    ; Befehlstest
		SUBB    A,R3                    ; Befehlstest
		CJNE    A,#00h,SUBB_err4        ; Vergleich mit Erwartungshaltung
		RET
SUBB_err4:      LJMP    ERROR_ARI         



; ********************* SUBB_TEST 5 *****************************************
; Funktion: Test von SUBB A,R4

; aufgerufen von: SUBB_TEST
; ruft auf: -

; Vernderte Register: A, R4, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
SUBB_TEST5:     MOV     A,#55h                  ; Testmuster 1 laden
		MOV     R4,#0AAh                ; Testmuster 2 laden 
		SUBB    A,R4                    ; Befehlstest 
		SUBB    A,R4                    ; Befehlstest 
		CJNE    A,#00h,SUBB_err5        ; Vergleich mit Erwartungshaltung 
		RET
SUBB_err5:      LJMP    ERROR_ARI          



; ********************* SUBB_TEST 6 *****************************************
; Funktion: Test von SUBB A,R5

; aufgerufen von: SUBB_TEST
; ruft auf: -

; Vernderte Register: A, R5, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
SUBB_TEST6:     MOV     A,#55h                  ; Testmuster 1 laden
		MOV     R5,#0AAh                ; Testmuster 2 laden 
		SUBB    A,R5                    ; Befehlstest 
		SUBB    A,R5                    ; Befehlstest 
		CJNE    A,#00h,SUBB_err6        ; Vergleich mit Erwartungshaltung 
		RET
SUBB_err6:      LJMP    ERROR_ARI          



; ********************* SUBB_TEST 7 *****************************************
; Funktion: Test von SUBB A,R6

; aufgerufen von: SUBB_TEST
; ruft auf: -

; Vernderte Register: A, R6, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
SUBB_TEST7:     MOV     A,#55h                  ; Testmuster 1 laden
		MOV     R6,#0AAh                ; Testmuster 2 laden 
		SUBB    A,R6                    ; Befehlstest 
		SUBB    A,R6                    ; Befehlstest 
		CJNE    A,#00h,SUBB_err7        ; Vergleich mit Erwartungshaltung 
		RET
SUBB_err7:      LJMP    ERROR_ARI



; ********************* SUBB_TEST 8 *****************************************
; Funktion: Test von SUBB A,R7

; aufgerufen von: SUBB_TEST
; ruft auf: -

; Vernderte Register: A, R7, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
SUBB_TEST8:     MOV     A,#55h                  ; Testmuster 1 laden
		MOV     R7,#0AAh                ; Testmuster 2 laden 
		SUBB    A,R7                    ; Befehlstest 
		SUBB    A,R7                    ; Befehlstest 
		CJNE    A,#00h,SUBB_err8        ; Vergleich mit Erwartungshaltung 
		RET
SUBB_err8:      LJMP    ERROR_ARI          
	 


; ********************* SUBB_TEST 9 *****************************************
; Funktion: Test von SUBB A,dir

; aufgerufen von: SUBB_TEST
; ruft auf: -

; Vernderte Register: A, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
SUBB_TEST9:     MOV     A,#55h                  ; Testmuster 1 laden
		MOV     INTRAM10,#0AAh          ; Testmuster 2 laden
		SUBB    A,INTRAM10              ; Befehlstest 
		SUBB    A,INTRAM10              ; Befehlstest 
		CJNE    A,#00h,SUBB_err9        ; Vergleich mit Erwartungshaltung 
		RET
SUBB_err9:      LJMP    ERROR_ARI          



; ********************* SUBB_TEST 10 ****************************************
; Funktion: Test von SUBB A,@R0

; aufgerufen von: SUBB_TEST
; ruft auf: -

; Vernderte Register: A, R0, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
SUBB_TEST10:    MOV     A,#55h                  ; Testmuster 1 laden
		MOV     INTRAM10,#0AAh          ; Testmuster 2 laden
		MOV     R0,#10h                 ; Testmuster 3 laden
		SUBB    A,@R0                   ; Befehlstest 
		SUBB    A,@R0                   ; Befehlstest 
		CJNE    A,#00h,SUBB_err10       ; Vergleich mit Erwartungshaltung
		RET
SUBB_err10:     LJMP    ERROR_ARI          



; ********************* SUBB_TEST 11 ****************************************
; Funktion: Test von SUBB A,R1

; aufgerufen von: SUBB_TEST
; ruft auf: -

; Vernderte Register: A, R1, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
SUBB_TEST11:    MOV     A,#55h                  ; Testmuster 1 laden
		MOV     INTRAM10,#0AAh          ; Testmuster 2 laden
		MOV     R1,#10h                 ; Testmuster 3 laden
		SUBB    A,@R1                   ; Befehlstest 
		SUBB    A,@R1                   ; Befehlstest 
		CJNE    A,#00h,SUBB_err11       ; Vergleich mit Erwartungshaltung
		RET
SUBB_err11:     LJMP    ERROR_ARI          



; ********************* SUBB_TEST 12 ****************************************
; Funktion: Test von SUBB A,#data

; aufgerufen von: SUBB_TEST
; ruft auf: -

; Vernderte Register: A, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
SUBB_TEST12:    MOV     A,#55h                  ; Testmuster 1 laden
		SUBB    A,#0AAh                 ; Befehlstest 
		SUBB    A,#0AAh                 ; Befehlstest 
		CJNE    A,#00h,SUBB_err12       ; Vergleich mit Erwartungshaltung 
		RET
SUBB_err12:     LJMP    ERROR_ARI          


; ********************* INC_TEST 1 ******************************************
; Funktion: Test von INC A

; aufgerufen von: INC_TEST
; ruft auf: -

; Vernderte Register: A, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
INC_TEST1:      MOV     A,#0FFh                 ; Testmuster 1 laden
		INC     A                       ; Befehlstest 
		CJNE    A,#00h,INC_err1         ; Vergleich mit Erwartungshaltung
		RET
INC_err1:       LJMP    ERROR_ARI          



; ********************* INC_TEST 2 ******************************************
; Funktion: Test von INC R0

; aufgerufen von: INC_TEST
; ruft auf: -

; Vernderte Register: R0, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
INC_TEST2:      MOV     R0,#0FFh                ; Testmuster 1 laden 
		INC     R0                      ; Befehlstest 
		CJNE    R0,#00h,INC_err2        ; Vergleich mit Erwartungshaltung 
		RET
INC_err2:       LJMP    ERROR_ARI          



; ********************* INC_TEST 3 ******************************************
; Funktion: Test von INC R1

; aufgerufen von: INC_TEST
; ruft auf: -

; Vernderte Register: R1, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
INC_TEST3:      MOV     R1,#0FFh                ; Testmuster 1 laden 
		INC     R1                      ; Befehlstest  
		CJNE    R1,#00h,INC_err3        ; Vergleich mit Erwartungshaltung
		RET
INC_err3:       LJMP    ERROR_ARI          



; ********************* INC_TEST 4 ******************************************
; Funktion: Test von INC R2

; aufgerufen von: INC_TEST
; ruft auf: -

; Vernderte Register: R2, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
INC_TEST4:      MOV     R2,#0FFh                ; Testmuster 1 laden 
		INC     R2                      ; Befehlstest  
		CJNE    R2,#00h,INC_err4        ; Vergleich mit Erwartungshaltung 
		RET
INC_err4:       LJMP    ERROR_ARI          



; ********************* INC_TEST 5 ******************************************
; Funktion: Test von INC R3

; aufgerufen von: INC_TEST
; ruft auf: -

; Vernderte Register: R3, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
INC_TEST5:      MOV     R3,#0FFh                ; Testmuster 1 laden 
		INC     R3                      ; Befehlstest 
		CJNE    R3,#00h,INC_err5        ; Vergleich mit Erwartungshaltung
		RET
INC_err5:       LJMP    ERROR_ARI          



; ********************* INC_TEST 6 ******************************************
; Funktion: Test von INC R4

; aufgerufen von: INC_TEST
; ruft auf: -

; Vernderte Register: R4, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
INC_TEST6:      MOV     R4,#0FFh                ; Testmuster 1 laden 
		INC     R4                      ; Befehlstest 
		CJNE    R4,#00h,INC_err6        ; Vergleich mit Erwartungshaltung 
		RET
INC_err6:       LJMP    ERROR_ARI          



; ********************* INC_TEST 7 ******************************************
; Funktion: Test von INC R5

; aufgerufen von: INC_TEST
; ruft auf: -

; Vernderte Register: R5, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
INC_TEST7:      MOV     R5,#0FFh                ; Testmuster 1 laden 
		INC     R5                      ; Befehlstest 
		CJNE    R5,#00h,INC_err7        ; Vergleich mit Erwartungshaltung
		RET
INC_err7:       LJMP    ERROR_ARI          
			


; ********************* INC_TEST 8 ******************************************
; Funktion: Test von INC R6

; aufgerufen von: INC_TEST
; ruft auf: -

; Vernderte Register: R6, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
INC_TEST8:      MOV     R6,#0FFh                ; Testmuster 1 laden 
		INC     R6                      ; Befehlstest 
		CJNE    R6,#00h,INC_err8        ; Vergleich mit Erwartungshaltung 
		RET
INC_err8:       LJMP    ERROR_ARI          



; ********************* INC_TEST 9 ******************************************
; Funktion: Test von INC R7

; aufgerufen von: INC_TEST
; ruft auf: -

; Vernderte Register: R7, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
INC_TEST9:      MOV     R7,#0FFh                ; Testmuster 1 laden 
		INC     R7                      ; Befehlstest 
		CJNE    R7,#00h,INC_err9        ; Vergleich mit Erwartungshaltung
		RET
INC_err9:       LJMP    ERROR_ARI          



; ********************* INC_TEST 10 *****************************************
; Funktion: Test von INC dir

; aufgerufen von: INC_TEST
; ruft auf: -

; Vernderte Register: A, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
INC_TEST10:     MOV     INTRAM10,#0FFh          ; Testmuster 1 laden
		INC     INTRAM10                ; Befehlstest 
		MOV     A,INTRAM10              
		CJNE    A,#00h,INC_err10        ; Vergleich mit Erwartungshaltung 
		RET
INC_err10:      LJMP    ERROR_ARI          



; ********************* INC_TEST 11 *****************************************
; Funktion: Test von INC @R0

; aufgerufen von: INC_TEST
; ruft auf: -

; Vernderte Register: A, R0, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
INC_TEST11:     MOV     INTRAM10,#0FFh          ; Testmuster 1 laden
		MOV     R0,#10h                 ; Testmuster 2 laden
		INC     @R0                     ; Befehlstest
		MOV     A,@R0                
		CJNE    A,#00h,INC_err11        ; Vergleich mit Erwartungshaltung
		RET
INC_err11:      LJMP    ERROR_ARI          



; ********************* INC_TEST 12 *****************************************
; Funktion: Test von INC @R1

; aufgerufen von: INC_TEST
; ruft auf: -

; Vernderte Register: A, R1, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
INC_TEST12:     MOV     INTRAM10,#0FFh          ; Testmuster 1 laden
		MOV     R1,#10H                 ; Testmuster 2 laden
		INC     @R1                     ; Befehlstest
		MOV     A,@R1
		CJNE    A,#00h,INC_err12        ; Vergleich mit Erwartungshaltung 
		RET
INC_err12:      LJMP    ERROR_ARI          



; ********************* INC_TEST 13 *****************************************
; Funktion: Test von INC DPTR

; aufgerufen von: INC_TEST
; ruft auf: -

; Vernderte Register: A, DPTR, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
INC_TEST13:     MOV     DPL,#0FEh               ; ldt Low-Byte 
		MOV     DPH,#0FEh               ; ldt High-Byte
		INC     DPTR                    ; Befehlstest            
		INC     DPTR                    ; Befehlstest            
		MOV     A,DPL  
		CJNE    A,#00h,INC_err13        ; Vergleich mit Erwartungshaltung
		MOV     A,DPH  
		CJNE    A,#0FFh,INC_err13       ; Vergleich mit Erwartungshaltung 
		RET
INC_err13:      LJMP    ERROR_ARI          



; ********************* DEC_TEST 1 ******************************************
; Funktion: Test von DEC A

; aufgerufen von: DEC_TEST
; ruft auf: -

; Vernderte Register: A, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
DEC_TEST1:      MOV     A,#00h                  ; Testmuster 1 laden
		DEC     A                       ; Befehlstest
		CJNE    A,#0FFh,DEC_err1        ; Vergleich mit Erwartungshaltung 
		RET
DEC_err1:       LJMP    ERROR_ARI          



; ********************* DEC_TEST 2 ******************************************
; Funktion: Test von DEC R0

; aufgerufen von: DEC_TEST
; ruft auf: -

; Vernderte Register: R0, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
DEC_TEST2:      MOV     R0,#00h                 ; Testmuster 1 laden
		DEC     R0                      ; Befehlstest 
		CJNE    R0,#0FFh,DEC_err2       ; Vergleich mit Erwartungshaltung 
		RET
DEC_err2:       LJMP    ERROR_ARI          



; ********************* DEC_TEST 3 ******************************************
; Funktion: Test von DEC R1

; aufgerufen von: DEC_TEST
; ruft auf: -

; Vernderte Register: R1, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
DEC_TEST3:      MOV     R1,#00h                 ; Testmuster 1 laden 
		DEC     R1                      ; Befehlstest 
		CJNE    R1,#0FFh,DEC_err3       ; Vergleich mit Erwartungshaltung
		RET
DEC_err3:       LJMP    ERROR_ARI          



; ********************* DEC_TEST 4 ******************************************
; Funktion: Test von DEC R2

; aufgerufen von: DEC_TEST
; ruft auf: -

; Vernderte Register: R2, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
DEC_TEST4:      MOV     R2,#00h                 ; Testmuster 1 laden 
		DEC     R2                      ; Befehlstest 
		CJNE    R2,#0FFh,DEC_err4       ; Vergleich mit Erwartungshaltung
		RET
DEC_err4:       LJMP    ERROR_ARI          



; ********************* DEC_TEST 5 ******************************************
; Funktion: Test von DEC R3

; aufgerufen von: DEC_TEST
; ruft auf: -

; Vernderte Register: R3, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
DEC_TEST5:      MOV     R3,#00h                 ; Testmuster 1 laden 
		DEC     R3                      ; Befehlstest 
		CJNE    R3,#0FFh,DEC_err5       ; Vergleich mit Erwartungshaltung 
		RET
DEC_err5:       LJMP    ERROR_ARI          



; ********************* DEC_TEST 6 ******************************************
; Funktion: Test von DEC R4

; aufgerufen von: DEC_TEST
; ruft auf: -

; Vernderte Register: R4, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
DEC_TEST6:      MOV     R4,#00h                 ; Testmuster 1 laden 
		DEC     R4                      ; Befehlstest 
		CJNE    R4,#0FFh,DEC_err6       ; Vergleich mit Erwartungshaltung
		RET
DEC_err6:       LJMP    ERROR_ARI          



; ********************* DEC_TEST 7 ******************************************
; Funktion: Test von DEC R5

; aufgerufen von: DEC_TEST
; ruft auf: -

; Vernderte Register: R5, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
DEC_TEST7:      MOV     R5,#00h                 ; Testmuster 1 laden 
		DEC     R5                      ; Befehlstest 
		CJNE    R5,#0FFh,DEC_err7       ; Vergleich mit Erwartungshaltung
		RET
DEC_err7:       LJMP    ERROR_ARI          



; ********************* DEC_TEST 8 ******************************************
; Funktion: Test von DEC R6

; aufgerufen von: DEC_TEST
; ruft auf: -

; Vernderte Register: R6, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
DEC_TEST8:      MOV     R6,#00h                 ; Testmuster 1 laden 
		DEC     R6                      ; Befehlstest 
		CJNE    R6,#0FFh,DEC_err8       ; Vergleich mit Erwartungshaltung
		RET
DEC_err8:       LJMP    ERROR_ARI          



; ********************* DEC_TEST 9 ******************************************
; Funktion: Test von DEC R7

; aufgerufen von: DEC_TEST
; ruft auf: -

; Vernderte Register: R7, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
DEC_TEST9:      MOV     R7,#00h                 ; Testmuster 1 laden 
		DEC     R7                      ; Befehlstest 
		CJNE    R7,#0FFh,DEC_err9       ; Vergleich mit Erwartungshaltung 
		RET
DEC_err9:       LJMP    ERROR_ARI          



; ********************* DEC_TEST 10 *****************************************
; Funktion: Test von DEC dir

; aufgerufen von: DEC_TEST
; ruft auf: -

; Vernderte Register: A, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
DEC_TEST10:     MOV     INTRAM10,#00h           ; Testmuster 1 laden
		DEC     INTRAM10                ; Befehlstest
		MOV     A,INTRAM10 
		CJNE    A,#0FFh,DEC_err10       ; Vergleich mit Erwartungshaltung
		RET
DEC_err10:      LJMP    ERROR_ARI          



; ********************* DEC_TEST 11 *****************************************
; Funktion: Test von DEC @R0

; aufgerufen von: DEC_TEST
; ruft auf: -

; Vernderte Register: A, R0, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
DEC_TEST11:     MOV     INTRAM10,#00h           ; Testmuster 1 laden
		MOV     R0,#10h                 ; Testmuster 2 laden
		DEC     @R0                     ; Befehlstest
		MOV     A,@R0  
		CJNE    A,#0FFh,DEC_err11       ; Vergleich mit Erwartungshaltung 
		RET
DEC_err11:      LJMP    ERROR_ARI



; ********************* DEC_TEST 12 *****************************************
; Funktion: Test von DEC @R1

; aufgerufen von: DEC_TEST
; ruft auf: -

; Vernderte Register: A, R1, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
DEC_TEST12:     MOV     INTRAM10,#00h           ; Testmuster 1 laden
		MOV     R1,#10h                 ; Testmuster 2 laden
		DEC     @R1                     ; Befehlstest
		MOV     A,@R1                   
		CJNE    A,#0FFh,DEC_err12       ; Vergleich mit Erwartungshaltung
		RET
DEC_err12:      LJMP    ERROR_ARI



; ********************* MUL_TEST1 *******************************************
; Funktion: Test von MUL AB

; aufgerufen von: MUL_TEST
; ruft auf: -

; Vernderte Register: A, B, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
MUL_TEST1:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     B,#55h                  ; Testmuster 2 laden 
		MUL     AB                      ; Befehlstest
		CJNE    A,#72h,MUL_err1         ; Vergleich mit Erwartungshaltung
		MOV     A,B 
		CJNE    A,#38h,MUL_err1         ; Vergleich mit Erwartungshaltung 
		RET
MUL_err1:       LJMP    ERROR_ARI                    



; ********************* DIV_TEST1 *******************************************
; Funktion: Test von DIV AB

; aufgerufen von: DIV_TEST
; ruft auf: -

; Vernderte Register: A, B, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
DIV_TEST1:      MOV     A,#0AAh                 ; Testmuster 1 laden 
		MOV     B,#54h                  ; Testmuster 2 laden 
		DIV     AB                      ; Befehlstest
		CJNE    A,#02h,DIV_err1         ; Vergleich mit Erwartungshaltung 
		MOV     A,B                     
		CJNE    A,#02h,DIV_err1         ; Vergleich mit Erwartungshaltung
		RET
DIV_err1:       LJMP    ERROR_ARI                   



; ********************* DA_TEST1 ********************************************
; Funktion: Test von DA A

; aufgerufen von: DA_TEST
; ruft auf: -

; Vernderte Register: A, PSW
; Stacktiefe: 2 Bytes
; ***************************************************************************
DA_TEST1:       MOV     A,#0AAh                 ; Testmuster 1 laden
		ADD     A,#55h                  ; Befehlstest
		DA      A                    
		CJNE    A,#65h,DA_err1          ; Vergleich mit Erwartungshaltung 
		RET
DA_err1:        LJMP    ERROR_ARI



; ********************* ADD_TEST ********************************************
; Funktion: Sammelaufruf aller ADD-Tests

; aufgerufen von: MAIN
; ruft auf: ADD_TEST1 - ADD_TEST12

; Vernderte Register: A, R0-R7, PSW
; Stacktiefe: 2 Bytes + aufgerufene Funktionen
; ***************************************************************************
ADD_TEST:       LCALL   ADD_TEST1
		LCALL   ADD_TEST2
		LCALL   ADD_TEST3
		LCALL   ADD_TEST4
		LCALL   ADD_TEST5
		LCALL   ADD_TEST6
		LCALL   ADD_TEST7
		LCALL   ADD_TEST8
		LCALL   ADD_TEST9
		LCALL   ADD_TEST10
		LCALL   ADD_TEST11
		LCALL   ADD_TEST12
		RET



; ********************* ADDC_TEST *******************************************
; Funktion: Sammelaufruf aller ADDC-Tests

; aufgerufen von: MAIN
; ruft auf: ADDC_TEST1 - ADDC_TEST12

; Vernderte Register: A, R0-R7, PSW
; Stacktiefe: 2 Bytes + aufgerufene Funktionen
; ***************************************************************************
ADDC_TEST:      CLR     C                       ; Carry lschen
		LCALL   ADDC_TEST1           
		LCALL   ADDC_TEST2
		LCALL   ADDC_TEST3
		LCALL   ADDC_TEST4
		LCALL   ADDC_TEST5
		LCALL   ADDC_TEST6
		LCALL   ADDC_TEST7
		LCALL   ADDC_TEST8
		LCALL   ADDC_TEST9
		LCALL   ADDC_TEST10
		LCALL   ADDC_TEST11
		LCALL   ADDC_TEST12
		RET



; ********************* SUBB_TEST *******************************************
; Funktion: Sammelaufruf aller SUBB-Tests

; aufgerufen von: MAIN
; ruft auf: SUBB_TEST1 - SUBB_TEST12

; Vernderte Register: A, R0-R7, PSW
; Stacktiefe: 2 Bytes + aufgerufene Funktionen
; ***************************************************************************
SUBB_TEST:      CLR     C                       ; Carry lschen
		LCALL   SUBB_TEST1           
		LCALL   SUBB_TEST2
		LCALL   SUBB_TEST3
		LCALL   SUBB_TEST4
		LCALL   SUBB_TEST5
		LCALL   SUBB_TEST6
		LCALL   SUBB_TEST7
		LCALL   SUBB_TEST8
		LCALL   SUBB_TEST9
		LCALL   SUBB_TEST10
		LCALL   SUBB_TEST11
		LCALL   SUBB_TEST12
		RET



; ********************* INC_TEST ********************************************
; Funktion: Sammelaufruf aller INC-Tests

; aufgerufen von: MAIN
; ruft auf: INC_TEST1 - INC_TEST13

; Vernderte Register: A, R0-R7, PSW
; Stacktiefe: 2 Bytes + aufgerufene Funktionen
; ***************************************************************************
INC_TEST:       LCALL   INC_TEST1            
		LCALL   INC_TEST2
		LCALL   INC_TEST3
		LCALL   INC_TEST4
		LCALL   INC_TEST5
		LCALL   INC_TEST6
		LCALL   INC_TEST7
		LCALL   INC_TEST8
		LCALL   INC_TEST9
		LCALL   INC_TEST10
		LCALL   INC_TEST11
		LCALL   INC_TEST12
		LCALL   INC_TEST13
		RET
		


; ********************* DEC_TEST ********************************************
; Funktion: Sammelaufruf aller DEC-Tests

; aufgerufen von: MAIN
; ruft auf: DEC_TEST1 - DEC_TEST12

; Vernderte Register: A, R0-R7, PSW
; Stacktiefe: 2 Bytes + aufgerufene Funktionen
; ***************************************************************************
DEC_TEST:       LCALL   DEC_TEST1            
		LCALL   DEC_TEST2
		LCALL   DEC_TEST3
		LCALL   DEC_TEST4
		LCALL   DEC_TEST5
		LCALL   DEC_TEST6
		LCALL   DEC_TEST7
		LCALL   DEC_TEST8
		LCALL   DEC_TEST9
		LCALL   DEC_TEST10
		LCALL   DEC_TEST11
		LCALL   DEC_TEST12
		RET



; ********************* MUL_TEST ********************************************
; Funktion: Aufruf des MUL-Tests

; aufgerufen von: MAIN
; ruft auf: MUL_TEST1

; Vernderte Register: A, B, PSW
; Stacktiefe: 2 Bytes + aufgerufene Funktionen
; ***************************************************************************
MUL_TEST:       LCALL   MUL_TEST1            
		RET



; ********************* DIV_TEST ********************************************
; Funktion: Aufruf des DIV-Tests

; aufgerufen von: MAIN
; ruft auf: DIV_TEST1

; Vernderte Register: A, B, PSW
; Stacktiefe: 2 Bytes + aufgerufene Funktionen
; ***************************************************************************
DIV_TEST:       LCALL   DIV_TEST1            
		RET



; ********************* DA_TEST *********************************************
; Funktion: Aufruf des DA-Tests

; aufgerufen von: MAIN
; ruft auf: DA_TEST1

; Vernderte Register: A, PSW
; Stacktiefe: 2 Bytes + aufgerufene Funktionen
; ***************************************************************************
DA_TEST:        LCALL   DA_TEST1             
		RET 



; ***************************************************************************
ERROR_ARI:      MOV     FEHLER,#FEHLER_ARI      ; Fehlerspeicher laden
		LJMP    ERROR
; ***************************************************************************

