; Modul: BIT_TEST.ASM

; Version 1.00          BIA - Referat 5.2                    Datum: 15.09.2000

; Funktion:
; Die Unterprogramme testen die BIT-Adressierung im bitadressierbaren
; Speicherbereich von 20H bis 2FH (internes RAM). Daraus ergeben
; sich 128 Bitadressen. Aus Grnden des Zeitaufwandes werden
; acht gezielt ausgesuchte Adressen fr die Tests ausgewhlt
; (wandernde 1 vor 0-Hintergrund in der Bitadresse).
; Vorgehensweise:
; Zunchst wird der Speicherbereich gelscht.
; Dann wird jeweils das ausgewhlte Bit gesetzt und berprft.
; Der restliche Speicher wird jeweils auf korrekten Inhalt berprft.
; Danach wird das jeweils gesetzte Bit wieder gelscht.
; (Die Bitbefehle SETB bit und CLR bit werden bei diesen Operationen gleich-
; zeitig getestet).
; In einem weiteren Test werden die Befehle fr logische Bitoperationen getestet.

; Eingabeparameter: keine
; Ausgabeparameter: keine
; Vernderte Register: siehe Einzelfunktionen
; Vernderte Speicherbereiche: siehe Einzelfunktionen

; Fehleraussprung: nach Funktion ERROR

; bergeordnete Module: LOGITEST.ASM
; Untergeordnete Module: keine

; Verwendete Registerbank: aktuelle Bank
; ***************************************************************************



; ********************* SPEICHERVORBELEGUNG *********************************
; Funktion: Belegen des bitadressierbaren Speicherbereichs mit 0

; aufgerufen von: BIT_TEST_A, BIT_TEST_B, BIT_TEST_C, BIT_TEST_D
; ruft auf: -

; Vernderte Register: R0, PSW
; Vernderte Speicherbereiche: bitadressierbarer Speicherbereich (20h-2Fh)

; Stacktiefe: 2 Bytes
; *************************************************************************** 
SPEICHERVORBELEGUNG:    
                MOV     R0,#2Fh                 ; Speicherbereich von
comp1:          MOV     @R0,#00h                ; 20h bis 2Fh wird mit 0
                DEC     R0                      ; vorbelegt
                CJNE    R0,#1Fh,comp1
                RET



; ********************* BIT_TEST1 *******************************************
; Funktion: Testbit Adresse 01h

; aufgerufen von: BIT_TEST_A
; ruft auf: BIT_SPEICHER_RUECKL

; Vernderte Register: A, PSW
; Vernderte Speicherbereiche: Testbit (Bit 01h)

; Stacktiefe: 2 Bytes + aufgerufene Funktionen
; *************************************************************************** 
BIT_TEST1:      MOV     BYTE_ADR,#20h           ; Merker fr Byte-Adressenausschlu vorbelegen
                SETB    01h                     ; setzt Testbit 
                MOV     A,INTRAM20              
                CJNE    A,#02h,Bit_err          ; Vergleich mit Erwartungshaltung
                LCALL   BIT_SPEICHER_RUECKL     ; brigen bitadressierbaren Speicher prfen
                CLR     01h                     ; lscht Testbit               
                RET



; ********************* BIT_TEST2 *******************************************
; Funktion: Testbit Adresse 02h

; aufgerufen von: BIT_TEST_A
; ruft auf: BIT_SPEICHER_RUECKL

; Vernderte Register: A, PSW
; Vernderte Speicherbereiche: Testbit (Bit 02h)

; Stacktiefe: 2 Bytes + aufgerufene Funktionen
; *************************************************************************** 
BIT_TEST2:      MOV     BYTE_ADR,#20h           ; Merker fr Byte-Adressenausschlu vorbelegen
                SETB    02h                     ; setzt Testbit 
                MOV     A,INTRAM20          
                CJNE    A,#04h,Bit_err          ; Vergleich mit Erwartungshaltung 
                LCALL   BIT_SPEICHER_RUECKL     ; brigen bitadressierbaren Speicher prfen
                CLR     02h                     ; lscht Testbit               
                RET



; ********************* BIT_TEST3 *******************************************
; Funktion: Testbit Adresse 04h

; aufgerufen von: BIT_TEST_B
; ruft auf: BIT_SPEICHER_RUECKL

; Vernderte Register: A, PSW
; Vernderte Speicherbereiche: Testbit (Bit 04h)

; Stacktiefe: 2 Bytes + aufgerufene Funktionen
; *************************************************************************** 
BIT_TEST3:      MOV     BYTE_ADR,#20h           ; Merker fr Byte-Adressenausschlu vorbelegen
                SETB    04h                     ; setzt Testbit 
                MOV     A,INTRAM20              
                CJNE    A,#10h,Bit_err          ; Vergleich mit Erwartungshaltung 
                LCALL   BIT_SPEICHER_RUECKL     ; brigen bitadressierbaren Speicher prfen
                CLR     04h                     ; lscht Testbit               
                RET



; ********************* BIT_TEST4 *******************************************
; Funktion: Testbit Adresse 08h

; aufgerufen von: BIT_TEST_B
; ruft auf: BIT_SPEICHER_RUECKL

; Vernderte Register: A, PSW
; Vernderte Speicherbereiche: Testbit (Bit 08h)

; Stacktiefe: 2 Bytes + aufgerufene Funktionen
; *************************************************************************** 
BIT_TEST4:      MOV     BYTE_ADR,#21h           ; Merker fr Byte-Adressenausschlu vorbelegen
                SETB    08h                     ; setzt Testbit 
                MOV     A,INTRAM21              
                CJNE    A,#01H,Bit_err          ; Vergleich mit Erwartungshaltung 
                LCALL   BIT_SPEICHER_RUECKL     ; brigen bitadressierbaren Speicher prfen
                CLR     08h                     ; lscht Testbit                       
                RET



; ********************* BIT_TEST5 *******************************************
; Funktion: Testbit Adresse 10h

; aufgerufen von: BIT_TEST_C
; ruft auf: BIT_SPEICHER_RUECKL

; Vernderte Register: A, PSW
; Vernderte Speicherbereiche: Testbit (Bit 10h)

; Stacktiefe: 2 Bytes + aufgerufene Funktionen
; *************************************************************************** 
BIT_TEST5:      MOV     BYTE_ADR,#22h           ; Merker fr Byte-Adressenausschlu vorbelegen
                SETB    10h                     ; setzt Testbit 
                MOV     A,INTRAM22              
                CJNE    A,#01h,Bit_err          ; Vergleich mit Erwartungshaltung 
                LCALL   BIT_SPEICHER_RUECKL     ; brigen bitadressierbaren Speicher prfen
                CLR     10h                     ; lscht Testbit
                        RET                     



; ********************* BIT_TEST6 *******************************************
; Funktion: Testbit Adresse 20h

; aufgerufen von: BIT_TEST_C
; ruft auf: BIT_SPEICHER_RUECKL

; Vernderte Register: A, PSW
; Vernderte Speicherbereiche: Testbit (Bit 20h)

; Stacktiefe: 2 Bytes + aufgerufene Funktionen
; *************************************************************************** 
BIT_TEST6:      MOV     BYTE_ADR,#24h           ; Merker fr Byte-Adressenausschlu vorbelegen
                SETB    20h                     ; setzt Testbit
                MOV     A,INTRAM24              
                CJNE    A,#01h,Bit_err          ; Vergleich mit Erwartungshaltung 
                LCALL   BIT_SPEICHER_RUECKL     ; brigen bitadressierbaren Speicher prfen
                CLR     20h                     ; lscht Testbit
                RET
                        


; ********************* BIT_TEST7 *******************************************
; Funktion: Testbit Adresse 40h

; aufgerufen von: BIT_TEST_D
; ruft auf: BIT_SPEICHER_RUECKL

; Vernderte Register: A, PSW
; Vernderte Speicherbereiche: Testbit (Bit 40h)

; Stacktiefe: 2 Bytes + aufgerufene Funktionen
; *************************************************************************** 
BIT_TEST7:      MOV     BYTE_ADR,#28h           ; Merker fr Byte-Adressenausschlu vorbelegen
                SETB    40h                     ; setzt Testbit 
                MOV     A,INTRAM28              
                CJNE    A,#01h,Bit_err          ; Vergleich mit Erwartungshaltung 
                LCALL   BIT_SPEICHER_RUECKL     ; brigen bitadressierbaren Speicher prfen
                CLR     40h                     ; lscht Testbit 
                RET
                        


; ********************* BIT_TEST8 *******************************************
; Funktion: Testbit Adresse 7Fh

; aufgerufen von: BIT_TEST_D
; ruft auf: BIT_SPEICHER_RUECKL

; Vernderte Register: A, PSW
; Vernderte Speicherbereiche: Testbit (bit 7Fh)

; Stacktiefe: 2 Bytes + aufgerufene Funktionen
; *************************************************************************** 
BIT_TEST8:      MOV     BYTE_ADR,#2Fh           ; Merker fr Byte-Adressenausschlu vorbelegen
                SETB    7Fh                     ; setzt Testbit
                MOV     A,INTRAM2F              
                CJNE    A,#80h,Bit_err          ; Vergleich mit Erwartungshaltung 
                LCALL   BIT_SPEICHER_RUECKL     ; brigen bitadressierbaren Speicher prfen
                CLR     7Fh                     ; lscht Testbit
                RET
                        


; ***************************************************************************
Bit_err:        MOV     FEHLER,#FEHLER_BIT      ; Fehlerspeicher laden
                LJMP    ERROR
; ***************************************************************************



; ********************* BIT_SPEICHER_RUECKL *********************************
; Funktion: berprft den bitadressierbaren Speicherbereich (20h-2Fh) mit 
;           Ausnahme des gerade beschriebenen Bytes auf korrekten Inhalt.

; aufgerufen von: BIT_TEST1 - BIT_TEST_8
; ruft auf: - 

; Vernderte Register: A, R0, PSW
; Vernderte Speicherbereiche: keine

; Stacktiefe: 2 Bytes
; *************************************************************************** 
BIT_SPEICHER_RUECKL:
                MOV     R0,#20h                 ; Anfang des bitadressierbaren Bereichs
comp2:          MOV     A,R0                    
                CJNE    A,BYTE_ADR,comp3        ; Position des Datenbytes, welches =! 0 ist ?
                INC     R0                      ; falls ja, Position inkrementieren
comp3:          CJNE    R0,#30h,comp4           ; Ende des bitadressierbaren Bereichs?
                SJMP    comp5
comp4:          CJNE    @R0,#00h,BIT_err        ; aktuelles Byte==0 ?              
                INC     R0                      ; Position inkrementieren
                SJMP    comp2
comp5:          RET                            



; ********************* BITBEFEHLE ******************************************
; Funktion: berprft die bitorientierten Befehle auf korrekte Funktion

; aufgerufen von: BIT_TEST_D
; ruft auf: - 

; Vernderte Register: PSW
; Vernderte Speicherbereiche: Bitadresse 01h

; Stacktiefe: 2 Bytes
; *************************************************************************** 
BITBEFEHLE:     SETB    01h                     
                MOV     C,01h                   ; Transfer            
                JNC     BIT_err                 ; Ergebnis OK?
                CPL     C                       
                ANL     C,01h                   
                JC      BIT_err                 ; Ergebnis OK?
                ORL     C,01h                   
                JNC     BIT_err                 ; Ergebnis OK?                             
                CLR     C                       
                JC      BIT_err                 ; Ergebnis OK?             

                SETB    C                           
                CLR     01h                     
                MOV     01h,C                   ; Transfer    
                JNB     01h,BIT_err             ; Ergebnis OK?                 
                ANL     C,/01h                  
                JC      BIT_err                 ; Ergebnis OK?     
                ORL     C,/01h                  
                JC      BIT_err                 ; Ergebnis OK?                      
                CLR     01h                         
                JB      01h,BIT_err             ; Ergebnis OK?     
                CPL     01h                                               
                JNB     01h,BIT_err             ; Ergebnis OK?    
                RET




