$LIST

; Modul: CPU_TEST.ASM

; Version 1.00          BIA - Referat 5.2                    Datum: 15.09.2000

; Fr Infineon-Mikrocontroller 80C537

; Funktion:
; Rahmenprogramm fr CPU-Tests
; Die Einzeltests werden durch das Rahmenprogramm nacheinander aufgerufen.
; In einer realen Anwendung ist dieses Programm durch einen geeigneten
; Testmanager zu ersetzen.

; Eingabeparameter: keine
; Ausgabeparameter: keine

; bergeordnete Module: keine
; Untergeordnete Module: ACC_TEST.ASM, ARI_TEST.ASM, CRS_TEST.ASM, 
;                        IO_TEST.ASM, JNZ_TEST.ASM, LOGITEST.ASM,
;                        PC_TEST.ASM, PPR_TEST.ASM, ROM_TEST.ASM,
;                        SFR_TEST.ASM, TRANTEST.ASM, WD_TEST.ASM, 
;                        XRAMTEST.ASM, SIGNAT.ASM

; aufgerufen von: -
; ruft auf: WD_TEST1
;           PC_TEST                
;           ACC_TEST               
;           JNZ_TEST               
;           PPR_TEST               
;           ADD_TEST               
;           ADDC_TEST
;           SUBB_TEST
;           INC_TEST
;           DEC_TEST
;           MUL_TEST
;           DIV_TEST
;           DA_TEST
;           ANL_TEST               
;           ORL_TEST
;           XRL_TEST
;           C_R_S_TEST
;           BIT_TEST_A
;           BIT_TEST_B
;           BIT_TEST_C
;           BIT_TEST_D
;           MOV_TEST               
;           XCH_TEST
;           MOVX_TEST
;           MOVC_TEST
;           IO_TEST1               
;           IO_TEST5               
;           XRAM_TEST1             
;           XRAM_TEST2             
;           ROM_TEST               
;           SFR_TEST_B             
;           SFR_TEST_DPSEL
;           SFR_TEST_DPH
;           SFR_TEST_DPL
;           SFR_TEST_CCH1
;           SFR_TEST_CCH2
;           SFR_TEST_CCH3
;           SFR_TEST_CCH4
;           SFR_TEST_CCL1
;           SFR_TEST_CCL2
;           SFR_TEST_CCL3
;           SFR_TEST_CCL4
;           SFR_TEST_CMEN
;           SFR_TEST_CMH0
;           SFR_TEST_CMH1
;           SFR_TEST_CMH2
;           SFR_TEST_CMH3
;           SFR_TEST_CMH4
;           SFR_TEST_CMH5
;           SFR_TEST_CMH6
;           SFR_TEST_CMH7
;           SFR_TEST_CML0
;           SFR_TEST_CML1
;           SFR_TEST_CML2
;           SFR_TEST_CML3
;           SFR_TEST_CML4
;           SFR_TEST_CML5
;           SFR_TEST_CML6
;           SFR_TEST_CML7

; Stacktiefe: aufgerufene Funktionen
; Verwendete Registerbank: Bank 0
;   Die Tests sind auf die Verwendung mit Registerbank 0 abgestimmt, bei
;   Verwendung einer anderen Registerbank mssen evtl. nderungen 
;   vorgenommen werden.

; Hinweis: 
; Whrend der Abarbeitung der Tests mssen Interrupts gesperrt sein.
; ***************************************************************************

		ORG     0000h

$INCLUDE (REG517.INC)
$INCLUDE (WD_TEST.ASM)                          ; Watchdogtest                
$INCLUDE (DEC.ASM)                              ; Deklaration von Variablen und Konstanten
$INCLUDE (PC_TEST.ASM)                          ; Programcountertest
$INCLUDE (ACC_TEST.ASM)                         ; Akkutest
$INCLUDE (JNZ_TEST.ASM)                         ; JNZ-Test
$INCLUDE (PPR_TEST.ASM)                         ; PUSH-POP-RET-Test
$INCLUDE (ARI_TEST.ASM)                         ; Test Arithmetische Operationen
$INCLUDE (LOGITEST.ASM)                         ; Test Logische Operationen
$INCLUDE (TRANTEST.ASM)                         ; Test Transferbefehle
$INCLUDE (IO_TEST.ASM)                          ; Test IO-Ports
$INCLUDE (XRAMTEST.ASM)                         ; Test des externen RAM
$INCLUDE (ROM_TEST.ASM)                         ; Test des Programmspeichers
$INCLUDE (SFR_TEST.ASM)                         ; Test der Special Function Register
$INCLUDE (SIGNAT.ASM)                           ; Signaturberechnung

; ***************************************************************************
ERROR:          
		; Raum fr sicherheitsgerichtete Aktionen
		
		MOV     WDTREL,#RELOADTIME      ; WD-Reloadregister mit Reloadwert refreshen
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		MOV     WD_TEST_FLAG,#0         ; Damit fhrt ein WD-Reset zur Fehlerroutine
		NOP
		NOP
		NOP
		NOP
		NOP
		SJMP    ERROR
		NOP                             
		NOP
		NOP
		NOP
		NOP
		LJMP    ERROR                   ; LJMP, falls SJMP ignoriert wird
; ***************************************************************************



; ************* Hauptprogramm ***********************************************
MAIN:           MOV     WDTREL,#RELOADTIME      ; WD-Reloadregister mit Reloadwert refreshen
		MOV     WD_TEST_FLAG,#0         ; Damit fhrt ein WD-Reset zur Fehlerroutine
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		SETB    TESTSIGNAL
		LCALL   WD_TEST1                ; Watchdogtest (WD_TEST.ASM)
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		CLR     TESTSIGNAL

		LCALL   PC_TEST                 ; Programcountertest (PC_TEST.ASM)
		LCALL   ACC_TEST                ; Akkutest (ACC_TEST.ASM)
		LCALL   JNZ_TEST                ; JNZ-Test (JNZ_TEST.ASM)
		LCALL   PPR_TEST                ; PUSH-POP-RET-Test (PPR_TEST.ASM)
		
		LCALL   ADD_TEST                ; Test der Arithmetikbefehle (ARI_TEST.ASM)
		LCALL   ADDC_TEST
		LCALL   SUBB_TEST
		LCALL   INC_TEST
		LCALL   DEC_TEST
		LCALL   MUL_TEST
		LCALL   DIV_TEST
		LCALL   DA_TEST

		LCALL   ANL_TEST                ; Test der Logikbefehle (LOGITEST.ASM)
		LCALL   ORL_TEST
		LCALL   XRL_TEST
		LCALL   C_R_S_TEST
		LCALL   BIT_TEST_A
		LCALL   BIT_TEST_B
		LCALL   BIT_TEST_C
		LCALL   BIT_TEST_D

		LCALL   MOV_TEST                ; Test der Transferbefehle (TRANTEST.ASM)
		LCALL   XCH_TEST
		LCALL   MOVX_TEST
		LCALL   MOVC_TEST

		LCALL   IO_TEST1               ; Test IO-Port 1 (IO_TEST.ASM)
		LCALL   IO_TEST5               ; Test IO-Port 5
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT

		LCALL   XRAM_TEST1              ; Test des externen RAM (XRAMTEST.ASM)
		LCALL   XRAM_TEST2              ; Test des externen RAM (XRAMTEST.ASM)
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   XRAM_TEST1              ; Test des externen RAM (XRAMTEST.ASM)
		LCALL   XRAM_TEST2              ; Test des externen RAM (XRAMTEST.ASM)
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   XRAM_TEST1              ; Test des externen RAM (XRAMTEST.ASM)
		LCALL   XRAM_TEST2              ; Test des externen RAM (XRAMTEST.ASM)
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   XRAM_TEST1              ; Test des externen RAM (XRAMTEST.ASM)
		LCALL   XRAM_TEST2              ; Test des externen RAM (XRAMTEST.ASM)
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		
		LCALL   ROM_TEST                ; Test des Programmspeichers (ROM_TEST.ASM)
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   ROM_TEST                ; Test des Programmspeichers (ROM_TEST.ASM)
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   ROM_TEST                ; Test des Programmspeichers (ROM_TEST.ASM)
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   ROM_TEST                ; Test des Programmspeichers (ROM_TEST.ASM)
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   ROM_TEST                ; Test des Programmspeichers (ROM_TEST.ASM)
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   ROM_TEST                ; Test des Programmspeichers (ROM_TEST.ASM)
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   ROM_TEST                ; Test des Programmspeichers (ROM_TEST.ASM)
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   ROM_TEST                ; Test des Programmspeichers (ROM_TEST.ASM)
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT

; Die Speichertestfunktionen werden merfach aufgerufen, um eine schnellere
; Abarbeitung der Tests zu erreichen.

	       
		LCALL   SFR_TEST_B              ; Test der Special Function Register
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   SFR_TEST_DPSEL
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   SFR_TEST_DPH
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   SFR_TEST_DPL
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   SFR_TEST_CCH1
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   SFR_TEST_CCH2
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   SFR_TEST_CCH3
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   SFR_TEST_CCH4
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   SFR_TEST_CCL1
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   SFR_TEST_CCL2
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   SFR_TEST_CCL3
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   SFR_TEST_CCL4
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   SFR_TEST_CMEN
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   SFR_TEST_CMH0
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   SFR_TEST_CMH1
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   SFR_TEST_CMH2
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   SFR_TEST_CMH3
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   SFR_TEST_CMH4
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   SFR_TEST_CMH5
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   SFR_TEST_CMH6
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   SFR_TEST_CMH7
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   SFR_TEST_CML0
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   SFR_TEST_CML1
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   SFR_TEST_CML2
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   SFR_TEST_CML3
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   SFR_TEST_CML4
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   SFR_TEST_CML5
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   SFR_TEST_CML6
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT
		LCALL   SFR_TEST_CML7

		LJMP    MAIN


		ORG     ROM_TOP_H*100h+ROM_TOP_L-1      ; Signatur in letzten 
							; beiden ROM-Bytes
		DB      12h,34h                         ; Signatur (High-Byte, Low-Byte)
							; 12h, 34h ist ein Beispiel, 
							; fhrt daher zum ROM-Fehler

		END
	
	
	
	
	
	
