; Modul: DEC.ASM

; Version 1.00          BIA - Referat 5.2                    Datum: 15.09.2000

; Funktion:
; Deklarationsdatei fr Variablen und Konstanten sowie Initialisierungen.

; bergeordnete Module: CPU_TEST.ASM
; Untergeordnete Module: keine

; INIT-Funktion:  aufgerufen von: WD_TEST
;                 ruft auf: -
;                 Stacktiefe: 2 Bytes

; ************* Allgemeine Variablen und Konstanten *************************
STACKANFANG     EQU     04Fh    ; Stackanfangsposition im internen RAM -> 050h


FEHLER          DATA    07Fh    ; Fehlervariable, enthlt bei Auftreten eines
				; Fehlers eine der nachfolgenden Fehlernummern

FEHLER_ACC      EQU     010h    ; Fehler Akkutest
FEHLER_JNZ      EQU     011h    ; Fehler JNZ-Test
FEHLER_PC       EQU     012h    ; Fehler Programcountertest
FEHLER_PPR      EQU     013h    ; Fehler PUSH-POP-RET-Test

FEHLER_ANL      EQU     020h    ; Fehler ANL-Test
FEHLER_ORL      EQU     021h    ; Fehler ORL-Test
FEHLER_XRL      EQU     022h    ; Fehler XRL-Test
FEHLER_CRS      EQU     023h    ; Fehler Clear-, Complement-, Rotate-, Swap-Test
FEHLER_BIT      EQU     024h    ; Fehler Bitverarbeitungstests

FEHLER_ARI      EQU     030h    ; Fehler Arithmetiktests

FEHLER_IO       EQU     040h    ; Fehler Porttests

FEHLER_TRAN     EQU     050h    ; Fehler Transferbefehltests

FEHLER_ROM      EQU     060h    ; Fehler ROM-Test
FEHLER_XRAM     EQU     061h    ; Fehler XRAM-Test

FEHLER_WD0      EQU     070h    ; Fehler Watchdogtest: WD hat nicht ausgelst (bei WD-Test)
FEHLER_WD1      EQU     071h    ; Fehler Watchdog: Auslsung wegen fehlenden WD-Refreshs

TESTSIGNAL      BIT     P3.4    ; Signal, das zeigt, ob der Controller noch arbeitet


; ************* WD_TEST.ASM *************************************************
RELOADTIME      EQU     054h    ; WD-Reaktionszeit: 22520 Taktzyklen
WD_TEST_ZEIT    EQU     230     ; Dauer der Zeitschleife, whrend der der WD getestet wird
				; (Vielfaches von 100 Taktzyklen)

WD_TEST_FLAG    EQU     04Dh    ; Flag fr Unterscheidung WD-Test (==FFh) 
				; bzw. wirklicher WD-Reset (==0) wegen fehlendem Refresh



; ************* XRAM_TEST.ASM ***********************************************
XRAM_SIG_H      DATA    040h    ; Signatur High-Byte
XRAM_SIG_L      DATA    041h    ; Signatur Low-Byte
XRAM_SEGM_H     DATA    042h    ; aktives Segment High-Byte
XRAM_SEGM_L     DATA    043h    ; aktives Segment Low-Byte
XRAM_H          DATA    044h    ; aktives Byte High-Byte
XRAM_L          DATA    045h    ; aktives Byte Low-Byte

XRAM_SEGM_SIZE  EQU     020h    ; Segmentgre (XRAM_TOP muss ganzzahlig durch diesen Wert teilbar sein, aber >= 2)
XRAM_TOP_H      EQU     001h    ; Endadresse des XRAM+1
XRAM_TOP_L      EQU     000h



; ************* ROM_TEST.ASM ************************************************
ROM_SIG_H       DATA    046h    ; Signatur High-Byte
ROM_SIG_L       DATA    047h    ; Signatur Low-Byte
ROM_SEGM_H      DATA    048h    ; aktives Segment High-Byte
ROM_SEGM_L      DATA    049h    ; aktives Segment Low-Byte

ROM_SEGM_SIZE   EQU     040h    ; Segmentgre
ROM_TOP_H       EQU     0FFh    ; Endadresse des ROM
ROM_TOP_L       EQU     0FFh



; ************* PC_TEST.ASM *************************************************
REG0            EQU     00h     ; Adresse R0 in Bank 0
REG1            EQU     01h     ; Adresse R1 in Bank 0

JMPCALL         BIT     00h     ; Flag fr LJMP- (0) bzw. LCALL-Test (1) 



; ************* IO_TEST.ASM *************************************************
IO_Waittime     EQU     02h     ; Wartezeit fr Warteschleife

IO_SAV_P4       DATA    4Ah     ; Zwischenspeicher fr Port 4
IO_SAV_P6       DATA    4Bh     ; Zwischenspeicher fr Port 6
IO_SAV_Px       DATA    4Ch     ; Zwischenspeicher fr getesteten Port



; ************* ARI_TEST.ASM, TRANTEST.ASM **********************************
BYTE_ADR        DATA    30H     
XCH1            DATA    31H     
INTRAM02        DATA    02h     
INTRAM04        DATA    04h     
INTRAM10        DATA    10h     
INTRAM11        DATA    11h     

INTRAM20        DATA    20h     ; Variable muss im bitadressierbaren Bereich liegen
INTRAM21        DATA    21h     ; Variable muss im bitadressierbaren Bereich liegen
INTRAM22        DATA    22h     ; Variable muss im bitadressierbaren Bereich liegen
INTRAM24        DATA    24h     ; Variable muss im bitadressierbaren Bereich liegen
INTRAM28        DATA    28h     ; Variable muss im bitadressierbaren Bereich liegen
INTRAM2F        DATA    2Fh     ; Variable muss im bitadressierbaren Bereich liegen



; ************* INIT-Funktion (Initialisierung von Variablen ****************
INIT:           MOV     FEHLER,#0               ; Fehlerspeicher lschen                
		MOV     WD_TEST_FLAG,#0         ; bei WD-Reset wird dieser nicht
						; als Test interpretiert

		MOV     XRAM_SEGM_H,#0          ; aktives Segment fr XRAM-Test
		MOV     XRAM_SEGM_L,#0
		MOV     XRAM_H,#0               ; erstes aktives Byte
		MOV     XRAM_L,#0

		MOV     ROM_SEGM_H,#0           ; aktives Segment fr ROM-Test
		MOV     ROM_SEGM_L,#0
		MOV     ROM_SIG_H,#0            ; Signaturspeicher lschen
		MOV     ROM_SIG_L,#0

		RET
