; Modul: IO_TEST.ASM

; Version 1.00          BIA - Referat 5.2                    Datum: 15.09.2000

; Funktion:
; Test der Portausgnge auf Kurzschlsse und Stuck-at-Fehler.
; Achtung: Bei diesem Porttest werden die Ports 1 und 5 als Ausgnge
;               verwendet; die Ports 4 und 6 sind als Eingnge konfiguriert
;               und dienen zum Rcklesen der an Port 1 und 4 ausgegebenen
;               Informationen. Zu diesem Zweck mssen die Ports 1 und 5 mit
;               den Ports 4 und 6 hardwaremig verbunden werden.
;               Der Test geht davon aus, dass eine "1" am Ausgang 
;               als "1" am entsprechenden Eingang erscheint.
; Das Programm enthlt eine zeitlich vernderbare Warteschleife, um
; Einschwingvorgnge an den Portpins zu bercksichtigen

; Eingabeparameter: keine
; Ausgabeparameter: keine
; Vernderte Register: siehe Einzelfunktionen
; Vernderte Speicherbereiche: keine, auer speziell fr diese Tests reservierte Speicherzellen

; Fehleraussprung: nach Funktion ERROR

; bergeordnete Module: CPU_TEST.ASM
; Untergeordnete Module: keine

; Stacktiefe: siehe Einzelfunktionen
; Verwendete Registerbank: aktuelle Bank
; ***************************************************************************



; ***************************************************************************
IO_error:       MOV     FEHLER,#FEHLER_IO      ; Fehlerspeicher laden
		LJMP    ERROR
; ***************************************************************************



; ********************* IO_WAIT *********************************************
; Funktion: Warteschleife zur Bercksichtigung von Einschwingvorgngen

; aufgerufen von: IO_TEST1, IO_TEST5
; ruft auf: -

; Vernderte Register: A, PSW

; Stacktiefe: 2 Bytes
; *************************************************************************** 
IO_WAIT:        MOV     A,#IO_Waittime          ; Startwert laden
IO_WAIT1:       DJNZ    ACC,IO_WAIT1            ; Schleifenende?
			RET



; ********************* IO_SAVE *********************************************
; Funktion: Speicherung des augenblicklichen Zustandes der Portausgnge

; aufgerufen von: IO_TEST1, IO_TEST5
; ruft auf: -

; Vernderte Register: keine

; Stacktiefe: 2 Bytes
; *************************************************************************** 
IO_SAVE:        MOV     IO_SAV_P4,P4            ; Werte an Portausgngen werden 
		MOV     IO_SAV_P6,P6            ; zwischengespeichert
		RET



; ********************* IO_VERGLEICH ****************************************
; Funktion: Eingeschriebener Wert == Eingelesener Wert?

; aufgerufen von: IO_TEST1, IO_TEST5
; ruft auf: -

; Vernderte Register: A, PSW

; Stacktiefe: 2 Bytes
; *************************************************************************** 
IO_VERGLEICH:   MOV     A,P4                    
		CJNE    A,IO_SAV_P4,IO_error    ; Wert von P1 OK?
		MOV     A,P6
		CJNE    A,IO_SAV_P6,IO_error    ; Wert von P5 OK?
		RET



; ********************* IO_TEST1 ********************************************
; Funktion: Test Port 1

; aufgerufen von: MAIN
; ruft auf: IO_SAVE, IO_WAIT, IO_VERGLEICH

; Vernderte Register: A, PSW

; Stacktiefe: 3 Bytes + aufgerufene Funktionen
; *************************************************************************** 
IO_TEST1:       LCALL   IO_SAVE                 ; Portinhalte speichern          
		MOV     IO_SAV_Px,IO_SAV_P4     ; zu prfenden Port zwischenspeichern
		MOV     A,#1                    ; Bit 0 wird zuerst geprft
IO_TEST1_a:     PUSH    ACC                     ; Akkuwert zwischenspeichern
		XRL     A,IO_SAV_Px             ; zu prfendes Bit invertieren
		MOV     P1,A                    ; neuen Wert in Port schreiben
		MOV     IO_SAV_P4,A             ; Wert abspeichern
		LCALL   IO_WAIT                 ; Wartezeit zum Einschwingen
		LCALL   IO_VERGLEICH            ; Erwartungswerte vorhanden?                
		MOV     P1,IO_SAV_Px            ; Ursprungswert wieder in Port schreiben
		POP     ACC                     
		RL      A                       ; nchstes Bit selektieren
		CJNE    A,#1,IO_TEST1_a         ; Testende?
		RET



; ********************* IO_TEST5 ********************************************
; Funktion: Test Port 5

; aufgerufen von: MAIN
; ruft auf: IO_SAVE, IO_WAIT, IO_VERGLEICH

; Vernderte Register: A, PSW

; Stacktiefe: 3 Bytes + aufgerufene Funktionen
; *************************************************************************** 
IO_TEST5:       LCALL   IO_SAVE                 ; Portinhalte speichern          
		MOV     IO_SAV_Px,IO_SAV_P6     ; zu prfenden Port zwischenspeichern
		MOV     A,#1                    ; Bit 0 wird zuerst geprft
IO_TEST5_a:     PUSH    ACC                     ; Akkuwert zwischenspeichern
		XRL     A,IO_SAV_Px             ; zu prfendes Bit invertieren
		MOV     P5,A                    ; neuen Wert in Port schreiben
		MOV     IO_SAV_P6,A             ; Wert abspeichern
		LCALL   IO_WAIT                 ; Wartezeit zum Einschwingen
		LCALL   IO_VERGLEICH            ; Erwartungswerte vorhanden?                
		MOV     P5,IO_SAV_Px            ; Ursprungswert wieder in Port schreiben
		POP     ACC                     
		RL      A                       ; nchstes Bit selektieren
		CJNE    A,#1,IO_TEST5_a         ; Testende?
		RET
