; Modul: JNZ_TEST.ASM

; Version 1.00          BIA - Referat 5.2                    Datum: 15.09.2000

; Funktion:
; Test von JNZ fr die komplementren Akkumulatorinhalte AAh 
; und 55h bei 5 Rcksprungschritten.

; Eingabeparameter: keine
; Ausgabeparameter: keine
; Vernderte Register: A, B, PSW
; Vernderte Speicherbereiche: keine

; Fehleraussprung: keiner

; bergeordnete Module: CPU_TEST.ASM
; Untergeordnete Module: keine
; aufgerufen von: MAIN
; ruft auf: -

; Stacktiefe: 2 Bytes
; Verwendete Registerbank: keine
; ***************************************************************************
JNZ_TEST:       CLR     C
		MOV     A,#0AAh                 ; Lade Akku mit 1. Testbyte
		MOV     B,#0AAh                 ; Lade Register B mit 1. Testbyte
		SUBB    A,B                     ; Vergleich von A und B durch Subtraktion
Error1:         NOP            
		NOP                  
		NOP      
		NOP      
		NOP      
		MOV     FEHLER,#FEHLER_JNZ      ; Fehlerspeicher laden
		JNZ     Error1                  ; Sollte ein Fehler bei den Registern oder der Subtraktion 
						; auftreten, so zwingt JNZ zur Endlosschleife, die relative 
						; Adresse ist hier immer 05. 
		MOV     FEHLER,#0               ; Fehlerspeicher lschen
		JZ      Error2                  ; Falls Ergebnis OK, Sprung zum CJNE-Test
		MOV     FEHLER,#FEHLER_JNZ      ; Fehlerspeicher laden
		NOP
		NOP
		NOP
		NOP
		NOP
Error8:         SJMP    Error8                  ; Beide Sprnge haben versagt > Endlosschleife
Error2:         NOP      
		NOP      
		NOP      
		NOP      
		NOP      
		MOV     FEHLER,#FEHLER_JNZ      ; Fehlerspeicher laden
		CJNE    A,#00h,Error2           ; Sollte JNZ ignoriert werden, fngt sich hier 
						; der Controller in einer Endlosschleife
		MOV     FEHLER,#0               ; Fehlerspeicher lschen

; Gleiche Vorgehensweise fr den Wert 55h
		MOV     A,#055h                 ; Lade Akku 2. Testbyte 
		MOV     B,#055h                 ; Lade Register B mit 2. Testbyte
		SUBB    A,B                     ; Vergleich von A und B durch Subtraktion
Error3:         NOP               
		NOP                  
		NOP      
		NOP      
		NOP      
		MOV     FEHLER,#FEHLER_JNZ      ; Fehlerspeicher laden
		JNZ     Error1                  ; Sollte ein Fehler bei den Registern oder der Subtraktion 
						; auftreten, so zwingt JNZ zur Endlosschleife, die relative 
						; Adresse ist hier immer 05. 
		MOV     FEHLER,#0               ; Fehlerspeicher lschen
		JZ      Error4                  ; Falls Ergebnis OK, Sprung zum CJNE-Test
		MOV     FEHLER,#FEHLER_JNZ      ; Fehlerspeicher laden
		NOP
		NOP
		NOP
		NOP
		NOP
Error9:         SJMP    Error9                  ; Beide Sprnge haben versagt > Endlosschleife
Error4:         NOP      
		NOP      
		NOP      
		NOP      
		NOP      
		MOV     FEHLER,#FEHLER_JNZ      ; Fehlerspeicher laden
		CJNE    A,#00h,Error4           ; Sollte JNZ ignoriert werden, fngt sich hier 
						; der Controller in einer Endlosschleife
		MOV     FEHLER,#0               ; Fehlerspeicher lschen
		RET
