; Modul: LOGITEST.ASM

; Version 1.00          BIA - Referat 5.2                    Datum: 15.09.2000

; Funktion:
; Test der Logikbefehle, Sammelaufruffunktionen

; Eingabeparameter: keine
; Ausgabeparameter: keine
; Vernderte Register: siehe Einzelfunktionen
; Vernderte Speicherbereiche: siehe Einzelfunktionen

; Fehleraussprung: siehe untergeordnete Module

; bergeordnete Module: CPU_TEST.ASM
; Untergeordnete Module: siehe Einzelfunktionen

; Stacktiefe: 2 Bytes + aufgerufene Funktionen
; Verwendete Registerbank: aktuelle Bank
; ***************************************************************************



$Include (ANL_TEST.ASM)         ; Dateien enthalten die verschiedenen Tests,
$Include (ORL_TEST.ASM)         ; die von diesem Modul aus aufgerufen werden.
$Include (XRL_TEST.ASM)
$Include (CRS_TEST.ASM) 
$Include (BIT_TEST.ASM)



; ********************* ANL_TEST ********************************************
; Funktion: Sammelaufruf aller ANL-Tests

; aufgerufen von: MAIN
; ruft auf: ANL_TEST1 - ANL_TEST14

; Vernderte Register: A, R0-R7, PSW
; Vernderte Speicherbereiche: keine, auer speziell fr diese Tests reservierte Speicherzellen
; Untergeordnete Module: ANL_TEST.ASM
; ***************************************************************************
ANL_TEST:       LCALL   ANL_TEST1 
		LCALL   ANL_TEST2 
		LCALL   ANL_TEST3 
		LCALL   ANL_TEST4 
		LCALL   ANL_TEST5 
		LCALL   ANL_TEST6
		LCALL   ANL_TEST7 
		LCALL   ANL_TEST8 
		LCALL   ANL_TEST9 
		LCALL   ANL_TEST10 
		LCALL   ANL_TEST11
		LCALL   ANL_TEST12 
		LCALL   ANL_TEST13 
		LCALL   ANL_TEST14
		RET



; ********************* ORL_TEST ********************************************
; Funktion: Sammelaufruf aller ORL-Tests

; aufgerufen von: MAIN
; ruft auf: ORL_TEST1 - ORL_TEST14

; Vernderte Register: A, R0-R7, PSW
; Vernderte Speicherbereiche: keine, auer speziell fr diese Tests reservierte Speicherzellen
; Untergeordnete Module: ORL_TEST.ASM
; ***************************************************************************
ORL_TEST:       LCALL   ORL_TEST1 
		LCALL   ORL_TEST2 
		LCALL   ORL_TEST3 
		LCALL   ORL_TEST4 
		LCALL   ORL_TEST5 
		LCALL   ORL_TEST6 
		LCALL   ORL_TEST7 
		LCALL   ORL_TEST8 
		LCALL   ORL_TEST9 
		LCALL   ORL_TEST10 
		LCALL   ORL_TEST11
		LCALL   ORL_TEST12 
		LCALL   ORL_TEST13 
		LCALL   ORL_TEST14
		RET



; ********************* XRL_TEST ********************************************
; Funktion: Sammelaufruf aller XRL-Tests

; aufgerufen von: MAIN
; ruft auf: XRL_TEST1 - XRL_TEST14

; Vernderte Register: A, R0-R7, PSW
; Vernderte Speicherbereiche: keine, auer speziell fr diese Tests reservierte Speicherzellen
; Untergeordnete Module: XRL_TEST.ASM
; ***************************************************************************
XRL_TEST:       LCALL   XRL_TEST1 
		LCALL   XRL_TEST2 
		LCALL   XRL_TEST3 
		LCALL   XRL_TEST4 
		LCALL   XRL_TEST5 
		LCALL   XRL_TEST6 
		LCALL   XRL_TEST7 
		LCALL   XRL_TEST8 
		LCALL   XRL_TEST9 
		LCALL   XRL_TEST10 
		LCALL   XRL_TEST11
		LCALL   XRL_TEST12 
		LCALL   XRL_TEST13 
		LCALL   XRL_TEST14
		RET



; ********************* C_R_S_TEST ********************************************
; Funktion: Sammelaufruf von Clear-, Complement-, Rotate- und Swap-Tests

; aufgerufen von: MAIN
; ruft auf: CLR_TEST1; CPL_TEST1, RL_TEST1, RLC_TEST1, RR_TEST1, RRC_TEST1, SWAP_TEST1

; Vernderte Register: A, PSW
; Vernderte Speicherbereiche: keine
; Untergeordnete Module: CRS_TEST.ASM
; ***************************************************************************
C_R_S_TEST:     LCALL   CLR_TEST1
		LCALL   CPL_TEST1
		LCALL   RL_TEST1
		LCALL   RLC_TEST1
		LCALL   RR_TEST1
		LCALL   RRC_TEST1
		LCALL   SWAP_TEST1                        
		RET



; ********************* BIT_TEST_A ******************************************
; Funktion: Sammelaufruf der ersten Gruppe von Bit-Tests

; aufgerufen von: MAIN
; ruft auf: SPEICHERVORBELEGUNG, BIT_TEST1, BIT_TEST2

; Vernderte Register: A, R0, PSW
; Vernderte Speicherbereiche: bitadressierbarer Speicherbereich (IRAM 20h-2Fh)
; Untergeordnete Module: BIT_TEST.ASM
; ***************************************************************************
BIT_TEST_A:     LCALL   SPEICHERVORBELEGUNG     ; bitadressierbaren Speicherbereich vorbelegen
		LCALL   BIT_TEST1               ; Test
		LCALL   BIT_TEST2               ; Test
			RET



; ********************* BIT_TEST_B ******************************************
; Funktion: Sammelaufruf der zweiten Gruppe von Bit-Tests

; aufgerufen von: MAIN
; ruft auf: SPEICHERVORBELEGUNG, BIT_TEST3, BIT_TEST4

; Vernderte Register: A, R0, PSW
; Vernderte Speicherbereiche: bitadressierbarer Speicherbereich (IRAM 20h-2Fh)
; Untergeordnete Module: BIT_TEST.ASM
; ***************************************************************************
BIT_TEST_B:     LCALL   SPEICHERVORBELEGUNG     ; bitadressierbaren Speicherbereich vorbelegen
		LCALL   BIT_TEST3               ; Test 
		LCALL   BIT_TEST4               ; Test
			RET



; ********************* BIT_TEST_C ******************************************
; Funktion: Sammelaufruf der dritten Gruppe von Bit-Tests

; aufgerufen von: MAIN
; ruft auf: SPEICHERVORBELEGUNG, BIT_TEST5, BIT_TEST6

; Vernderte Register: A, R0, PSW
; Vernderte Speicherbereiche: bitadressierbarer Speicherbereich (IRAM 20h-2Fh)
; Untergeordnete Module: BIT_TEST.ASM
; ***************************************************************************
BIT_TEST_C:     LCALL   SPEICHERVORBELEGUNG     ; bitadressierbaren Speicherbereich vorbelegen
		LCALL   BIT_TEST5               ; Test
		LCALL   BIT_TEST6               ; Test
		RET



; ********************* BIT_TEST_D ******************************************
; Funktion: Sammelaufruf der vierten Gruppe von Bit-Tests

; aufgerufen von: MAIN
; ruft auf: SPEICHERVORBELEGUNG, BIT_TEST7, BIT_TEST8, BITBEFEHLE

; Vernderte Register: A, R0, PSW
; Vernderte Speicherbereiche: bitadressierbarer Speicherbereich (IRAM 20h-2Fh)
; Untergeordnete Module: BIT_TEST.ASM
; ***************************************************************************
BIT_TEST_D:     LCALL   SPEICHERVORBELEGUNG     ; bitadressierbaren Speicherbereich vorbelegen
		LCALL   BIT_TEST7               ; Test
		LCALL   BIT_TEST8               ; Test
		LCALL   BITBEFEHLE              ; Bitoperationen testen
		RET 
