; Modul: ORL_TEST.ASM

; Version 1.00          BIA - Referat 5.2                    Datum: 15.09.2000

; Funktion:
; Die Unterprogramme testen den Verknpfungsbefehl ORL, indem AAh
; (10101010B) und 56H (01010110B) bitweise logisch ODER verknpft 
; werden und das berechnete Ergebnis mit dem erwarteten Ergebnis
; von FEh (11111110B) verglichen wird.

; Eingabeparameter: keine
; Ausgabeparameter: keine
; Vernderte Register: siehe Einzelfunktionen
; Vernderte Speicherbereiche: keine, auer speziell fr diese Tests reservierte Speicherzellen

; Fehleraussprung: nach Funktion ERROR

; bergeordnete Module: LOGITEST.ASM
; Untergeordnete Module: keine
; aufgerufen von: ORL_TEST
; ruft auf: -

; Stacktiefe: 2 Bytes
; Verwendete Registerbank: aktuelle Bank
; ***************************************************************************



; ********************* ORL_TEST 1  *****************************************
; Funktion: Test von ORL A,R0
; Vernderte Register: A, R0, PSW
; ***************************************************************************
ORL_TEST1:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     R0,#56h                 ; Testmuster 2 laden 
		ORL     A,R0                    ; Befehlstest 
		CJNE    A,#0FEh,ORL_err1        ; Vergleich mit Erwartungshaltung
		RET
ORL_err1:       LJMP    ERROR_ORL           



; ********************* ORL_TEST 2  *****************************************
; Funktion: Test von ORL A,R1
; Vernderte Register: A, R1, PSW
; ***************************************************************************
ORL_TEST2:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     R1,#56h                 ; Testmuster 2 laden 
		ORL     A,R1                    ; Befehlstest 
		CJNE    A,#0FEh,ORL_err2        ; Vergleich mit Erwartungshaltung
		RET
ORL_err2:       LJMP    ERROR_ORL           



; ********************* ORL_TEST 3  *****************************************
; Funktion: Test von ORL A,R2
; Vernderte Register: A, R2, PSW
; ***************************************************************************
ORL_TEST3:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     R2,#56h                 ; Testmuster 2 laden 
		ORL     A,R2                    ; Befehlstest 
		CJNE    A,#0FEh,ORL_err3        ; Vergleich mit Erwartungshaltung
		RET
ORL_err3:       LJMP    ERROR_ORL           



; ********************* ORL_TEST 4  *****************************************
; Funktion: Test von ORL A,R3
; Vernderte Register: A, R3, PSW
; ***************************************************************************
ORL_TEST4:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     R3,#56h                 ; Testmuster 2 laden 
		ORL     A,R3                    ; Befehlstest 
		CJNE    A,#0FEh,ORL_err4        ; Vergleich mit Erwartungshaltung
		RET
ORL_err4:       LJMP    ERROR_ORL           



; ********************* ORL_TEST 5  *****************************************
; Funktion: Test von ORL A,R4
; Vernderte Register: A, R4, PSW
; ***************************************************************************
ORL_TEST5:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     R4,#56h                 ; Testmuster 2 laden 
		ORL     A,R4                    ; Befehlstest 
		CJNE    A,#0FEh,ORL_err5        ; Vergleich mit Erwartungshaltung
		RET
ORL_err5:       LJMP    ERROR_ORL           



; ********************* ORL_TEST 6  *****************************************
; Funktion: Test von ORL A,R5
; Vernderte Register: A, R5, PSW
; ***************************************************************************
ORL_TEST6:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     R5,#56h                 ; Testmuster 2 laden 
		ORL     A,R5                    ; Befehlstest 
		CJNE    A,#0FEh,ORL_err6        ; Vergleich mit Erwartungshaltung
		RET
ORL_err6:       LJMP    ERROR_ORL           



; ********************* ORL_TEST 7  *****************************************
; Funktion: Test von ORL A,R6
; Vernderte Register: A, R6, PSW
; ***************************************************************************
ORL_TEST7:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     R6,#56h                 ; Testmuster 2 laden 
		ORL     A,R6                    ; Befehlstest 
		CJNE    A,#0FEh,ORL_err7        ; Vergleich mit Erwartungshaltung
		RET
ORL_err7:       LJMP    ERROR_ORL           



; ********************* ORL_TEST 8  *****************************************
; Funktion: Test von ORL A,R7
; Vernderte Register: A, R7, PSW
; ***************************************************************************
ORL_TEST8:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     R7,#56h                 ; Testmuster 2 laden
		ORL     A,R7                    ; Befehlstest 
		CJNE    A,#0FEh,ORL_err8        ; Vergleich mit Erwartungshaltung
		RET
ORL_err8:       LJMP    ERROR_ORL           



; ********************* ORL_TEST 9  *****************************************
; Funktion: Test von ORL A,dir
; Vernderte Register: A, PSW
; ***************************************************************************
ORL_TEST9:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     INTRAM10,#56h           ; Testmuster 2 laden
		ORL     A,INTRAM10              ; Befehlstest 
		CJNE    A,#0FEh,ORL_err9        ; Vergleich mit Erwartungshaltung
		RET
ORL_err9:       LJMP    ERROR_ORL           



; ********************* ORL_TEST 10  ****************************************
; Funktion: Test von ORL A,@R0
; Vernderte Register: A, R0, PSW
; ***************************************************************************
ORL_TEST10:     MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     INTRAM10,#56h           ; Testmuster 2 laden
		MOV     R0,#10h                 ; Adresse von INTRAM10 laden
		ORL     A,@R0                   ; Befehlstest 
		CJNE    A,#0FEh,ORL_err10       ; Vergleich mit Erwartungshaltung
		RET
ORL_err10:      LJMP    ERROR_ORL           



; ********************* ORL_TEST 11  ****************************************
; Funktion: Test von ORL A,@R1
; Vernderte Register: A, R1, PSW
; ***************************************************************************
ORL_TEST11:     MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     INTRAM10,#56h           ; Testmuster 2 laden
		MOV     R1,#10h                 ; Adresse von INTRAM10 laden
		ORL     A,@R1                   ; Befehlstest 
		CJNE    A,#0FEh,ORL_err11       ; Vergleich mit Erwartungshaltung
		RET
ORL_err11:      LJMP    ERROR_ORL           



; ********************* ORL_TEST 12  ****************************************
; Funktion: Test von ORL A,#data
; Vernderte Register: A, PSW
; ***************************************************************************
ORL_TEST12:     MOV     A,#0AAh                 ; Testmuster 1 laden
		ORL     A,#56h                  ; Befehlstest 
		CJNE    A,#0FEh,ORL_err12       ; Vergleich mit Erwartungshaltung
		RET
ORL_err12:      LJMP    ERROR_ORL           



; ********************* ORL_TEST 13  ****************************************
; Funktion: Test von ORL dir,A
; Vernderte Register: A, PSW
; ***************************************************************************
ORL_TEST13:     MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     INTRAM10,#56h           ; Testmuster 2 laden
		ORL     INTRAM10,A              ; Befehlstest 
		MOV     A,INTRAM10              
		CJNE    A,#0FEh,ORL_err13       ; Vergleich mit Erwartungshaltung
		RET
ORL_err13:      LJMP    ERROR_ORL           



; ********************* ORL_TEST 14  ****************************************
; Funktion: Test von ORL dir,#data
; Vernderte Register: A, PSW
; ***************************************************************************
ORL_TEST14:     MOV     INTRAM10,#0AAh          ; Testmuster 1 laden
		ORL     INTRAM10,#56h           ; Befehlstest
		MOV     A,INTRAM10              
		CJNE    A,#0FEh,ORL_err14       ; Vergleich mit Erwartungshaltung
		RET
ORL_err14:      LJMP    ERROR_ORL           



; ***************************************************************************
ERROR_ORL:      MOV     FEHLER,#FEHLER_ORL      ; Fehlerspeicher laden
		LJMP    ERROR
; ***************************************************************************

