; Modul: PC_TEST.ASM

; Version 1.00          BIA - Referat 5.2                    Datum: 15.09.2000

; Funktion:
; Inseltest fr LJMP und LCALL
; LJMP wird getestet, wenn das Flag JMPCALL nicht gesetzt ist, 
; anderenfalls wird LCALL getestet. Sinn des Flags: Man kann die 
; gleichen Inseln fr beide Tests benutzen.

; Das Programm testet mit einer laufenden 1 den 
; Programmzhler oberhalb der Adresse 100h
; folgende Adressen werden mit LJMP/LCALL angesprungen
; Binrcode              Hexcode
; 0000000100000000b       100h
; 0000001000000000b       200h
; 0000010000000000b       400h
; 0000100000000000b       800h
; 0001000000000000b      1000h
; 0010000000000000b      2000h
; 0100000000000000b      4000h
; 1000000000000000b      8000h
; Die Adressen 100h, 200h, 400h, 800h, 1000h und 2000h  
; werden nicht direkt getestet, sondern die
; jew. Bits werden oberhalb von 4000h getestet -> Speicherplatz freihalten
; es werden nun letzlich die folgenden Adressen als Inseln angesprungen:
; Binrcode              Hexcode
; 0100000000000000b      4000h
; 0100000100000000b      4100h
; 0100001000000000b      4200h
; 0100010000000000b      4400h
; 0100100000000000b      4800h
; 0101000000000000b      5000h
; 0110000000000000b      6000h
; 1000000000000000b      8000h
; Die Erwartungshaltung wird im Macro INSEL1 festgelegt, im Moment werden 
; die Additionen von Akku und Register R0 verglichen und bei Widerspruch 
; in eine Endlosschleife gesprungen.

; HINWEIS: Aufgrund der Intention, den PC mit einer wandernden 1
;          zu testen, kann dieses Programm nicht nach den Regeln der
;          strukturierten Programmierung erstellt werden.

; Eingabeparameter: keine
; Ausgabeparameter: keine
; Vernderte Register: A, R0, R1, PSW
; Vernderte Speicherbereiche: keine

; Fehleraussprung: keiner

; bergeordnete Module: CPU_TEST.ASM
; Untergeordnete Module: keine

; Stacktiefe des gesamten Tests: 23 Bytes
; Verwendete Registerbank: Bank 0

; Hinweis: 
; Bei einem auftretenden Fehler wird keine Fehlernummer ausgegeben.
; ***************************************************************************



; ********************* MAKRODEFINITIONEN ***********************************

; ********************* MAKRO INSEL1 ****************************************
; Funktion: Reihenfolgeprfung

; aufgerufen von: INSEL2
; ruft auf: -

; Vernderte Register: A, PSW
; *************************************************************************** 
INSEL1          MACRO                           ; hier wird die Reihenfolge geprft 
		LOCAL   PC_Fehler    
		ADD     A,#01h                  ; Akku erhhen
PC_Fehler:      CJNE    A,REG0,PC_Fehler        ; A<>0 -> Endlosschleife 
		ENDM        



; ********************* MAKRO INSEL2 ****************************************
; Funktion: Inselbildung

; aufgerufen von: PC_TEST
; ruft auf: INSEL1

; Vernderte Register: A, R0, PSW
; *************************************************************************** 
INSEL2          MACRO   ADR,SPRUNGZU,Reihenfolge        ; Hier werden die Sprnge durchgefhrt
		LOCAL   PC_FEHL,LC_TEST,LC_RET
		ORG     ADR                             ; Adresse der Insel
		MOV     R0,#Reihenfolge                 ; Reihenfolge-Zhler bergeben
		INSEL1                                  ; Erwartungswerte berechnen und vergleichen
		JB      JMPCALL,LC_TEST                 ; CALL oder JMP-Befehle?
		NOP
		LJMP    SPRUNGZU                        ; springe zur nchsten Insel bzw. zum Ende
LC_TEST:        LCALL   SPRUNGZU
		MOV     A,SP                            ; Stackpointer prfen,
		CJNE    A,REG1,LC_RET                   ; letzter Rcksprung?
		LJMP    ENDE
LC_RET:         RET    
PC_FEHL:        NOP
		NOP
		NOP
		NOP
		NOP
		SJMP    PC_FEHL                         ; Falls LJMP ignoriert wird -> Endlosschleife
		ENDM

; ********************* ENDE DER MAKRO-DEFINITIONEN *************************



; ********************* PC_TEST *********************************************
; Funktion: Test des Programmzhlers

; aufgerufen von: MAIN
; ruft auf: INSEL2

; Vernderte Register: A, R0, R1, PSW
; *************************************************************************** 
PC_TEST:MOV     A,#55h
	MOV     R0,#66h
	MOV     R1,#77h
	PUSH    ACC                     ; rette Akku
	PUSH    REG0                    ; rette R0
	PUSH    REG1                    ; rette R1
	MOV     R1,SP                   ; Stackpointerwert speichern
	MOV     R0,#00h                 ; lsche R0
	SETB    JMPCALL  
Start1: CPL     JMPCALL
	MOV     A,#00h                  ; lsche Akku

Start:  INSEL2  Start,4000h,01h
	INSEL2  4000h,4100h,02h         ; teste Bit 14 von PC
	INSEL2  4100h,4200h,03h         ; teste zustzlich Bit 8 von PC
	INSEL2  4200h,4400h,04h         ; teste zustzlich Bit 9 von PC
	INSEL2  4400h,4800h,05h         ; teste zustzlich Bit 10 von PC
	INSEL2  4800h,5000h,06h         ; teste zustzlich Bit 11 von PC
	INSEL2  5000h,6000h,07h         ; teste zustzlich Bit 12 von PC
	INSEL2  6000h,8000h,08h         ; teste zustzlich Bit 13 von PC
	INSEL2  8000h,WEITER,09h

WEITER: JB      JMPCALL, WEI2           ; Ist LCALL auch schon bearbeitet?
	LJMP    Start1                  ; LCALL noch nicht bearbeitet  -> zurck zu Start
WEI2:   RET      
	
ENDE:   POP     REG1                    ; restauriere R1
	POP     REG0                    ; restauriere R0
	POP     ACC                     ; restauriere Akku
	RET
