; Modul: ROM_TEST.ASM

; Version 1.00          BIA - Referat 5.2                    Datum: 15.09.2000

; Funktion:
; ROM-Test durch Signaturberechnung und Vergleich mit Sollsignatur.
; Die Sollsignatur steht in den letzten beiden Speicherzellen des ROMs.
; Die Berechnung erfolgt segmentweise.

; Eingabeparameter: keine
; Ausgabeparameter: keine
; Vernderte Register: A, R1-R7, DPTR, PSW
; Vernderte Speicherbereiche: keine, auer speziell fr diese Tests reservierte Speicherzellen

; Fehleraussprung: nach Funktion ERROR

; bergeordnete Module: CPU_TEST.ASM
; Untergeordnete Module: SIGNAT.ASM
; aufgerufen von: MAIN
; ruft auf: SIGNAT

; Stacktiefe: 2 Bytes + aufgerufene Funktionen
; Verwendete Registerbank: aktuelle Bank
; ***************************************************************************
ROM_TEST:       MOV     DPH,ROM_SEGM_H          ; Datenpointer mit Segmentanfangsadresse laden
                MOV     DPL,ROM_SEGM_L
                MOV     R1,#0                   ; Zhler nullsetzen
                MOV     R6,ROM_SIG_H            ; alte Signatur als Funktionsparameter
                MOV     R7,ROM_SIG_L            ;   in Register laden
ROM_TEST1:      CLR     A                       ; Akku fr Transferbefehl lschen
                MOVC    A,@A+DPTR               ; Codebyte aus ROM holen
                MOV     R4,A                    ; Funktionsparameter laden
                LCALL   SIGNAT                  ; neue Signatur berechnen
                INC     R1                      ; Zhler erhhen
                INC     DPTR                    ; ROM-Adresse erhhen
                MOV     A,DPH                   ; ROM-Ende erreicht? Wenn ja, Aussprung zu Signaturvergleich
                CJNE    A,#ROM_TOP_H,ROM_TEST2
                MOV     A,DPL
                CJNE    A,#ROM_TOP_L-2,ROM_TEST2
                MOV     ROM_SIG_H,R6            ; neue Signatur speichern
                MOV     ROM_SIG_L,R7
                MOV     DPL,#ROM_TOP_L-1        ; Sollsignatur High-Byte laden
                CLR     A
                MOVC    A,@A+DPTR
                CJNE    A,ROM_SIG_H,ROM_ERROR   ; Vergleich des High-Bytes
                MOV     DPL,#ROM_TOP_L
                CLR     A
                MOVC    A,@A+DPTR
                CJNE    A,ROM_SIG_L,ROM_ERROR   ; Vergleich des Low-Bytes
                MOV     DPTR,#0                 ; neuer Segmentanfang ist Speicheranfang
                MOV     R6,#0                   ; Signatur lschen
                MOV     R7,#0
                SJMP    ROM_TEST3               ; Aussprung zum Funktionsende
ROM_TEST2:      CJNE    R1,#ROM_SEGM_SIZE,ROM_TEST1     ; Segmentende?
ROM_TEST3:      MOV     ROM_SIG_H,R6            ; neue Signatur abspeichern
                MOV     ROM_SIG_L,R7
                MOV     ROM_SEGM_H,DPH          ; neuen Segmentanfang abspeichern
                MOV     ROM_SEGM_L,DPL
                RET

                

; ***************************************************************************
ROM_ERROR:      MOV     FEHLER,#FEHLER_ROM      ; Fehlerspeicher laden
                LJMP    error             
; ***************************************************************************


