; Modul: SFR_TEST.ASM

; Version 1.00          BIA - Referat 5.2                    Datum: 15.09.2000

; Funktion:
; Special-Function-Register-Test
; Erkennt stuck-at, stuck-on, stuck-open und Kurzschluss-Fehler. 
; Aktive Register sind diejenigen Register, die beim Test mit einer 
; laufenden 1 beschrieben werden knnen, z. B. B-Register. Hintergrund 
; ist ein Ausschnitt aus der SFR-Addressumgebung von 80h-FFh, der mit
; Hilfe einer 16-Bit-Signatur auf Kurzschlussfehler berprft wird.

; Aktive Register:
; B, DPSEL, DPH, DPL, CCH1-CCH4, CCL1-CCL4, CMEN, CMH0-CMH7, CML0-CML7.
; Diese Liste ist nicht vollstndig, sondern nur ein Beispiel. Alle hier nicht
; aufgefhrten SFR mssen bei Verwendung evtl. andersartig getestet werden.
; Das Beschreiben von MDU-Registern ist durch Tests in der Regel nicht zulssig,
; da durch das Beschreiben der Rechenvorgang ausgelst wird. Wird die MDU 
; verwendet, so ist diese durch einen geeigneten Test zu prfen.
; Bei Verwendung mehrerer DPTR sind diese alle einzeln zu testen.

; Passive Register: im SFR-Bereich 80h-FFh (siehe Funktion SFR_RAM)
; Um die Registerinhalte indirekt addressieren zu knnen, werden die 
; jeweiligen Registerinhalte in das XRAM ab Addresse 0 geladen 
; (Funktion SFR_RAM).

; Eingabeparameter: siehe Einzelfunktionen
; Ausgabeparameter: siehe Einzelfunktionen
; Vernderte Register: siehe Einzelfunktionen
; Vernderte Speicherbereiche: keine, auer speziell fr diese Tests reservierte Speicherzellen
;                              XRAM-Zellen 0 bis ?

; Fehleraussprung: nach Funktion ERROR

; bergeordnete Module: CPU_TEST.ASM
; Untergeordnete Module: SIGNAT.ASM

; Stacktiefe: siehe Einzelfunktionen
; Verwendete Registerbank: aktuelle Bank
; ***************************************************************************



; ********************* SIGNATUR ********************************************
; Funktion: Berechnung der Signatur der ins XRAM gespiegelten
;           SFR-Registerinhalte. Das jeweils aktive Register wird
;           dabei ausgeblendet.
; Eingabeparameter: R0: Adresse des aktiven SFR
;                   R1: Adresse der nchsten XRAM-Zelle ber gespiegeltem Bereich
; Ausgabeparameter: R6, R7: neue Signatur (MSB, LSB)

; aufgerufen von: SFR_TEST_X
; ruft auf: SIGNAT

; Vernderte Register: A, R2-R7, DPTR, PSW

; Stacktiefe: 3 Bytes + aufgerufene Funktionen
; ***************************************************************************
SIGNATUR:       PUSH    B                       ; B retten
		MOV     B,R1                    ; R1 retten
		MOV     R1,#0                   ; XRAM-Anfang
		MOV     R6,#0                   ; Signaturregister initialisieren
		MOV     R7,#0
SIGNATUR1:      MOV     A,R0                    ; Adresse des aktiven SFR?
		XRL     A,R1
		JNZ     SIGNATUR2    
		INC     R1                      ; nchstes Byte adressieren
SIGNATUR2:      MOV     A,R1                    ; Ende des gespiegelten Bereichs?
		XRL     A,B   
		JZ      SIGNATUR3
		MOVX    A,@R1                   ; gespiegeltes SFR aus XRAM holen
		MOV     R4,A                    ; Parameterbergabe fr nachfolgenden Funktionsaufruf
		LCALL   SIGNAT                  ; Signatur bilden
		INC     R1                      ; nchstes Byte adressieren
		SJMP    SIGNATUR1
SIGNATUR3:      MOV     R1,B                    ; R1 wiederherstellen
		POP     B                       ; B wiederherstellen
		RET



; ********************* SAVE_SIG ********************************************
; Funktion: Abspeichern der berechneten Signatur.
; Eingabeparameter: R1: Adresse der nchsten XRAM-Zelle ber gespiegeltem Bereich
;                   R6, R7: aktuelle Signatur (MSB, LSB)
; Ausgabeparameter: keine

; aufgerufen von: SFR_TEST_X
; ruft auf: -

; Vernderte Register: A, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
SAVE_SIG:       MOV     A,R6                    ; MSB der Signatur abspeichern
		MOVX    @R1,A
		INC     R1                      ; LSB der Signatur abspeichern
		MOV     A,R7
		MOVX    @R1,A
		DEC     R1                      ; alten Zustand von R1 wiederherstellen
		RET
 


; ********************* SIG_VGL *********************************************
; Funktion: Vergleichen der beiden berechneten Signaturen.
; Eingabeparameter: R1: Adresse der nchsten XRAM-Zelle ber gespiegeltem Bereich
;                   R6, R7: aktuelle Signatur (MSB, LSB)
; Ausgabeparameter: keine

; aufgerufen von: SFR_TEST_X
; ruft auf: -

; Vernderte Register: A, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
SIG_VGL:        MOVX    A,@R1                   ; MSB der alten Signatur aus XRAM holen
		XRL     A,R6                    ; neue Signatur (MSB) == alte Signatur (MSB)?
		JNZ     SFR_ERROR               ; falls ungleich, Fehleraussprung
		INC     R1                      ; LSB der alten Signatur aus XRAM holen
		MOVX    A,@R1
		XRL     A,R7                    ; neue Signatur (LSB) == alte Signatur (LSB)?
		JNZ     SFR_ERROR               ; falls ungleich, Fehleraussprung
		DEC     R1                      ; alten Zustand von R1 wiederherstellen
		RET



; ***************************************************************************
SFR_ERROR:      LJMP    error
; ***************************************************************************  



; ********************* SFR_RAM *********************************************
; Funktion: 
; Sequentielle Einblendung ausgewhlter SFRs (80h-FFh) in das externe RAM 
; SFRs lassen sich nicht indirekt adressieren. Deshalb muss bei 
; jeder Signaturbildung ber SFRs der  SFR-Bereich in das externe RAM
; gespiegelt werden. Die Signaturbildung erfolgt dann nach jeder nderung 
; des aktiven Registers nach der Spiegelung ber den RAM-Bereich
;
;           ------->  | aktives Register ndern |
;           |                      |
;           |              | SFR spiegeln |
;           |                      |
;           ----  | Signatur ber entsprechenden RAM-Bereich

; Eingabeparameter: keine
; Ausgabeparameter: R1: Adresse der nchsten XRAM-Zelle ber gespiegeltem Bereich

; aufgerufen von: SFR_TEST_X
; ruft auf: -

; Vernderte Register: A, R1, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
SFR_RAM:        MOV     R1,#0                   ; Zeiger fr XRAM-Zugriff initialisieren
		
		MOV     A,B                     ; B -> XRAM 0
		MOVX    @R1,A  
		INC     R1                      ; nchsten Speicherplatz adressieren
		
		MOV     A,DPSEL                 ; DPSEL -> XRAM 1
		MOVX    @R1,A     
		INC     R1          
		
		MOV     A,DPH                   ; DPH -> XRAM 2
		MOVX    @R1,A     
		INC     R1          
		
		MOV     A,DPL                   ; DPL -> XRAM 3
		MOVX    @R1,A     
		INC     R1          
		
		MOV     A,ADCON0                ; ADCON0 -> XRAM 4  
		MOVX    @R1,A
		INC     R1
		
		MOV     A,ADCON1                ; ADCON1 -> XRAM 5 
		MOVX    @R1,A
		INC     R1

		MOV     A,ADDAT                 ; ADDAT -> XRAM 6
		MOVX    @R1,A
		INC     R1
		
		MOV     A,DAPR                  ; DAPR -> XRAM 7
		MOVX    @R1,A
		INC     R1

		MOV     A,IEN0                  ; IEN0 -> XRAM 8 
		MOVX    @R1,A
		INC     R1
		
		MOV     A,CTCON                 ; CTCON -> XRAM 9 
		MOVX    @R1,A
		INC     R1
		
		MOV     A,IEN1                  ; IEN1 -> XRAM 10
		MOVX    @R1,A
		INC     R1
		
		MOV     A,IP0                   ; IP0 -> XRAM 11
		MOVX    @R1,A
		INC     R1
		
		MOV     A,IP1                   ; IP1 -> XRAM 12 
		MOVX    @R1,A
		INC     R1

		MOV     A,TMOD                  ; TMOD -> XRAM 13 
		MOVX    @R1,A
		INC     R1
		
		MOV     A,MD0                   ; MD0 -> XRAM 14
		MOVX    @R1,A
		INC     R1
		
		MOV     A,MD1                   ; MD1 -> XRAM 15 
		MOVX    @R1,A
		INC     R1
		
		MOV     A,MD2                   ; MD2 -> XRAM 16 
		MOVX    @R1,A
		INC     R1
		
		MOV     A,MD3                   ; MD3 -> XRAM 17 
		MOVX    @R1,A
		INC     R1
		
		MOV     A,MD4                   ; MD4 -> XRAM 18 
		MOVX    @R1,A
		INC     R1
		
		MOV     A,MD5                   ; MD5 -> XRAM 19 
		MOVX    @R1,A
		INC     R1

		MOV     A,CCEN                  ; CCEN -> XRAM 20 
		MOVX    @R1,A
		INC     R1

		MOV     A,CC4EN                 ; CC4EN -> XRAM 21 
		MOVX    @R1,A
		INC     R1
		
		MOV     A,CCH1                  ; CCH1 -> XRAM 22
		MOVX    @R1,A
		INC     R1
		
		MOV     A,CCH2                  ; CCH2 -> XRAM 23 
		MOVX    @R1,A
		INC     R1
		
		MOV     A,CCH3                  ; CCH3 -> XRAM 24 
		MOVX    @R1,A
		INC     R1
		
		MOV     A,CCH4                  ; CCH4 -> XRAM 25 
		MOVX    @R1,A      
		INC     R1
		
		MOV     A,CCL1                  ; CCL1 -> XRAM 26  
		MOVX    @R1,A
		INC     R1
		
		MOV     A,CCL2                  ; CCL2 -> XRAM 27  
		MOVX    @R1,A
		INC     R1
		
		MOV     A,CCL3                  ; CCL3 -> XRAM 28  
		MOVX    @R1,A
		INC     R1
		
		MOV     A,CCL4                  ; CCL4 -> XRAM 29  
		MOVX    @R1,A
		INC     R1
		
		MOV     A,CMEN                  ; CMEN -> XRAM 30  
		MOVX    @R1,A
		INC     R1
		
		MOV     A,CMH0                  ; CMH0 -> XRAM 31  
		MOVX    @R1,A
		INC     R1
		
		MOV     A,CMH1                  ; CMH1 -> XRAM 32  
		MOVX    @R1,A
		INC     R1
		
		MOV     A,CMH2                  ; CMH2 -> XRAM 33  
		MOVX    @R1,A
		INC     R1
		
		MOV     A,CMH3                  ; CMH3 -> XRAM 34  
		MOVX    @R1,A
		INC     R1
		
		MOV     A,CMH4                  ; CMH4 -> XRAM 35  
		MOVX    @R1,A
		INC     R1
		
		MOV     A,CMH5                  ; CMH5 -> XRAM 36  
		MOVX    @R1,A
		INC     R1
		
		MOV     A,CMH6                  ; CMH6 -> XRAM 37  
		MOVX    @R1,A
		INC     R1
		
		MOV     A,CMH7                  ; CMH7 -> XRAM 38  
		MOVX    @R1,A
		INC     R1
		
		MOV     A,CML0                  ; CML0  -> XRAM 39  
		MOVX    @R1,A
		INC     R1
		
		MOV     A,CML1                  ; CML1 -> XRAM 40 
		MOVX    @R1,A
		INC     R1
		
		MOV     A,CML2                  ; CML2 -> XRAM 41  
		MOVX    @R1,A                     
		INC     R1
		
		MOV     A,CML3                  ; CML3 -> XRAM 42  
		MOVX    @R1,A
		INC     R1
		
		MOV     A,CML4                  ; CML4 -> XRAM 43  
		MOVX    @R1,A
		INC     R1
		
		MOV     A,CML5                  ; CML5 -> XRAM 44  
		MOVX    @R1,A
		INC     R1
		
		MOV     A,CML6                  ; CML6 -> XRAM 45  
		MOVX    @R1,A
		INC     R1
		
		MOV     A,CML7                  ; CML7 -> XRAM 46  
		MOVX    @R1,A
		INC     R1
		
		MOV     A,CMSEL                 ; CMSEL -> XRAM 47  
		MOVX    @R1,A
		INC     R1
		
		MOV     A,CRCH                  ; CRCH -> XRAM 48
		MOVX    @R1,A
		INC     R1
		
		MOV     A,CRCL                  ; CRCL -> XRAM 49  
		MOVX    @R1,A
		INC     R1
		
		MOV     A,PCON                  ; PCON -> XRAM 50  
		MOVX    @R1,A
		INC     R1                    

		RET     



; ********************* MAKRODEFINITIONEN *********************************** 

; ********************* MAKRO SFR_TEST_X ************************************
; Funktion: Prfung der verschiedenen Special-Function-Register

; aufgerufen von: SFR_TEST_B - SFR_TEST_CML7
; ruft auf: SFR_RAM, SIGNATUR, SAVE_SIG, SIG_VGL

; Vernderte Register: A, R0-R7, PSW, P2
; Stacktiefe: 1 Byte + aufgerufene Funktionen
; ***************************************************************************
SFR_TEST_X      MACRO   ADRESSE,SPIEGEL         ; ADRESSE enthlt die Adresse des aktiven SFR
						; SPIEGEL enthlt die Adresse des aktiven SFR im XRAM
		PUSH    ADRESSE                 ; SFR-Inhalt retten
		MOV     ADRESSE,#55h            ; Testmuster in SFR schreiben
		MOV     P2,#0                   ; Page 0 des XRAM selektieren
		LCALL   SFR_RAM                 ; SFR-Bereich in XRAM kopieren
		MOV     R0,#SPIEGEL             ; Adresse des gespiegelten SFR im XRAM in R0 speichern
		LCALL   SIGNATUR                ; Hintergrundsignatur bilden
		LCALL   SAVE_SIG                ; Signatur speichern
		MOV     ADRESSE,#0AAh           ; Testmuster in SFR schreiben
		LCALL   SFR_RAM                 ; SFR-Bereich in XRAM kopieren
		LCALL   SIGNATUR                ; Hintergrundsignatur bilden
		LCALL   SIG_VGL                 ; Signaturvergleich
		POP     ADRESSE                 ; SFR-Inhalt wiederherstellen
		ENDM



; ********************* SFR_TEST_REGISTER ********************************************
; Funktion:
; Die nachfolgenden Funktionen berprfen jeweils ein SFR. Dazu wird das 
; jeweils aktive Register mit den Testbytes AAh und 55h belegt und der
; Hintergrund auf Kurzschlsse und bersprechen durch eine Signaturanalyse 
; berprft.
; Eingabeparameter: keine
; Ausgabeparameter: keine

; aufgerufen von: MAIN
; ruft auf: SFR_TEST_X

; Vernderte Register: A, R0-R7, PSW, P2

; Stacktiefe: 2 Bytes + aufgerufene Funktionen
; ***************************************************************************
SFR_TEST_B:     SFR_TEST_X      B,0             ; Aktives Register: B
		RET

SFR_TEST_DPSEL: SFR_TEST_X      DPSEL,1         ; Aktives Register: DPSEL
		RET

SFR_TEST_DPH:   SFR_TEST_X      DPH,2           ; Aktives Register: DPH
		RET

SFR_TEST_DPL:   SFR_TEST_X      DPL,3           ; Aktives Register: DPL
		RET

SFR_TEST_CCH1:  SFR_TEST_X      CCH1,22         ; Aktives Register: CCH1
		RET

SFR_TEST_CCH2:  SFR_TEST_X      CCH2,23         ; Aktives Register: CCH2
		RET

SFR_TEST_CCH3:  SFR_TEST_X      CCH3,24         ; Aktives Register: CCH3
		RET

SFR_TEST_CCH4:  SFR_TEST_X      CCH4,25         ; Aktives Register: CCH4
		RET

SFR_TEST_CCL1:  SFR_TEST_X      CCL1,26         ; Aktives Register: CCL1
		RET

SFR_TEST_CCL2:  SFR_TEST_X      CCL2,27         ; Aktives Register: CCL2
		RET

SFR_TEST_CCL3:  SFR_TEST_X      CCL3,28         ; Aktives Register: CCL3
		RET

SFR_TEST_CCL4:  SFR_TEST_X      CCL4,29         ; Aktives Register: CCL4
		RET

SFR_TEST_CMEN:  SFR_TEST_X      CMEN,30         ; Aktives Register: CMEN
		RET

SFR_TEST_CMH0:  SFR_TEST_X      CMH0,31         ; Aktives Register: CMH0
		RET

SFR_TEST_CMH1:  SFR_TEST_X      CMH1,32         ; Aktives Register: CMH1
		RET

SFR_TEST_CMH2:  SFR_TEST_X      CMH2,33         ; Aktives Register: CMH2
		RET

SFR_TEST_CMH3:  SFR_TEST_X      CMH3,34         ; Aktives Register: CMH3
		RET

SFR_TEST_CMH4:  SFR_TEST_X      CMH4,35         ; Aktives Register: CMH4
		RET

SFR_TEST_CMH5:  SFR_TEST_X      CMH5,36         ; Aktives Register: CMH5
		RET

SFR_TEST_CMH6:  SFR_TEST_X      CMH6,37         ; Aktives Register: CMH6
		RET

SFR_TEST_CMH7:  SFR_TEST_X      CMH7,38         ; Aktives Register: CMH7
		RET

SFR_TEST_CML0:  SFR_TEST_X      CML0,39         ; Aktives Register: CML0
		RET

SFR_TEST_CML1:  SFR_TEST_X      CML1,40         ; Aktives Register: CML1
		RET

SFR_TEST_CML2:  SFR_TEST_X      CML2,41         ; Aktives Register: CML2
		RET

SFR_TEST_CML3:  SFR_TEST_X      CML3,42         ; Aktives Register: CML3
		RET

SFR_TEST_CML4:  SFR_TEST_X      CML4,43         ; Aktives Register: CML4
		RET

SFR_TEST_CML5:  SFR_TEST_X      CML5,44         ; Aktives Register: CML5
		RET

SFR_TEST_CML6:  SFR_TEST_X      CML6,45         ; Aktives Register: CML6
		RET

SFR_TEST_CML7:  SFR_TEST_X      CML7,46         ; Aktives Register: CML7
		RET
