; Modul: SIGNAT.ASM

; Version 1.00          BIA - Referat 5.2                    Datum: 15.09.2000

; Funktion:
; Serielle Signaturberechnung eines Bytes.
; Quelle: D. Leisengang, Signaturanalyse in der Datenverarbeitung,
;         Elektronik 21, Oktober 1983
; Signaturlnge: 16 Bit
; Generatorpolynom: X16+X15+X2+X1

; R6, R7: momentane Signatur (R6=MSB, R7=LSB)
; R4: Eingangsbyte
; Veraenderte Register: A, R2-R7

; Eingabeparameter: R4 (neues Byte), R6, R7 (momentane Signatur: R6=MSB, R7=LSB)
; Ausgabeparameter: R6, R7 (neue Signatur: R6=MSB, R7=LSB)
; Vernderte Register: A, R2-R7, PSW
; Vernderte Speicherbereiche: keine

; Fehleraussprung: keiner

; bergeordnete Module: CPU_TEST.ASM
; Untergeordnete Module: keine
; aufgerufen von: ROM_TEST, XRAM_SIGN
; ruft auf: -

; Stacktiefe: 2 Bytes
; Verwendete Registerbank: aktuelle Bank
; ***************************************************************************
SIGNAT:         MOV     R2,#1100$0000B          ; Generatorpolynom MSB laden
		MOV     R3,#0000$0101B          ; Generatorploynom LSB laden 
		MOV     R5,#08h                 ; Schleifenzhler (R5) setzen
SI_ANF:         CLR     C                       ; Carry loeschen
		MOV     A,R7                    ; LSB der Signatur nach A
		RLC     A                       ; Signatur (LSB) in Akku nach links schieben C->0
		MOV     R7,A                    ; verschobenes LSB zurck nach Ursprung
		MOV     A,R6                    ; Signatur (MSB) nach A
		RLC     A                       ; Signatur (MSB) in Akku nach links schieben C->0
		MOV     R6,A                    ; verschobenes MSB zurck nach Ursprung
		JNC     SI_WEI1                 ; Wenn Carry dann nach SI_WEI1

; Division durch Generatorpol.        
	
		XRL     A,R2                    ; MSB EXOR Polynom
		MOV     R6,A                    ; Ergebnis -> R6
		MOV     A,R7                    ; LSB -> A
		XRL     A,R3                    ; LSB EXOR Polynom 
		MOV     R7,A                    ; Ergebnis -> R7
SI_WEI1:        MOV     A,R4    
		RLC     A
		MOV     R4,A
		JNC     SI_WEI2
		MOV     A,R6
		XRL     A,R2
		MOV     R6,A
		MOV     A,R7
		XRL     A,R3
		MOV     R7,A
SI_WEI2:        DJNZ    R5,SI_ANF
		RET
