; Modul: TRANTEST.ASM

; Version 1.00          BIA - Referat 5.2                    Datum: 15.09.2000

; Funktion:
; Test von Transferbefehlen: MOV, XCH, MOVX, MOVC

; Eingabeparameter: keine
; Ausgabeparameter: keine
; Vernderte Register: siehe Einzelfunktionen
; Vernderte Speicherbereiche: keine, auer speziell fr diese Tests reservierte Speicherzellen

; Fehleraussprung: nach Funktion ERROR

; bergeordnete Module: CPU_TEST.ASM
; Untergeordnete Module: keine

; Stacktiefe: siehe Einzelfunktionen
; Verwendete Registerbank: aktuelle Bank

; Hinweis: 
; Vom Anwenderprogramm aus sollten die Sammelfunktionen aufgerufen werden.
; ***************************************************************************



; ********************* MOV_TEST1 *******************************************
; Funktion: Test von MOV A,R0

; aufgerufen von: MOV_TEST
; ruft auf: -

; Vernderte Register: A, R0, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOV_TEST1:      MOV     A,#55h                  ; Akku initialisieren
		MOV     R0,#0AAh                ; Testmuster 1 laden
		MOV     A,R0                    ; Befehlstest
		CJNE    A,#0AAh,TRAN_err1       ; Vergleich mit Erwartungshaltung
		RET



; ********************* MOV_TEST2 *******************************************
; Funktion: Test von MOV A,R1

; aufgerufen von: MOV_TEST
; ruft auf: -

; Vernderte Register: A, R1, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOV_TEST2:      MOV R1,#55h                     ; Testmuster 1 laden
		MOV A,R1                        ; Befehlstest
		CJNE A,#55h,TRAN_err1           ; Vergleich mit Erwartungshaltung
		RET



; ********************* MOV_TEST3 *******************************************
; Funktion: Test von MOV A,R2

; aufgerufen von: MOV_TEST
; ruft auf: -

; Vernderte Register: A, R2, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOV_TEST3:      MOV     R2,#0AAh                ; Testmuster 1 laden
		MOV     A,R2                    ; Befehlstest
		CJNE    A,#0AAh,TRAN_err1       ; Vergleich mit Erwartungshaltung 
		RET



; ********************* MOV_TEST4 *******************************************
; Funktion: Test von MOV A,R3

; aufgerufen von: MOV_TEST
; ruft auf: -

; Vernderte Register: A, R3, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOV_TEST4:      MOV     R3,#55h                 ; Testmuster 1 laden
		MOV     A,R3                    ; Befehlstest
		CJNE    A,#55h,TRAN_err1        ; Vergleich mit Erwartungshaltung
		RET



; ********************* MOV_TEST5 *******************************************
; Funktion: Test von MOV A,R4

; aufgerufen von: MOV_TEST
; ruft auf: -

; Vernderte Register: A, R4, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOV_TEST5:      MOV     R4,#0AAh                ; Testmuster 1 laden
		MOV     A,R4                    ; Befehlstest
		CJNE    A,#0AAh,TRAN_err1       ; Vergleich mit Erwartungshaltung 
		RET



; ********************* MOV_TEST6 *******************************************
; Funktion: Test von MOV A,R5

; aufgerufen von: MOV_TEST
; ruft auf: -

; Vernderte Register: A, R5, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOV_TEST6:      MOV     R5,#55h                 ; Testmuster 1 laden
		MOV     A,R5                    ; Befehlstest
		CJNE    A,#55h,TRAN_err1        ; Vergleich mit Erwartungshaltung 
		RET



; ********************* MOV_TEST7 *******************************************
; Funktion: Test von MOV A,R6

; aufgerufen von: MOV_TEST
; ruft auf: -

; Vernderte Register: A, R6, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOV_TEST7:      MOV     R6,#0AAh                ; Testmuster 1 laden
		MOV     A,R6                    ; Befehlstest
		CJNE    A,#0AAh,TRAN_err1       ; Vergleich mit Erwartungshaltung 
		RET



; ********************* MOV_TEST8 *******************************************
; Funktion: Test von MOV A,R7

; aufgerufen von: MOV_TEST
; ruft auf: -

; Vernderte Register: A, R7, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOV_TEST8:      MOV     R7,#55h                 ; Testmuster 1 laden
		MOV     A,R7                    ; Befehlstest
		CJNE    A,#55h,TRAN_err1        ; Vergleich mit Erwartungshaltung 
		RET



; ***************************************************************************
TRAN_err1:      LJMP    ERROR_TRAN
; ***************************************************************************



; ********************* MOV_TEST9 *******************************************
; Funktion: Test von MOV R0,A

; aufgerufen von: MOV_TEST
; ruft auf: -

; Vernderte Register: A, R0, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOV_TEST9:      MOV     A,#55h                  ; Testmuster 1 laden
		MOV     R0,A                    ; Befehlstest
		CJNE    R0,#55h,TRAN_err2       ; Vergleich mit Erwartungshaltung 
		RET



; ********************* MOV_TEST10 ******************************************
; Funktion: Test von MOV R1,A

; aufgerufen von: MOV_TEST
; ruft auf: -

; Vernderte Register: A, R1, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOV_TEST10:     MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     R1,A                    ; Befehlstest
		CJNE    R1,#0AAh,TRAN_err2      ; Vergleich mit Erwartungshaltung 
			RET



; ********************* MOV_TEST11 ******************************************
; Funktion: Test von MOV R2,A

; aufgerufen von: MOV_TEST
; ruft auf: -

; Vernderte Register: A, R2, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOV_TEST11:     MOV     A,#55h                  ; Testmuster 1 laden
		MOV     R2,A                    ; Befehlstest
		CJNE    R2,#55h,TRAN_err2       ; Vergleich mit Erwartungshaltung 
		RET



; ********************* MOV_TEST12 ******************************************
; Funktion: Test von MOV R3,A

; aufgerufen von: MOV_TEST
; ruft auf: -

; Vernderte Register: A, R3, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOV_TEST12:     MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     R3,A                    ; Befehlstest
		CJNE    R3,#0AAh,TRAN_err2      ; Vergleich mit Erwartungshaltung 
		RET



; ********************* MOV_TEST13 ******************************************
; Funktion: Test von MOV R4,A

; aufgerufen von: MOV_TEST
; ruft auf: -

; Vernderte Register: A, R4, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOV_TEST13:     MOV     A,#55h                  ; Testmuster 1 laden
		MOV     R4,A                    ; Befehlstest
		CJNE    R4,#55h,TRAN_err2       ; Vergleich mit Erwartungshaltung 
		RET



; ********************* MOV_TEST14 ******************************************
; Funktion: Test von MOV R5,A

; aufgerufen von: MOV_TEST
; ruft auf: -

; Vernderte Register: A, R5, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOV_TEST14:     MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     R5,A                    ; Befehlstest
		CJNE    R5,#0AAh,TRAN_err2      ; Vergleich mit Erwartungshaltung 
		RET



; ********************* MOV_TEST15 ******************************************
; Funktion: Test von MOV R6,A

; aufgerufen von: MOV_TEST
; ruft auf: -

; Vernderte Register: A, R6, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOV_TEST15:     MOV     A,#55h                  ; Testmuster 1 laden
		MOV     R6,A                    ; Befehlstest
		CJNE    R6,#55h,TRAN_err2       ; Vergleich mit Erwartungshaltung
		RET



; ********************* MOV_TEST16 ******************************************
; Funktion: Test von MOV R7,A

; aufgerufen von: MOV_TEST
; ruft auf: -

; Vernderte Register: A, R7, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOV_TEST16:     MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     R7,A                    ; Befehlstest
		CJNE    R7,#0AAh,TRAN_err2      ; Vergleich mit Erwartungshaltung 
		RET



; ***************************************************************************
TRAN_err2:      LJMP    ERROR_TRAN
; ***************************************************************************



; ********************* MOV_TEST17 ******************************************
; Funktion: Test von MOV Rn,dir

; aufgerufen von: MOV_TEST
; ruft auf: -

; Vernderte Register: R0-R7, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOV_TEST17:     MOV     R0,#55h                 ; Registerwerte initialisieren
		MOV     R1,#55h
		MOV     R2,#55h
		MOV     R3,#55h
		MOV     R4,#55h
		MOV     R5,#55h
		MOV     R6,#55h
		MOV     R7,#55h
		MOV     INTRAM20,#0AAh          ; Testmuster 1 laden
		
		MOV     R0,INTRAM20             ; Befehlstest
		CJNE    R0,#0AAh,TRAN_err3      ; Vergleich mit Erwartungshaltung

		MOV     R1,INTRAM20             ; Befehlstest
		CJNE    R1,#0AAh,TRAN_err3      ; Vergleich mit Erwartungshaltung 

		MOV     R2,INTRAM20             ; Befehlstest
		CJNE    R2,#0AAh,TRAN_err3      ; Vergleich mit Erwartungshaltung 

		MOV     R3,INTRAM20             ; Befehlstest
		CJNE    R3,#0AAh,TRAN_err3      ; Vergleich mit Erwartungshaltung 

		MOV     R4,INTRAM20             ; Befehlstest
		CJNE    R4,#0AAh,TRAN_err3      ; Vergleich mit Erwartungshaltung 

		MOV     R5,INTRAM20             ; Befehlstest
		CJNE    R5,#0AAh,TRAN_err3      ; Vergleich mit Erwartungshaltung 

		MOV     R6,INTRAM20             ; Befehlstest
		CJNE    R6,#0AAh,TRAN_err3      ; Vergleich mit Erwartungshaltung 

		MOV     R7,INTRAM20             ; Befehlstest
		CJNE    R7,#0AAh,TRAN_err3      ; Vergleich mit Erwartungshaltung 
		
		RET



; ***************************************************************************
TRAN_err3:      LJMP    ERROR_TRAN
; ***************************************************************************



; ********************* MOV_TEST18 ******************************************
; Funktion: Test von MOV dir,A

; aufgerufen von: MOV_TEST
; ruft auf: -

; Vernderte Register: A, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOV_TEST18:     MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     INTRAM10,#55h           ; Testmuster 2 laden
		MOV     INTRAM10,A              ; Befehlstest
		CJNE    A,INTRAM10,TRAN_err4    ; Vergleich mit Erwartungshaltung 
		RET



; ***************************************************************************
TRAN_err4:      LJMP    ERROR_TRAN
; ***************************************************************************



; ********************* MOV_TEST19 ******************************************
; Funktion: Test von MOV dir,R0

; aufgerufen von: MOV_TEST
; ruft auf: -

; Vernderte Register: A, R0, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOV_TEST19:     MOV     INTRAM20,#0             ; Speicherzelle initialisieren
		MOV     R0,#0AAh                ; Testmuster 1 laden
		MOV     INTRAM20,R0             ; Befehlstest
		MOV     A,INTRAM20            
		CJNE    A,#0AAh,TRAN_err5       ; Vergleich mit Erwartungshaltung 
		RET



; ********************* MOV_TEST20 ******************************************
; Funktion: Test von MOV dir,R1

; aufgerufen von: MOV_TEST
; ruft auf: -

; Vernderte Register: A, R1, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOV_TEST20:     MOV     R1,#55h                 ; Testmuster 1 laden
		MOV     INTRAM20,R1             ; Befehlstest
		MOV     A,INTRAM20           
		CJNE    A,#55h,TRAN_err5        ; Vergleich mit Erwartungshaltung 
		RET



; ********************* MOV_TEST21 ******************************************
; Funktion: Test von MOV dir,R2

; aufgerufen von: MOV_TEST
; ruft auf: -

; Vernderte Register: A, R2, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOV_TEST21:     MOV     R2,#0AAh                ; Testmuster 1 laden
		MOV     INTRAM20,R2             ; Befehlstest
		MOV     A,INTRAM20             
		CJNE    A,#0AAh,TRAN_err5       ; Vergleich mit Erwartungshaltung 
		RET



; ********************* MOV_TEST22 ******************************************
; Funktion: Test von MOV dir,R3

; aufgerufen von: MOV_TEST
; ruft auf: -

; Vernderte Register: A, R3, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOV_TEST22:     MOV     R3,#55h                 ; Testmuster 1 laden
		MOV     INTRAM20,R3             ; Befehlstest
		MOV     A,INTRAM20              
		CJNE    A,#55h,TRAN_err5        ; Vergleich mit Erwartungshaltung 
		RET



; ********************* MOV_TEST23 ******************************************
; Funktion: Test von MOV dir,R4

; aufgerufen von: MOV_TEST
; ruft auf: -

; Vernderte Register: A, R4, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOV_TEST23:     MOV     R4,#0AAh                ; Testmuster 1 laden
		MOV     INTRAM20,R4             ; Befehlstest
		MOV     A,INTRAM20              
		CJNE    A,#0AAh,TRAN_err5       ; Vergleich mit Erwartungshaltung
		RET



; ********************* MOV_TEST24 ******************************************
; Funktion: Test von MOV dir,R5

; aufgerufen von: MOV_TEST
; ruft auf: -

; Vernderte Register: A, R5, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOV_TEST24:     MOV     R5,#55h                 ; Testmuster 1 laden
		MOV     INTRAM20,R5             ; Befehlstest
		MOV     A,INTRAM20            
		CJNE    A,#55h,TRAN_err5        ; Vergleich mit Erwartungshaltung 
		RET



; ********************* MOV_TEST25 ******************************************
; Funktion: Test von MOV dir,R6

; aufgerufen von: MOV_TEST
; ruft auf: -

; Vernderte Register: A, R6, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOV_TEST25:     MOV     R6,#0AAh                ; Testmuster 1 laden
		MOV     INTRAM20,R6             ; Befehlstest
		MOV     A,INTRAM20              
		CJNE    A,#0AAh,TRAN_err5       ; Vergleich mit Erwartungshaltung 
		RET



; ********************* MOV_TEST26 ******************************************
; Funktion: Test von MOV dir,R7

; aufgerufen von: MOV_TEST
; ruft auf: -

; Vernderte Register: A, R7, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOV_TEST26:     MOV     R7,#55h                 ; Testmuster 1 laden
		MOV     INTRAM20,R7             ; Befehlstest
		MOV     A,INTRAM20              
		CJNE    A,#55h,TRAN_err5        ; Vergleich mit Erwartungshaltung 
		RET



; ***************************************************************************
TRAN_err5:      LJMP    ERROR_TRAN
; ***************************************************************************



; ********************* MOV_TEST27 ******************************************
; Funktion: Test von MOV dir,dir

; aufgerufen von: MOV_TEST
; ruft auf: -

; Vernderte Register: A, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOV_TEST27:     MOV     INTRAM20,#0AAh          ; Testmuster 1 laden
		MOV     INTRAM21,#55h           ; Testmuster 2 laden
		MOV     INTRAM20,INTRAM21       ; Befehlstest
		MOV     A,INTRAM20              
		CJNE    A,#55h,TRAN_err6        ; Vergleich mit Erwartungshaltung 
		RET



; ***************************************************************************
TRAN_err6:      LJMP    ERROR_TRAN
; ***************************************************************************



; ********************* MOV_TEST28 ******************************************
; Funktion: Test von MOV dir,@R0

; aufgerufen von: MOV_TEST
; ruft auf: -

; Vernderte Register: A, R0, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOV_TEST28:     MOV     INTRAM11,#0             ; Speicherzelle initialisieren
		MOV     R0,#10h                 ; Testmuster 1 laden
		MOV     INTRAM10,#20h           ; Testmuster 2 laden
		MOV     INTRAM11,@R0            ; Befehlstest
		INC     R0                      
		CJNE    @R0,#20h,TRAN_err7      ; Vergleich mit Erwartungshaltung 
		RET



; ********************* MOV_TEST29 ******************************************
; Funktion: Test von MOV dir,@R1

; aufgerufen von: MOV_TEST
; ruft auf: -

; Vernderte Register: A, R1, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOV_TEST29:     MOV     INTRAM11,#0             ; Speicherzelle initialisieren
		MOV     R1,#10h                 ; Testmuster 1 laden
		MOV     INTRAM10,#20h           ; Testmuster 2 laden
		MOV     INTRAM11,@R1            ; Befehlstest
		INC     R1                        
		CJNE    @R1,#20h,TRAN_err7      ; Vergleich mit Erwartungshaltung 
		RET



; ***************************************************************************
TRAN_err7:      LJMP    ERROR_TRAN
; ***************************************************************************



; ********************* MOV_TEST30 ******************************************
; Funktion: Test von MOV @R0,A

; aufgerufen von: MOV_TEST
; ruft auf: -

; Vernderte Register: A, R0, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOV_TEST30:     MOV     A,#01h                  ; Testmuster 1 laden
		MOV     R0,#02h                 ; Testmuster 2 laden
		MOV     @R0,A                   ; Befehlstest
		CJNE    A,INTRAM02,TRAN_err8    ; Vergleich mit Erwartungshaltung 
		RET



; ********************* MOV_TEST31 ******************************************
; Funktion: Test von MOV @R1,A

; aufgerufen von: MOV_TEST
; ruft auf: -

; Vernderte Register: A, R1, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOV_TEST31:     MOV     A,#03h                  ; Testmuster 1 laden
		MOV     R1,#04h                 ; Testmuster 2 laden
		MOV     @R1,A                   ; Befehlstest
		CJNE    A,INTRAM04,TRAN_err8    ; Vergleich mit Erwartungshaltung 
		RET



; ***************************************************************************
TRAN_err8:      LJMP    ERROR_TRAN
; ***************************************************************************



; ********************* MOV_TEST32 ******************************************
; Funktion: Test von MOV @R0,dir

; aufgerufen von: MOV_TEST
; ruft auf: -

; Vernderte Register: A, R0, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOV_TEST32:     MOV     INTRAM10,#0             ; Speicherzelle initialisieren
		MOV     INTRAM20,#55h           ; Testmuster 1 laden
		MOV     R0,#10h                 ; Testmuster 2 laden
		MOV     @R0,INTRAM20            ; Befehlstest
		MOV     A,INTRAM10              
		CJNE    A,#55h,TRAN_err9        ; Vergleich mit Erwartungshaltung 
		RET



; ********************* MOV_TEST33 ******************************************
; Funktion: Test von MOV @R1,dir

; aufgerufen von: MOV_TEST
; ruft auf: -

; Vernderte Register: A, R1, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOV_TEST33:     MOV     INTRAM20,#0             ; Speicherzelle initialisieren
		MOV     INTRAM21,#55h           ; Testmuster 1 laden
		MOV     R1,#20h                 ; Testmuster 2 laden
		MOV     @R1,INTRAM21            ; Befehlstest
		MOV     A,INTRAM20              
		CJNE    A,#55h,TRAN_err9        ; Vergleich mit Erwartungshaltung
		RET



; ***************************************************************************
TRAN_err9:      LJMP    ERROR_TRAN
; ***************************************************************************



; ********************* MOV_TEST34 ******************************************
; Funktion: Test von MOV @R0,data

; aufgerufen von: MOV_TEST
; ruft auf: -

; Vernderte Register: A, R0, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOV_TEST34:     MOV     R0,#20h                 ; Testmuster 1 laden
		MOV     @R0,#0FFh               ; Befehlstest
		MOV     A,INTRAM20              
		CJNE    A,#0FFh,TRAN_err10      ; Vergleich mit Erwartungshaltung 
		RET



; ********************* MOV_TEST35 ******************************************
; Funktion: Test von MOV @R1,data

; aufgerufen von: MOV_TEST
; ruft auf: -

; Vernderte Register: A, R1, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOV_TEST35:     MOV     R1,#21h                 ; Testmuster 1 laden
		MOV     @R1,#0FFh               ; Befehlstest
		MOV     A,INTRAM21             
		CJNE    A,#0FFh,TRAN_err10      ; Vergleich mit Erwartungshaltung 
		RET



; ***************************************************************************
TRAN_err10:     LJMP    ERROR_TRAN
; ***************************************************************************



; ********************* XCH_TEST1 *******************************************
; Funktion: Test von XCH A,R0

; aufgerufen von: XCH_TEST
; ruft auf: -

; Vernderte Register: A, R0, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
XCH_TEST1:      MOV     A,#0AAh                 ; Testmuster 1 laden             
		MOV     R0,#55h                 ; Testmuster 2 laden
		XCH     A,R0                    ; Befehlstest
		CJNE    A,#55h,TRAN_err11       ; Vergleich mit Erwartungshaltung 
		CJNE    R0,#0AAh,TRAN_err11     ; Vergleich mit Erwartungshaltung 
		RET



; ********************* XCH_TEST2 *******************************************
; Funktion: Test von XCH A,R1

; aufgerufen von: XCH_TEST
; ruft auf: -

; Vernderte Register: A, R1, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
XCH_TEST2:      MOV     A,#0AAh                 ; Testmuster 1 laden             
		MOV     R1,#55h                 ; Testmuster 2 laden
		XCH     A,R1                    ; Befehlstest
		CJNE    A,#55h,TRAN_err11       ; Vergleich mit Erwartungshaltung 
		CJNE    R1,#0AAh,TRAN_err11     ; Vergleich mit Erwartungshaltung 
		RET



; ********************* XCH_TEST3 *******************************************
; Funktion: Test von XCH A,R2

; aufgerufen von: XCH_TEST
; ruft auf: -

; Vernderte Register: A, R2, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
XCH_TEST3:      MOV     A,#0AAh                 ; Testmuster 1 laden             
		MOV     R2,#55h                 ; Testmuster 2 laden
		XCH     A,R2                    ; Befehlstest
		CJNE    A,#55h,TRAN_err11       ; Vergleich mit Erwartungshaltung 
		CJNE    R2,#0AAh,TRAN_err11     ; Vergleich mit Erwartungshaltung 
		RET



; ********************* XCH_TEST4 *******************************************
; Funktion: Test von XCH A,R3

; aufgerufen von: XCH_TEST
; ruft auf: -

; Vernderte Register: A, R3, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
XCH_TEST4:      MOV     A,#0AAh                 ; Testmuster 1 laden             
		MOV     R3,#55h                 ; Testmuster 2 laden
		XCH     A,R3                    ; Befehlstest
		CJNE    A,#55h,TRAN_err11       ; Vergleich mit Erwartungshaltung 
		CJNE    R3,#0AAh,TRAN_err11     ; Vergleich mit Erwartungshaltung 
		RET



; ********************* XCH_TEST5 *******************************************
; Funktion: Test von XCH A,R4

; aufgerufen von: XCH_TEST
; ruft auf: -

; Vernderte Register: A, R4, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
XCH_TEST5:      MOV     A,#0AAh                 ; Testmuster 1 laden             
		MOV     R4,#55h                 ; Testmuster 2 laden
		XCH     A,R4                    ; Befehlstest
		CJNE    A,#55h,TRAN_err11       ; Vergleich mit Erwartungshaltung 
		CJNE    R4,#0AAh,TRAN_err11     ; Vergleich mit Erwartungshaltung 
		RET



; ********************* XCH_TEST6 *******************************************
; Funktion: Test von XCH A,R5

; aufgerufen von: XCH_TEST
; ruft auf: -

; Vernderte Register: A, R5, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
XCH_TEST6:      MOV     A,#0AAh                 ; Testmuster 1 laden             
		MOV     R5,#55h                 ; Testmuster 2 laden
		XCH     A,R5                    ; Befehlstest
		CJNE    A,#55h,TRAN_err11       ; Vergleich mit Erwartungshaltung 
		CJNE    R5,#0AAh,TRAN_err11     ; Vergleich mit Erwartungshaltung 
		RET



; ********************* XCH_TEST7 *******************************************
; Funktion: Test von XCH A,R6

; aufgerufen von: XCH_TEST
; ruft auf: -

; Vernderte Register: A, R6, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
XCH_TEST7:      MOV     A,#0AAh                 ; Testmuster 1 laden             
		MOV     R6,#55h                 ; Testmuster 2 laden
		XCH     A,R6                    ; Befehlstest
		CJNE    A,#55h,TRAN_err11       ; Vergleich mit Erwartungshaltung 
		CJNE    R6,#0AAh,TRAN_err11     ; Vergleich mit Erwartungshaltung
		RET



; ********************* XCH_TEST8 *******************************************
; Funktion: Test von XCH A,R7

; aufgerufen von: XCH_TEST
; ruft auf: -

; Vernderte Register: A, R7, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
XCH_TEST8:      MOV     A,#0AAh                 ; Testmuster 1 laden             
		MOV     R7,#55h                 ; Testmuster 2 laden
		XCH     A,R7                    ; Befehlstest
		CJNE    A,#55h,TRAN_err11       ; Vergleich mit Erwartungshaltung 
		CJNE    R7,#0AAh,TRAN_err11     ; Vergleich mit Erwartungshaltung 
		RET



; ***************************************************************************
TRAN_err11:     LJMP    ERROR_TRAN
; ***************************************************************************



; ********************* XCH_TEST9 *******************************************
; Funktion: Test von XCH A,dir

; aufgerufen von: XCH_TEST
; ruft auf: -

; Vernderte Register: A, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
XCH_TEST9:      MOV     A,#0AAh                 ; Testmuster 1 laden             
		MOV     INTRAM10,#55h           ; Testmuster 2 laden
		XCH     A,INTRAM10              ; Befehlstest
		CJNE    A,#55h,TRAN_err12       ; Vergleich mit Erwartungshaltung 
		MOV     A,INTRAM10 
		CJNE    A,#0AAh,TRAN_err12      ; Vergleich mit Erwartungshaltung 
		RET



; ********************* XCH_TEST10 ******************************************
; Funktion: Test von XCH A,@R0

; aufgerufen von: XCH_TEST
; ruft auf: -

; Vernderte Register: A, R0, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
XCH_TEST10:     MOV     A,#0AAh                 ; Testmuster 1 laden             
		MOV     XCH1,#55h               ; Testmuster 2 laden
		MOV     R0,#XCH1               
		XCH     A,@R0                   ; Befehlstest                    
		CJNE    A,#55h,TRAN_err12       ; Vergleich mit Erwartungshaltung 
		CJNE    @R0,#0AAh,TRAN_err12    ; Vergleich mit Erwartungshaltung 
		RET



; ********************* XCH_TEST11 ******************************************
; Funktion: Test von XCH A,@R1

; aufgerufen von: XCH_TEST
; ruft auf: -

; Vernderte Register: A, R1, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
XCH_TEST11:     MOV     A,#0AAh                 ; Testmuster 1 laden             
		MOV     XCH1,#55h               ; Testmuster 2 laden
		MOV     R1,#XCH1 
		XCH     A,@R1                   ; Befehlstest                    
		CJNE    A,#55h,TRAN_err12       ; Vergleich mit Erwartungshaltung 
		CJNE    @R1,#0AAh,TRAN_err12    ; Vergleich mit Erwartungshaltung
		RET



; ********************* XCH_TEST12 ******************************************
; Funktion: Test von XCHD A,@R0

; aufgerufen von: XCH_TEST
; ruft auf: -

; Vernderte Register: A, R0, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
XCH_TEST12:     MOV     A,#0Ch                  ; Testmuster 1 laden             
		MOV     XCH1,#03h               ; Testmuster 2 laden
		MOV     R0,#XCH1            
		XCHD    A,@R0                   ; Befehlstest                    
		CJNE    A,#03h,TRAN_err12       ; Vergleich mit Erwartungshaltung 
		CJNE    @R0,#0Ch,TRAN_err12     ; Vergleich mit Erwartungshaltung 
		RET



; ********************* XCH_TEST13 ******************************************
; Funktion: Test von XCH A,@R1

; aufgerufen von: XCH_TEST
; ruft auf: -

; Vernderte Register: A, R1, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
XCH_TEST13:     MOV     A,#0Ch                  ; Testmuster 1 laden             
		MOV     XCH1,#03h               ; Testmuster 2 laden
		MOV     R1,#XCH1                    
		XCHD    A,@R1                   ; Befehlstest                    
		CJNE    A,#03h,TRAN_err12       ; Vergleich mit Erwartungshaltung
		CJNE    @R1,#0Ch,TRAN_err12     ; Vergleich mit Erwartungshaltung 
		RET



; ***************************************************************************
TRAN_err12:     LJMP    ERROR_TRAN
; ***************************************************************************



; ********************* MOVX_TEST1 ******************************************
; Funktion: Test von MOVX A,@R0, MOVX @R0,A

; aufgerufen von: MOVX_TEST
; ruft auf: -

; Vernderte Register: A, R0, PSW

; Stacktiefe: 3 Bytes
; ***************************************************************************
MOVX_TEST1:     MOV     R0,#0AAh            
		MOVX    A,@R0                   ; Inhalt von XRAM retten
		PUSH    ACC
		MOV     A,#55h                  ; Testmuster laden
		MOVX    @R0,A                   ; Befehlstest
		MOV     A,#00h               
		MOVX    A,@R0                   ; Befehlstest    
		CJNE    A,#55h,TRAN_err13       ; Vergleich mit Erwartungshaltung 
		POP     ACC                     ; Inhalt von XRAM wiederherstellen
		MOVX    @R0,A
		RET



; ********************* MOVX_TEST2 ******************************************
; Funktion: Test von MOVX A,@R1, MOVX @R1,A

; aufgerufen von: MOVX_TEST
; ruft auf: -

; Vernderte Register: A, R1, PSW

; Stacktiefe: 3 Bytes
; ***************************************************************************
MOVX_TEST2:     MOV     R1,#55h              
		MOVX    A,@R1                   ; Inhalt von XRAM retten
		PUSH    ACC
		MOV     A,#0AAh                 ; Testmuster laden
		MOVX    @R1,A                   ; Befehlstest
		MOV     A,#00h 
		MOVX    A,@R1                   ; Befehlstest    
		CJNE    A,#0AAh,TRAN_err13      ; Vergleich mit Erwartungshaltung 
		POP     ACC                     ; Inhalt von XRAM wiederherstellen
		MOVX    @R1,A
		RET



; ********************* MOVX_TEST3 ******************************************
; Funktion: Test von MOVX A,@DPTR, MOVX @DPTR,A

; aufgerufen von: MOVX_TEST
; ruft auf: -

; Vernderte Register: A, DPTR, PSW

; Stacktiefe: 3 Bytes
; ***************************************************************************
MOVX_TEST3:     MOV     DPTR,#0000h             ; initialisiert DataPointer
		MOV     DPTR,#5555h
		MOVX    A,@DPTR                 ; Inhalt von XRAM retten
		PUSH    ACC
		MOV     A,#0AAh                 ; Testmuster laden
		MOVX    @DPTR,A                 ; Befehlstest
		MOV     A,#00h                  
		MOVX    A,@DPTR                 ; Befehlstest
		CJNE    A,#0AAh,TRAN_err13      ; Vergleich mit Erwartungshaltung 
		POP     ACC                     ; Inhalt von XRAM wiederherstellen
		MOVX    @DPTR,A
		RET



; ***************************************************************************
TRAN_err13:     LJMP    ERROR_TRAN
; ***************************************************************************



; ********************* MOVC_TEST1 ******************************************
; Funktion: Test von MOVC A,@A+DPTR und MOVC A,@A+PC

; aufgerufen von: MOVC_TEST
; ruft auf: -

; Vernderte Register: A, DPTR, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOVC_TEST1:     MOV     DPTR,#MOVC_1            ; Adresse des Testbefehls laden
		CLR     A
		MOVC    A,@A+DPTR               ; Byte holen
		CJNE    A,#0AAH,TRAN_err14      ; Vegleich mit Erwartungshaltung
		MOV     A,#1                    ; Offset in Akku (Byte nach RET holen)
		MOVC    A,@A+PC                 ; Byte holen
		CJNE    A,#0AAH,TRAN_err14      ; Vergleich mit Erwartungshaltung
		RET                                                   
MOVC_1:         MOV     R2,20                   ; Befehl nur zum Test (Opcode AAh)



; ********************* MOVC_TEST2 ******************************************
; Funktion: Test von MOVC A,@A+DPTR und MOVC A,@A+PC

; aufgerufen von: MOVC_TEST
; ruft auf: -

; Vernderte Register: A, DPTR, PSW

; Stacktiefe: 2 Bytes
; ***************************************************************************
MOVC_TEST2:     MOV     DPTR,#MOVC_2            ; Adresse des Testbefehls laden
		CLR     A
		MOVC    A,@A+DPTR               ; Byte holen
		CJNE    A,#55H,TRAN_err14       ; Vergleich mit Erwartungshaltung
		MOV     A,#1                    ; Offset in Akku (Byte nach RET holen)
		MOVC    A,@A+PC                 ; Byte holen
		CJNE    A,#55H,TRAN_err14       ; Vergleich mit Erwartungshaltung
		RET                                                   
MOVC_2:         ANL     A,20                    ; Befehl nur zum Test (Opcode 55h)



; ***************************************************************************
TRAN_err14:     LJMP    ERROR_TRAN
; ***************************************************************************



; ********************* MOV_TEST ********************************************
; Funktion: Sammelaufruf aller MOV-Tests

; aufgerufen von: MAIN
; ruft auf: MOV_TEST1 - MOV_TEST35

; Vernderte Register: A, R0-R7, PSW

; Stacktiefe: 2 Bytes + aufgerufene Funktionen
; ***************************************************************************
MOV_TEST:       LCALL   MOV_TEST1 
		LCALL   MOV_TEST2 
		LCALL   MOV_TEST3 
		LCALL   MOV_TEST4 
		LCALL   MOV_TEST5 
		LCALL   MOV_TEST6
		LCALL   MOV_TEST7 
		LCALL   MOV_TEST8 
		LCALL   MOV_TEST9 
		LCALL   MOV_TEST10 
		LCALL   MOV_TEST11
		LCALL   MOV_TEST12 
		LCALL   MOV_TEST13 
		LCALL   MOV_TEST14
		LCALL   MOV_TEST15 
		LCALL   MOV_TEST16 
		LCALL   MOV_TEST17 
		LCALL   MOV_TEST18
		LCALL   MOV_TEST19 
		LCALL   MOV_TEST20 
		LCALL   MOV_TEST21 
		LCALL   MOV_TEST22 
		LCALL   MOV_TEST23 
		LCALL   MOV_TEST24 
		LCALL   MOV_TEST25
		LCALL   MOV_TEST26 
		LCALL   MOV_TEST27 
		LCALL   MOV_TEST28
		LCALL   MOV_TEST29 
		LCALL   MOV_TEST30
		LCALL   MOV_TEST31 
		LCALL   MOV_TEST32 
		LCALL   MOV_TEST33
		LCALL   MOV_TEST34 
		LCALL   MOV_TEST35
		RET



; ********************* XCH_TEST ********************************************
; Funktion: Sammelaufruf aller XCH-Tests

; aufgerufen von: MAIN
; ruft auf: XCH_TEST1 - XCH_TEST13

; Vernderte Register: A, R0-R7, PSW

; Stacktiefe: 2 Bytes + aufgerufene Funktionen
; ***************************************************************************
XCH_TEST:       LCALL   XCH_TEST1 
		LCALL   XCH_TEST2
		LCALL   XCH_TEST3 
		LCALL   XCH_TEST4
		LCALL   XCH_TEST5 
		LCALL   XCH_TEST6
		LCALL   XCH_TEST7 
		LCALL   XCH_TEST8
		LCALL   XCH_TEST9
		LCALL   XCH_TEST10
		LCALL   XCH_TEST11
		LCALL   XCH_TEST12
		LCALL   XCH_TEST13
		RET



; ********************* MOVX_TEST *******************************************
; Funktion: Sammelaufruf aller MOVX-Tests

; aufgerufen von: MAIN
; ruft auf: MOVX_TEST1 - MOVX_TEST3

; Vernderte Register: A, R0, R1, DPTR, PSW

; Stacktiefe: 2 Bytes + aufgerufene Funktionen
; ***************************************************************************
MOVX_TEST:      MOV     P2,#00h                 ; Page 0 des XRAM selektieren
		LCALL   MOVX_TEST1
		LCALL   MOVX_TEST2
		LCALL   MOVX_TEST3
		RET



; ********************* MOVC_TEST *******************************************
; Funktion: Sammelaufruf aller MOVC-Tests

; aufgerufen von: MAIN
; ruft auf: MOVC_TEST1 - MOVC_TEST2

; Vernderte Register: A, DPTR, PSW

; Stacktiefe: 2 Bytes + aufgerufene Funktionen
; ***************************************************************************
MOVC_TEST:      LCALL   MOVC_TEST1                        
		LCALL   MOVC_TEST2
		RET 



; ***************************************************************************
ERROR_TRAN:     MOV     FEHLER,#FEHLER_TRAN     ; Fehlerspeicher laden
		LJMP    ERROR
; ***************************************************************************

