; Modul: WD_TEST.ASM

; Version 1.00          BIA - Referat 5.2                    Datum: 15.09.2000

; Funktion:
; Die Funktion initialisiert den internen Watchdog. Ferner wird dieser 
; getestet, indem er ausgelst wird. Sollte innerhalb eines Zeitfensters 
; innerhalb einer Endlosschleife keine Auslsung erfolgen, so erfolgt 
; ein Fehleraussprung. Der WD_TEST sollte vor allen anderen Tests stehen,
; weil man hiermit den Prozessor in den sicheren Zustand 
; berfhren kann.

; Eingabeparameter: keine
; Ausgabeparameter: keine
; Vernderte Register: A, R0-R2, PSW
; Vernderte Speicherbereiche: keine

; Fehleraussprung: nach Funktion ERROR

; bergeordnete Module: CPU_TEST.ASM
; Untergeordnete Module: keine
; aufgerufen von: MAIN
; ruft auf: INIT

; Stacktiefe: 2 Bytes + aufgerufene Funktionen
; Verwendete Registerbank: Bank 0 muss von der aufrufenden Funktion eingestellt sein
; ***************************************************************************
WD_TEST:        MOV     WDTREL,#RELOADTIME      ; WD-Reloadregister mit Reloadwert laden
		SETB    SWDT                    ; Watchdog starten
		NOP
		SETB    WDT                     ; Watchdogrefresh
		SETB    SWDT                                        
		MOV     A,#40h                  ; Reset durch Watchdog oder Hardwarereset?
		ANL     A,IP0
		JNZ     WD_ENDE                 ; falls Bit WDTS gesetzt, Reset durch WD
		MOV     SP,#STACKANFANG         ; Stack im internen RAM positionieren
		LCALL   INIT                    ; Initialisierungen
		LJMP    MAIN                    ; Sprung zum Hauptprogramm
WD_TEST1:       NOP                             ; Einsprungpunkt bei Aufruf als Unterprogramm
		MOV     WD_TEST_FLAG,#0FFh      ; WD-Reset wird als Test interpretiert
		MOV     R2,SP                   ; Stackpointerposition sichern
		MOV     R0,#WD_TEST_ZEIT        ; Zeitschleife initialisieren
		MOV     R1,#48
WD_LOOP:        DJNZ    R1,WD_LOOP              ; Zeitschleife
		MOV     R1,#48
		NOP
		DJNZ    R0,WD_LOOP
		NOP                   
		NOP                   
		NOP
		NOP
		NOP
WD_FEHL:        MOV     FEHLER,#FEHLER_WD0      ; Fehlerspeicher laden (WD hat nicht ausgelst)
		NOP
		NOP
		NOP
		NOP
		NOP
		LJMP    ERROR               
WD_ENDE:        ANL     IP0,#10111111B          ; WDTS lschen
		MOV     A,WD_TEST_FLAG          ; WD-Reset wegen Test oder fehlender WD-Triggerung?
		CJNE    A,0FFh,WD_ENDE1         ; Bei WD_TEST_FLAG == FFh war dies ein WD-Test
		MOV     WD_TEST_FLAG,#0         ; Damit fhrt ein WD-Reset zur Fehlerroutine
		MOV     SP,R2                   ; Stackpointerposition wiederherstellen
		NOP                             ; An dieser Stelle Portausgangswerte
		NOP                             ; vor WD-Reset wiederherstellen
		RET
WD_ENDE1:       MOV     A,FEHLER                ; Ist WD-Auslsung ein Folgefehler?
		JNZ     WD_ENDE2                ; Falls ja, bleibt Fehlernummer erhalten
		MOV     FEHLER,#FEHLER_WD1      ; Fehlerspeicher laden (fehlender WD-Refresh)
WD_ENDE2:       NOP
		NOP
		NOP
		NOP
		NOP
		LJMP    ERROR           
