; Modul: XRAMTEST.ASM

; Version 1.00          BIA - Referat 5.2                    Datum: 15.09.2000

; Funktion:
; XRAM_TEST1 erkennt stuck-at, stuck-on, stuck-open und
; Kurzschluss-Fehler innerhalb der aktiven XRAM-Zelle.
; XRAM_TEST2 berprft den Hintergrund, d.h. das restliche RAM wird 
; gegenber der aktiven Zelle auf Kurzschlsse berprft.

; Eingabeparameter: keine
; Ausgabeparameter: keine
; Vernderte Register: siehe Einzelfunktionen
; Vernderte Speicherbereiche: keine, auer speziell fr diese Tests reservierte Speicherzellen

; Fehleraussprung: nach Funktion ERROR

; bergeordnete Module: CPU_TEST.ASM
; Untergeordnete Module: SIGNAT.ASM

; Stacktiefe: siehe Einzelfunktionen
; Verwendete Registerbank: aktuelle Bank
; Laufzeit: ?
; ***************************************************************************



; ********************* XRAM_TEST1 ******************************************
; Funktion: Testet die aktive RAM-Zelle auf stuck-at, stuck-on, stuck-open,
;           und Kurzschlussfehler (innerhalb dieser Zelle).
; Vernderte Register: A, R0, R1, DPTR, PSW

; aufgerufen von: MAIN
; ruft auf: -
; Stacktiefe: 2 Bytes
; *************************************************************************** 
XRAM_TEST1:     MOV     A,XRAM_SEGM_H                   ; Erstes Segment des Speichers?
                CJNE    A,#0,XRAM_TEST12                ; wenn ja, dann Zellentest
                MOV     A,XRAM_SEGM_L
                CJNE    A,#0,XRAM_TEST12
                MOV     DPH,XRAM_H                      ; Zelleninhalt sichern
                MOV     DPL,XRAM_L
                MOVX    A,@DPTR
                MOV     R0,A
                MOV     A,#01h                          ; Anfangswert des Tests
XRAM_TEST11:    MOVX    @DPTR,A                         ; in externes RAM schreiben
                MOV     R1,A                            ; Wert fr spteren Vergleich speichern
                MOVX    A,@DPTR                         ; Wert zurcklesen
                XRL     A,R1                            ; Vergleich
                JNZ     XRAM_ERROR
                MOV     A,R1
                RL      A                               ; Bit nach links schieben
                CJNE    A,#01h,XRAM_TEST11              ; alle Bits getestet?
                MOV     A,R0                            ; Zelleninhalt wiederherstellen
                MOVX    @DPTR,A
XRAM_TEST12:    RET



; ********************* XRAM_SIGN *******************************************
; Funktion: Berechnet die neue Signatur eines gesamten Segments.
; Vernderte Register: A, R1-R7, DPTR, PSW

; aufgerufen von: XRAM_TEST2
; ruft auf: SIGNAT

; Stacktiefe: 2 Bytes + aufgerufene Funktionen
; *************************************************************************** 
XRAM_SIGN:      MOV     XRAM_SIG_H,#0           ; Signatur lschen
                MOV     XRAM_SIG_L,#0
                MOV     R1,#0                   ; Zhlvariable
XRAM_SIGN1:     MOV     DPH,XRAM_SEGM_H         ; Segmentadresse laden
                MOV     DPL,XRAM_SEGM_L
                MOV     A,XRAM_L                ; aktuelles Byte ausgewhlt?
                CJNE    A,DPL,XRAM_SIGN2        
                MOV     A,XRAM_H
                CJNE    A,DPH,XRAM_SIGN2        ; wenn gleich, wird Byte bersprungen     
                INC     DPTR
                MOV     XRAM_SEGM_H,DPH
                MOV     XRAM_SEGM_L,DPL
                INC     R1
                CJNE    R1,#XRAM_SEGM_SIZE,XRAM_SIGN2   ; Segmentende?
                SJMP    XRAM_SIGN3
XRAM_SIGN2:     MOVX    A,@DPTR                 ; zu signierendes Byte laden
                MOV     R4,A
                MOV     R6,XRAM_SIG_H           ; momentane Signatur als Parameter bergeben
                MOV     R7,XRAM_SIG_L
                LCALL   SIGNAT                  ; neue Signatur berechnen
                MOV     XRAM_SIG_H,R6           ; neue Signatur abspeichern
                MOV     XRAM_SIG_L,R7
                INC     DPTR                    ; nchstes Byte
                MOV     XRAM_SEGM_H,DPH
                MOV     XRAM_SEGM_L,DPL
                INC     R1
                CJNE    R1,#XRAM_SEGM_SIZE,XRAM_SIGN1   ; Segmentende?
XRAM_SIGN3:     RET

                

; ***************************************************************************
XRAM_ERROR:     MOV     FEHLER,#FEHLER_XRAM     ; Fehlerspeicher laden
                LJMP    ERROR
; ***************************************************************************



; ********************* XRAM_TEST2 ******************************************
; Funktion: Berechnet und vergleicht die Signaturen der Segmente bei
;           verschiedenen Inhalten der aktiven Speicherzelle.
; Vernderte Register: A, R1-R7, DPTR, PSW

; aufgerufen von: MAIN
; ruft auf: XRAM_SIGN

; Stacktiefe: 7 Bytes + aufgerufene Funktionen
; *************************************************************************** 
XRAM_TEST2:     MOV     DPH,XRAM_H              ; DPTR mit aktueller XRAM-Adresse laden                
                MOV     DPL,XRAM_L
                MOVX    A,@DPTR                 ; aktive Zelle sichern
                PUSH    ACC
                PUSH    XRAM_SEGM_H             ; Segmentanfangswerte sichern
                PUSH    XRAM_SEGM_L
                LCALL   XRAM_SIGN               ; Signatur bilden
                POP     XRAM_SEGM_L             ; Segmentanfangswerte wiederherstellen
                POP     XRAM_SEGM_H
                PUSH    XRAM_SIG_H              ; berechnete Signatur zwischenspeichern
                PUSH    XRAM_SIG_L
                
                MOV     DPH,XRAM_H              ; DPTR mit aktueller XRAM-Adresse laden
                MOV     DPL,XRAM_L
                MOV     A,#0                    ; Testwert 00h
                MOVX    @DPTR,A
                PUSH    XRAM_SEGM_H             ; Segmentanfangswerte sichern
                PUSH    XRAM_SEGM_L
                LCALL   XRAM_SIGN               ; Signatur bilden
                POP     XRAM_SEGM_L             ; Segmentanfangswerte wiederherstellen
                POP     XRAM_SEGM_H
                POP     ACC                     ; Signaturen vergleichen, falls Fehler -> Endlosschleife
                CJNE    A,XRAM_SIG_L,XRAM_ERROR 
                POP     ACC
                CJNE    A,XRAM_SIG_H,XRAM_ERROR
                PUSH    XRAM_SIG_H              ; berechnete Signatur zwischenspeichern
                PUSH    XRAM_SIG_L
                
                MOV     DPH,XRAM_H              ; DPTR mit aktueller XRAM-Adresse laden
                MOV     DPL,XRAM_L
                MOV     A,#0FFh                 ; Testwert FFh
                MOVX    @DPTR,A
                LCALL   XRAM_SIGN               ; Signatur bilden
                POP     ACC                     ; Signaturen vergleichen, falls Fehler -> Endlosschleife
                CJNE    A,XRAM_SIG_L,XRAM_ERROR 
                POP     ACC
                CJNE    A,XRAM_SIG_H,XRAM_ERROR
                
                MOV     DPH,XRAM_H              ; Ursprungswert in Speicherzelle zurckschreiben
                MOV     DPL,XRAM_L
                POP     ACC
                MOVX    @DPTR,A
                MOV     A,XRAM_SEGM_H           ; Speicherende erreicht? Wenn ja, nchstes Byte
                CJNE    A,#XRAM_TOP_H,XRAM_TEST22
                MOV     A,XRAM_SEGM_L
                CJNE    A,#XRAM_TOP_L,XRAM_TEST22
                INC     DPTR                    ; nchstes Byte
                MOV     A,DPH
                CJNE    A,#XRAM_TOP_H,XRAM_TEST21
                MOV     A,DPL
                CJNE    A,#XRAM_TOP_L,XRAM_TEST21
                MOV     DPTR,#0000h             ; Speicheranfang
XRAM_TEST21:    MOV     XRAM_H,DPH              ; neues aktives Byte
                MOV     XRAM_L,DPL
                MOV     XRAM_SEGM_H,#0          ; Segmentanfang an Speicheranfang
                MOV     XRAM_SEGM_L,#0
XRAM_TEST22:    RET


