; Modul: XRL_TEST.ASM

; Version 1.00          BIA - Referat 5.2                    Datum: 15.09.2000

; Funktion:
; Die Unterprogramme testen den Verknpfungsbefehl XRL, indem AAH
; (10101010B) und 56H (01010110B) bitweise logisch Exclusiv-ODER verknpft
; werden und das berechnete Ergebnis mit dem erwarteten Ergebnis 
; von FCh (11111100B) verglichen wird.

; Eingabeparameter: keine
; Ausgabeparameter: keine
; Vernderte Register: siehe Einzelfunktionen
; Vernderte Speicherbereiche: keine, auer speziell fr diese Tests reservierte Speicherzellen

; Fehleraussprung: nach Funktion ERROR

; bergeordnete Module: LOGITEST.ASM
; Untergeordnete Module: keine
; aufgerufen von: XRL_TEST
; ruft auf: -

; Stacktiefe: 2 Bytes
; Verwendete Registerbank: aktuelle Bank
; ***************************************************************************



; ********************* XRL_TEST 1  *****************************************
; Funktion: Test von XRL A,R0
; Vernderte Register: A, R0, PSW
; ***************************************************************************
XRL_TEST1:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     R0,#56h                 ; Testmuster 2 laden 
		XRL     A,R0                    ; Befehlstest 
		CJNE    A,#0FCh,XRL_err1        ; Vergleich mit Erwartungshaltung
		RET
XRL_err1:       LJMP    ERROR_XRL           



; ********************* XRL_TEST 2  *****************************************
; Funktion: Test von XRL A,R1
; Vernderte Register: A, R1, PSW
; ***************************************************************************
XRL_TEST2:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     R1,#56h                 ; Testmuster 2 laden 
		XRL     A,R1                    ; Befehlstest 
		CJNE    A,#0FCh,XRL_err2        ; Vergleich mit Erwartungshaltung
		RET
XRL_err2:       LJMP    ERROR_XRL           



; ********************* XRL_TEST 3  *****************************************
; Funktion: Test von XRL A,R2
; Vernderte Register: A, R2, PSW
; ***************************************************************************
XRL_TEST3:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     R2,#56h                 ; Testmuster 2 laden 
		XRL     A,R2                    ; Befehlstest 
		CJNE    A,#0FCh,XRL_err3        ; Vergleich mit Erwartungshaltung
		RET
XRL_err3:       LJMP    ERROR_XRL



; ********************* XRL_TEST 4  *****************************************
; Funktion: Test von XRL A,R3
; Vernderte Register: A, R3, PSW
; ***************************************************************************
XRL_TEST4:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     R3,#56h                 ; Testmuster 2 laden 
		XRL     A,R3                    ; Befehlstest 
		CJNE    A,#0FCh,XRL_err4        ; Vergleich mit Erwartungshaltung
		RET
XRL_err4:       LJMP    ERROR_XRL



; ********************* XRL_TEST 5  *****************************************
; Funktion: Test von XRL A,R4
; Vernderte Register: A, R4, PSW
; ***************************************************************************
XRL_TEST5:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     R4,#56h                 ; Testmuster 2 laden 
		XRL     A,R4                    ; Befehlstest 
		CJNE    A,#0FCh,XRL_err5        ; Vergleich mit Erwartungshaltung
		RET
XRL_err5:       LJMP    ERROR_XRL           



; ********************* XRL_TEST 6  *****************************************
; Funktion: Test von XRL A,R5
; Vernderte Register: A, R5, PSW
; ***************************************************************************
XRL_TEST6:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     R5,#56h                 ; Testmuster 2 laden 
		XRL     A,R5                    ; Befehlstest 
		CJNE    A,#0FCh,XRL_err6        ; Vergleich mit Erwartungshaltung
		RET
XRL_err6:       LJMP    ERROR_XRL           



; ********************* XRL_TEST 7  *****************************************
; Funktion: Test von XRL A,R6
; Vernderte Register: A, R6, PSW
; ***************************************************************************
XRL_TEST7:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     R6,#56h                 ; Testmuster 2 laden 
		XRL     A,R6                    ; Befehlstest 
		CJNE    A,#0FCh,XRL_err7        ; Vergleich mit Erwartungshaltung
		RET
XRL_err7:       LJMP    ERROR_XRL           



; ********************* XRL_TEST 8  *****************************************
; Funktion: Test von XRL A,R7
; Vernderte Register: A, R7, PSW
; ***************************************************************************
XRL_TEST8:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     R7,#56h                 ; Testmuster 2 laden
		XRL     A,R7                    ; Befehlstest 
		CJNE    A,#0FCh,XRL_err8        ; Vergleich mit Erwartungshaltung
		RET
XRL_err8:       LJMP    ERROR_XRL           



; ********************* XRL_TEST 9  *****************************************
; Funktion: Test von XRL A,dir
; Vernderte Register: A, PSW
; ***************************************************************************
XRL_TEST9:      MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     INTRAM10,#56h           ; Testmuster 2 laden
		XRL     A,INTRAM10              ; Befehlstest 
		CJNE    A,#0FCh,XRL_err9        ; Vergleich mit Erwartungshaltung
		RET
XRL_err9:       LJMP    ERROR_XRL           



; ********************* XRL_TEST 10  ****************************************
; Funktion: Test von XRL A,@R0
; Vernderte Register: A, R0, PSW
; ***************************************************************************
XRL_TEST10:     MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     INTRAM10,#56h           ; Testmuster 2 laden
		MOV     R0,#10h                 ; Adresse von INTRAM10 laden
		XRL     A,@R0                   ; Befehlstest 
		CJNE    A,#0FCh,XRL_err10       ; Vergleich mit Erwartungshaltung
		RET
XRL_err10:      LJMP    ERROR_XRL           



; ********************* XRL_TEST 11  ****************************************
; Funktion: Test von XRL A,@R1
; Vernderte Register: A, R1, PSW
; ***************************************************************************
XRL_TEST11:     MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     INTRAM10,#56h           ; Testmuster 2 laden
		MOV     R1,#10h                 ; Adresse von INTRAM10 laden
		XRL     A,@R1                   ; Befehlstest 
		CJNE    A,#0FCh,XRL_err11       ; Vergleich mit Erwartungshaltung
		RET
XRL_err11:      LJMP    ERROR_XRL           



; ********************* XRL_TEST 12  ****************************************
; Funktion: Test von XRL A,#data
; Vernderte Register: A, PSW
; ***************************************************************************
XRL_TEST12:     MOV     A,#0AAh                 ; Testmuster 1 laden
		XRL     A,#56h                  ; Befehlstest 
		CJNE    A,#0FCh,XRL_err12       ; Vergleich mit Erwartungshaltung
		RET
XRL_err12:      LJMP    ERROR_XRL           



; ********************* XRL_TEST 13  ****************************************
; Funktion: Test von XRL dir,A
; Vernderte Register: A, PSW
; ***************************************************************************
XRL_TEST13:     MOV     A,#0AAh                 ; Testmuster 1 laden
		MOV     INTRAM10,#56h           ; Testmuster 2 laden
		XRL     INTRAM10,A              ; Befehlstest 
		MOV     A,INTRAM10              
		CJNE    A,#0FCh,XRL_err13       ; Vergleich mit Erwartungshaltung
		RET
XRL_err13:      LJMP    ERROR_XRL           



; ********************* XRL_TEST 14  ****************************************
; Funktion: Test von XRL dir,#data
; Vernderte Register: A, PSW
; ***************************************************************************
XRL_TEST14:     MOV     INTRAM10,#0AAh          ; Testmuster 1 laden
		XRL     INTRAM10,#56h           ; Befehlstest
		MOV     A,INTRAM10               
		CJNE    A,#0FCh,XRL_err14       ; Vergleich mit Erwartungshaltung
		RET
XRL_err14:      LJMP    ERROR_XRL           



; ***************************************************************************
ERROR_XRL:      MOV     FEHLER,#FEHLER_XRL      ; Fehlerspeicher laden
		LJMP    ERROR
; ***************************************************************************
