/*
 * $RCSfile: mgnr.h,v $
 * 
 * created by rieger on 21.08.2009
 * 
 * $Revision: 1.0 $
 * 
 * $Date: 03.04.2006 16:46:20 $
 * 
 * Copyright:
 * Werum Software & Systems AG
 * Wulf-Werum-Strasse 3, 
 * 21337 Lueneburg
 */
#ifndef _MGNR_H_
#define _MGNR_H_

// <summary>
// Fehlerstatus der durchgefhrten Mitgliedsnummerprfung.
// </summary>
enum ErrorStatus
{
   // <summary>
   // Definiert den Ergebnisstatus, wenn keine Prfung durchgefhrt wurde.
   // </summary>
   // <value>-1</value>
   noCheck = -1,

   // <summary>
   // Definiert den Ergebnisstatus, wenn die Mitgliedsnummer in Ordnung ist.
   // </summary>
   // <value>0</value>
   ok = 0,

   // <summary>
   // Definiert den Ergebnisstatus, wenn die Mitgliedsnummer unzulssige Zeichen enthlt.
   // </summary>
   // <value>1</value>
   wrongChars = 1,

   // <summary>
   // Definiert den Ergebnisstatus, wenn die Mitgliedsnummer eine falsche Lnge hat.
   // </summary>
   // <value>2</value>
   wrongLength = 2,

   // <summary>
   // Definiert den Ergebnisstatus, wenn die Mitgliedsnummer das falsche Format hat.
   // </summary>
   // <value>3</value>
   wrongFormat = 3,

   // <summary>
   // Definiert den Ergebnisstatus, wenn die Mitgliedsnummer eine falsche Prfziffer hat.
   // </summary>
   // <value>4</value>
   wrongCheckDigit = 4,

   // <summary>
   // Definiert den Ergebnisstatus, wenn der UV-Trger unbekannt ist.
   // </summary>
   // <value>5</value>
   uvtUnknown = 5
};

// <summary>
// Genauigkeit der Mitgliedsnummerprfung.
// </summary>
enum CheckAccuracy
{
   // <summary>
   // Definiert die Prfgenauigkeit, wenn nur Lnge und zulssige Zeichen
   // geprft werden.
   // </summary>
   // <value>1</value>
   lengthAndChars = 1,

   // <summary>
   // Definiert die Prfgenauigkeit, wenn eine komplette Prfung der
   // Mitgliedsnummer mit Formatierung und Prfziffern durchgefhrt wird.
   // </summary>
   // <value>2</value>
   full = 2,

   // <summary>
   // Definiert die Prfgenauigkeit, wenn die Mitgliedsnummer gegen den
   // Bestand geprft wird.
   // </summary>
   // <value>3</value>
   againstStock = 3
};

// <summary>
// Definiert die zu verwendende Prfgenauigkeit und erhlt das Ergebnis der
// Mitgliedsnummerprfung. Neben dem Fehlerstatus sind auch der Fehlertext,
// die verwendete Prfgenauigkeit und die Version der verwendeten PL abfragbar.
// </summary>
class __declspec(dllexport) PlausiReport
{
public:
   // <summary>
   // Erstellt ein neues PlausiResult-Objekt mit der Angabe der Prfgenaugkeit.
   // </summary>
   // <param name="accuracy">Genaugkeit, mit der geprft werden soll</param>
   PlausiReport(CheckAccuracy accuracy);

   // <summary>
   // Lscht alle gespeicherten Informationen zur Mitgliedsnummerprfung.
   // </summary>
   ~PlausiReport();

   // <summary>
   // Liefert den Fehlerstatus der durchgefhrten Mitgliedsnummerprfung.
   // </summary>
   // <returns>Fehlerstatus der durchgefhrten Mitgliedsnummerprfung</returns>
   ErrorStatus getErrorStatus();

   // <summary>
   // Liefert den Fehlerstatus der durchgefhrten Mitgliedsnummerprfung,
   // wenn der Status nicht ok ist.
   // </summary>
   // <returns>Fehlerstatus der durchgefhrten Mitgliedsnummerprfung</returns>
   const char* getErrorText();

   // <summary>
   // Liefert die vorgegebene Prfgenauigkeit.
   // </summary>
   // <returns>vorgegebene Prfgenauigkeit</returns>
   CheckAccuracy getDefinedAccuracy();

   // <summary>
   // Liefert die verwendete Prfgenauigkeit.
   // </summary>
   // <returns>verwendete Prfgenauigkeit</returns>
   CheckAccuracy getUsedAccuracy();

   // <summary>
   // Liefert die fr die Prfung verwendete PL-Version.
   // </summary>
   // <returns>PL-Version</returns>
   const char* getPlausiVersion();

   void setErrorStatus(ErrorStatus errorStatus);
   void setErrorText(const char* errorText);
   void setUsedAccuracy(CheckAccuracy usedAccuracy);
   void setPlausiVersion(const char* plausiVersion);

private:
   ErrorStatus errorStatus;
   char* errorText;
   CheckAccuracy definedAccuracy;
   CheckAccuracy usedAccuracy;
   char* plausiVersion;
};

// <summary>
// Ausfhren der Plausibilittsprfungen auf den vorgegebenen Rohdaten auf
// Basis der durch den PL-Editor gepflegten Metadaten.
// </summary>
// <param name="plausiReport">Report-Objekt, das sowohl die Eingabeparameter
// fr die Prfung enthlt, als auch das Ergebnis der Prfung aufnimmt</param>
// <param name="bbnrUvt">der UV-Trger zudem die Mitgliedsnummer gehrt</param>
// <param name="mgNr">zu prfende Mitgliedsnummer</param>
__declspec(dllexport) void doPlausi(PlausiReport* plausiReport, const char* bbnrUvt, const char* mgNr);

#endif