/*
 * Decompiled with CFR 0.152.
 */
package de.werum.dguv.mgnr.plausi;

import de.werum.dguv.mgnr.plausi.PlausiResult;
import de.werum.dguv.mgnr.plausi.log.ResultLog;
import de.werum.dguv.mgnr.plausi.log.ResultLogFacade;
import de.werum.dguv.mgnr.plausi.lzu.PlausiPerformer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.HashMap;

public class PlausiFacade {
    private static HashMap parameter;
    private static PlausiFacade instance;
    static /* synthetic */ Class class$0;

    static {
        instance = null;
    }

    private PlausiFacade() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PlausiFacade getInstance() {
        if (instance != null) return instance;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.werum.dguv.mgnr.plausi.PlausiFacade");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (instance != null) return instance;
            instance = new PlausiFacade();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public PlausiResult doPlausi(int pruefgenauigkeit, String bbnrUvt, String mgNr) {
        PlausiResult plausiResult = null;
        String zuPruefendeMgnr = mgNr;
        if (zuPruefendeMgnr != null) {
            zuPruefendeMgnr = zuPruefendeMgnr.trim();
        }
        PlausiPerformer plausiPerformer = new PlausiPerformer();
        plausiResult = plausiPerformer.doPlausi(pruefgenauigkeit, bbnrUvt, zuPruefendeMgnr);
        return plausiResult;
    }

    public static void main(String[] args) {
        ResultLog resultLog;
        PrintStream testLog;
        String mgnr;
        String bbnr;
        String file;
        int pruefgenauigkeit;
        boolean argsOK;
        PlausiFacade plausiFacade;
        int erg;
        block36: {
            erg = -1;
            plausiFacade = PlausiFacade.getInstance();
            argsOK = false;
            PlausiFacade.initialisierenParameter(args);
            pruefgenauigkeit = -1;
            file = null;
            bbnr = null;
            mgnr = null;
            testLog = null;
            if (parameter.keySet().contains("t")) {
                String testfile = (String)parameter.get("t");
                try {
                    testLog = new PrintStream(new FileOutputStream(testfile));
                }
                catch (Exception e) {
                    System.err.println("Es wird kein Testlog geschrieben: " + e.getMessage());
                    testLog = null;
                }
            }
            resultLog = ResultLogFacade.getInstance().getLog("csv", System.out, testLog != null);
            if (parameter.keySet().contains("a")) {
                try {
                    String ausgabeformat = (String)parameter.get("a");
                    if (ausgabeformat == null || !ausgabeformat.equalsIgnoreCase("csv") && !ausgabeformat.equalsIgnoreCase("xml")) {
                        System.err.println("Ausgabeformat muss csv oder xml sein. Default csv wird verwendet.");
                    } else {
                        resultLog = ResultLogFacade.getInstance().getLog(ausgabeformat, System.out, testLog != null);
                    }
                }
                catch (Exception e) {
                    System.err.println("Ausgabeformat muss eine Zeichenkette sein.");
                }
            }
            if (parameter.keySet().contains("p")) {
                try {
                    pruefgenauigkeit = Integer.parseInt((String)parameter.get("p"));
                    if (pruefgenauigkeit < 1 || pruefgenauigkeit > 3) {
                        System.err.println("Pr\u00fcfgenauigkeit muss 1, 2 oder 3 sein.");
                        PlausiFacade.printUsage();
                        break block36;
                    }
                    argsOK = true;
                }
                catch (Exception e) {
                    System.err.println("Pr\u00fcfgenauigkeit muss eine Zahl sein.");
                }
            } else {
                System.err.println("Pr\u00fcfgenauigkeit (-p) n\u00f6tig.");
                PlausiFacade.printUsage();
            }
        }
        if (argsOK) {
            if (parameter.keySet().contains("f")) {
                file = (String)parameter.get("f");
            } else {
                if (!parameter.keySet().contains("u")) {
                    System.err.println("Betriebsnummer des UV-Tr\u00e4gers (-u) n\u00f6tig.");
                    PlausiFacade.printUsage();
                } else {
                    bbnr = (String)parameter.get("u");
                }
                if (!parameter.keySet().contains("m")) {
                    System.err.println("Mitgliedsnummer (-m) n\u00f6tig.");
                    PlausiFacade.printUsage();
                } else {
                    mgnr = (String)parameter.get("m");
                }
            }
        }
        if (argsOK && file != null) {
            File inputFile = new File(file);
            try {
                FileReader in = new FileReader(inputFile);
                BufferedReader reader = new BufferedReader(in);
                int tmp_erg = -1;
                String line = null;
                int lineCount = 0;
                resultLog.printHeader();
                if (testLog != null) {
                    testLog.println("BBNR-UV;   MGNR;  Status;  erw. Status; Ergebnis");
                }
                while ((line = reader.readLine()) != null) {
                    ++lineCount;
                    if ((line = line.trim()).length() <= 0 || line.startsWith("#") || line.startsWith("BBNR")) continue;
                    String[] values = line.split(";");
                    String akt_bbnr = "";
                    String akt_mgnr = "";
                    if (values != null && values.length > 0) {
                        akt_bbnr = values[0];
                    }
                    if (values != null && values.length > 1) {
                        akt_mgnr = values[1];
                    }
                    int sollStatus = -1;
                    if (values != null && values.length > 2) {
                        try {
                            sollStatus = Integer.parseInt(values[2].trim());
                        }
                        catch (Exception e) {
                            sollStatus = -1;
                        }
                    }
                    PlausiResult plausiResult = plausiFacade.doPlausi(pruefgenauigkeit, akt_bbnr, akt_mgnr);
                    resultLog.printResult(pruefgenauigkeit, akt_bbnr, akt_mgnr, plausiResult, sollStatus);
                    tmp_erg = plausiResult.getErrorStatus();
                    if (erg == -1) {
                        erg = tmp_erg;
                    } else if (tmp_erg != 0 && (erg == 0 || erg > tmp_erg)) {
                        erg = tmp_erg;
                    }
                    if (testLog == null) continue;
                    String erwarteteErrStatus = "";
                    String ok = "";
                    if (values.length <= 2 || (erwarteteErrStatus = values[2].trim()).equals("" + plausiResult.getErrorStatus())) continue;
                    ok = "2".equals(erwarteteErrStatus) && plausiResult.getErrorStatus() == 3 ? "Laenge-Fehler" : "Fehler";
                    testLog.println(String.valueOf(akt_bbnr) + ";" + akt_mgnr + ";" + plausiResult.getErrorStatus() + ";" + erwarteteErrStatus + ";" + ok);
                }
                resultLog.printFooter();
                if (testLog != null) {
                    resultLog.printTestResult(testLog);
                }
            }
            catch (Exception e) {
                System.err.println("Fehler bei der Verarbeitung der Datei " + file + ": " + e.getLocalizedMessage());
                e.printStackTrace();
            }
        } else if (argsOK && bbnr != null && mgnr != null) {
            resultLog.printHeader();
            PlausiResult plausiResult = plausiFacade.doPlausi(pruefgenauigkeit, bbnr, mgnr);
            resultLog.printResult(pruefgenauigkeit, bbnr, mgnr, plausiResult, -1);
            erg = plausiResult.getErrorStatus();
            resultLog.printFooter();
        }
        System.exit(erg);
    }

    public static void printUsage() {
        System.err.println("usage: PlausiFacade [-a csv|xml (csv default)] -p Pr\u00fcfgenauigkeit -u BBNR-UVT -m Mitgliedsnummer");
        System.err.println("       PlausiFacade [-a csv|xml (csv default)][-t Testdatei] -p Pr\u00fcfgenauigkeit -f CSV-Datei (mit Tupeln aus BBNR-UVT und Mitgliedsnummer)");
    }

    private static void initialisierenParameter(String[] args) {
        parameter = new HashMap();
        if (args != null && args.length > 0) {
            String param = null;
            int i = 0;
            while (i < args.length) {
                if (args[i] != null && args[i].length() > 0) {
                    if (args[i].charAt(0) == '-') {
                        if (param != null) {
                            parameter.put(param, "");
                        }
                        param = args[i].substring(1);
                    } else if (param != null) {
                        parameter.put(param, args[i]);
                        param = null;
                    }
                }
                ++i;
            }
            if (param != null) {
                parameter.put(param, "");
            }
        }
    }
}

