/*
 * Decompiled with CFR 0.152.
 */
package de.werum.dguv.mgnr.plausi.log;

import de.werum.dguv.mgnr.plausi.PlausiResult;
import de.werum.dguv.mgnr.plausi.log.ResultLog;
import de.werum.dguv.mgnr.plausi.log.ResultOverview;
import java.io.PrintStream;

public class ResultLogCSV
extends ResultLog {
    protected int[] status = new int[6];
    protected ResultOverview resultOverview = null;

    public ResultLogCSV(PrintStream log, boolean doTest) {
        super(log);
        this.status[0] = 0;
        this.status[1] = 0;
        this.status[2] = 0;
        this.status[3] = 0;
        this.status[4] = 0;
        this.status[5] = 0;
        if (doTest) {
            this.resultOverview = new ResultOverview();
        }
    }

    public void printHeader() {
        this.log.println("Betriebsnummer UVT;Mitgliedsnummer;gew\u00fcnschte Pr\u00fcfgenauigkeit;verwendete Pr\u00fcfgenauigkeit;Ergebnis;Fehlertext");
    }

    public void printFooter() {
    }

    public void printResult(int pg, String bbnr, String mgnr, PlausiResult result, int sollStatus) {
        this.log.println(String.valueOf(bbnr) + ";" + mgnr + ";" + pg + ";" + result.getUsedAccuracy() + ";" + result.getErrorStatus() + ";" + (result.getErrorText() != null ? result.getErrorText() : ""));
        if (result.getErrorStatus() >= 0 && result.getErrorStatus() < 6) {
            this.status[result.getErrorStatus()] = this.status[result.getErrorStatus()] + 1;
        }
        if (this.resultOverview != null) {
            this.resultOverview.addStatus(bbnr, result.getErrorStatus());
        }
    }

    public void printTestResult(PrintStream testLog) {
        if (testLog != null && this.resultOverview != null) {
            this.resultOverview.printOverview(testLog);
            testLog.println(" ------------------------ Ergebnis ------------------------------- ");
            testLog.println("      Ok: " + Integer.toString(this.status[0]));
            testLog.println("      Zeichen: " + Integer.toString(this.status[1]));
            testLog.println("      Laenge: " + Integer.toString(this.status[2]));
            testLog.println("      Format: " + Integer.toString(this.status[3]));
            testLog.println("      Pruefziffer: " + Integer.toString(this.status[4]));
            testLog.println("      Uvt: " + Integer.toString(this.status[5]));
            testLog.println("      Insg: " + Integer.toString(this.status[0] + this.status[1] + this.status[2] + this.status[3] + this.status[4] + this.status[5]));
        }
    }
}

