/*
 * Decompiled with CFR 0.152.
 */
package de.werum.dguv.mgnr.plausi.log;

import de.werum.dguv.mgnr.plausi.PlausiResult;
import de.werum.dguv.mgnr.plausi.log.ResultLog;
import java.io.PrintStream;

public class ResultLogXML
extends ResultLog {
    public static final String TAG_LOG = "mitgliedsnummerpruefung";
    public static final String TAG_ERGEBNIS = "pruefergebnis";
    public static final String TAG_BBNRUVT = "betriebsnummer_uvt";
    public static final String TAG_MGNR = "mitgliedsnummer";
    public static final String TAG_PG_SOLL = "preufgenauigkeit_soll";
    public static final String TAG_PG_IST = "preufgenauigkeit_ist";
    public static final String TAG_STATUS = "status";
    public static final String TAG_FEHLERTEXT = "fehlertext";
    public static final String TAG_STATUS_SOLL = "status_soll";
    protected int[] status = new int[6];

    public ResultLogXML(PrintStream log, boolean doTest) {
        super(log);
        this.status[0] = 0;
        this.status[1] = 0;
        this.status[2] = 0;
        this.status[3] = 0;
        this.status[4] = 0;
        this.status[5] = 0;
    }

    public void printHeader() {
        this.log.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        this.log.println("<?xml-stylesheet type=\"text/xsl\" href=\"report.xsl\"?>");
        this.log.println(this.getStructureTag(TAG_LOG, true));
    }

    public void printFooter() {
        this.log.println("   " + this.getStructureTag("status_count", true));
        this.log.println("      " + this.getValueTag("ok", Integer.toString(this.status[0])));
        this.log.println("      " + this.getValueTag("zeichen", Integer.toString(this.status[1])));
        this.log.println("      " + this.getValueTag("laenge", Integer.toString(this.status[2])));
        this.log.println("      " + this.getValueTag("format", Integer.toString(this.status[3])));
        this.log.println("      " + this.getValueTag("pruefziffer", Integer.toString(this.status[4])));
        this.log.println("      " + this.getValueTag("uvt", Integer.toString(this.status[5])));
        this.log.println("   " + this.getStructureTag("status_count", false));
        this.log.println(this.getStructureTag(TAG_LOG, false));
    }

    public void printResult(int pg, String bbnr, String mgnr, PlausiResult result, int sollStatus) {
        this.log.println("   " + this.getStructureTag(TAG_ERGEBNIS, true));
        this.log.println("      " + this.getValueTag(TAG_BBNRUVT, bbnr));
        this.log.println("      " + this.getValueTag(TAG_MGNR, mgnr));
        this.log.println("      " + this.getValueTag(TAG_PG_SOLL, Integer.toString(pg)));
        this.log.println("      " + this.getValueTag(TAG_PG_IST, Integer.toString(result.getUsedAccuracy())));
        this.log.println("      " + this.getValueTag(TAG_STATUS, Integer.toString(result.getErrorStatus())));
        this.log.println("      " + this.getValueTag(TAG_FEHLERTEXT, result.getErrorText()));
        this.log.println("      " + this.getValueTag(TAG_STATUS_SOLL, sollStatus > -1 ? Integer.toString(sollStatus) : ""));
        this.log.println("   " + this.getStructureTag(TAG_ERGEBNIS, false));
        if (result.getErrorStatus() >= 0 && result.getErrorStatus() < 6) {
            this.status[result.getErrorStatus()] = this.status[result.getErrorStatus()] + 1;
        }
    }

    private String getXMLTextISO_8859_1(String text) {
        if (text == null) {
            return null;
        }
        StringBuffer escapedText = new StringBuffer();
        char[] chars = text.toCharArray();
        int i = 0;
        while (i < chars.length) {
            switch (chars[i]) {
                case '<': {
                    escapedText.append("&lt;");
                    break;
                }
                case '>': {
                    escapedText.append("&gt;");
                    break;
                }
                case '&': {
                    escapedText.append("&amp;");
                    break;
                }
                case '\"': {
                    escapedText.append("&quot;");
                    break;
                }
                default: {
                    escapedText.append(chars[i]);
                }
            }
            ++i;
        }
        return escapedText.toString();
    }

    private String getStructureTag(String tag, boolean start) {
        return "<" + (start ? "" : "/") + tag + ">";
    }

    private String getValueTag(String tag, String value) {
        String erg = null;
        if (value == null) {
            value = "";
        }
        erg = "<" + tag + ">" + this.getXMLTextISO_8859_1(value) + "</" + tag + ">";
        return erg;
    }
}

