/*
 * Decompiled with CFR 0.152.
 */
package de.werum.dguv.mgnr.plausi.log;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class ResultOverview {
    public HashMap uvtStatusMap = new HashMap();
    public HashMap uvtNames = null;
    public HashSet invalideUVTs = new HashSet();

    public ResultOverview() {
        this.uvtNames = new HashMap();
        this.uvtNames.put("01064065", "UK Sachsen");
        this.uvtNames.put("01627953", "Hanseat. FW");
        this.uvtNames.put("01681222", "UK MV");
        this.uvtNames.put("02379637", "UK Brandenburg");
        this.uvtNames.put("03701377", "UK Sachsen-Anhalt");
        this.uvtNames.put("07235792", "UK Thueringen");
        this.uvtNames.put("09322747", "FW UK Mitte");
        this.uvtNames.put("13385729", "Hanseat. FW");
        this.uvtNames.put("15087927", "BG Bau HH");
        this.uvtNames.put("15141364", "BGF");
        this.uvtNames.put("15186676", "BGW");
        this.uvtNames.put("15197214", "BG Bahnen");
        this.uvtNames.put("15250094", "VBG");
        this.uvtNames.put("16716004", "UK Nord");
        this.uvtNames.put("18477668", "UK Muenchen");
        this.uvtNames.put("18484827", "LPZ BG");
        this.uvtNames.put("18484877", "LPZ BG");
        this.uvtNames.put("18626026", "LUK Nieders.");
        this.uvtNames.put("18645029", "Hanseat. FW");
        this.uvtNames.put("20345417", "UK Bremen");
        this.uvtNames.put("21204943", "Braunschweigischer GUV");
        this.uvtNames.put("21204943", "Braunschweigischer GUV (Priv.)");
        this.uvtNames.put("26125562", "GUVV Oldenburg");
        this.uvtNames.put("28143238", "UK Bund");
        this.uvtNames.put("29029801", "STBG");
        this.uvtNames.put("29036720", "BG Bau H");
        this.uvtNames.put("29059513", "BGM (NMBG alt)");
        this.uvtNames.put("29059513", "BGM (neu)");
        this.uvtNames.put("29086457", "GUVV Hannover");
        this.uvtNames.put("29214533", "FW UK Nieders");
        this.uvtNames.put("31608112", "Bergbau BG");
        this.uvtNames.put("32064004", "BGHW (Einzelh)");
        this.uvtNames.put("34217193", "MMBG");
        this.uvtNames.put("34217193", "MMBG (neu)");
        this.uvtNames.put("34239086", "UK NRW");
        this.uvtNames.put("34364283", "HWBG");
        this.uvtNames.put("34364283", "HWBG (neu)");
        this.uvtNames.put("34364294", "BGETE aktuell");
        this.uvtNames.put("37916971", "BGETE");
        this.uvtNames.put("42884688", "BG Bau W");
        this.uvtNames.put("44861264", "UK Hessen");
        this.uvtNames.put("44888436", "BG Bau Frankfurt");
        this.uvtNames.put("48626018", "BGDP");
        this.uvtNames.put("49005902", "Eisenbahn-UK");
        this.uvtNames.put("52717470", "LPZ BG");
        this.uvtNames.put("52738475", "FBG");
        this.uvtNames.put("52742028", "BGM (SMBG alt)");
        this.uvtNames.put("52742028", "BGM (neu)");
        this.uvtNames.put("53149588", "UK RP");
        this.uvtNames.put("55423519", "UK Saarland");
        this.uvtNames.put("61635458", "BG Chemie");
        this.uvtNames.put("62279404", "BG Bau KA");
        this.uvtNames.put("63800761", "BGN");
        this.uvtNames.put("63886548", "BGHW (GroLa)");
        this.uvtNames.put("66337061", "UK PT");
        this.uvtNames.put("67334480", "UK BW");
        this.uvtNames.put("67350937", "BG Bau Boeblingen");
        this.uvtNames.put("75932959", "BG Keramik");
        this.uvtNames.put("87661138", "BG Bau M Hoch");
        this.uvtNames.put("87661183", "BG Bau M Tief");
        this.uvtNames.put("87661207", "Bayerischer GUVV, Bay. LUK");
        this.uvtNames.put("87741942", "HBG");
        this.uvtNames.put("88270171", "Bayerischer GUVV, Bay. LUK");
        this.uvtNames.put("90276713", "UK Berlin");
        this.uvtNames.put("98705576", "FW UK Mitte");
        this.uvtNames.put("99011352", "See-BG");
    }

    public void addStatus(String uvtNr, int statusId) {
        if (statusId == 5) {
            this.invalideUVTs.add(uvtNr);
        } else {
            if (!this.uvtStatusMap.containsKey(uvtNr)) {
                this.uvtStatusMap.put(uvtNr, new UVTResult());
            }
            ((UVTResult)this.uvtStatusMap.get(uvtNr)).addStatus(statusId);
        }
    }

    public void printOverview(PrintStream out) {
        Object[] uvtNrn = this.uvtStatusMap.keySet().toArray(new String[0]);
        Arrays.sort(uvtNrn);
        out.println("------------------------------------------------------------------");
        out.println("BBNR_UV;Bezeichnung;Ok;Zeichen;Laenge;Format;Pr\u00fcfziffer;Insg;%Ok;%Zeichen;%Laenge;%Format;%Pr\u00fcfziffer");
        int i = 0;
        while (i < uvtNrn.length) {
            UVTResult result = (UVTResult)this.uvtStatusMap.get(uvtNrn[i]);
            int insg = result.status[0] + result.status[1] + result.status[2] + result.status[3] + result.status[4];
            String name = "";
            if (this.uvtNames.containsKey(uvtNrn[i])) {
                name = (String)this.uvtNames.get(uvtNrn[i]);
            }
            out.println(String.valueOf(uvtNrn[i]) + ";" + name + ";" + Integer.toString(result.status[0]) + ";" + Integer.toString(result.status[1]) + ";" + Integer.toString(result.status[2]) + ";" + Integer.toString(result.status[3]) + ";" + Integer.toString(result.status[4]) + ";" + Integer.toString(insg) + ";" + Integer.toString((int)((double)result.status[0] * 100.0 / (double)insg + 0.5)) + "%" + ";" + Integer.toString((int)((double)result.status[1] * 100.0 / (double)insg + 0.5)) + "%" + ";" + Integer.toString((int)((double)result.status[2] * 100.0 / (double)insg + 0.5)) + "%" + ";" + Integer.toString((int)((double)result.status[3] * 100.0 / (double)insg + 0.5)) + "%" + ";" + Integer.toString((int)((double)result.status[4] * 100.0 / (double)insg + 0.5)) + "%");
            ++i;
        }
        out.println("------------------------------------------------------------------");
        out.println(String.valueOf(this.invalideUVTs.size()) + " falsche BBNR_UV:");
        Iterator it = this.invalideUVTs.iterator();
        while (it.hasNext()) {
            out.println(it.next());
        }
    }

    public class UVTResult {
        protected int[] status = new int[6];

        public UVTResult() {
            this.status[0] = 0;
            this.status[1] = 0;
            this.status[2] = 0;
            this.status[3] = 0;
            this.status[4] = 0;
            this.status[5] = 0;
        }

        public void addStatus(int statusId) {
            int n = statusId;
            this.status[n] = this.status[n] + 1;
        }
    }
}

