/*
 * Decompiled with CFR 0.152.
 */
package de.werum.dguv.mgnr.plausi.lzu;

import de.statspez.pleditor.generator.runtime.plausi.PlausiFactory;
import de.statspez.pleditor.generator.runtime.plausi.PlausiFehler;
import de.statspez.pleditor.generator.runtime.plausi.PlausiInterface;
import de.statspez.pleditor.generator.runtime.plausi.PlausiKontext;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import de.werum.dguv.mgnr.plausi.PlausiResult;
import de.werum.dguv.mgnr.plausi.lzu.DataSet;
import de.werum.dguv.mgnr.plausi.lzu.DefaultPlausiResult;

public class PlausiPerformer {
    public static final String FIELD_NAME_MGNR = "mgnr";
    public static final String FIELD_NAME_BBNR_UVT = "bbnr";
    public static final String FIELD_NAME_PRUEFSTUFE = "pruefstufe";
    public static final String FIELD_NAME_VERWENDETE_PRUEFSTUFE = "verw_pruefstufe";
    public static final String PL_TYPE = "Mitgliedsnummerpruefung";

    public PlausiResult doPlausi(int pruefgenauigkeit, String bbnrUvt, String mgNr) {
        DefaultPlausiResult plausiResult = new DefaultPlausiResult();
        plausiResult.setDefinedAccuracy(pruefgenauigkeit);
        try {
            DataSet dataSet = new DataSet();
            dataSet.setValue(FIELD_NAME_MGNR, mgNr);
            dataSet.setValue(FIELD_NAME_BBNR_UVT, bbnrUvt);
            dataSet.setValue(FIELD_NAME_PRUEFSTUFE, Integer.toString(pruefgenauigkeit));
            dataSet.setValue(FIELD_NAME_VERWENDETE_PRUEFSTUFE, Integer.toString(pruefgenauigkeit));
            PlausiInterface plausi = new PlausiFactory().createPlausi(PL_TYPE);
            if (plausi != null) {
                PlausiKontext kontext = new PlausiKontext();
                plausi.gesamtPlausi((SatzInterface)dataSet, kontext);
                this.intiPlausiResult(dataSet, kontext, plausiResult, plausi);
            } else {
                plausiResult.setErrorStatus(-1);
                plausiResult.setErrorText("Systemfehler: Die PL_Klasse konnte nicht initialisiert werden.");
            }
        }
        catch (Exception ex) {
            plausiResult.setErrorStatus(-1);
            plausiResult.setErrorText("Systemfehler: " + ex.getMessage());
        }
        return plausiResult;
    }

    public void intiPlausiResult(DataSet dataSet, PlausiKontext kontext, DefaultPlausiResult plausiResult, PlausiInterface plausiInterface) {
        plausiResult.setPlausiVersion(plausiInterface.getPlausiVersionString());
        String pruefstufe = dataSet.getValue(FIELD_NAME_VERWENDETE_PRUEFSTUFE);
        plausiResult.setUsedAccuracy(Integer.parseInt(pruefstufe));
        int anzahlFehler = kontext.getAnzahlFehler();
        if (anzahlFehler > 0) {
            PlausiFehler plausifehler = kontext.getFehler(0);
            String pname = plausifehler.getFehlerSchluessel();
            if (pname.length() > 1 && Character.isDigit(pname.charAt(1))) {
                plausiResult.setErrorStatus(Integer.parseInt(pname.substring(1, 2)));
            }
            plausiResult.setErrorText(plausifehler.getFehlertextKurz());
        } else {
            plausiResult.setErrorStatus(0);
        }
    }

    public String getErrorTextLength(PlausiFehler plausifehler) {
        return "Das Feld enth\u00e4lt mehr als die zul\u00e4ssigen " + plausifehler.getWertlaenge() + " Zeichen.";
    }

    public String getErrorTextMissingValue() {
        return "Das Datenfeld muss gef\u00fcllt sein.";
    }

    public String getErrorTextType(PlausiFehler plausifehler) {
        String maske;
        String text = "Feldinhalt muss " + plausifehler.getMerkmalstyp() + " sein.";
        if (plausifehler.getMaske() != null && (maske = plausifehler.getMaske()).startsWith("0")) {
            text = String.valueOf(text) + " Zahlwerte m\u00fcssen mit 0 aufgef\u00fcllt werden.";
        }
        return text;
    }

    public String getErrorTextValueRange(PlausiFehler plausifehler) {
        return "Der Wert liegt nicht im Wertebereich " + plausifehler.getWertebereich() + ".";
    }
}

