/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codeassist;

public class SyntaxElement
implements Comparable {
    public static final int TYPE_LOCAL_VAR = 1;
    public static final int TYPE_ABLAUF = 2;
    public static final int TYPE_AUSPRAEGUNG = 3;
    public static final int TYPE_AUSPR_GRUPPE = 4;
    public static final int TYPE_EIGENSCHAFT = 5;
    public static final int TYPE_FELD = 6;
    public static final int TYPE_FUNKTION = 7;
    public static final int TYPE_FUNKTION_INTERN = 8;
    public static final int TYPE_MATERIALREFERENZ = 9;
    public static final int TYPE_PL_INITWERT = 10;
    public static final int TYPE_PL_PARAMETER = 11;
    public static final int TYPE_PL_VARIABLE = 12;
    public static final int TYPE_PRUEFUNG = 13;
    public static final int TYPE_TB = 14;
    public static final int TYPE_KEYWORD = 15;
    public static final int TYPE_TEMPLATE = 16;
    private static final String[] TYPE_TEXTES = new String[]{"unbekannter Typ", "lokale Variable", "Ablauf", "Auspr\u00e4gung", "Auspr\u00e4gungsgruppe", "Eigenschaft", "Feld", "Funktion", "Funktion (intern)", "Materialreferenz", "Initwert", "Parameter", "PL Variable", "Pr\u00fcfung", "Strukturfeld", "Schl\u00fcsselwort", "Vorlage"};
    private static final int[] SCOPE_FUNKTION = new int[]{1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 15, 16};
    private static final int[] SCOPE_ABLAUF = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
    private static final int[] SCOPE_PRUEFUNG = new int[]{1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 15, 16};
    private static final int[] SCOPE_EIGENSCHAFT = new int[]{1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 15, 16};
    private static final int[] SCOPE_WERTEBEREICH = new int[]{8, 15, 16};
    private static final int[] SCOPE_MAPPING = new int[]{1, 6, 8, 15, 16};
    private int type;
    private String displayText;
    private String replaceText;
    private int caretPosition;
    private int selectionStart;
    private int selectionLength;

    public static int[] getRelatedTypes(int scopeType) {
        switch (scopeType) {
            case 4: {
                return SCOPE_ABLAUF;
            }
            case 3: {
                return SCOPE_PRUEFUNG;
            }
            case 2: {
                return SCOPE_EIGENSCHAFT;
            }
            case 1: {
                return SCOPE_FUNKTION;
            }
            case 5: {
                return SCOPE_WERTEBEREICH;
            }
            case 6: {
                return SCOPE_MAPPING;
            }
        }
        return null;
    }

    public SyntaxElement(int type, String displayText, String replaceText) {
        this.setType(type);
        this.setDisplayText(displayText);
        this.setReplaceText(replaceText);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public void setDisplayText(String displayText) {
        this.displayText = displayText;
    }

    public String getReplaceText() {
        return this.replaceText;
    }

    public void setReplaceText(String replaceText) {
        this.replaceText = replaceText;
        this.setCaretPosition(this.replaceText.length());
    }

    public int getCaretPosition() {
        return this.caretPosition;
    }

    public void setCaretPosition(int caretPosition) {
        this.caretPosition = caretPosition;
        this.setSelectionStart(caretPosition);
        this.setSelectionLength(0);
    }

    public int getSelectionStart() {
        return this.selectionStart;
    }

    public void setSelectionStart(int selectionStart) {
        this.selectionStart = selectionStart;
    }

    public int getSelectionLength() {
        return this.selectionLength;
    }

    public void setSelectionLength(int selectionLength) {
        this.selectionLength = selectionLength;
    }

    private String getTypeAsText() {
        return TYPE_TEXTES[this.getType()];
    }

    public String toString() {
        return String.valueOf(this.getDisplayText()) + " - " + this.getTypeAsText();
    }

    public int compareTo(Object o) {
        return this.toString().compareTo(o.toString());
    }
}

