/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codeassist.ui;

import de.statspez.pleditor.generator.codeassist.CodeAssistant;
import de.statspez.pleditor.generator.codeassist.CodeAssistantResult;
import de.statspez.pleditor.generator.codeassist.CustomSyntaxElement;
import de.statspez.pleditor.generator.codeassist.SyntaxElement;
import de.statspez.pleditor.generator.codeassist.ui.ScopeProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class CodeAssistantWindow
extends JWindow
implements KeyListener,
MouseListener,
HierarchyListener,
CaretListener {
    private static final Icon localVarIcon;
    private static final Icon categoryGroupIcon;
    private static final Icon categoryIcon;
    private static final Icon flowIcon;
    private static final Icon checkIcon;
    private static final Icon propertyIcon;
    private static final Icon functionIcon;
    private static final Icon functionIntIcon;
    private static final Icon structIcon;
    private static final Icon fieldIcon;
    private static final Icon initValueIcon;
    private static final Icon helpVarIcon;
    private static final Icon paramIcon;
    private static final Icon materialRefIcon;
    private static final Icon templateIcon;
    private static final Icon keywordIcon;
    private JTextComponent codeTextComponent;
    private ScopeProvider scopeProvider;
    private CodeAssistant codeAssistant;
    private CodeAssistantListModel codeAssistListModel;
    private JList list;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.statspez.pleditor.generator.codeassist.CodeAssistant");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        localVarIcon = new ImageIcon(clazz.getResource("/de/statspez/pleditor/generator/images/lokalvar.gif"));
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("de.statspez.pleditor.generator.codeassist.CodeAssistant");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        categoryGroupIcon = new ImageIcon(clazz2.getResource("/de/statspez/pleditor/generator/images/auspraegungsgruppe.gif"));
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("de.statspez.pleditor.generator.codeassist.CodeAssistant");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        categoryIcon = new ImageIcon(clazz3.getResource("/de/statspez/pleditor/generator/images/auspraegung.gif"));
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("de.statspez.pleditor.generator.codeassist.CodeAssistant");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        flowIcon = new ImageIcon(clazz4.getResource("/de/statspez/pleditor/generator/images/ablauf.gif"));
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName("de.statspez.pleditor.generator.codeassist.CodeAssistant");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        checkIcon = new ImageIcon(clazz5.getResource("/de/statspez/pleditor/generator/images/pruefung.gif"));
        Class<?> clazz6 = class$0;
        if (clazz6 == null) {
            try {
                clazz6 = class$0 = Class.forName("de.statspez.pleditor.generator.codeassist.CodeAssistant");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        propertyIcon = new ImageIcon(clazz6.getResource("/de/statspez/pleditor/generator/images/eigenschaft.gif"));
        Class<?> clazz7 = class$0;
        if (clazz7 == null) {
            try {
                clazz7 = class$0 = Class.forName("de.statspez.pleditor.generator.codeassist.CodeAssistant");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        functionIcon = new ImageIcon(clazz7.getResource("/de/statspez/pleditor/generator/images/funktion.gif"));
        Class<?> clazz8 = class$0;
        if (clazz8 == null) {
            try {
                clazz8 = class$0 = Class.forName("de.statspez.pleditor.generator.codeassist.CodeAssistant");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        functionIntIcon = new ImageIcon(clazz8.getResource("/de/statspez/pleditor/generator/images/funktion_intern.gif"));
        Class<?> clazz9 = class$0;
        if (clazz9 == null) {
            try {
                clazz9 = class$0 = Class.forName("de.statspez.pleditor.generator.codeassist.CodeAssistant");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        structIcon = new ImageIcon(clazz9.getResource("/de/statspez/pleditor/generator/images/subthemenbereich.gif"));
        Class<?> clazz10 = class$0;
        if (clazz10 == null) {
            try {
                clazz10 = class$0 = Class.forName("de.statspez.pleditor.generator.codeassist.CodeAssistant");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fieldIcon = new ImageIcon(clazz10.getResource("/de/statspez/pleditor/generator/images/tbfeld.gif"));
        Class<?> clazz11 = class$0;
        if (clazz11 == null) {
            try {
                clazz11 = class$0 = Class.forName("de.statspez.pleditor.generator.codeassist.CodeAssistant");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        initValueIcon = new ImageIcon(clazz11.getResource("/de/statspez/pleditor/generator/images/initwert.gif"));
        Class<?> clazz12 = class$0;
        if (clazz12 == null) {
            try {
                clazz12 = class$0 = Class.forName("de.statspez.pleditor.generator.codeassist.CodeAssistant");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        helpVarIcon = new ImageIcon(clazz12.getResource("/de/statspez/pleditor/generator/images/plvar.gif"));
        Class<?> clazz13 = class$0;
        if (clazz13 == null) {
            try {
                clazz13 = class$0 = Class.forName("de.statspez.pleditor.generator.codeassist.CodeAssistant");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        paramIcon = new ImageIcon(clazz13.getResource("/de/statspez/pleditor/generator/images/param.gif"));
        Class<?> clazz14 = class$0;
        if (clazz14 == null) {
            try {
                clazz14 = class$0 = Class.forName("de.statspez.pleditor.generator.codeassist.CodeAssistant");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        materialRefIcon = new ImageIcon(clazz14.getResource("/de/statspez/pleditor/generator/images/materialref.gif"));
        Class<?> clazz15 = class$0;
        if (clazz15 == null) {
            try {
                clazz15 = class$0 = Class.forName("de.statspez.pleditor.generator.codeassist.CodeAssistant");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        templateIcon = new ImageIcon(clazz15.getResource("/de/statspez/pleditor/generator/codeassist/images/template.gif"));
        Class<?> clazz16 = class$0;
        if (clazz16 == null) {
            try {
                clazz16 = class$0 = Class.forName("de.statspez.pleditor.generator.codeassist.CodeAssistant");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        keywordIcon = new ImageIcon(clazz16.getResource("/de/statspez/pleditor/generator/codeassist/images/keyword.gif"));
    }

    public CodeAssistantWindow(JTextComponent codeTextComponent, ScopeProvider scopeProvider) {
        super(SwingUtilities.getWindowAncestor(codeTextComponent));
        this.codeTextComponent = codeTextComponent;
        this.scopeProvider = scopeProvider;
        this.codeAssistant = new CodeAssistant();
        this.codeAssistListModel = new CodeAssistantListModel();
        this.list = new JList();
        this.codeTextComponent.addHierarchyListener(this);
        this.codeTextComponent.addKeyListener(this);
        this.codeTextComponent.addCaretListener(this);
        this.codeTextComponent.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                CodeAssistantWindow.this.closeWindow(false);
            }
        });
        this.setFocusableWindowState(false);
        this.list.setModel(this.codeAssistListModel);
        this.list.setCellRenderer(new SyntaxCellRenderer());
        this.list.setSelectionMode(0);
        this.list.addMouseListener(this);
        JScrollPane scrollPane = new JScrollPane(this.list, 20, 30);
        int red = SystemColor.control.getRed();
        int green = SystemColor.control.getGreen();
        int blue = SystemColor.control.getBlue();
        red = red >= 10 ? red - 10 : 0;
        green = green >= 10 ? green - 10 : 0;
        blue = blue >= 10 ? blue - 10 : 0;
        scrollPane.setBorder(new CompoundBorder(new BevelBorder(0), new LineBorder(new Color(red, green, blue), 1)));
        this.getContentPane().add(scrollPane);
    }

    private void updateList() {
        Cursor cursor = this.codeTextComponent.getCursor();
        this.codeTextComponent.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.codeAssistListModel.setCodeAssistantResult(this.codeAssistant.computeChoices(this.scopeProvider.getScope(), this.scopeProvider.getScopeType(), this.scopeProvider.getCustomChoices(), this.codeTextComponent.getText(), this.codeTextComponent.getSelectionStart()));
        }
        finally {
            this.codeTextComponent.setCursor(cursor);
        }
    }

    private void openWindow() {
        this.updateList();
        if (this.codeAssistListModel.getSize() > 0) {
            Point magicCaretPos = this.codeTextComponent.getCaret().getMagicCaretPosition();
            if (magicCaretPos == null) {
                magicCaretPos = new Point(0, 0);
            }
            int x = this.codeTextComponent.getLocationOnScreen().x + magicCaretPos.x;
            int y = this.codeTextComponent.getLocationOnScreen().y + magicCaretPos.y + this.codeTextComponent.getFont().getSize() + 5;
            this.pack();
            this.setLocation(x, y);
            this.setVisible(true);
            this.list.ensureIndexIsVisible(0);
            this.list.setSelectedIndex(0);
        }
    }

    private void updateWindow() {
        int currentOffset = this.codeAssistListModel.getCodeAssistantResult().getOffset();
        this.updateList();
        if (this.codeAssistListModel.getSize() == 0 || this.codeAssistListModel.getCodeAssistantResult().getOffset() != currentOffset) {
            this.setVisible(false);
        }
    }

    private void closeWindow(boolean selectionOk) {
        if (selectionOk && this.list.getSelectedIndex() >= 0) {
            CodeAssistantResult result = this.codeAssistListModel.getCodeAssistantResult();
            SyntaxElement element = result.getChoice(this.list.getSelectedIndex());
            boolean shouldReplace = true;
            if (element instanceof CustomSyntaxElement) {
                shouldReplace = this.scopeProvider.handleCustomChoice((CustomSyntaxElement)element);
            }
            if (shouldReplace) {
                try {
                    this.codeTextComponent.getDocument().remove(result.getOffset(), this.codeTextComponent.getSelectionEnd() - result.getOffset());
                    this.codeTextComponent.getDocument().insertString(result.getOffset(), element.getReplaceText(), null);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                this.codeTextComponent.setCaretPosition(result.getOffset() + element.getCaretPosition());
                this.codeTextComponent.setSelectionStart(result.getOffset() + element.getSelectionStart());
                this.codeTextComponent.setSelectionEnd(this.codeTextComponent.getSelectionStart() + element.getSelectionLength());
            }
        }
        this.setVisible(false);
    }

    private void changeSelectedElement(int delta) {
        int selIndex;
        int listSize = this.codeAssistListModel.getSize();
        if (Math.abs(delta) >= listSize) {
            selIndex = delta > 0 ? listSize - 1 : 0;
        } else {
            selIndex = this.list.getSelectedIndex() + delta;
            if (selIndex < 0) {
                selIndex = listSize + selIndex;
            } else if (selIndex >= listSize) {
                selIndex -= listSize;
            }
        }
        this.list.ensureIndexIsVisible(selIndex);
        this.list.setSelectedIndex(selIndex);
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 32 && e.isControlDown()) {
            if (!this.isShowing()) {
                this.openWindow();
            }
        } else if (this.isShowing()) {
            switch (e.getKeyCode()) {
                case 10: {
                    this.closeWindow(true);
                    e.consume();
                    break;
                }
                case 27: {
                    this.closeWindow(false);
                    e.consume();
                    break;
                }
                case 38: {
                    this.changeSelectedElement(-1);
                    e.consume();
                    break;
                }
                case 40: {
                    this.changeSelectedElement(1);
                    e.consume();
                    break;
                }
                case 33: {
                    this.changeSelectedElement(-this.list.getVisibleRowCount());
                    e.consume();
                    break;
                }
                case 34: {
                    this.changeSelectedElement(this.list.getVisibleRowCount());
                    e.consume();
                }
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.closeWindow(true);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void hierarchyChanged(HierarchyEvent e) {
        if (this.isShowing() && !this.codeTextComponent.isShowing()) {
            this.closeWindow(false);
        }
    }

    public void caretUpdate(CaretEvent e) {
        if (this.isShowing()) {
            this.updateWindow();
        }
    }

    private class CodeAssistantListModel
    extends AbstractListModel {
        private CodeAssistantResult result = null;

        public void setCodeAssistantResult(CodeAssistantResult result) {
            int oldSize = this.getSize();
            this.result = result;
            int newSize = this.getSize();
            this.fireContentsChanged(this, 0, newSize);
            if (oldSize > newSize) {
                this.fireIntervalRemoved(this, newSize, oldSize - 1);
            } else if (oldSize < newSize) {
                this.fireIntervalAdded(this, oldSize, newSize - 1);
            }
        }

        public CodeAssistantResult getCodeAssistantResult() {
            return this.result;
        }

        public int getSize() {
            if (this.result != null) {
                return this.result.getChoicesCount();
            }
            return 0;
        }

        public Object getElementAt(int index) {
            return this.result.getChoice(index);
        }
    }

    private class SyntaxCellRenderer
    extends DefaultListCellRenderer {
        private SyntaxCellRenderer() {
        }

        public Component getListCellRendererComponent(JList aList, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)aList, value, index, isSelected, cellHasFocus);
            if (value instanceof SyntaxElement) {
                SyntaxElement element = (SyntaxElement)value;
                this.setText(element.toString());
                switch (element.getType()) {
                    case 1: {
                        this.setIcon(localVarIcon);
                        break;
                    }
                    case 4: {
                        this.setIcon(categoryGroupIcon);
                        break;
                    }
                    case 3: {
                        this.setIcon(categoryIcon);
                        break;
                    }
                    case 2: {
                        this.setIcon(flowIcon);
                        break;
                    }
                    case 13: {
                        this.setIcon(checkIcon);
                        break;
                    }
                    case 5: {
                        this.setIcon(propertyIcon);
                        break;
                    }
                    case 7: {
                        this.setIcon(functionIntIcon);
                        break;
                    }
                    case 8: {
                        this.setIcon(functionIcon);
                        break;
                    }
                    case 14: {
                        this.setIcon(structIcon);
                        break;
                    }
                    case 6: {
                        this.setIcon(fieldIcon);
                        break;
                    }
                    case 10: {
                        this.setIcon(initValueIcon);
                        break;
                    }
                    case 12: {
                        this.setIcon(helpVarIcon);
                        break;
                    }
                    case 11: {
                        this.setIcon(paramIcon);
                        break;
                    }
                    case 9: {
                        this.setIcon(materialRefIcon);
                        break;
                    }
                    case 16: {
                        this.setIcon(templateIcon);
                        break;
                    }
                    case 15: {
                        this.setIcon(keywordIcon);
                    }
                }
            }
            return this;
        }
    }
}

