/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.analysis;

import de.statspez.pleditor.generator.codegen.support.NamespaceHelper;
import de.statspez.pleditor.generator.codegen.support.Scope;
import de.statspez.pleditor.generator.codegen.support.Traverser;
import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaAblaufStatement;
import de.statspez.pleditor.generator.meta.MetaArrayAccess;
import de.statspez.pleditor.generator.meta.MetaCallStatement;
import de.statspez.pleditor.generator.meta.MetaCheckFeldStatement;
import de.statspez.pleditor.generator.meta.MetaContextOperator;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaFactor;
import de.statspez.pleditor.generator.meta.MetaFieldAccess;
import de.statspez.pleditor.generator.meta.MetaFunctionCall;
import de.statspez.pleditor.generator.meta.MetaHierarchicalForEachLoop;
import de.statspez.pleditor.generator.meta.MetaIdentifier;
import de.statspez.pleditor.generator.meta.MetaPruefeStatement;
import de.statspez.pleditor.generator.meta.MetaStructureAccess;
import de.statspez.pleditor.generator.meta.MetaValueAccess;
import de.statspez.pleditor.generator.meta.MetaWithOperator;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import java.util.Hashtable;
import java.util.Stack;

public class CrossReferenceBuilder
extends Traverser {
    private Scope globalScope = null;
    private Hashtable tbScopes = null;
    private Scope currentScope = null;
    private NamespaceHelper nsHelper = new NamespaceHelper();
    private SymbolReferenceSplitter splitter = new SymbolReferenceSplitter();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.statspez.pleditor.generator.codegen.analysis.CrossReferenceBuilder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public void buildCrossReference(MetaElement element, Scope globalScope, Hashtable tbScopes) {
        if (!$assertionsDisabled && element == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && globalScope == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && tbScopes == null) {
            throw new AssertionError();
        }
        this.globalScope = globalScope;
        this.tbScopes = tbScopes;
        this.currentScope = this.globalScope;
        element.accept(this);
    }

    public void visitThemenbereich(MetaThemenbereich themenbereich) {
        this.currentScope = (Scope)this.tbScopes.get(themenbereich.getName());
        if (!$assertionsDisabled && this.currentScope == null) {
            throw new AssertionError((Object)("Kein Scope fuer Themenbereich " + themenbereich.getName()));
        }
        super.visitThemenbereich(themenbereich);
        this.currentScope = this.globalScope;
    }

    public void visitHierarchicalForEachLoop(MetaHierarchicalForEachLoop aStatement) {
        this.splitter.splitSymbolReference(aStatement.value());
        String subNamespace = this.splitter.namespace().length() > 0 ? String.valueOf(this.splitter.namespace()) + "." + this.splitter.id().value() : this.splitter.id().value();
        this.nsHelper.enterSubNamespace(subNamespace);
        aStatement.loopBody().accept(this);
        this.nsHelper.leaveSubNamespace();
    }

    public void visitContextOperator(MetaContextOperator anOperator) {
        if (anOperator.type() == 1) {
            this.nsHelper.startNewNamespace();
        }
        super.visitContextOperator(anOperator);
        if (anOperator.type() == 1) {
            this.nsHelper.leaveThisNamespace();
        }
    }

    public void visitStructureAccess(MetaStructureAccess aStructureAccess) {
        Stack<MetaValueAccess> structureStack = new Stack<MetaValueAccess>();
        MetaStructureAccess currentStructureAccess = aStructureAccess;
        while (currentStructureAccess.structureAccess() instanceof MetaStructureAccess) {
            currentStructureAccess = (MetaStructureAccess)currentStructureAccess.structureAccess();
            structureStack.push(currentStructureAccess.selectedElement());
        }
        structureStack.push(currentStructureAccess.structureAccess());
        while (!structureStack.isEmpty()) {
            MetaValueAccess mfa;
            MetaValueAccess valueAccess = (MetaValueAccess)structureStack.pop();
            valueAccess.accept(this);
            if (valueAccess instanceof MetaFieldAccess) {
                mfa = (MetaFieldAccess)valueAccess;
                this.nsHelper.enterSubNamespace(((MetaFieldAccess)mfa).accessedField().value());
                continue;
            }
            if (!(valueAccess instanceof MetaArrayAccess)) continue;
            mfa = (MetaArrayAccess)valueAccess;
            this.nsHelper.enterSubNamespace(((MetaArrayAccess)mfa).accessedArray().value());
        }
        aStructureAccess.selectedElement().accept(this);
        currentStructureAccess = aStructureAccess;
        while (currentStructureAccess.structureAccess() instanceof MetaStructureAccess) {
            currentStructureAccess = (MetaStructureAccess)currentStructureAccess.structureAccess();
            this.nsHelper.leaveSubNamespace();
        }
        this.nsHelper.leaveSubNamespace();
    }

    public void visitPruefeStatement(MetaPruefeStatement statement) {
        this.createReferenceForCall(statement);
        super.visitPruefeStatement(statement);
    }

    public void visitAblaufStatement(MetaAblaufStatement statement) {
        this.createReferenceForCall(statement);
        super.visitAblaufStatement(statement);
    }

    public void visitFunctionCall(MetaFunctionCall statement) {
        this.createReferenceForCall(statement);
        super.visitFunctionCall(statement);
    }

    public void visitCheckFeldStatement(MetaCheckFeldStatement statement) {
        this.splitter.splitSymbolReference(statement.field());
        this.createCrossReference(statement, this.splitter.id(), this.splitter.namespace(), true);
        super.visitCheckFeldStatement(statement);
    }

    public void visitFieldAccess(MetaFieldAccess aFieldAccess) {
        this.createCrossReference(aFieldAccess, aFieldAccess.accessedField(), "", false);
        super.visitFieldAccess(aFieldAccess);
    }

    public void visitArrayAccess(MetaArrayAccess anArrayAccess) {
        this.createCrossReference(anArrayAccess, anArrayAccess.accessedArray(), "", false);
        anArrayAccess.accessedArray().accept(this);
        int i = 0;
        while (i < anArrayAccess.numberOfIndices()) {
            MetaFactor index = anArrayAccess.indexAt(i);
            if (index != null) {
                NamespaceHelper currentNs = this.nsHelper;
                this.nsHelper = new NamespaceHelper();
                if (index.adaptedObject() instanceof MetaWithOperator) {
                    this.nsHelper = currentNs;
                    this.nsHelper.enterSubNamespace(anArrayAccess.accessedArray().value());
                }
                index.accept(this);
                if (index.adaptedObject() instanceof MetaWithOperator) {
                    this.nsHelper.leaveSubNamespace();
                }
                this.nsHelper = currentNs;
            }
            ++i;
        }
    }

    private void createReferenceForCall(MetaCallStatement statement) {
        this.splitter.splitSymbolReference(statement.function());
        this.createCrossReference(statement, this.splitter.id(), this.splitter.namespace(), true);
    }

    private void createCrossReference(MetaElement from, MetaIdentifier to, String namespace, boolean showWarnings) {
        if (!$assertionsDisabled && from == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && to == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && namespace == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.currentScope == null) {
            throw new AssertionError();
        }
        if (this.currentScope.isDefined(to, namespace = namespace.length() > 0 ? String.valueOf(this.nsHelper.namespace()) + "." + namespace : this.nsHelper.namespace())) {
            MetaElement referredElement = (MetaElement)this.currentScope.property(to, namespace, "MetaElement");
            if (referredElement != null) {
                from.setReferredElement(referredElement);
            } else if (showWarnings) {
                System.err.println("WARNUNG: Querverweis von " + from.toString() + " auf " + to.toString() + " kann nicht erzeugt " + "werden weil kein MetaElement gefunden wurde");
            }
        } else if (showWarnings) {
            System.err.println("WARNUNG: Querverweis von " + from.toString() + " auf " + to.toString() + " kann nicht erzeugt " + "werden!");
        }
    }

    private class SymbolReferenceSplitter
    extends AbstractElementVisitor {
        private NamespaceHelper nsHelper = null;
        private MetaIdentifier id = null;
        private Stack structureStack = null;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.statspez.pleditor.generator.codegen.analysis.CrossReferenceBuilder");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public void splitSymbolReference(MetaElement symbol) {
            this.nsHelper = new NamespaceHelper();
            this.id = null;
            this.structureStack = new Stack();
            symbol.accept(this);
        }

        public MetaIdentifier id() {
            return this.id;
        }

        public String namespace() {
            return this.nsHelper.prettyNamespace();
        }

        public void visitIdentifier(MetaIdentifier id) {
            this.id = id;
        }

        public void visitStructureAccess(MetaStructureAccess access) {
            if (access.structureAccess() instanceof MetaStructureAccess) {
                this.structureStack.push(access.selectedElement());
                access.structureAccess().accept(this);
            } else {
                this.structureStack.push(access.selectedElement());
                this.structureStack.push(access.structureAccess());
                while (this.structureStack.size() > 1) {
                    ((MetaElement)this.structureStack.pop()).accept(this);
                    if (!$assertionsDisabled && this.id == null) {
                        throw new AssertionError();
                    }
                    this.nsHelper.enterSubNamespace(this.id.value());
                }
                ((MetaElement)this.structureStack.pop()).accept(this);
            }
        }

        public void visitArrayAccess(MetaArrayAccess arrayAccess) {
            arrayAccess.accessedArray().accept(this);
        }

        public void visitFieldAccess(MetaFieldAccess fieldAccess) {
            fieldAccess.accessedField().accept(this);
        }
    }
}

