/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.cpp;

import de.statspez.pleditor.generator.codegen.cpp.CppProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.support.CodegenException;
import de.statspez.pleditor.generator.codegen.support.HelperVisitor;
import de.statspez.pleditor.generator.codegen.support.SymbolDescriptor;
import de.statspez.pleditor.generator.meta.MetaArrayAccess;
import de.statspez.pleditor.generator.meta.MetaFieldAccess;
import de.statspez.pleditor.generator.meta.MetaIdentifier;
import de.statspez.pleditor.generator.meta.MetaLiteralAccess;
import de.statspez.pleditor.generator.meta.MetaStructureAccess;

class CppGetArrayRefStrategy
extends HelperVisitor {
    public CppGetArrayRefStrategy(CppProgramCodeGenerator generator) {
        super(generator);
    }

    public void visitFieldAccess(MetaFieldAccess anAccess) {
        this.checkIfExistsAndArray(anAccess.accessedField());
        this.out().print(StringHelper.getEscapedName(anAccess.accessedField().value()));
    }

    public void visitArrayAccess(MetaArrayAccess anAccess) {
        this.checkIfExistsAndArray(anAccess.accessedArray());
    }

    public void visitStructureAccess(MetaStructureAccess anAccess) {
        throw new CodegenException("Fatal Fehler: Zugriff auf Strukturen wird hier nicht unterstuetzt!");
    }

    public void visitLiteralAccess(MetaLiteralAccess anAccess) {
        this.error(anAccess, "ein Literal kann nie eine Liste sein");
    }

    private void checkIfExistsAndArray(MetaIdentifier anId) {
        if (!this.scope().isDefined(anId, this.namespace())) {
            this.error(anId, String.valueOf(anId.toString()) + " ist nicht in diesem Gueltigkeitsbereich definiert " + "(Scope:" + this.namespace() + ")");
            return;
        }
        SymbolDescriptor sd = this.scope().symbolDescriptor(anId, this.namespace());
        if (!sd.isArray()) {
            this.error(anId, String.valueOf(anId.toString()) + " ist keine Liste");
        }
    }
}

