/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.diff;

import de.statspez.pleditor.generator.codegen.diff.DiffResultTreeNode;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaElement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DiffResultTree {
    private Map contextNodeMap = null;
    private DiffResultTreeNode rootNode = null;

    DiffResultTree(MetaCustomPlausibilisierung plausi1, MetaCustomPlausibilisierung plausi2) {
        if (plausi1 == null || plausi2 == null) {
            throw new NullPointerException();
        }
        this.rootNode = new DiffResultTreeNode(plausi1.getName(), plausi1, plausi2, this);
        this.contextNodeMap = new HashMap();
        this.contextNodeMap.put(plausi1.getName(), this.rootNode);
    }

    DiffResultTreeNode addNode(String context, MetaElement metaElement1, MetaElement metaElement2) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (context.equals("")) {
            throw new IllegalArgumentException("Context darf nicht leer sein!");
        }
        DiffResultTreeNode added = null;
        String parentContext = this.getParentContext(context);
        DiffResultTreeNode parent = (DiffResultTreeNode)this.contextNodeMap.get(parentContext);
        if (parent == null) {
            String farestContext = this.getFarestExistingContext(context);
            DiffResultTreeNode farest = (DiffResultTreeNode)this.contextNodeMap.get(farestContext);
            String missingContext = context.substring(farestContext.length() + 1);
            String[] missingContexts = missingContext.split("\\.");
            int i = 0;
            while (i < missingContexts.length - 1) {
                farestContext = String.valueOf(farestContext) + "." + missingContexts[i];
                DiffResultTreeNode tmp = new DiffResultTreeNode(farestContext, null, null, this);
                farest.addChildNode(tmp);
                this.contextNodeMap.put(farestContext, tmp);
                farest = tmp;
                ++i;
            }
            parent = farest;
        }
        added = new DiffResultTreeNode(context, metaElement1, metaElement2, this);
        parent.addChildNode(added);
        this.contextNodeMap.put(context, added);
        return added;
    }

    DiffResultTreeNode getGlobalContextNode() {
        return this.getNode(this.getPlausiContext());
    }

    DiffResultTreeNode getGlobalThemenbereicheContextNode() {
        return this.getNode(this.getPlausiTBsContext());
    }

    DiffResultTreeNode getNode(String context) {
        return (DiffResultTreeNode)this.contextNodeMap.get(context);
    }

    List getNodeChildren(String context) {
        DiffResultTreeNode node = this.getNode(context);
        return node.getNodeChildren();
    }

    String getPlausiContext() {
        return String.valueOf(this.getRootContext()) + ".Plausibilisierung";
    }

    String getPlausiTBsContext() {
        return String.valueOf(this.getPlausiContext()) + ".Themenbereiche";
    }

    String getPLStrukturContext() {
        return String.valueOf(this.getRootContext()) + ".PL-Struktur";
    }

    String getRootContext() {
        return this.getRootNode().getContext();
    }

    DiffResultTreeNode getRootNode() {
        return this.rootNode;
    }

    DiffResultTreeNode getRootTBContextNode() {
        return this.getNode(this.getPLStrukturContext());
    }

    boolean isHeaderNode(DiffResultTreeNode node) {
        return node == this.getRootNode() || node == this.getRootTBContextNode() || node == this.getGlobalContextNode() || node == this.getGlobalThemenbereicheContextNode();
    }

    private String getFarestExistingContext(String context) {
        String farestContext = context;
        while (!this.contextNodeMap.containsKey(farestContext)) {
            farestContext = this.getParentContext(farestContext);
        }
        return farestContext;
    }

    private String getParentContext(String context) {
        String parentContext = context;
        int lastSegmentIndex = parentContext.lastIndexOf(46);
        if (lastSegmentIndex != -1) {
            parentContext = parentContext.substring(0, lastSegmentIndex);
        }
        return parentContext;
    }
}

