/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.diff;

import de.statspez.pleditor.generator.codegen.diff.DiffConfig;
import de.statspez.pleditor.generator.codegen.diff.DiffResult;
import de.statspez.pleditor.generator.codegen.diff.DiffResultContainer;
import de.statspez.pleditor.generator.codegen.diff.DiffResultTree;
import de.statspez.pleditor.generator.codegen.diff.DiffResultTreeNode;
import de.statspez.pleditor.generator.codegen.diff.DiffUITreeCellRenderer;
import de.statspez.pleditor.generator.codegen.diff.DiffUITreeNode;
import de.statspez.pleditor.generator.codegen.diff.EdtDiffFacade;
import de.statspez.pleditor.generator.codegen.diff.ElementNameComparator;
import de.statspez.pleditor.generator.codegen.diff.ElementTypeComparator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DiffUITreePanel {
    private String context = null;
    private DiffConfig diffConfig = null;
    private DiffResultTree diffResultTree = null;
    private Action hideNoDiffAction = null;
    private JPanel mainPanel = null;
    private Action sortNameAction = null;
    private Action sortTypeAction = null;
    private JSplitPane splitPane = null;
    private JTextArea textArea = null;
    private JPanel textPanel = null;
    private JScrollPane textScroll = null;
    private JToolBar toolBar = null;
    private JPanel treePanel = null;
    private JScrollPane treeScroll = null;
    private JTree uiTree = null;

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                File file1 = new File("D:/Eigene Dateien/asa/ofd-atlas-import/ofd/edt/ohne Referenzdateien/Plausi_OFD.xml");
                File file2 = new File("D:/Eigene Dateien/asa/ofd-atlas-import/ofd/edt/mit Referenzdateien/Plausi_OFD.xml");
                DiffConfig config = new DiffConfig();
                config.setCheckId(true);
                config.EL_MERKMAL_ADDED = 2;
                config.EL_MERKMAL_REMOVED = 1;
                DiffResultContainer diffResult = EdtDiffFacade.diff(file1, file2, config);
                DiffUITreePanel panel = new DiffUITreePanel(diffResult.getDiffResultTree(), diffResult.getDiffResultTree().getRootContext());
                panel.setDiffConfig(diffResult.getDiffConfig());
                JFrame frame = new JFrame();
                frame.setDefaultCloseOperation(2);
                frame.getContentPane().add(panel.getMainContainer());
                frame.pack();
                frame.setVisible(true);
            }
        });
    }

    public DiffUITreePanel(DiffResultTree diffResultTree) {
        this(diffResultTree, null);
    }

    public DiffUITreePanel(DiffResultTree diffResultTree, String context) {
        this.init();
        this.context = context == null ? diffResultTree.getRootContext() : context;
        this.setDiffResultTree(diffResultTree);
    }

    public final void expandAll(boolean expand) {
        TreeNode root = (TreeNode)this.uiTree.getModel().getRoot();
        this.expandAll(new TreePath(root), expand);
    }

    public final void expandAll(TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(path, expand);
            }
        }
        if (expand) {
            this.uiTree.expandPath(parent);
        } else {
            this.uiTree.collapsePath(parent);
        }
    }

    public final DiffConfig getDiffConfig() {
        return this.diffConfig;
    }

    public final Action getHideNoDiffAction() {
        return this.hideNoDiffAction;
    }

    public final Container getMainContainer() {
        return this.mainPanel;
    }

    public final Action getSortNameAction() {
        return this.sortNameAction;
    }

    public final Action getSortTypeAction() {
        return this.sortTypeAction;
    }

    public final JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public final Container getTextContainer() {
        return this.textPanel;
    }

    public final JScrollPane getTextScroll() {
        return this.textScroll;
    }

    public final Container getTreeContainer() {
        return this.treePanel;
    }

    public final JScrollPane getTreeScroll() {
        return this.treeScroll;
    }

    public final JTree getUITree() {
        return this.uiTree;
    }

    public final void setDiffConfig(DiffConfig diffConfig) {
        this.diffConfig = diffConfig;
        this.uiTree.setCellRenderer(new DiffUITreeCellRenderer(this.getDiffConfig()));
        if (this.uiTree.isVisible()) {
            this.uiTree.repaint();
        }
    }

    protected void hideNoDiff(boolean hide) {
        Enumeration<TreePath> enumeration = this.uiTree.getExpandedDescendants(new TreePath(this.uiTree.getModel().getRoot()));
        ((DiffUITreeNode)this.uiTree.getModel().getRoot()).hideNoDiff(hide);
        ((DefaultTreeModel)this.uiTree.getModel()).nodeStructureChanged((TreeNode)((DefaultTreeModel)this.uiTree.getModel()).getRoot());
        while (enumeration.hasMoreElements()) {
            TreePath path = enumeration.nextElement();
            this.uiTree.expandPath(path);
        }
    }

    protected void showText(DiffResultTreeNode resultNode) {
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = resultNode.getDiffResults().iterator();
        while (iterator.hasNext()) {
            DiffResult diffResult = (DiffResult)iterator.next();
            buffer.append(diffResult.getDiffDescription());
            if (!iterator.hasNext()) continue;
            buffer.append("\n");
        }
        this.textArea.setText(buffer.toString());
        this.textArea.setCaretPosition(0);
    }

    protected void sortTree(Comparator comparator) {
        if (comparator == null) {
            throw new NullPointerException();
        }
        Enumeration<TreePath> enumeration = this.uiTree.getExpandedDescendants(new TreePath(this.uiTree.getModel().getRoot()));
        if (enumeration != null) {
            ((DiffUITreeNode)this.uiTree.getModel().getRoot()).sortChildren(comparator);
            ((DefaultTreeModel)this.uiTree.getModel()).nodeStructureChanged((TreeNode)((DefaultTreeModel)this.uiTree.getModel()).getRoot());
            while (enumeration.hasMoreElements()) {
                TreePath path = enumeration.nextElement();
                this.uiTree.expandPath(path);
            }
        }
    }

    private List getAllUINodeChildren(DiffUITreeNode node) {
        LinkedList<DiffUITreeNode> children = new LinkedList<DiffUITreeNode>();
        Enumeration enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            DiffUITreeNode child = (DiffUITreeNode)enumeration.nextElement();
            children.add(child);
            children.addAll(this.getAllUINodeChildren(child));
        }
        return children;
    }

    private List getAllUINodes() {
        LinkedList<DiffUITreeNode> nodes = new LinkedList<DiffUITreeNode>();
        DiffUITreeNode root = (DiffUITreeNode)this.uiTree.getModel().getRoot();
        nodes.add(root);
        nodes.addAll(this.getAllUINodeChildren(root));
        return nodes;
    }

    private void init() {
        this.mainPanel = new JPanel();
        this.textPanel = new JPanel();
        this.treePanel = new JPanel();
        this.uiTree = new JTree();
        this.textArea = new JTextArea();
        this.treeScroll = new JScrollPane(this.uiTree);
        this.textScroll = new JScrollPane(this.textArea);
        this.splitPane = new JSplitPane(0);
        ToolTipManager.sharedInstance().registerComponent(this.uiTree);
        this.uiTree.getSelectionModel().setSelectionMode(1);
        this.uiTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = ((JTree)e.getSource()).getSelectionPath();
                if (path != null) {
                    DiffUITreeNode uiNode = (DiffUITreeNode)path.getLastPathComponent();
                    DiffResultTreeNode resultNode = uiNode.getDiffResultTreeNode();
                    DiffUITreePanel.this.showText(resultNode);
                }
            }
        });
        this.treeScroll.setVerticalScrollBarPolicy(22);
        this.treeScroll.setHorizontalScrollBarPolicy(30);
        this.treePanel.setLayout(new BorderLayout());
        this.treePanel.add((Component)this.treeScroll, "Center");
        this.textArea.setRows(3);
        this.textScroll.setVerticalScrollBarPolicy(22);
        this.textScroll.setHorizontalScrollBarPolicy(30);
        this.textPanel.setLayout(new BorderLayout());
        this.textPanel.add((Component)this.textScroll, "Center");
        this.textPanel.setEnabled(false);
        this.splitPane.setLeftComponent(this.treePanel);
        this.splitPane.setRightComponent(this.textPanel);
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.toolBar.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("V");
        JMenu sort = new JMenu("Sortierung");
        JCheckBoxMenuItem sortType = new JCheckBoxMenuItem("Nach Typen");
        sortType.setSelected(true);
        this.sortTypeAction = new AbstractAction(){
            private static final long serialVersionUID = -7696407933459951177L;

            public void actionPerformed(ActionEvent e) {
                DiffUITreePanel.this.sortTree(new ElementTypeComparator());
            }
        };
        sortType.addActionListener(this.sortTypeAction);
        JCheckBoxMenuItem sortAlpha = new JCheckBoxMenuItem("Nach Name");
        this.sortNameAction = new AbstractAction(){
            private static final long serialVersionUID = -4832638428783679223L;

            public void actionPerformed(ActionEvent e) {
                DiffUITreePanel.this.sortTree(new ElementNameComparator());
            }
        };
        sortAlpha.addActionListener(this.sortNameAction);
        ButtonGroup bg = new ButtonGroup();
        bg.add(sortType);
        bg.add(sortAlpha);
        sort.add(sortType);
        sort.add(sortAlpha);
        JMenu hide = new JMenu("Ausblenden");
        final JCheckBoxMenuItem hideNoError = new JCheckBoxMenuItem("Unver\u00e4nderte Elemente");
        this.hideNoDiffAction = new AbstractAction(){
            private static final long serialVersionUID = 8730522302630791870L;

            public void actionPerformed(ActionEvent e) {
                DiffUITreePanel.this.hideNoDiff(hideNoError.isSelected());
            }
        };
        hideNoError.addActionListener(this.hideNoDiffAction);
        hide.add(hideNoError);
        menu.add(sort);
        menu.add(hide);
        menuBar.add(menu);
        this.toolBar.add(menuBar);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.splitPane, "Center");
        this.mainPanel.add((Component)this.toolBar, "North");
    }

    private void setDiffResultTree(DiffResultTree diffResultTree) {
        if (diffResultTree == null) {
            throw new NullPointerException();
        }
        this.diffResultTree = diffResultTree;
        DiffResultTreeNode node = this.diffResultTree.getNode(this.context);
        this.uiTree.setModel(new DefaultTreeModel(new DiffUITreeNode(null, node)));
        this.uiTree.setCellRenderer(new DiffUITreeCellRenderer(this.getDiffConfig()));
        this.sortTree(new ElementTypeComparator());
        this.expandAll(true);
    }
}

